(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1594316,      29853]
NotebookOptionsPosition[   1580642,      29428]
NotebookOutlinePosition[   1581006,      29444]
CellTagsIndexPosition[   1580963,      29441]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 3}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{Inherited, 5}],

Cell["Quanty package tutorial", "Notebook"],

Cell[CellGroupData[{

Cell["\<\
Ligand Field Theory - Magnetic susceptibility and spin dynamics\
\>", "Title"],

Cell[TextData[{
 "This tutorial explains how to deal with low energy excited states and \
degenerate ground states by the example of the magnetic susceptibility. It \
furthermore shows some nice effects of spin dynamics (on a localized spin) \
This tutorial is a continuation of the tutorial on ",
 ButtonBox["Energy Level Diagram and Temperature",
  BaseStyle->"Link",
  ButtonData->
   "paclet:Quanty/tutorial/ligand_field_theory_energy_level_diagram_and_\
temperature"]
}], "Text"],

Cell[CellGroupData[{

Cell["Load some packages", "Section"],

Cell["\<\
Before one starts one should load the Ligand Field theory package \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Quanty`LigandFieldTheory`\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loaded the Solid State Physics : Ligand Field Theory Package - \
version \"\>", "\[InvisibleSpace]", "\<\"2013.1.8\"\>"}],
  SequenceForm[
  "Loaded the Solid State Physics : Ligand Field Theory Package - version ", 
   "2013.1.8"],
  Editable->False]], "Print"],

Cell[BoxData["\<\"Written by Maurits W. Haverkort\"\>"], "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Additional functions needed for this tutorial", "Section"],

Cell["EnergyLevelDiagram", "SubsectionIcon",
 CellChangeTimes->{{3.466081400779326*^9, 3.4660814045052137`*^9}}],

Cell["\<\
The Function EnergyLevelDiagram plots an energy level diagram. The input is a \
Hamiltonian that has to be a function of a single parameter i.e. \
H[param]:=....., then the minimum and maximum value of the parameter, the \
number of points in the plot and optional PlotOptions like range etc. \
Returned is a Graphic 2D plot made by ListPlot\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"EnergyLevelDiagram", "[", 
   RowBox[{
   "H_", ",", "parmin_", ",", "parmax_", ",", "Npar_", ",", 
    "PlotOptions___"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ipar", ",", "par", ",", "val", ",", "fun", ",", "valList"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"ipar", "=", "0"}], ",", 
       RowBox[{"ipar", "\[LessEqual]", "Npar"}], ",", 
       RowBox[{"ipar", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"par", "=", 
         RowBox[{"parmin", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"parmax", "-", "parmin"}], ")"}], 
           FractionBox["ipar", "Npar"]}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"val", ",", "fun"}], "}"}], "=", 
         RowBox[{"CIEigensystem", "[", 
          RowBox[{
           RowBox[{"H", "[", "par", "]"}], ",", 
           RowBox[{"Length", "[", 
            RowBox[{"H", "[", "par", "]"}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ipar", "\[Equal]", "0"}], ",", 
          RowBox[{"valList", "=", 
           RowBox[{"{", "val", "}"}]}], ",", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"valList", ",", "val"}], "]"}]}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"Transpose", "[", "valList", "]"}], ",", "PlotOptions", ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"Joined", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"DataRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"parmin", ",", "parmax"}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"RGBColor", "[", 
         RowBox[{"0", ",", "0", ",", "0"}], "]"}]}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.466077458483655*^9, 3.4660775156150227`*^9}, {
   3.466077546161738*^9, 3.46607759925308*^9}, {3.466077646996015*^9, 
   3.466077743392722*^9}, 3.466078086318874*^9, 3.46607812266602*^9, {
   3.466078152859419*^9, 3.466078180498252*^9}, {3.4660782127595787`*^9, 
   3.4660782130763073`*^9}, {3.466078263776395*^9, 3.466078320258321*^9}, {
   3.4660783706787033`*^9, 3.4660784072647247`*^9}, {3.466078741857306*^9, 
   3.466078751494261*^9}, {3.466083034472479*^9, 3.466083035957658*^9}}],

Cell["GroundStateProperties", "SubsectionIcon",
 CellChangeTimes->{{3.466081400779326*^9, 3.4660814045052137`*^9}, {
  3.466082656959919*^9, 3.466082676906993*^9}}],

Cell["\<\
The function GroundStateProperties has as input an Hamiltonian. Furthermore \
it expects that several operators are defined on the correct basis. The \
output is a list of wave-function properties for all eigen-states in the \
system\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "OppSsqr", ",", "OppLsqr", ",", "OppJsqr", ",", "OppLx", ",", "OppLy", ",",
     "OppLz", ",", "OppSx", ",", "OppSy", ",", "OppSz", ",", "OppJx", ",", 
    "OppJy", ",", "OppJz", ",", "OppNeg", ",", "OppNt2g", ",", "OppNx2y2", 
    ",", "OppNz2", ",", "OppNyz", ",", "OppNxz", ",", "OppNxy"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GroundStateProperties", "[", "H_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "val", ",", "fun", ",", "TableSsqr", ",", "TableLsqr", ",", "TableJsqr", 
      ",", "TableLx", ",", "TableLy", ",", "TableLz", ",", "TableSx", ",", 
      "TableSy", ",", "TableSz", ",", "TableJx", ",", "TableJy", ",", 
      "TableJz", ",", "TableNeg", ",", "TableNt2g", ",", "TableNx2y2", ",", 
      "TableNz2", ",", "TableNyz", ",", "TableNxz", ",", "TableNxy"}], "}"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"val", ",", "fun"}], "}"}], "=", 
      RowBox[{"CIEigensystem", "[", 
       RowBox[{"H", ",", 
        RowBox[{"Length", "[", "H", "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TableSsqr", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fun", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[Conjugate]"}], ".", "OppSsqr", 
         ".", 
         RowBox[{"fun", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "val", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TableLsqr", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fun", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[Conjugate]"}], ".", "OppLsqr", 
         ".", 
         RowBox[{"fun", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "val", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TableJsqr", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fun", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[Conjugate]"}], ".", "OppJsqr", 
         ".", 
         RowBox[{"fun", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "val", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TableLx", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fun", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[Conjugate]"}], ".", "OppLx", 
         ".", 
         RowBox[{"fun", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "val", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TableLy", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fun", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[Conjugate]"}], ".", "OppLy", 
         ".", 
         RowBox[{"fun", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "val", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TableLz", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fun", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[Conjugate]"}], ".", "OppLz", 
         ".", 
         RowBox[{"fun", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "val", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TableSx", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fun", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[Conjugate]"}], ".", "OppSx", 
         ".", 
         RowBox[{"fun", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "val", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TableSy", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fun", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[Conjugate]"}], ".", "OppSy", 
         ".", 
         RowBox[{"fun", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "val", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TableSz", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fun", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[Conjugate]"}], ".", "OppSz", 
         ".", 
         RowBox[{"fun", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "val", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TableJx", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fun", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[Conjugate]"}], ".", "OppJx", 
         ".", 
         RowBox[{"fun", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "val", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TableJy", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fun", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[Conjugate]"}], ".", "OppJy", 
         ".", 
         RowBox[{"fun", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "val", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TableJz", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fun", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[Conjugate]"}], ".", "OppJz", 
         ".", 
         RowBox[{"fun", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "val", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TableNeg", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fun", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[Conjugate]"}], ".", "OppNeg", 
         ".", 
         RowBox[{"fun", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "val", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TableNt2g", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fun", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[Conjugate]"}], ".", "OppNt2g", 
         ".", 
         RowBox[{"fun", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "val", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TableNx2y2", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fun", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[Conjugate]"}], ".", "OppNx2y2", 
         ".", 
         RowBox[{"fun", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "val", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TableNz2", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fun", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[Conjugate]"}], ".", "OppNz2", 
         ".", 
         RowBox[{"fun", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "val", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TableNyz", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fun", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[Conjugate]"}], ".", "OppNyz", 
         ".", 
         RowBox[{"fun", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "val", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TableNxz", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fun", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[Conjugate]"}], ".", "OppNxz", 
         ".", 
         RowBox[{"fun", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "val", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TableNxy", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"fun", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[Conjugate]"}], ".", "OppNxy", 
         ".", 
         RowBox[{"fun", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "val", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Prepend", "[", 
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"Chop", "[", 
         RowBox[{"{", 
          RowBox[{"val", ",", 
           RowBox[{"val", "-", 
            RowBox[{"val", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ",", "TableSsqr", ",", 
           "TableLsqr", ",", "TableJsqr", ",", "TableLx", ",", "TableLy", ",",
            "TableLz", ",", "TableSx", ",", "TableSy", ",", "TableSz", ",", 
           "TableNeg", ",", "TableNt2g", ",", "TableNx2y2", ",", "TableNz2", 
           ",", "TableNyz", ",", "TableNxz", ",", "TableNxy"}], "}"}], "]"}], 
        "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Energy\>\"", ",", "\"\<Relative_Energy\>\"", ",", "\"\<Ssqr\>\"",
          ",", "\"\<Lsqr\>\"", ",", "\"\<Jsqr\>\"", ",", "\"\<Lx\>\"", ",", 
         "\"\<Ly\>\"", ",", "\"\<Lz\>\"", ",", "\"\<Sx\>\"", ",", 
         "\"\<Sy\>\"", ",", "\"\<Sz\>\"", ",", "\"\<Neg\>\"", ",", 
         "\"\<Nt2g\>\"", ",", "\"\<Nx2y2\>\"", ",", "\"\<Nz2\>\"", ",", 
         "\"\<Nyz\>\"", ",", "\"\<Nxz\>\"", ",", "\"\<Nxy\>\""}], "}"}]}], 
      "]"}]}]}], "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.466082680777397*^9, 3.4660827476709003`*^9}, {
  3.4660830397966967`*^9, 3.4660830786628933`*^9}, {3.4660837191274967`*^9, 
  3.466083900780306*^9}}],

Cell["Additional functions needed from packages", "SubsectionIcon"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<Quanty`PlotTools`\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.466081816482318*^9, 3.466081832093025*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loaded the Solid State Physics : Plot Tools Package - version \
\"\>", "\[InvisibleSpace]", "\<\"0.2011.08.23\"\>"}],
  SequenceForm[
  "Loaded the Solid State Physics : Plot Tools Package - version ", 
   "0.2011.08.23"],
  Editable->False]], "Print",
 CellChangeTimes->{3.466137001539138*^9, 3.523353193680081*^9, 
  3.523353226323113*^9, 3.524504711253043*^9}],

Cell[BoxData["\<\"Written by Maurits W. Haverkort\"\>"], "Print",
 CellChangeTimes->{3.466137001539138*^9, 3.523353193680081*^9, 
  3.523353226323113*^9, 3.52450471125836*^9}]
}, Open  ]]
}, Open  ]],

Cell["Basis of d1", "SubsectionIcon",
 CellChangeTimes->{{3.466081400779326*^9, 3.4660814045052137`*^9}, {
  3.4660818474913282`*^9, 3.466081872208736*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Basisd1Dn", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"SphericalHarmonicY", "[", 
         RowBox[{"2", ",", "m", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
        "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"m", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Basisd1Up", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"SphericalHarmonicY", "[", 
         RowBox[{"2", ",", "m", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"m", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.466081946292182*^9, 3.466082025853462*^9}}],

Cell["\<\
Transforms a function in radial coordinates to a function in Cartesian \
coordinates\
\>", "SubsectionIcon"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f\[Theta]\[Phi]Tofxyz", "[", "f_", "]"}], ":=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"TrigExpand", "[", 
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"TrigExpand", "[", 
          RowBox[{"ExpToTrig", "[", 
           RowBox[{"Simplify", "[", "f", "]"}], "]"}], "]"}], "/.", 
         RowBox[{
          RowBox[{"Cos", "[", "\[Phi]", "]"}], "\[Rule]", 
          FractionBox["x", 
           RowBox[{"Sin", "[", "\[Theta]", "]"}]]}]}], " ", "/.", 
        RowBox[{
         RowBox[{"Sin", "[", "\[Phi]", "]"}], "\[Rule]", 
         FractionBox["y", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]]}]}], "]"}], "]"}], "/.", 
     RowBox[{
      RowBox[{"Cos", "[", "\[Theta]", "]"}], "\[Rule]", "z"}]}], "/.", 
    RowBox[{
     RowBox[{"Sin", "[", "\[Theta]", "]"}], "\[Rule]", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["z", "2"]}]]}]}], "]"}]}]], "Input"],

Cell["Several potentials needed all over the place", "SubsectionIcon",
 CellChangeTimes->{{3.466081400779326*^9, 3.4660814045052137`*^9}, {
  3.4660818474913282`*^9, 3.466081872208736*^9}, {3.466082973397952*^9, 
  3.466082980827223*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "Et2g", ",", "Eeg", ",", "Eag2", ",", "Eag1", ",", "Eb1g", ",", "Eb2g", 
    ",", "Eb3g", ",", "Mag"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Et2g", "=", "0"}], ";", 
  RowBox[{"Eeg", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Vnegd", "[", 
    RowBox[{"k_Integer", ",", "m_Integer"}], "]"}], ":=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"\[Piecewise]", GridBox[{
       {
        RowBox[{
         RowBox[{
          FractionBox["3", "5"], "Et2g"}], "+", 
         RowBox[{
          FractionBox["2", "5"], "Eeg"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "0"}], "&&", 
         RowBox[{"m", "\[Equal]", "0"}]}]},
       {
        RowBox[{
         FractionBox["21", "10"], " ", 
         RowBox[{"(", 
          RowBox[{"Eeg", "-", "Et2g"}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "4"}], "&&", 
         RowBox[{"m", "\[Equal]", "0"}]}]},
       {
        RowBox[{
         SqrtBox[
          FractionBox["5", "14"]], 
         FractionBox["21", "10"], " ", 
         RowBox[{"(", 
          RowBox[{"Eeg", "-", "Et2g"}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "4"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"m", "\[Equal]", "4"}], "||", 
           RowBox[{"m", "\[Equal]", 
            RowBox[{"-", "4"}]}]}], ")"}]}]},
       {"0", "True"}
      }]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Et2g", "=", "1"}], ";", 
  RowBox[{"Eeg", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Vnt2gd", "[", 
    RowBox[{"k_Integer", ",", "m_Integer"}], "]"}], ":=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"\[Piecewise]", GridBox[{
       {
        RowBox[{
         RowBox[{
          FractionBox["3", "5"], "Et2g"}], "+", 
         RowBox[{
          FractionBox["2", "5"], "Eeg"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "0"}], "&&", 
         RowBox[{"m", "\[Equal]", "0"}]}]},
       {
        RowBox[{
         FractionBox["21", "10"], " ", 
         RowBox[{"(", 
          RowBox[{"Eeg", "-", "Et2g"}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "4"}], "&&", 
         RowBox[{"m", "\[Equal]", "0"}]}]},
       {
        RowBox[{
         SqrtBox[
          FractionBox["5", "14"]], 
         FractionBox["21", "10"], " ", 
         RowBox[{"(", 
          RowBox[{"Eeg", "-", "Et2g"}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "4"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"m", "\[Equal]", "4"}], "||", 
           RowBox[{"m", "\[Equal]", 
            RowBox[{"-", "4"}]}]}], ")"}]}]},
       {"0", "True"}
      }]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eag1", "=", "0"}], ";", 
  RowBox[{"Eag2", "=", "0"}], ";", 
  RowBox[{"Eb1g", "=", "0"}], ";", 
  RowBox[{"Eb2g", "=", "0"}], ";", 
  RowBox[{"Eb3g", "=", "1"}], ";", 
  RowBox[{"Mag", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Vnyzd", "[", 
    RowBox[{"k_Integer", ",", "m_Integer"}], "]"}], ":=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"\[Piecewise]", GridBox[{
       {
        RowBox[{
         FractionBox["1", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
          "Eag2", "+", "Eag1", "+", "Eb1g", "+", "Eb2g", "+", "Eb3g"}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "0"}], "&&", 
         RowBox[{"m", "\[Equal]", "0"}]}]},
       {
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "Eag2"}], "+", 
           RowBox[{"2", " ", "Eag1"}], "-", 
           RowBox[{"2", " ", "Eb1g"}], "+", "Eb2g", "+", "Eb3g"}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "2"}], "&&", 
         RowBox[{"m", "\[Equal]", "0"}]}]},
       {
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SqrtBox["6"], " ", "Eb2g"}], "-", 
           RowBox[{
            SqrtBox["6"], " ", "Eb3g"}], "-", 
           RowBox[{"4", " ", 
            SqrtBox["2"], " ", "Mag"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "2"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"m", "\[Equal]", 
            RowBox[{"-", "2"}]}], "||", 
           RowBox[{"m", "\[Equal]", "2"}]}], ")"}]}]},
       {
        RowBox[{
         FractionBox["3", "10"], " ", 
         RowBox[{"(", 
          RowBox[{"Eag2", "+", 
           RowBox[{"6", " ", "Eag1"}], "+", "Eb1g", "-", 
           RowBox[{"4", " ", "Eb2g"}], "-", 
           RowBox[{"4", " ", "Eb3g"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "4"}], "&&", 
         RowBox[{"m", "\[Equal]", "0"}]}]},
       {
        FractionBox[
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{"Eb2g", "-", "Eb3g", "+", 
            RowBox[{
             SqrtBox["3"], " ", "Mag"}]}], ")"}]}], 
         SqrtBox["10"]], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "4"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"m", "\[Equal]", 
            RowBox[{"-", "2"}]}], "||", 
           RowBox[{"m", "\[Equal]", "2"}]}], ")"}]}]},
       {
        RowBox[{
         FractionBox["3", "2"], " ", 
         SqrtBox[
          FractionBox["7", "10"]], " ", 
         RowBox[{"(", 
          RowBox[{"Eag2", "-", "Eb1g"}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "4"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"m", "\[Equal]", 
            RowBox[{"-", "4"}]}], "||", 
           RowBox[{"m", "\[Equal]", "4"}]}], ")"}]}]},
       {"0", "True"}
      }]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eag1", "=", "0"}], ";", 
  RowBox[{"Eag2", "=", "0"}], ";", 
  RowBox[{"Eb1g", "=", "0"}], ";", 
  RowBox[{"Eb2g", "=", "1"}], ";", 
  RowBox[{"Eb3g", "=", "0"}], ";", 
  RowBox[{"Mag", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Vnxzd", "[", 
    RowBox[{"k_Integer", ",", "m_Integer"}], "]"}], ":=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"\[Piecewise]", GridBox[{
       {
        RowBox[{
         FractionBox["1", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
          "Eag2", "+", "Eag1", "+", "Eb1g", "+", "Eb2g", "+", "Eb3g"}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "0"}], "&&", 
         RowBox[{"m", "\[Equal]", "0"}]}]},
       {
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "Eag2"}], "+", 
           RowBox[{"2", " ", "Eag1"}], "-", 
           RowBox[{"2", " ", "Eb1g"}], "+", "Eb2g", "+", "Eb3g"}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "2"}], "&&", 
         RowBox[{"m", "\[Equal]", "0"}]}]},
       {
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SqrtBox["6"], " ", "Eb2g"}], "-", 
           RowBox[{
            SqrtBox["6"], " ", "Eb3g"}], "-", 
           RowBox[{"4", " ", 
            SqrtBox["2"], " ", "Mag"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "2"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"m", "\[Equal]", 
            RowBox[{"-", "2"}]}], "||", 
           RowBox[{"m", "\[Equal]", "2"}]}], ")"}]}]},
       {
        RowBox[{
         FractionBox["3", "10"], " ", 
         RowBox[{"(", 
          RowBox[{"Eag2", "+", 
           RowBox[{"6", " ", "Eag1"}], "+", "Eb1g", "-", 
           RowBox[{"4", " ", "Eb2g"}], "-", 
           RowBox[{"4", " ", "Eb3g"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "4"}], "&&", 
         RowBox[{"m", "\[Equal]", "0"}]}]},
       {
        FractionBox[
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{"Eb2g", "-", "Eb3g", "+", 
            RowBox[{
             SqrtBox["3"], " ", "Mag"}]}], ")"}]}], 
         SqrtBox["10"]], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "4"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"m", "\[Equal]", 
            RowBox[{"-", "2"}]}], "||", 
           RowBox[{"m", "\[Equal]", "2"}]}], ")"}]}]},
       {
        RowBox[{
         FractionBox["3", "2"], " ", 
         SqrtBox[
          FractionBox["7", "10"]], " ", 
         RowBox[{"(", 
          RowBox[{"Eag2", "-", "Eb1g"}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "4"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"m", "\[Equal]", 
            RowBox[{"-", "4"}]}], "||", 
           RowBox[{"m", "\[Equal]", "4"}]}], ")"}]}]},
       {"0", "True"}
      }]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eag1", "=", "0"}], ";", 
  RowBox[{"Eag2", "=", "0"}], ";", 
  RowBox[{"Eb1g", "=", "1"}], ";", 
  RowBox[{"Eb2g", "=", "0"}], ";", 
  RowBox[{"Eb3g", "=", "0"}], ";", 
  RowBox[{"Mag", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Vnxyd", "[", 
    RowBox[{"k_Integer", ",", "m_Integer"}], "]"}], ":=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"\[Piecewise]", GridBox[{
       {
        RowBox[{
         FractionBox["1", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
          "Eag2", "+", "Eag1", "+", "Eb1g", "+", "Eb2g", "+", "Eb3g"}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "0"}], "&&", 
         RowBox[{"m", "\[Equal]", "0"}]}]},
       {
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "Eag2"}], "+", 
           RowBox[{"2", " ", "Eag1"}], "-", 
           RowBox[{"2", " ", "Eb1g"}], "+", "Eb2g", "+", "Eb3g"}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "2"}], "&&", 
         RowBox[{"m", "\[Equal]", "0"}]}]},
       {
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SqrtBox["6"], " ", "Eb2g"}], "-", 
           RowBox[{
            SqrtBox["6"], " ", "Eb3g"}], "-", 
           RowBox[{"4", " ", 
            SqrtBox["2"], " ", "Mag"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "2"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"m", "\[Equal]", 
            RowBox[{"-", "2"}]}], "||", 
           RowBox[{"m", "\[Equal]", "2"}]}], ")"}]}]},
       {
        RowBox[{
         FractionBox["3", "10"], " ", 
         RowBox[{"(", 
          RowBox[{"Eag2", "+", 
           RowBox[{"6", " ", "Eag1"}], "+", "Eb1g", "-", 
           RowBox[{"4", " ", "Eb2g"}], "-", 
           RowBox[{"4", " ", "Eb3g"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "4"}], "&&", 
         RowBox[{"m", "\[Equal]", "0"}]}]},
       {
        FractionBox[
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{"Eb2g", "-", "Eb3g", "+", 
            RowBox[{
             SqrtBox["3"], " ", "Mag"}]}], ")"}]}], 
         SqrtBox["10"]], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "4"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"m", "\[Equal]", 
            RowBox[{"-", "2"}]}], "||", 
           RowBox[{"m", "\[Equal]", "2"}]}], ")"}]}]},
       {
        RowBox[{
         FractionBox["3", "2"], " ", 
         SqrtBox[
          FractionBox["7", "10"]], " ", 
         RowBox[{"(", 
          RowBox[{"Eag2", "-", "Eb1g"}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "4"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"m", "\[Equal]", 
            RowBox[{"-", "4"}]}], "||", 
           RowBox[{"m", "\[Equal]", "4"}]}], ")"}]}]},
       {"0", "True"}
      }]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eag1", "=", "0"}], ";", 
  RowBox[{"Eag2", "=", "1"}], ";", 
  RowBox[{"Eb1g", "=", "0"}], ";", 
  RowBox[{"Eb2g", "=", "0"}], ";", 
  RowBox[{"Eb3g", "=", "0"}], ";", 
  RowBox[{"Mag", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Vnx2y2d", "[", 
    RowBox[{"k_Integer", ",", "m_Integer"}], "]"}], ":=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"\[Piecewise]", GridBox[{
       {
        RowBox[{
         FractionBox["1", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
          "Eag2", "+", "Eag1", "+", "Eb1g", "+", "Eb2g", "+", "Eb3g"}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "0"}], "&&", 
         RowBox[{"m", "\[Equal]", "0"}]}]},
       {
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "Eag2"}], "+", 
           RowBox[{"2", " ", "Eag1"}], "-", 
           RowBox[{"2", " ", "Eb1g"}], "+", "Eb2g", "+", "Eb3g"}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "2"}], "&&", 
         RowBox[{"m", "\[Equal]", "0"}]}]},
       {
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SqrtBox["6"], " ", "Eb2g"}], "-", 
           RowBox[{
            SqrtBox["6"], " ", "Eb3g"}], "-", 
           RowBox[{"4", " ", 
            SqrtBox["2"], " ", "Mag"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "2"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"m", "\[Equal]", 
            RowBox[{"-", "2"}]}], "||", 
           RowBox[{"m", "\[Equal]", "2"}]}], ")"}]}]},
       {
        RowBox[{
         FractionBox["3", "10"], " ", 
         RowBox[{"(", 
          RowBox[{"Eag2", "+", 
           RowBox[{"6", " ", "Eag1"}], "+", "Eb1g", "-", 
           RowBox[{"4", " ", "Eb2g"}], "-", 
           RowBox[{"4", " ", "Eb3g"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "4"}], "&&", 
         RowBox[{"m", "\[Equal]", "0"}]}]},
       {
        FractionBox[
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{"Eb2g", "-", "Eb3g", "+", 
            RowBox[{
             SqrtBox["3"], " ", "Mag"}]}], ")"}]}], 
         SqrtBox["10"]], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "4"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"m", "\[Equal]", 
            RowBox[{"-", "2"}]}], "||", 
           RowBox[{"m", "\[Equal]", "2"}]}], ")"}]}]},
       {
        RowBox[{
         FractionBox["3", "2"], " ", 
         SqrtBox[
          FractionBox["7", "10"]], " ", 
         RowBox[{"(", 
          RowBox[{"Eag2", "-", "Eb1g"}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "4"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"m", "\[Equal]", 
            RowBox[{"-", "4"}]}], "||", 
           RowBox[{"m", "\[Equal]", "4"}]}], ")"}]}]},
       {"0", "True"}
      }]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eag1", "=", "1"}], ";", 
  RowBox[{"Eag2", "=", "0"}], ";", 
  RowBox[{"Eb1g", "=", "0"}], ";", 
  RowBox[{"Eb2g", "=", "0"}], ";", 
  RowBox[{"Eb3g", "=", "0"}], ";", 
  RowBox[{"Mag", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Vnz2d", "[", 
    RowBox[{"k_Integer", ",", "m_Integer"}], "]"}], ":=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"\[Piecewise]", GridBox[{
       {
        RowBox[{
         FractionBox["1", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
          "Eag2", "+", "Eag1", "+", "Eb1g", "+", "Eb2g", "+", "Eb3g"}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "0"}], "&&", 
         RowBox[{"m", "\[Equal]", "0"}]}]},
       {
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "Eag2"}], "+", 
           RowBox[{"2", " ", "Eag1"}], "-", 
           RowBox[{"2", " ", "Eb1g"}], "+", "Eb2g", "+", "Eb3g"}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "2"}], "&&", 
         RowBox[{"m", "\[Equal]", "0"}]}]},
       {
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SqrtBox["6"], " ", "Eb2g"}], "-", 
           RowBox[{
            SqrtBox["6"], " ", "Eb3g"}], "-", 
           RowBox[{"4", " ", 
            SqrtBox["2"], " ", "Mag"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "2"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"m", "\[Equal]", 
            RowBox[{"-", "2"}]}], "||", 
           RowBox[{"m", "\[Equal]", "2"}]}], ")"}]}]},
       {
        RowBox[{
         FractionBox["3", "10"], " ", 
         RowBox[{"(", 
          RowBox[{"Eag2", "+", 
           RowBox[{"6", " ", "Eag1"}], "+", "Eb1g", "-", 
           RowBox[{"4", " ", "Eb2g"}], "-", 
           RowBox[{"4", " ", "Eb3g"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "4"}], "&&", 
         RowBox[{"m", "\[Equal]", "0"}]}]},
       {
        FractionBox[
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{"Eb2g", "-", "Eb3g", "+", 
            RowBox[{
             SqrtBox["3"], " ", "Mag"}]}], ")"}]}], 
         SqrtBox["10"]], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "4"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"m", "\[Equal]", 
            RowBox[{"-", "2"}]}], "||", 
           RowBox[{"m", "\[Equal]", "2"}]}], ")"}]}]},
       {
        RowBox[{
         FractionBox["3", "2"], " ", 
         SqrtBox[
          FractionBox["7", "10"]], " ", 
         RowBox[{"(", 
          RowBox[{"Eag2", "-", "Eb1g"}], ")"}]}], 
        RowBox[{
         RowBox[{"k", "\[Equal]", "4"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"m", "\[Equal]", 
            RowBox[{"-", "4"}]}], "||", 
           RowBox[{"m", "\[Equal]", "4"}]}], ")"}]}]},
       {"0", "True"}
      }]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "Et2g", ",", "Eeg", ",", "Eag2", ",", "Eag1", ",", "Eb1g", ",", "Eb2g", 
    ",", "Eb3g", ",", "Mag", ",", "Ea1g", ",", "Eb1g", ",", "Eb2g", ",", 
    "Eeg"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VOhd", "[", 
    RowBox[{"k_Integer", ",", "m_Integer"}], "]"}], ":=", 
   RowBox[{"\[Piecewise]", GridBox[{
      {
       RowBox[{
        RowBox[{
         FractionBox["3", "5"], "Et2g"}], "+", 
        RowBox[{
         FractionBox["2", "5"], "Eeg"}]}], 
       RowBox[{
        RowBox[{"k", "\[Equal]", "0"}], "&&", 
        RowBox[{"m", "\[Equal]", "0"}]}]},
      {
       RowBox[{
        FractionBox["21", "10"], " ", 
        RowBox[{"(", 
         RowBox[{"Eeg", "-", "Et2g"}], ")"}]}], 
       RowBox[{
        RowBox[{"k", "\[Equal]", "4"}], "&&", 
        RowBox[{"m", "\[Equal]", "0"}]}]},
      {
       RowBox[{
        SqrtBox[
         FractionBox["5", "14"]], 
        FractionBox["21", "10"], " ", 
        RowBox[{"(", 
         RowBox[{"Eeg", "-", "Et2g"}], ")"}]}], 
       RowBox[{
        RowBox[{"k", "\[Equal]", "4"}], "&&", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m", "\[Equal]", "4"}], "||", 
          RowBox[{"m", "\[Equal]", 
           RowBox[{"-", "4"}]}]}], ")"}]}]},
      {"0", "True"}
     }]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VD4hd", "[", 
    RowBox[{"k_Integer", ",", "m_Integer"}], "]"}], ":=", 
   RowBox[{"\[Piecewise]", GridBox[{
      {
       RowBox[{
        FractionBox["1", "5"], " ", 
        RowBox[{"(", 
         RowBox[{"Ea1g", "+", "Eb1g", "+", "Eb2g", "+", 
          RowBox[{"2", " ", "Eeg"}]}], ")"}]}], 
       RowBox[{
        RowBox[{"k", "\[Equal]", "0"}], "&&", 
        RowBox[{"m", "\[Equal]", "0"}]}]},
      {
       RowBox[{"Ea1g", "-", "Eb1g", "-", "Eb2g", "+", "Eeg"}], 
       RowBox[{
        RowBox[{"k", "\[Equal]", "2"}], "&&", 
        RowBox[{"m", "\[Equal]", "0"}]}]},
      {
       FractionBox[
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            SqrtBox["70"], " ", "Ea1g"}], "+", 
           RowBox[{
            SqrtBox["70"], " ", "Eb1g"}], "+", 
           RowBox[{
            SqrtBox["70"], " ", "Eb2g"}], "-", 
           RowBox[{"8", " ", 
            SqrtBox["70"], " ", "Eeg"}]}], ")"}]}], 
        RowBox[{"10", " ", 
         SqrtBox["70"]}]], 
       RowBox[{
        RowBox[{"k", "\[Equal]", "4"}], "&&", 
        RowBox[{"m", "\[Equal]", "0"}]}]},
      {
       RowBox[{
        FractionBox["3", "20"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SqrtBox["70"], " ", "Eb1g"}], "-", 
          RowBox[{
           SqrtBox["70"], " ", "Eb2g"}]}], ")"}]}], 
       RowBox[{
        RowBox[{"k", "\[Equal]", "4"}], "&&", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m", "\[Equal]", 
           RowBox[{"-", "4"}]}], "||", 
          RowBox[{"m", "\[Equal]", "4"}]}], ")"}]}]},
      {"0", "True"}
     }]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VD2hd", "[", 
    RowBox[{"k_Integer", ",", "m_Integer"}], "]"}], ":=", 
   RowBox[{"\[Piecewise]", GridBox[{
      {
       RowBox[{
        FractionBox["1", "5"], " ", 
        RowBox[{"(", 
         RowBox[{"Eag2", "+", "Eag1", "+", "Eb1g", "+", "Eb2g", "+", "Eb3g"}],
          ")"}]}], 
       RowBox[{
        RowBox[{"k", "\[Equal]", "0"}], "&&", 
        RowBox[{"m", "\[Equal]", "0"}]}]},
      {
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "Eag2"}], "+", 
          RowBox[{"2", " ", "Eag1"}], "-", 
          RowBox[{"2", " ", "Eb1g"}], "+", "Eb2g", "+", "Eb3g"}], ")"}]}], 
       RowBox[{
        RowBox[{"k", "\[Equal]", "2"}], "&&", 
        RowBox[{"m", "\[Equal]", "0"}]}]},
      {
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SqrtBox["6"], " ", "Eb2g"}], "-", 
          RowBox[{
           SqrtBox["6"], " ", "Eb3g"}], "-", 
          RowBox[{"4", " ", 
           SqrtBox["2"], " ", "Mag"}]}], ")"}]}], 
       RowBox[{
        RowBox[{"k", "\[Equal]", "2"}], "&&", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m", "\[Equal]", 
           RowBox[{"-", "2"}]}], "||", 
          RowBox[{"m", "\[Equal]", "2"}]}], ")"}]}]},
      {
       RowBox[{
        FractionBox["3", "10"], " ", 
        RowBox[{"(", 
         RowBox[{"Eag2", "+", 
          RowBox[{"6", " ", "Eag1"}], "+", "Eb1g", "-", 
          RowBox[{"4", " ", "Eb2g"}], "-", 
          RowBox[{"4", " ", "Eb3g"}]}], ")"}]}], 
       RowBox[{
        RowBox[{"k", "\[Equal]", "4"}], "&&", 
        RowBox[{"m", "\[Equal]", "0"}]}]},
      {
       FractionBox[
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{"Eb2g", "-", "Eb3g", "+", 
           RowBox[{
            SqrtBox["3"], " ", "Mag"}]}], ")"}]}], 
        SqrtBox["10"]], 
       RowBox[{
        RowBox[{"k", "\[Equal]", "4"}], "&&", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m", "\[Equal]", 
           RowBox[{"-", "2"}]}], "||", 
          RowBox[{"m", "\[Equal]", "2"}]}], ")"}]}]},
      {
       RowBox[{
        FractionBox["3", "2"], " ", 
        SqrtBox[
         FractionBox["7", "10"]], " ", 
        RowBox[{"(", 
         RowBox[{"Eag2", "-", "Eb1g"}], ")"}]}], 
       RowBox[{
        RowBox[{"k", "\[Equal]", "4"}], "&&", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m", "\[Equal]", 
           RowBox[{"-", "4"}]}], "||", 
          RowBox[{"m", "\[Equal]", "4"}]}], ")"}]}]},
      {"0", "True"}
     }]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4660829878721533`*^9, 3.466082988696542*^9}, {
   3.4660831406320143`*^9, 3.466083185479846*^9}, {3.466083259729075*^9, 
   3.466083381783222*^9}, {3.4660835083065434`*^9, 3.4660835538192177`*^9}, {
   3.466083950556798*^9, 3.466084004258634*^9}, {3.466086813186925*^9, 
   3.466086881239615*^9}, 3.524504541656624*^9}],

Cell["Define some constants", "SubsectionIcon"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "I", " ", "want", " ", "to", " ", "express", " ", "energies", " ", "in", 
   " ", "eV"}], ",", " ", 
  RowBox[{"temperatures", " ", "in", " ", "K"}], ",", " ", 
  RowBox[{"and", " ", "susceptibilities", " ", "in", " ", "emu", " ", 
   RowBox[{
    SuperscriptBox["mol", 
     RowBox[{"-", "1"}]], ".", " ", "Therefore"}], " ", "the", " ", 
   "following", " ", "constants"}]}]], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Mu]B", "=", 
   RowBox[{"9.2741", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "24"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NA", "=", 
   RowBox[{"6.022", " ", 
    SuperscriptBox["10", "23"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kB", "=", 
   RowBox[{"8.61735", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "5"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TeslaToeV", "=", 
   RowBox[{"5.78834", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "5"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eVToTesla", "=", 
   FractionBox["1", "TeslaToeV"]}], ";"}]}], "Input"],

Cell["Define a function CreateMofT that creates a function M[T_]", \
"SubsectionIcon",
 CellChangeTimes->{{3.466088480145995*^9, 3.466088505003949*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CreateMofT", "[", 
    RowBox[{"H_", ",", "Bmag_", ",", "Hex_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Mxi", ",", "Myi", ",", "Mzi", ",", "Z"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ClearAll", "[", 
       RowBox[{"M", ",", "T"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"val", ",", "fun"}], "}"}], "=", 
       RowBox[{"Chop", "[", 
        RowBox[{"CIEigensystem", "[", 
         RowBox[{
          RowBox[{"H", "[", 
           RowBox[{
            RowBox[{"Bmag", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Bmag", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"Bmag", "[", 
             RowBox[{"[", "3", "]"}], "]"}], ",", 
            RowBox[{"Hex", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Hex", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"Hex", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"Length", "[", 
           RowBox[{"H", "[", 
            RowBox[{
             RowBox[{"Bmag", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"Bmag", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"Bmag", "[", 
              RowBox[{"[", "3", "]"}], "]"}], ",", 
             RowBox[{"Hex", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"Hex", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"Hex", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], "]"}], "]"}]}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Mxi", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"-", 
           RowBox[{
            RowBox[{"Conjugate", "[", 
             RowBox[{"fun", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "]"}], ".", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "OppSx"}], "+", "OppLx"}], ")"}], ".", 
            RowBox[{"fun", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "fun", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Myi", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"-", 
           RowBox[{
            RowBox[{"Conjugate", "[", 
             RowBox[{"fun", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "]"}], ".", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "OppSy"}], "+", "OppLy"}], ")"}], ".", 
            RowBox[{"fun", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "fun", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Mzi", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"-", 
           RowBox[{
            RowBox[{"Conjugate", "[", 
             RowBox[{"fun", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "]"}], ".", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "OppSz"}], "+", "OppLz"}], ")"}], ".", 
            RowBox[{"fun", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "fun", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"M", "[", "T_", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
         FractionBox[
          RowBox[{"Mxi", ".", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"-", 
             FractionBox["val", 
              RowBox[{"kB", " ", "T"}]]}]]}], 
          RowBox[{"Tr", "[", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"-", 
             FractionBox["val", 
              RowBox[{"kB", " ", "T"}]]}]], "]"}]], ",", 
         FractionBox[
          RowBox[{"Myi", ".", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"-", 
             FractionBox["val", 
              RowBox[{"kB", " ", "T"}]]}]]}], 
          RowBox[{"Tr", "[", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"-", 
             FractionBox["val", 
              RowBox[{"kB", " ", "T"}]]}]], "]"}]], ",", 
         FractionBox[
          RowBox[{"Mzi", ".", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"-", 
             FractionBox["val", 
              RowBox[{"kB", " ", "T"}]]}]]}], 
          RowBox[{"Tr", "[", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"-", 
             FractionBox["val", 
              RowBox[{"kB", " ", "T"}]]}]], "]"}]]}], "}"}]}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.46591010491261*^9, 3.465910261875928*^9}, {
   3.465910423722535*^9, 3.465910485819332*^9}, {3.465910631606925*^9, 
   3.465910691436811*^9}, {3.465910747552195*^9, 3.465910825221974*^9}, {
   3.465911053394929*^9, 3.465911096294001*^9}, {3.465911135386314*^9, 
   3.465911183515004*^9}, {3.465915914569422*^9, 3.465915930249896*^9}, 
   3.4659164481767*^9}],

Cell["Define CalculateM/S/L", "SubsectionIcon",
 CellChangeTimes->{{3.466088517354959*^9, 3.466088538291575*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CalculateM", "[", 
    RowBox[{"H_", ",", "Bmag_", ",", "Hex_", ",", "T_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Mxi", ",", "Myi", ",", "Mzi", ",", "Z"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"val", ",", "fun"}], "}"}], "=", 
       RowBox[{"Chop", "[", 
        RowBox[{"CIEigensystem", "[", 
         RowBox[{
          RowBox[{"H", "[", 
           RowBox[{
            RowBox[{"Bmag", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Bmag", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"Bmag", "[", 
             RowBox[{"[", "3", "]"}], "]"}], ",", 
            RowBox[{"Hex", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Hex", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"Hex", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"Length", "[", 
           RowBox[{"H", "[", 
            RowBox[{
             RowBox[{"Bmag", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"Bmag", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"Bmag", "[", 
              RowBox[{"[", "3", "]"}], "]"}], ",", 
             RowBox[{"Hex", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"Hex", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"Hex", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], "]"}], "]"}]}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Mxi", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"-", 
           RowBox[{
            RowBox[{"Conjugate", "[", 
             RowBox[{"fun", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "]"}], ".", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "OppSx"}], "+", "OppLx"}], ")"}], ".", 
            RowBox[{"fun", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "fun", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Myi", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"-", 
           RowBox[{
            RowBox[{"Conjugate", "[", 
             RowBox[{"fun", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "]"}], ".", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "OppSy"}], "+", "OppLy"}], ")"}], ".", 
            RowBox[{"fun", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "fun", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Mzi", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"-", 
           RowBox[{
            RowBox[{"Conjugate", "[", 
             RowBox[{"fun", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "]"}], ".", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "OppSz"}], "+", "OppLz"}], ")"}], ".", 
            RowBox[{"fun", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "fun", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        FractionBox[
         RowBox[{"Mxi", ".", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox["val", 
             RowBox[{"kB", " ", "T"}]]}]]}], 
         RowBox[{"Tr", "[", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox["val", 
             RowBox[{"kB", " ", "T"}]]}]], "]"}]], ",", 
        FractionBox[
         RowBox[{"Myi", ".", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox["val", 
             RowBox[{"kB", " ", "T"}]]}]]}], 
         RowBox[{"Tr", "[", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox["val", 
             RowBox[{"kB", " ", "T"}]]}]], "]"}]], ",", 
        FractionBox[
         RowBox[{"Mzi", ".", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox["val", 
             RowBox[{"kB", " ", "T"}]]}]]}], 
         RowBox[{"Tr", "[", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox["val", 
             RowBox[{"kB", " ", "T"}]]}]], "]"}]]}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CalculateS", "[", 
    RowBox[{"H_", ",", "Bmag_", ",", "Hex_", ",", "T_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Sxi", ",", "Syi", ",", "Szi", ",", "Z"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"val", ",", "fun"}], "}"}], "=", 
       RowBox[{"Chop", "[", 
        RowBox[{"CIEigensystem", "[", 
         RowBox[{
          RowBox[{"H", "[", 
           RowBox[{
            RowBox[{"Bmag", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Bmag", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"Bmag", "[", 
             RowBox[{"[", "3", "]"}], "]"}], ",", 
            RowBox[{"Hex", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Hex", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"Hex", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"Length", "[", 
           RowBox[{"H", "[", 
            RowBox[{
             RowBox[{"Bmag", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"Bmag", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"Bmag", "[", 
              RowBox[{"[", "3", "]"}], "]"}], ",", 
             RowBox[{"Hex", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"Hex", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"Hex", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], "]"}], "]"}]}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Sxi", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"-", 
           RowBox[{
            RowBox[{"Conjugate", "[", 
             RowBox[{"fun", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "]"}], ".", 
            RowBox[{"(", "OppSx", ")"}], ".", 
            RowBox[{"fun", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "fun", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Syi", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"-", 
           RowBox[{
            RowBox[{"Conjugate", "[", 
             RowBox[{"fun", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "]"}], ".", 
            RowBox[{"(", "OppSy", ")"}], ".", 
            RowBox[{"fun", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "fun", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Szi", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"-", 
           RowBox[{
            RowBox[{"Conjugate", "[", 
             RowBox[{"fun", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "]"}], ".", 
            RowBox[{"(", "OppSz", ")"}], ".", 
            RowBox[{"fun", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "fun", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        FractionBox[
         RowBox[{"Sxi", ".", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox["val", 
             RowBox[{"kB", " ", "T"}]]}]]}], 
         RowBox[{"Tr", "[", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox["val", 
             RowBox[{"kB", " ", "T"}]]}]], "]"}]], ",", 
        FractionBox[
         RowBox[{"Syi", ".", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox["val", 
             RowBox[{"kB", " ", "T"}]]}]]}], 
         RowBox[{"Tr", "[", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox["val", 
             RowBox[{"kB", " ", "T"}]]}]], "]"}]], ",", 
        FractionBox[
         RowBox[{"Szi", ".", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox["val", 
             RowBox[{"kB", " ", "T"}]]}]]}], 
         RowBox[{"Tr", "[", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox["val", 
             RowBox[{"kB", " ", "T"}]]}]], "]"}]]}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CalculateL", "[", 
    RowBox[{"H_", ",", "Bmag_", ",", "Hex_", ",", "T_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Lxi", ",", "Lyi", ",", "Lzi", ",", "Z"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"val", ",", "fun"}], "}"}], "=", 
       RowBox[{"Chop", "[", 
        RowBox[{"CIEigensystem", "[", 
         RowBox[{
          RowBox[{"H", "[", 
           RowBox[{
            RowBox[{"Bmag", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Bmag", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"Bmag", "[", 
             RowBox[{"[", "3", "]"}], "]"}], ",", 
            RowBox[{"Hex", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Hex", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"Hex", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"Length", "[", 
           RowBox[{"H", "[", 
            RowBox[{
             RowBox[{"Bmag", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"Bmag", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"Bmag", "[", 
              RowBox[{"[", "3", "]"}], "]"}], ",", 
             RowBox[{"Hex", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"Hex", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"Hex", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], "]"}], "]"}]}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Lxi", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"-", 
           RowBox[{
            RowBox[{"Conjugate", "[", 
             RowBox[{"fun", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "]"}], ".", 
            RowBox[{"(", "OppLx", ")"}], ".", 
            RowBox[{"fun", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "fun", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Lyi", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"-", 
           RowBox[{
            RowBox[{"Conjugate", "[", 
             RowBox[{"fun", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "]"}], ".", 
            RowBox[{"(", "OppLy", ")"}], ".", 
            RowBox[{"fun", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "fun", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Lzi", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"-", 
           RowBox[{
            RowBox[{"Conjugate", "[", 
             RowBox[{"fun", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "]"}], ".", 
            RowBox[{"(", "OppLz", ")"}], ".", 
            RowBox[{"fun", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "fun", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        FractionBox[
         RowBox[{"Lxi", ".", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox["val", 
             RowBox[{"kB", " ", "T"}]]}]]}], 
         RowBox[{"Tr", "[", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox["val", 
             RowBox[{"kB", " ", "T"}]]}]], "]"}]], ",", 
        FractionBox[
         RowBox[{"Lyi", ".", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox["val", 
             RowBox[{"kB", " ", "T"}]]}]]}], 
         RowBox[{"Tr", "[", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox["val", 
             RowBox[{"kB", " ", "T"}]]}]], "]"}]], ",", 
        FractionBox[
         RowBox[{"Lzi", ".", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox["val", 
             RowBox[{"kB", " ", "T"}]]}]]}], 
         RowBox[{"Tr", "[", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox["val", 
             RowBox[{"kB", " ", "T"}]]}]], "]"}]]}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4659117208833933`*^9, 3.465911774021215*^9}, {
  3.465911846340757*^9, 3.465911889422319*^9}, {3.4659159489990377`*^9, 
  3.465915965118555*^9}, {3.465916416481284*^9, 3.46591646362114*^9}, {
  3.465971470951943*^9, 3.46597150742715*^9}}],

Cell["Define CalculateM1M2", "SubsectionIcon",
 CellChangeTimes->{{3.466088517354959*^9, 3.46608855991679*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CalculateM1M2", "[", 
    RowBox[{"H_", ",", "Bmag_", ",", "J_", ",", "T_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "Sx1", ",", "Sy1", ",", "Sz1", ",", "Sx2", ",", "Sy2", ",", "Sz2", ",", 
       "S1tot", ",", "S2tot", ",", "MaxCycles", ",", "ConvAcc", ",", 
       "Sprevious", ",", "Sxdamp", ",", "Sydamp", ",", "Szdamp"}], "}"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "When", " ", "the", " ", "calcualtion", " ", "is", " ", "finished", " ",
        "it", " ", "is", " ", "nice", " ", "to", " ", "know", " ", "how", " ",
        "long", " ", "it", " ", "took", " ", "and", " ", "what", " ", "the", 
       " ", "intermediate", " ", "values", " ", "of", " ", "S", " ", "were"}],
       " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ClearAll", "[", 
       RowBox[{"ConvergenceSteps", ",", "SHistory"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Start", " ", "with", " ", "site", " ", "1", " ", "without", " ", 
        "exchange", " ", "field"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Sx2", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Sy2", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Sz2", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Sx1", ",", "Sy1", ",", "Sz1"}], "}"}], "=", 
       RowBox[{"CalculateS", "[", 
        RowBox[{"H", ",", "Bmag", ",", 
         RowBox[{
          RowBox[{"-", "J"}], 
          RowBox[{"{", 
           RowBox[{"Sx2", ",", "Sy2", ",", "Sz2"}], "}"}]}], ",", "T"}], 
        "]"}]}], ";", 
      StyleBox["\[IndentingNewLine]",
       FontColor->RGBColor[0, 0, 1]], 
      StyleBox[
       RowBox[{"(*", " ", 
        RowBox[{
        "Calculate", " ", "site", " ", "2", " ", "with", " ", "exchange", " ",
          "field", " ", "of", " ", "site", " ", "one", " ", "and", " ", 
         "small", " ", "distortion"}], " ", "*)"}],
       FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
      RowBox[{"S1tot", "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Sx1", ",", "Sy1", ",", "Sz1"}], "}"}], ".", 
        RowBox[{"{", 
         RowBox[{"Sx1", ",", "Sy1", ",", "Sz1"}], "}"}]}]}], ";", 
      StyleBox["\[IndentingNewLine]",
       FontColor->RGBColor[0, 0, 1]], 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Sx2", ",", "Sy2", ",", "Sz2"}], "}"}], "=", 
       RowBox[{"CalculateS", "[", 
        RowBox[{"H", ",", "Bmag", ",", 
         RowBox[{
          RowBox[{"-", "J"}], 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Sx1", "+", 
             RowBox[{"RandomReal", "[", 
              RowBox[{"0.1", "S1tot"}], "]"}]}], ",", 
            RowBox[{"Sy1", "+", 
             RowBox[{"RandomReal", "[", 
              RowBox[{"0.1", "S1tot"}], "]"}]}], ",", 
            RowBox[{"Sz1", "+", 
             RowBox[{"RandomReal", "[", 
              RowBox[{"0.1", "S1tot"}], "]"}]}]}], "}"}]}], ",", "T"}], 
        "]"}]}], ";", 
      StyleBox["\[IndentingNewLine]",
       FontColor->RGBColor[0, 0, 1]], 
      StyleBox[
       RowBox[{"(*", " ", 
        RowBox[{
        "Calculate", " ", "site", " ", "2", " ", "with", " ", "exchange", " ",
          "field", " ", "of", " ", "site", " ", "one", " ", "and", " ", 
         "small", " ", "distortion"}], " ", "*)"}],
       FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
      RowBox[{"S2tot", "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Sx2", ",", "Sy2", ",", "Sz2"}], "}"}], ".", 
        RowBox[{"{", 
         RowBox[{"Sx2", ",", "Sy2", ",", "Sz2"}], "}"}]}]}], ";", 
      StyleBox["\[IndentingNewLine]",
       FontColor->RGBColor[0, 0, 1]], 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Sx1", ",", "Sy1", ",", "Sz1"}], "}"}], "=", 
       RowBox[{"CalculateS", "[", 
        RowBox[{"H", ",", "Bmag", ",", 
         RowBox[{
          RowBox[{"-", "J"}], 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Sx2", "+", 
             RowBox[{"RandomReal", "[", 
              RowBox[{"0.1", "S2tot"}], "]"}]}], ",", 
            RowBox[{"Sy2", "+", 
             RowBox[{"RandomReal", "[", 
              RowBox[{"0.1", "S2tot"}], "]"}]}], ",", 
            RowBox[{"Sz2", "+", 
             RowBox[{"RandomReal", "[", 
              RowBox[{"0.1", "S2tot"}], "]"}]}]}], "}"}]}], ",", "T"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"SHistory", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", " ", 
           RowBox[{"Sx1", ",", "Sy1", ",", " ", "Sz1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Sx2", ",", "Sy2", ",", "Sz2"}], "}"}]}], "}"}], "}"}]}], 
      ";", "\[IndentingNewLine]", 
      StyleBox[
       RowBox[{"(*", " ", 
        RowBox[{"Run", " ", "selveconsistency"}], " ", "*)"}],
       FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
      RowBox[{"MaxCycles", "=", "1000"}], ";", "\[IndentingNewLine]", 
      RowBox[{"ConvAcc", "=", 
       SuperscriptBox["10", 
        RowBox[{"-", "6.5"}]]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Sxdamp", "=", "1"}], ";", 
      RowBox[{"Sydamp", "=", "1"}], ";", 
      RowBox[{"Szdamp", "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"j", "=", "1"}], ",", 
        RowBox[{"j", "<", "MaxCycles"}], ",", 
        RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Sprevious", "=", 
          RowBox[{"{", 
           RowBox[{
           "Sx1", ",", "Sy1", ",", "Sz1", ",", "Sx2", ",", "Sy2", ",", 
            "Sz2"}], "}"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Sx2", ",", "Sy2", ",", "Sz2"}], "}"}], "=", 
          RowBox[{"CalculateS", "[", 
           RowBox[{"H", ",", "Bmag", ",", 
            RowBox[{
             RowBox[{"-", "J"}], " ", 
             RowBox[{"Sprevious", "[", 
              RowBox[{"[", 
               RowBox[{"{", 
                RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], "]"}]}], ",",
             "T"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Sx1", ",", "Sy1", ",", "Sz1"}], "}"}], "=", 
          RowBox[{"CalculateS", "[", 
           RowBox[{"H", ",", "Bmag", ",", 
            RowBox[{
             RowBox[{"-", "J"}], " ", 
             RowBox[{"Sprevious", "[", 
              RowBox[{"[", 
               RowBox[{"{", 
                RowBox[{"4", ",", "5", ",", "6"}], "}"}], "]"}], "]"}]}], ",",
             "T"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"SHistory", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", " ", 
              RowBox[{"Sx1", ",", "Sy1", ",", " ", "Sz1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Sx2", ",", "Sy2", ",", "Sz2"}], "}"}]}], "}"}]}], 
          "]"}], ";", "\[IndentingNewLine]", 
         StyleBox[
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{
            "Detect", " ", "Ossilations", " ", "and", " ", "if", " ", 
             "found"}], ",", " ", 
            RowBox[{"flip", " ", "Hex", " ", "on", " ", "site", " ", "1"}]}], 
           " ", "*)"}],
          FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"j", "\[GreaterEqual]", "4"}], ",", "\[IndentingNewLine]", 
           
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "1", ",", "1"}], "]"}], "]"}], "]"}], 
                 "\[NotEqual]", 
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "1", ",", "1"}], "]"}], 
                   "]"}], "]"}]}], ")"}], "&&", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "1", ",", "1"}], "]"}], "]"}], "]"}], "==", 
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "2"}], ",", "1", ",", "1"}], "]"}], 
                   "]"}], "]"}]}], ")"}], "&&", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "1"}], "]"}], "]"}], "]"}], 
                 "\[NotEqual]", 
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "2", ",", "1"}], "]"}], 
                   "]"}], "]"}]}], ")"}], "&&", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "1"}], "]"}], "]"}], "]"}], "==", 
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "2"}], ",", "2", ",", "1"}], "]"}], 
                   "]"}], "]"}]}], ")"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"Sx1", "=", 
                RowBox[{
                 RowBox[{"-", "Sxdamp"}], 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"Sx1", "+", 
                    RowBox[{
                    RowBox[{"Sign", "[", "Sx1", "]"}], "Sx2"}]}], ")"}], "/", 
                  "2.0"}]}]}], ";", 
               RowBox[{"Sxdamp", "*=", "0.95"}], ";"}], ",", 
              RowBox[{
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "1", ",", "1"}], "]"}], "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "2"}], ",", "1", ",", "1"}], "]"}], 
                    "]"}]}], "]"}], "<", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "1", ",", "1"}], "]"}], "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "1", ",", "1"}], "]"}], 
                    "]"}]}], "]"}]}], ")"}], "&&", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "1", ",", "1"}], "]"}], 
                    "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "3"}], ",", "1", ",", "1"}], "]"}], 
                    "]"}]}], "]"}], "<", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "1", ",", "1"}], "]"}], "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "1", ",", "1"}], "]"}], 
                    "]"}]}], "]"}]}], ")"}]}], ",", 
                 RowBox[{"Sx1", "=", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "1", ",", "1"}], "]"}], "]"}], "+", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "1", ",", "1"}], "]"}], 
                    "]"}]}], ")"}], "/", "2"}]}]}], "]"}], ";", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "1"}], "]"}], "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "2"}], ",", "2", ",", "1"}], "]"}], 
                    "]"}]}], "]"}], "<", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "1"}], "]"}], "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "2", ",", "1"}], "]"}], 
                    "]"}]}], "]"}]}], ")"}], "&&", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "2", ",", "1"}], "]"}], 
                    "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "3"}], ",", "2", ",", "1"}], "]"}], 
                    "]"}]}], "]"}], "<", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "1"}], "]"}], "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "2", ",", "1"}], "]"}], 
                    "]"}]}], "]"}]}], ")"}]}], ",", 
                 RowBox[{"Sx2", "=", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "1"}], "]"}], "]"}], "+", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "2", ",", "1"}], "]"}], 
                    "]"}]}], ")"}], "/", "2"}]}]}], "]"}], ";"}]}], "]"}], 
            ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "1", ",", "2"}], "]"}], "]"}], "]"}], 
                 "\[NotEqual]", 
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "1", ",", "2"}], "]"}], 
                   "]"}], "]"}]}], ")"}], "&&", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "1", ",", "2"}], "]"}], "]"}], "]"}], "==", 
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "2"}], ",", "1", ",", "2"}], "]"}], 
                   "]"}], "]"}]}], ")"}], "&&", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "2"}], "]"}], "]"}], "]"}], 
                 "\[NotEqual]", 
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "2", ",", "2"}], "]"}], 
                   "]"}], "]"}]}], ")"}], "&&", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "2"}], "]"}], "]"}], "]"}], "==", 
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "2"}], ",", "2", ",", "2"}], "]"}], 
                   "]"}], "]"}]}], ")"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"Sy1", "=", 
                RowBox[{
                 RowBox[{"-", "Sydamp"}], 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"Sy1", "+", 
                    RowBox[{
                    RowBox[{"Sign", "[", "Sy1", "]"}], "Sy2"}]}], ")"}], "/", 
                  "2.0"}]}]}], ";", 
               RowBox[{"Sydamp", "*=", "0.95"}], ";"}], ",", 
              RowBox[{
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "1", ",", "2"}], "]"}], "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "2"}], ",", "1", ",", "2"}], "]"}], 
                    "]"}]}], "]"}], "<", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "1", ",", "2"}], "]"}], "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "1", ",", "2"}], "]"}], 
                    "]"}]}], "]"}]}], ")"}], "&&", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "1", ",", "2"}], "]"}], 
                    "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "3"}], ",", "1", ",", "2"}], "]"}], 
                    "]"}]}], "]"}], "<", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "1", ",", "2"}], "]"}], "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "1", ",", "2"}], "]"}], 
                    "]"}]}], "]"}]}], ")"}]}], ",", 
                 RowBox[{"Sy1", "=", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "1", ",", "2"}], "]"}], "]"}], "+", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "1", ",", "2"}], "]"}], 
                    "]"}]}], ")"}], "/", "2"}]}]}], "]"}], ";", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "2"}], "]"}], "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "2"}], ",", "2", ",", "2"}], "]"}], 
                    "]"}]}], "]"}], "<", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "2"}], "]"}], "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "2", ",", "2"}], "]"}], 
                    "]"}]}], "]"}]}], ")"}], "&&", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "2", ",", "2"}], "]"}], 
                    "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "3"}], ",", "2", ",", "2"}], "]"}], 
                    "]"}]}], "]"}], "<", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "2"}], "]"}], "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "2", ",", "2"}], "]"}], 
                    "]"}]}], "]"}]}], ")"}]}], ",", 
                 RowBox[{"Sy2", "=", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "2"}], "]"}], "]"}], "+", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "2", ",", "2"}], "]"}], 
                    "]"}]}], ")"}], "/", "2"}]}]}], "]"}], ";"}]}], "]"}], 
            ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "1", ",", "3"}], "]"}], "]"}], "]"}], 
                 "\[NotEqual]", 
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "1", ",", "3"}], "]"}], 
                   "]"}], "]"}]}], ")"}], "&&", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "1", ",", "3"}], "]"}], "]"}], "]"}], "==", 
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "2"}], ",", "1", ",", "3"}], "]"}], 
                   "]"}], "]"}]}], ")"}], "&&", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "3"}], "]"}], "]"}], "]"}], 
                 "\[NotEqual]", 
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "2", ",", "3"}], "]"}], 
                   "]"}], "]"}]}], ")"}], "&&", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "3"}], "]"}], "]"}], "]"}], "==", 
                 RowBox[{"Sign", "[", 
                  RowBox[{"SHistory", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "2"}], ",", "2", ",", "3"}], "]"}], 
                   "]"}], "]"}]}], ")"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"Sz1", "=", 
                RowBox[{
                 RowBox[{"-", "Szdamp"}], 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"Sz1", "+", 
                    RowBox[{
                    RowBox[{"Sign", "[", "Sz1", "]"}], "Sz2"}]}], ")"}], "/", 
                  "2.0"}]}]}], ";", 
               RowBox[{"Szdamp", "*=", "0.95"}], ";"}], ",", 
              RowBox[{
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "1", ",", "3"}], "]"}], "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "2"}], ",", "1", ",", "3"}], "]"}], 
                    "]"}]}], "]"}], "<", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "1", ",", "3"}], "]"}], "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "1", ",", "3"}], "]"}], 
                    "]"}]}], "]"}]}], ")"}], "&&", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "1", ",", "3"}], "]"}], 
                    "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "3"}], ",", "1", ",", "3"}], "]"}], 
                    "]"}]}], "]"}], "<", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "1", ",", "3"}], "]"}], "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "1", ",", "3"}], "]"}], 
                    "]"}]}], "]"}]}], ")"}]}], ",", 
                 RowBox[{"Sz1", "=", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "1", ",", "3"}], "]"}], "]"}], "+", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "1", ",", "3"}], "]"}], 
                    "]"}]}], ")"}], "/", "2"}]}]}], "]"}], ";", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "3"}], "]"}], "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "2"}], ",", "2", ",", "3"}], "]"}], 
                    "]"}]}], "]"}], "<", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "3"}], "]"}], "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "2", ",", "3"}], "]"}], 
                    "]"}]}], "]"}]}], ")"}], "&&", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "2", ",", "3"}], "]"}], 
                    "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "3"}], ",", "2", ",", "3"}], "]"}], 
                    "]"}]}], "]"}], "<", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "3"}], "]"}], "]"}], "-", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "2", ",", "3"}], "]"}], 
                    "]"}]}], "]"}]}], ")"}]}], ",", 
                 RowBox[{"Sz2", "=", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "3"}], "]"}], "]"}], "+", 
                    RowBox[{"SHistory", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "-", "1"}], ",", "2", ",", "3"}], "]"}], 
                    "]"}]}], ")"}], "/", "2"}]}]}], "]"}], ";"}]}], "]"}], 
            ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "test", " ", "if", " ", "convergence", " ", "is", " ", "reached"}], 
          " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Abs", "[", 
               RowBox[{
                RowBox[{"Sprevious", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "-", "Sx1"}], "]"}], "<", 
              "ConvAcc"}], ")"}], "&&", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Abs", "[", 
               RowBox[{
                RowBox[{"Sprevious", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "-", "Sy1"}], "]"}], "<", 
              "ConvAcc"}], ")"}], "&&", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Abs", "[", 
               RowBox[{
                RowBox[{"Sprevious", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "-", "Sz1"}], "]"}], "<", 
              "ConvAcc"}], ")"}], "&&", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Abs", "[", 
               RowBox[{
                RowBox[{"Sprevious", "[", 
                 RowBox[{"[", "4", "]"}], "]"}], "-", "Sx2"}], "]"}], "<", 
              "ConvAcc"}], ")"}], "&&", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Abs", "[", 
               RowBox[{
                RowBox[{"Sprevious", "[", 
                 RowBox[{"[", "5", "]"}], "]"}], "-", "Sy2"}], "]"}], "<", 
              "ConvAcc"}], ")"}], "&&", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Abs", "[", 
               RowBox[{
                RowBox[{"Sprevious", "[", 
                 RowBox[{"[", "6", "]"}], "]"}], "-", "Sz2"}], "]"}], "<", 
              "ConvAcc"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"ConvergenceSteps", "=", "j"}], ";", 
            RowBox[{"j", "=", 
             RowBox[{"MaxCycles", "+", "2"}]}]}]}], "]"}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"j", "!=", 
         RowBox[{"MaxCycles", "+", "3"}]}], ",", 
        RowBox[{"Print", "[", "\"\<Convergence not reached\>\"", "]"}]}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "convergence", " ", "or", " ", "max", " ", "number", " ", "of", " ", 
        "cycles", " ", "reached"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Chop", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CalculateL", "[", 
            RowBox[{"H", ",", "Bmag", ",", 
             RowBox[{"J", 
              RowBox[{"{", 
               RowBox[{"Sx1", ",", "Sy1", ",", "Sz1"}], "}"}]}], ",", "T"}], 
            "]"}], ",", 
           RowBox[{"CalculateL", "[", 
            RowBox[{"H", ",", "Bmag", ",", 
             RowBox[{"J", 
              RowBox[{"{", 
               RowBox[{"Sx2", ",", "Sy2", ",", "Sz2"}], "}"}]}], ",", "T"}], 
            "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CalculateS", "[", 
            RowBox[{"H", ",", "Bmag", ",", 
             RowBox[{"J", 
              RowBox[{"{", 
               RowBox[{"Sx1", ",", "Sy1", ",", "Sz1"}], "}"}]}], ",", "T"}], 
            "]"}], ",", 
           RowBox[{"CalculateS", "[", 
            RowBox[{"H", ",", "Bmag", ",", 
             RowBox[{"J", 
              RowBox[{"{", 
               RowBox[{"Sx2", ",", "Sy2", ",", "Sz2"}], "}"}]}], ",", "T"}], 
            "]"}]}], "}"}]}], "}"}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4659124577803288`*^9, 3.465912559662745*^9}, {
   3.465912813300881*^9, 3.465912963817987*^9}, {3.465913044901437*^9, 
   3.46591317991335*^9}, {3.465913234965157*^9, 3.465913287161027*^9}, {
   3.465913336814735*^9, 3.4659133917482758`*^9}, {3.465913426915039*^9, 
   3.4659135622683907`*^9}, {3.465913625945842*^9, 3.4659136747309427`*^9}, {
   3.465913827183642*^9, 3.465913829561982*^9}, {3.465915847463027*^9, 
   3.465915863793844*^9}, {3.4659161240358057`*^9, 3.465916125664805*^9}, {
   3.465916212131138*^9, 3.46591636643369*^9}, {3.465916589628965*^9, 
   3.465916593463965*^9}, {3.465916628750423*^9, 3.46591670497421*^9}, {
   3.465916782204116*^9, 3.465916847017748*^9}, {3.465916975161915*^9, 
   3.465917088601272*^9}, {3.4659171744624357`*^9, 3.465917176094433*^9}, {
   3.46591729094123*^9, 3.4659173681050673`*^9}, {3.465917442761932*^9, 
   3.4659174875947447`*^9}, {3.465917768836399*^9, 3.4659177712450867`*^9}, {
   3.4659180422598953`*^9, 3.4659180809022083`*^9}, {3.4659187246502857`*^9, 
   3.4659189033815203`*^9}, {3.4659193201201143`*^9, 3.465919363217135*^9}, {
   3.4659194941461697`*^9, 3.46591952740126*^9}, {3.465919566575761*^9, 
   3.4659195704356403`*^9}, {3.4659199140234823`*^9, 3.465920013103808*^9}, {
   3.465920136431404*^9, 3.4659202154789867`*^9}, {3.465920296235798*^9, 
   3.465920310106084*^9}, {3.465969139389894*^9, 3.465969377858623*^9}, {
   3.465969453388926*^9, 3.465969524691024*^9}, {3.46596956420973*^9, 
   3.465969852432819*^9}, {3.46596997767661*^9, 3.465969978699073*^9}, {
   3.4659700317777023`*^9, 3.465970032005911*^9}, {3.46597010161335*^9, 
   3.465970132209749*^9}, {3.465970287976963*^9, 3.465970306263052*^9}, {
   3.465970409441749*^9, 3.465970411128146*^9}, {3.4659704949822083`*^9, 
   3.465970495493362*^9}, {3.465970550983974*^9, 3.465970570008939*^9}, {
   3.465970608598961*^9, 3.465970616958641*^9}, {3.465970651538425*^9, 
   3.465970684770102*^9}, {3.465970769490212*^9, 3.4659707872511997`*^9}, {
   3.465970856321786*^9, 3.4659708727633533`*^9}, 3.4659710235191793`*^9, {
   3.465971516694894*^9, 3.4659715200647297`*^9}, 3.466097845990814*^9, {
   3.466098558252212*^9, 3.466098558966917*^9}}],

Cell["Define the function PlotMagneticVector[\[Phi]_,OSx_,OSy_,OSz_]", \
"SubsectionIcon"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PlotMagneticVector", "[", 
   RowBox[{"psi_", ",", "OSx_", ",", "OSy_", ",", "OSz_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S", ",", "Sx", ",", "Sy", ",", "Sz", ",", "Seff"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S", "=", 
      RowBox[{"Chop", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox[
           RowBox[{"1", "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"psi", "\[Conjugate]"}], ".", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"OSx", ".", "OSx"}], ")"}], "+", 
                 RowBox[{"(", 
                  RowBox[{"OSy", ".", "OSy"}], ")"}], "+", 
                 RowBox[{"(", 
                  RowBox[{"OSz", ".", "OSz"}], ")"}]}], ")"}], ".", "psi"}], 
              ")"}]}]}]]}], ")"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Sx", "=", 
      RowBox[{"Chop", "[", 
       RowBox[{
        RowBox[{"psi", "\[Conjugate]"}], ".", "OSx", ".", "psi"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"Sy", "=", 
      RowBox[{"Chop", "[", 
       RowBox[{
        RowBox[{"psi", "\[Conjugate]"}], ".", "OSy", ".", "psi"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"Sz", "=", 
      RowBox[{"Chop", "[", 
       RowBox[{
        RowBox[{"psi", "\[Conjugate]"}], ".", "OSz", ".", "psi"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"Seff", "=", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["Sx", "2"], "+", 
        SuperscriptBox["Sy", "2"], "+", 
        SuperscriptBox["Sz", "2"]}]]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ParametricPlot3D", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"S", " ", 
              RowBox[{"Cos", "[", "t", "]"}]}], ",", 
             RowBox[{"S", " ", 
              RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", 
             RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
           RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
           RowBox[{"ColorFunction", "\[Rule]", 
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
              RowBox[{"RGBColor", "[", 
               RowBox[{"0.5", ",", "0.5", ",", "0.5"}], "]"}]}], "]"}]}]}], 
          "]"}], ",", 
         RowBox[{"ParametricPlot3D", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"S", " ", 
              RowBox[{"Cos", "[", "t", "]"}]}], ",", "0", ",", 
             RowBox[{"S", " ", 
              RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", 
             RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
           RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
           RowBox[{"ColorFunction", "\[Rule]", 
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
              RowBox[{"RGBColor", "[", 
               RowBox[{"0.5", ",", "0.5", ",", "0.5"}], "]"}]}], "]"}]}]}], 
          "]"}], ",", 
         RowBox[{"ParametricPlot3D", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"S", " ", 
              RowBox[{"Cos", "[", "t", "]"}]}], ",", 
             RowBox[{"S", " ", 
              RowBox[{"Sin", "[", "t", "]"}]}], ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", 
             RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
           RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
           RowBox[{"ColorFunction", "\[Rule]", 
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
              RowBox[{"RGBColor", "[", 
               RowBox[{"0.5", ",", "0.5", ",", "0.5"}], "]"}]}], "]"}]}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"ParametricPlot3D", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"Seff", " ", 
              RowBox[{"Cos", "[", "t", "]"}]}], ",", 
             RowBox[{"Seff", " ", 
              RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", 
             RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
           RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
           RowBox[{"ColorFunction", "\[Rule]", 
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
              RowBox[{"RGBColor", "[", 
               RowBox[{"0.5", ",", "0.5", ",", "1"}], "]"}]}], "]"}]}]}], 
          "]"}], ",", 
         RowBox[{"ParametricPlot3D", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Seff", " ", 
              RowBox[{"Cos", "[", "t", "]"}]}], ",", "0", ",", 
             RowBox[{"Seff", " ", 
              RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", 
             RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
           RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
           RowBox[{"ColorFunction", "\[Rule]", 
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
              RowBox[{"RGBColor", "[", 
               RowBox[{"0.5", ",", "0.5", ",", "1"}], "]"}]}], "]"}]}]}], 
          "]"}], ",", 
         RowBox[{"ParametricPlot3D", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Seff", " ", 
              RowBox[{"Cos", "[", "t", "]"}]}], ",", 
             RowBox[{"Seff", " ", 
              RowBox[{"Sin", "[", "t", "]"}]}], ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", 
             RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
           RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
           RowBox[{"ColorFunction", "\[Rule]", 
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
              RowBox[{"RGBColor", "[", 
               RowBox[{"0.5", ",", "0.5", ",", "1"}], "]"}]}], "]"}]}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Thickness", "[", ".005", "]"}], ",", 
              RowBox[{"RGBColor", "[", 
               RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"Sx", ",", "Sy", ",", "Sz"}], "}"}]}], "}"}], 
               "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"RGBColor", "[", 
               RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"Sx", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}]}],
              "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"RGBColor", "[", 
               RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "Sy", ",", "0"}], "}"}]}], "}"}], "]"}]}],
              "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"RGBColor", "[", 
               RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0", ",", "Sz"}], "}"}]}], "}"}], "]"}]}],
              "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"RGBColor", "[", 
               RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0", ",", "Sz"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "Sy", ",", "Sz"}], "}"}]}], "}"}], 
               "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"RGBColor", "[", 
               RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "Sy", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "Sy", ",", "Sz"}], "}"}]}], "}"}], 
               "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"RGBColor", "[", 
               RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "Sy", ",", "Sz"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"Sx", ",", "Sy", ",", "Sz"}], "}"}]}], "}"}], 
               "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"RGBColor", "[", 
               RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"Sx", ",", "0", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"Sx", ",", "Sy", ",", "0"}], "}"}]}], "}"}], 
               "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"RGBColor", "[", 
               RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "Sy", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"Sx", ",", "Sy", ",", "0"}], "}"}]}], "}"}], 
               "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"RGBColor", "[", 
               RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"Sx", ",", "Sy", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"Sx", ",", "Sy", ",", "Sz"}], "}"}]}], "}"}], 
               "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"RGBColor", "[", 
               RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"Sx", ",", "0", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"Sx", ",", "0", ",", "Sz"}], "}"}]}], "}"}], 
               "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"RGBColor", "[", 
               RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0", ",", "Sz"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"Sx", ",", "0", ",", "Sz"}], "}"}]}], "}"}], 
               "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"RGBColor", "[", 
               RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"Sx", ",", "0", ",", "Sz"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"Sx", ",", "Sy", ",", "Sz"}], "}"}]}], "}"}], 
               "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"RGBColor", "[", 
               RowBox[{"0.5", ",", "0.5", ",", "0.5"}], "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0", ",", 
                   RowBox[{"-", "S"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0", ",", "S"}], "}"}]}], "}"}], "]"}]}], 
             "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"RGBColor", "[", 
               RowBox[{"0.5", ",", "0.5", ",", "0.5"}], "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", 
                   RowBox[{"-", "S"}], ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "S", ",", "0"}], "}"}]}], "}"}], "]"}]}], 
             "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"RGBColor", "[", 
               RowBox[{"0.5", ",", "0.5", ",", "0.5"}], "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", "S"}], ",", "0", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"S", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}]}], 
             "}"}]}], "\[IndentingNewLine]", "}"}], "]"}]}], "}"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "True"}], ",", 
       RowBox[{"BoxRatios", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}]}], 
       ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "S"}], ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "S"}], ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "S"}], ",", "S"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "1"}], "}"}]}], ",", 
       RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}]}], 
      "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.466094283123258*^9, 3.4660942883739862`*^9}, {
  3.466094817543771*^9, 3.466094818912092*^9}, {3.466094895218903*^9, 
  3.4660949740433483`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Energy level diagram, temperature, magnetic susceptibility and spin dynamics\
\>", "Section"],

Cell[CellGroupData[{

Cell["d1 system as a function of 10Dq", "Subsection",
 CellChangeTimes->{{3.46608246058114*^9, 3.466082474199586*^9}}],

Cell[CellGroupData[{

Cell["Define basis", "Subsubsection",
 CellChangeTimes->{{3.466082118798918*^9, 3.466082120792042*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CIBasisShellDegeneracy", "=", 
    RowBox[{"{", "10", "}"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "there", " ", "are", " ", "10", " ", "fermions", " ", "in", " ", "a", " ", 
    "d", " ", "shell", " ", "5", " ", "orbitals", " ", "each", " ", "with", 
    " ", "either", " ", "spin", " ", "up", " ", "or", " ", "down"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CIBasisShellFilling", "=", 
    RowBox[{"{", 
     RowBox[{"{", "1", "}"}], "}"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"I", " ", "have", " ", "one", " ", "configuration"}], ",", " ", 
    RowBox[{"which", " ", "has", " ", "9", " ", "electrons"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CIBasis", "=", 
    RowBox[{"{", 
     RowBox[{"CIBasisShellDegeneracy", ",", "CIBasisShellFilling"}], "}"}]}], 
   ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "In", " ", "order", " ", "to", " ", "pass", " ", "the", " ", "basis", " ", 
    "around", " ", "I", " ", "create", " ", "a", " ", "list", " ", "of", " ", 
    "them"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CIBasisFull", "=", 
    RowBox[{"CISetMultiplicity", "[", "CIBasis", "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "I", " ", "need", " ", "in", " ", "almost", " ", "all", " ", 
     "subroutines", " ", "information", " ", "about", " ", "the", " ", 
     "multiplicity", " ", "of", " ", "the", " ", "basis"}], ",", " ", 
    RowBox[{
    "so", " ", "I", " ", "calcualte", " ", "it", " ", "once", " ", "and", " ",
      "pass", " ", "it", " ", "allong"}]}], " ", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.523353273494269*^9, 3.523353276298469*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Define Operators", "Subsubsection",
 CellChangeTimes->{{3.466082118798918*^9, 3.466082142335805*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Timing", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"OppSx", "=", 
      RowBox[{"CIOperatorSx", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppSy", "=", 
      RowBox[{"CIOperatorSy", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppSz", "=", 
      RowBox[{"CIOperatorSz", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppSsqr", "=", 
      RowBox[{"CIOperatorSsqr", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLx", "=", 
      RowBox[{"CIOperatorLx", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLy", "=", 
      RowBox[{"CIOperatorLy", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLz", "=", 
      RowBox[{"CIOperatorLz", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLsqr", "=", 
      RowBox[{"CIOperatorLsqr", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJx", "=", 
      RowBox[{"CIOperatorJx", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJy", "=", 
      RowBox[{"CIOperatorJy", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJz", "=", 
      RowBox[{"CIOperatorJz", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJsqr", "=", 
      RowBox[{"CIOperatorJsqr", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppCF", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "VOhd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Oppldots", "=", 
      RowBox[{"CIOperatorldots", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppU", "=", 
      RowBox[{"CIOperatorU", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Fdd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNeg", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnegd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNt2g", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnt2gd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNz2", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnz2d"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNx2y2", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnx2y2d"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNyz", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnyzd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNxz", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnxzd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNxy", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnxyd"}], "]"}]}], ";"}], "\[IndentingNewLine]", "]"}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.4660778074018173`*^9, 3.466077831177351*^9}, {
  3.4660778798659077`*^9, 3.466077889735778*^9}, {3.4660829512058773`*^9, 
  3.4660829538541117`*^9}, {3.4660835755891857`*^9, 3.466083692904258*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7.609706`", ",", "Null"}], "}"}]], "Print",
 CellChangeTimes->{3.466083706466501*^9, 3.466083919610579*^9, 
  3.466084053368881*^9, 3.466085934643907*^9, 3.523353287534669*^9, 
  3.5245047192702007`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create the Hamiltonian as a function of 10Dq", "Subsubsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "Hamiltonian", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eeg", "=", 
   RowBox[{"0.6", "tenDq"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Et2g", "=", 
   RowBox[{
    RowBox[{"-", "0.4"}], " ", "tenDq"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Hamiltonian", "[", "tenDq_", "]"}], ":=", 
  RowBox[{"Evaluate", "[", "OppCF", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"Eeg", ",", "Et2g"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4660778514661293`*^9, 3.4660778551711407`*^9}, {
  3.4660779037788553`*^9, 3.46607802956116*^9}, {3.466082259181775*^9, 
  3.466082289094554*^9}, {3.466082411016951*^9, 3.46608241717595*^9}, {
  3.466082791187235*^9, 3.466082809161236*^9}, {3.4660849476050386`*^9, 
  3.4660849607579107`*^9}, {3.466084996503484*^9, 3.466084999859572*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot energy level diagram", "Subsubsection",
 CellChangeTimes->{{3.466082118798918*^9, 3.466082142335805*^9}, {
  3.466082201199407*^9, 3.4660822107268267`*^9}, {3.466082444171822*^9, 
  3.466082448167088*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EnergyLevelDiagram", "[", 
  RowBox[{"Hamiltonian", ",", "0.0", ",", "3.0", ",", "100"}], "]"}]], "Input",\

 CellChangeTimes->{{3.466084880276795*^9, 3.466084893875984*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJxdlHlIVFEYxcdxnJHwj4g2QsyiwqgoKYsw+772hSKsiAgJibSIKIsIMQlE
pCIiIqKNijYqCAlpkQpvaFKYDea+O844LjPqbOq4ZPXuveevLgyPmffed885
v3Nn3pHTezPMJpMpw/jI6/+rOK7Am1r8kMYvnvh87uZlob8X4vsdMaXhaVbK
lA+0rmPPtdunnuB+Ce6/FKtWylVGH/V7eP4bni8Szpzphds6Kyh2edsCa947
vG/H+8Vie6d84Bc128P7XM8/YV4N5pWIufISV0e71lzZkO7+gvkNmF8qRhLS
rpcON9LSSzOb7OEy7NeM/cpFpVqtBF3Yvx37fxd71Q8O8ixKjH4dWwE9ndDz
Q6xXLzqp8nzJoznLf0KfC/rsYrHcPqGL9rue3/8aXwW9btqt9FaJGcawnOnd
tOXqyZ6JV7+gvwf6q4Wm0EtJ2jf89MJPjehPlQL7aGHLmKG4Fv488Fcn6lUc
XpqW/6Xi8ZZ6+O2H3wZhiDMGDpB5iRzYAP+D8N8olLxCHwWrdx+ZerAJefiR
RzPm+cmhc0U+AeTTgvkBqpovBbYiryBVqLzasF+QpLr3oTbkF0J+7dg/RG/O
Hr8xkNuBPIeQp0M8ky6eDlGqkda0fAfyHUYfHOLeXbmGCdyQ9whtVnl3iutK
4AhR0uGPO2KcyD+M/J1CjSsIk8blBI9R8HCJC3JqziitkHHfcoHPKPi4xBkp
L2uMEmRch7rAa4wWKF5d4limXOMUr3sBfuPg5xbKbtoEzWqSgbrBcwI8u8Hj
N01dVvTA96IbPH6Dbw94TJIt79YmwzJ4TIJ3D3j8IVNddt+ixF7w+AP+veDx
l8K6d+DxF33oQ54m9ufKBPugx8S6Hx7ka2K3KoAH+kys++JB3hGs4tvkhd4I
1v3xIv8IrpfyovuhP4J1n/rBw8x23Wv4MbM+jwPgY+byeNUg+DNzqerbAHiZ
ueTczdmWA4PwG8m6f4PgF8nvvsuBPviP5CLVR59Q8ryRbMA9mtzhQz8trPvp
FwpvpoVxbtBXC+u++oWupYX3GGmufetHf6NY/z/4wT+Kd8ZIYgH0OYpxzoQ+
xlG89X1osjY7AB5W1v8nAfCw8sZ0SSAAHlbWfQ+Ch5VT9LkEDxvr/gfBw8bJ
b2UAQfCwsT4PQfCw8Wo5zhwCj2jW5yMk/gGNjD+q
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJxdlHlIVFEYxcdxHCX6Q6KNCLMwMSpM2oiw72tfSEqLiIgQyYqINiTCJAiR
ioiIiDYqyqSCkJA0afGGFYnZYJZ75jjj6DijzqaOa/XuveevLgzDm/fed885
v3NnbtaJjGyzyWTKNj7y+/9VHlfgTS9/QKPnj77LuXFJ6OtiXN8WkxoLT6ZO
ek2r23dcvXX8Me5X4P4zsWypXB/pjX4Pz3/B8yXCkTu1eHNHNc1ObkuwXijF
+za8Xy62dMgHvlOLLbzLWfQW835gXoWYI7/i6mn7ystrM10fML8R8yvFUNL+
a5WDTbTo4vRmW/gj9mvBfp9FjVq/CLqw/2/sXyUy1A928iSmxLyYXQ09HdDz
VaxRLzqo5kzFw1nJ36DPCX02sUBun9RJu51F9z7F10Kvi9KU3loxzRiWO7WL
Nlw51j32/Dv0d0N/ndAU3LRc+4YfN/z8EL3pUmAPzW8dMRT/hD8P/NWLBhWH
l6bkf6h+tLEBfnvht1EY4oyBfWReKAc2wn8//DcJJa/YR8G6tKzYvc3Iw488
WjDPT3adK/IJIJ9WzA9Q7Twp8BfyClK1yqsN+wVJqisLtSG/EPL7jf1D9PL0
ket9ee3IcwB52sUT6aJwgHYaaU3JtyPfQfTBLu7ekWuQwA15DyHvDnFNCRwi
Wn7gzdbJDuQfRv4OocYVhEnjcoDHMHg4xTk5NXeYlsi4bzrBZxh8nOKUlHdy
hJJkXPs6wWuEEhSvTnH4kFyjFK97AX6j4OcSyu7+MZrRLAN1gecYeHaBxzjF
Li6573vaBR7j4NsNHhMUfeHmesMyeEyAdzd4/CFT/dmexBQ3ePwBfzd4/KWw
7h14/EUfepCnif15MsEe6DGx7ocH+ZrYpQrggT4T6754kHcEq/jWe6E3gnV/
vMg/ghukvJhe6I9g3ade8DCzTfcafsysz2Mf+Jj5c7xqEPyZuVL1rQ+8zPw+
58ZMy55++I1k3b9+8Ivk0io50Af/kVyi+ugTSp43kg24B1e3+9BPC+t++oXC
e8jCODfoq4V1X/1C19LCO4w0V73yo79RrP8f/OAfxdsmS2IB9DmKcc6EPsZR
vKksNPHzbAA8rKz7HQAPK6/LlAQC4GFl3fcgeFg5VZ9L8Ihm3f8geBjXr2QA
QfCIZn0eguARzSvkOHMIPGJYn4+Q+AdodD+f
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJxdk3lIVFEYxceZcUYkKKSNiLIIMSoqKqKivq99odUiIiQisiKiDYmwCCKi
IkJCpI2KMqkgJCRNrLxiSTGVWGqT5jKLo7M6Wzoumb377vmrC8PjzXvvu+ec
37nTDpzIyjEaDIYc7Sev/6+KKZcDOyoe0OCFo29zC64KdV+C+9si1V50cnnq
a1rWse3GreOP8bwKz5+JhQvkek+V6ju8/xHvlwpX3tiS9U4bTZ7bNsNysQzf
1+H7CrHBKV/4Ri11iZ3u4jeY14B5VWKqvExpos2Lr63c76nGfDvm14i+zOz8
mt6fNPvK+Oa6xHvs14L9asUXfbUSdGH/duz/SWTpfzjInzE/5cVkG/Q4oeez
WKF/6CLbmaqHk+Z+hT439NWJmXL7zE7a5S6+9yG9Hno90FsvxmnD8sZ20Zrr
x7qHnn+D/m7o/y4UBS/BN/x44adBBHdIgT6a8WtAU9wIf374axI/9DgClHap
2vZo7Q/4DcKvXWjitIEhMs6SA+3w3wP/P4UuryRMse9bDozZ04w8IsijBfMi
5FC5Ip8o8vmF+VGqny4FtiKvGPJqw34xkurK423IL4782rF/nF6ePnIzdL4D
ef5Gng7xRLoo+k3btbTSLjmQby/ydYi7d+TqJXBD3n3I2ynydYF9RIv2VW4c
5UL+CeTvEvq4ywlSuFzg0Q8ebnFOTs3rp3ky7kI3+PSDj1uckvJODlCmjGtv
J3gNgFenOHxIrkFKV70Av0Hw8wjdbvYQTWiWgXrAcwg8u8DjD42eU3o//LQL
PP6Abzd4DJP1YuFqzTJ4DIN3N3j8pZHGs76M+V7w+Av+XvAYoYTqHXiMoA8+
5Gng8HmZoA96DKz64Ue+BvboBfBDn4FVX/zIO4n1+FYHoDeJVX8CyD+Jm6S8
lCD0J7HqUxA8jPxV9Rp+jKz6FQIfI9em6w2CPyOrvoXAy8jvcgsmmnf3wK+J
Vf96wM/EZZ/kwDD8m1j1MSx0eQETa3APLusIo59mVv2MCB3vITPj3KCvZlZ9
jQhVSzNv1dJc8iqC/iaz6m8E/JN50yhJLIo+JzPOmVDHOJnXlceHG89GwcPC
qt9R8LDwqv2SQBQ8LKz6HgMPCy9X5xI8rKz6HwMPKy99JQOIgYeV1XmIgYeV
9XHGOHikMM6x+AeOK0CI
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJxdk3lIVFEYxceZcUYkKKSNiLIIMSoqKqKivq99odUiIiQisiKiDYmwCCKi
IkJCpI2KMqkgJCRNrLxiSTGVWGqT5jKLo7M6Wzoumb377vmrC8PjzXvvu+ec
37nTDpzIyjEaDIYc7Sev/6+KKZcDOyoe0OCFo29zC64KdV+C+9si1V50cnnq
a1rWse3GreOP8bwKz5+JhQvkek+V6ju8/xHvlwpX3tiS9U4bTZ7bNsNysQzf
1+H7CrHBKV/4Ri11iZ3u4jeY14B5VWKqvExpos2Lr63c76nGfDvm14i+zOz8
mt6fNPvK+Oa6xHvs14L9asUXfbUSdGH/duz/SWTpfzjInzE/5cVkG/Q4oeez
WKF/6CLbmaqHk+Z+hT439NWJmXL7zE7a5S6+9yG9Hno90FsvxmnD8sZ20Zrr
x7qHnn+D/m7o/y4UBS/BN/x44adBBHdIgT6a8WtAU9wIf374axI/9DgClHap
2vZo7Q/4DcKvXWjitIEhMs6SA+3w3wP/P4UuryRMse9bDozZ04w8IsijBfMi
5FC5Ip8o8vmF+VGqny4FtiKvGPJqw34xkurK423IL4782rF/nF6ePnIzdL4D
ef5Gng7xRLoo+k3btbTSLjmQby/ydYi7d+TqJXBD3n3I2ynydYF9RIv2VW4c
5UL+CeTvEvq4ywlSuFzg0Q8ebnFOTs3rp3ky7kI3+PSDj1uckvJODlCmjGtv
J3gNgFenOHxIrkFKV70Av0Hw8wjdbvYQTWiWgXrAcwg8u8DjD42eU3o//LQL
PP6Abzd4DJP1YuFqzTJ4DIN3N3j8pZHGs76M+V7w+Av+XvAYoYTqHXiMoA8+
5Gng8HmZoA96DKz64Ue+BvboBfBDn4FVX/zIO4n1+FYHoDeJVX8CyD+Jm6S8
lCD0J7HqUxA8jPxV9Rp+jKz6FQIfI9em6w2CPyOrvoXAy8jvcgsmmnf3wK+J
Vf96wM/EZZ/kwDD8m1j1MSx0eQETa3APLusIo59mVv2MCB3vITPj3KCvZlZ9
jQhVSzNv1dJc8iqC/iaz6m8E/JN50yhJLIo+JzPOmVDHOJnXlceHG89GwcPC
qt9R8LDwqv2SQBQ8LKz6HgMPCy9X5xI8rKz6HwMPKy99JQOIgYeV1XmIgYeV
9XHGOHikMM6x+AeOK0CI
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJxdk3lIVFEUxmfGcTQRCrGFiDKLKCJE2mg9J2yn1SJCJELSQqKNiDAJIqQi
IkKijYo2WggJaRErb1iRWA7u+zLOuM5os+Wu2bv3fn91YXi8ee+d853v953Z
KccTUy0mkynV+Mnr/ydvZpZnd94DGj6f/ul09mWh73Nwf1tE1Dw5sSbiA61q
2Xnt1rHHeF6A5y/EksXyfCV8h/d/4P1c4cyIztnUWkzT45rm2i68w/d2fJ8n
NrfKF8qo3j6wx/XsI+pVUL7uI2bJy8wq2rb8yrqD7V9Qvwb1C0X//OTrhX21
tPDSlDr7wFf0q0e/7+KXOo0EXejfjP5FIlH94SD3vPjw1zOKoaeVapWen2Kt
+tBJxWcKHk6PK4E+F+a1iwWy/fw22ut6du9bTCn0tkNvqZhsFMuI7qD1V492
jrwsg/5O6C8XmkIXYW7M04V5KkTPbtmpm+Y2DBmKKzGfG/NViWplh4eiLn4p
frShGvP20ATtkzDEGQV7yawK1mD+35i/Vih5OV7yl29PmbS/Dn744Ec96vnI
oX2FP37wakB9P9ljpcBG+BWAX03oFyCp7n2wCf4FwbcZ/YOUc+rIjd7MFvj5
B346xFM5xZM/tMtwK+qiA/72wV+HuHtHnj4CN/jdD79bxXUlsJ9o6YH8LZFO
+D8A/51ClcsaII3LCR6D4OES52TVjEFSdt90gc8g+LjESSnvxBApu5LawGuI
5ihebeJwmjzDhFyA3zD4tQs1bvIITa2ThraD5wh4doDHKE1clHvf+7wDPEaR
507wGCNDXIIxMniMkUUJ7ASPvzReebZ7XnwXePwF/y7wGKc+nTvwGKeAykM3
/DSxN1M62A09Jtb5cMNfE7eVygC4oc/EOi9u+G3memlfggd6zaz3ywP/zVwl
5YX3QL+ZVbn0HvCwcInONeaxsM5XL/hYuDDmjUwQ5rOwzlsveFn48+nsadZ9
vzFvCGMPwC+E3xbJgl7MH8KqWqZXKHmeEH41I+nQqhYv8mllnU+fUHjTrIy9
QV6trPPqEzqWVt5huLnirQ/5DWWdXx/4h/LWSEnMjzyHMvZM6DUO5Y3vg2OV
Z/3gYWOdbz942JiN9MY2+MHDxjrvAfCw8Wq9l+ARxjr/AfAI45XKgAB4hPEy
tQ8B8AhjVc4SBI9wxh6Lf/KcQFY=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJxdlHlIVFEUxmdzxiQoIiMiykyiiAhpo/WcsGihvYgIiZCskGgjIkyCiKiI
iIhoo6IsWoghokUsvGJFYjloau45zozbzNhsjWtq7977/dWFYXjz3jvnO9/v
OzMt68i2bIvJZMo2PvL7/1Mw5Xxga8F9GjiT8/HE9YtCXztxfUsk1eYfXZ70
npa0bL5y8/Aj3C/C/Wdi/jx5PhHew/Nfaal6/rXw5I53rmkto0lzm9PsZ9/i
fRfeLxBrW+UDldTg6t3uffIB9aqoUPcRU+XXlBrasOjSyr1txahfCz0lomdm
5tWSeB3NvjCh3tX7Cf0a0O+L+K5OE0EX+v9C/1KxTf3gJv+M9MSXk8ugp5Xq
lJ5vYoV60UNlJ4seTJpbDn1ezOsSs2T7mT7a4X1y93NKBfS2QW+FSDaK5Y5v
p1WXD3UMPq+E/g7480NoCp2EuTFPJ+apEsGtslMXpTX2G4qrMZ8f89WIn8qO
AI07V1z2cPVPzBukUdonYYgzCnaTWRWsxfy/MX+dUPKcIYr82Jg1dlc9/AjD
jwbUC5Nb+wp/IuDViPoRcqVKgU3wKwq/mtEvSlLdu1gz/IuB7y/0j5Hz+MFr
3Xkt8PMP/HSLx3KK/D+0xXBr3Dk3/I3DX7e4c1ueOIEb/O6B363iqhLYQ7Rg
T+G60R7434v8eIQqd76XNC4PePSBh1ecllVz+0jZfcMLPn3g4xXHpLyj/aTs
2u0Dr36arnj5xIH98gwQcgF+A+DXJtS4mYOUXC8NbQPPQfBsB4+/NGbO63uh
p+3g8Rd57gCPITLEZRgjg8cQWZTADvAYppHqU10z0jvBYxj8O8FjhOI6d+Ax
QlGVhy74aeJQnnSwC3pMrPPhh78m9lXIAPihz8Q6L374beYGaV9GAHrNrPcr
AP/NXCPlJQah38yqXE4QPCxcrnONeSys89UNPhYuSXklE4T5LKzz1g1eFjaG
nWjb+RvzWhl7AH5WflMqC4Ywv5VVtbyQUPICVn4xefe+pS0h5NPGOp9hofDu
tzH2Bnm1sc5rWOhY2niT4ebiN2HkN4F1fsPgn8DrR0tiEeQ5gbFnQq9xAq96
FxuqPhUBDzvrfEfAw85spDe1MQIedtZ5j4KHnZfpvQQPB+v/nyh4OHiJMiAK
Hg5eqPYhCh4OVuUsMfBIZOyx+AfbvEBO
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJxdlHtI01Ecxec2Z4hEREVElIXEIqKiJCLq+5WICpHwQURImKSJRA+DCIso
JCoqxB70QqNMgiIRkbIHKiVpllKp+cpym4/pNrc59/bR7r2nf7ogsu3u+z3n
fM5+K7KPp+VoNRpNTuRP/P//1C67ZEutLaOtf/beuHvsJqnXlXj9hGK7yk9s
i31NP9v86ZaKF/i8Dp9X06aN4nykONxT95tw/x2ZCxdU7jK1UIal4mFjfAO+
34bvf6DdJnHhOyX0Bc/nv2/EvHbMa6Ll4vqyTvL8SMmet/8z5ndh/hfyGTOL
P3i7qb7l8c5Xnlbs68W+b/RVnl+0C3vU/t/Y/4PS5BsDtL4/wXDxTjv0mKCn
g7bLhWZa1CMWdkKfBfq6aLVYbxykmY4zo6s2dEPvELml3h5aWCk2D5P528rI
xF7oH4H+PlIUrNQKncqPFX76yZ4qBI5STfPpukdL/sDfGPwN0E8pw0Zi25aa
Afi1w6+JIuIiAx2UlDUUUWCC/3H4N5OUV+mkxINv98RpLcjDhTwsmOciI3yq
fNzIZxDz3bT0wOHIyCHkNYG8hrBvgoS65tPDyM+D/Eaw30P6fXPXVpeOIM9J
5Gmlp8Je+ST50oVhK/L1og+j9OC+OF5yICeVt48GZd5jVCwF+kjanW9D/n7k
byM57pKf5LgtdvAIgIedzooUCwP0KXnz1aQsB/gEwMdBJ4W8E0ES6a25PA5e
QfBy0pFccUL0EjkrfiHwc5G0mxkmKTffBZ5h8HSBxxTJddMu8JgCXzd4TFNj
fFVBXokbPKbB2w0eM1T/aMm6/oQJ8JgB/wnwmKU34KR4zKIPHuSp4epS57NP
yR7o0bDqhwf5avi5LIAH+jRsBEeVdxQLt1UFk9Abxao/k8g/isuEPIMX+qNY
9ckLHlq+B87Kj5ZVv7zgo+Xbi0WDfPCnZdU3H3hp+XqEflGDD351HIceKH46
viIH+uFfx1rZRz9JeTYdX7iz49rRET/6qWfVzwBJvLl6/tcT1Vc9q74GSP0M
9XzqlhAYRH+jWT0fguAfzUJdy+Mg+hzNDvRIPWaiOa/EcY4SQ+BhYPU8CYGH
gQ9JwyHwMLDqexg8DPyvZ4pHDKv+h8EjhjOEXWcYPGJY/R6mwCOGU8S4oinw
mMOt6OFfy+wf8Q==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJxdlHtIE1AYxeecM0QioiIkzELCiKgoCYn6PomwEAk1IkLCpIdIlBlIWEQh
UlEhVtILFTMJCiwkyh6omGRZivlIzUznnK9tujn39tHuvcd/ujDGtrvvO+f8
zrYu41zKSa1GozkZeIjn/09NZIE5uaaUdg0cvPPg7F1Sr6vw+imFdVdk7w57
Rz2t7lRj5Ut8XovPq2nHdnE+UzjuqftNuP+RhvJWVCUYmumQsfJJY1Q9vt+K
7zfQfoO48JOi+7xXsj41Yl4H5jXRWnE9sosc7UkZy458w/xuzP9Orpi0wgZn
D9U1l+9762jBvt/Y10Y/5PlDCdij9v/F/nZKkW8M0tb+aP214g7oMUBPJ+2R
C4doVa9Y2AV9Rujrpo1ifcwwzXdeHN+wrQd6TWSXentpZZXYPEIjbesDE39D
/yj095GiMEYt0Kn8jMFPP1mShcBxevM1t7YsYgD+JuBvkH5JGWYS2+LeDMKv
BX4NFBAXGGil+HRTQIEB/ifhf4ikvKopij324UC41og8bMjDiHk2ioFPlY8d
+Qxjvp3WHD0RGGlCXtPIy4R90yTUfc0dQX4O5DeK/Q7SHV66ubpkFHnOIM8x
eibsVcyQK1UYHkO+TvRhnB4/EsdJVuSk8nYh7wkqlAJdJO0uNyN/N/I3kxxX
4CY5Ls4CHh7wsNAlkWKeh74k7rwZn24FHw/4WOm8kJftJZHepuuT4OUFryk6
fUocH71CzoqfD/xsJO2m+UnKzbKBpx88beAxS3LdnA08ZsHXDh5z1Bj1Oiez
yA4ec+BtB495qiuL2NIfPQ0e8+A/DR4L9B6cFI8F9MGBPDVcXTL1/EuiA3o0
rPrhQL4afiEL4IA+DceAo8o7iIXb1zkz0BvEqj8zyD+IS4U8vRP6g1j1yQke
Wn4IzsqPllW/nOCj5furRYNc8Kdl1TcXeGn5doB+fr0LfoM5HD1Q/IL5hhzo
hv9g1so+uknKMwfz1eK9t86MutFPHat+ekjiPaXjxZ6ovupY9dVD6meo4wv3
hEAv+hvC6v/BC/4hLNQ1l3vR5xC2okfqbyaEM4uslynWBx56Vv32gYeej0vD
PvDQs+q7Hzz0vNgzxSOUVf/94BHKh4TdKT94hLL6PcyCRygniXH5s+CxhFvQ
w38huyAJ
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJxdlH1ozHEcx+9u9yAtSUhL89DSSUJIS3w+SEham0iS1rKR5KksjUQSQpqH
PMWaWf6gkdYIzcxsM7awzRiz3W63u+3u7J4ft/H7fr/v/eNb13V33/t83u/3
6303K+9ATr5Bp9Plaw/x/P95kX7Gnf3iHi3vzrp0Y/8VUq8r8Po+je8oO7hi
/HPqbIlutpc/wufV+PwZLVkszjtKxT11vwH3X1Fv0eSKdbYm2mIvv1M3swbf
b8H3a2m9TVz4Qhk/4yf2vq7DvFbMa6AZ4np6OwW/bsqbuO0D5ndg/keKWHdc
rg1/p7dNpWurgs3Y14l9n+mTPL9oHfao/b+x/yvlyDd6aGFXhvnU9VbosUFP
G62UC3tp6g+xsB367NDXQXPFemsfjbYdHZiz6Dv0OqD3B02pEJv7qf/zbG1i
J/Q7of8nKQouaoZO5ccFP13kyRYCB6iysbC6JK0b/gbhr4e+SRluEtsyK3vg
1wO/NtLEaQO9tDrXoSmwwf8f+O8lKa9iiJbufLkh1WBHHj7kYcc8H1nhU+Xj
Rz59mO+n9O27tJEO5BVAXg7sC5BQ11jYj/yCyM+J/UEyb50w/9ldJ/IMIU8X
PRD2ykIU2ywMu5BvGPkO0O1b4oTJi5xU3hHkPUiXpcAISbuT3Mg/ivzdJMed
iZIcl+kBjxh4eOiYSLEoRvUbl51flesFnxj4eOmQkHcwTq+19Oad/QNecaqS
vIZod4E4CXqCnBW/BPj5SNrdkaQvQu5eH3gmwdMHHsP0Uawb8YHHMPj6wWOE
3s98enhPsR88RmiV5O0Hj1F6U5K2oCsjAB6j4B8Aj7/0EpwUj7/oQxB56rjy
7tDD+o1B6NGx6kcQ+er48XRRgCD06dgKjipvPT/U3D49HIJePav+hJC/nu8J
eeYw9OtZjssKg4eBb4Kz8mNg1a8w+Bj42jSj1qAI/BlY9S0CXga+qNE/XROB
3xRORQ8UvxQ+JwdG4T+FjbKPUZLy3Cl88vqaC/ucUfTTyKqfMZJ4C4w81hPV
VyOrvsZI/QyNfOSqEBhHf02s+hsHfxMLdU2lcfTZxF70SP3NmHhPsfc4LU2A
h5lVvxPgYeZ8aTgBHmZWfU+Ch5nHeqZ4WFj1PwkeFpZ2h5LgYeE2WcBh8LCw
HHd6GDzGcTN6+A/S0yBI
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJxdlH1ozHEcx+9u9yAtSUhL89DSSUJIS3w+SEham0iS1rKR5KksjUQSQpqH
PMWaWf6gkdYIzcxsM7awzRiz3W63u+3u7J4ft/H7fr/v/eNb13V33/t83u/3
6303K+9ATr5Bp9Plaw/x/P95kX7Gnf3iHi3vzrp0Y/8VUq8r8Po+je8oO7hi
/HPqbIlutpc/wufV+PwZLVkszjtKxT11vwH3X1Fv0eSKdbYm2mIvv1M3swbf
b8H3a2m9TVz4Qhk/4yf2vq7DvFbMa6AZ4np6OwW/bsqbuO0D5ndg/keKWHdc
rg1/p7dNpWurgs3Y14l9n+mTPL9oHfao/b+x/yvlyDd6aGFXhvnU9VbosUFP
G62UC3tp6g+xsB367NDXQXPFemsfjbYdHZiz6Dv0OqD3B02pEJv7qf/zbG1i
J/Q7of8nKQouaoZO5ccFP13kyRYCB6iysbC6JK0b/gbhr4e+SRluEtsyK3vg
1wO/NtLEaQO9tDrXoSmwwf8f+O8lKa9iiJbufLkh1WBHHj7kYcc8H1nhU+Xj
Rz59mO+n9O27tJEO5BVAXg7sC5BQ11jYj/yCyM+J/UEyb50w/9ldJ/IMIU8X
PRD2ykIU2ywMu5BvGPkO0O1b4oTJi5xU3hHkPUiXpcAISbuT3Mg/ivzdJMed
iZIcl+kBjxh4eOiYSLEoRvUbl51flesFnxj4eOmQkHcwTq+19Oad/QNecaqS
vIZod4E4CXqCnBW/BPj5SNrdkaQvQu5eH3gmwdMHHsP0Uawb8YHHMPj6wWOE
3s98enhPsR88RmiV5O0Hj1F6U5K2oCsjAB6j4B8Aj7/0EpwUj7/oQxB56rjy
7tDD+o1B6NGx6kcQ+er48XRRgCD06dgKjipvPT/U3D49HIJePav+hJC/nu8J
eeYw9OtZjssKg4eBb4Kz8mNg1a8w+Bj42jSj1qAI/BlY9S0CXga+qNE/XROB
3xRORQ8UvxQ+JwdG4T+FjbKPUZLy3Cl88vqaC/ucUfTTyKqfMZJ4C4w81hPV
VyOrvsZI/QyNfOSqEBhHf02s+hsHfxMLdU2lcfTZxF70SP3NmHhPsfc4LU2A
h5lVvxPgYeZ8aTgBHmZWfU+Ch5nHeqZ4WFj1PwkeFpZ2h5LgYeE2WcBh8LCw
HHd6GDzGcTN6+A/S0yBI
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.466082404462542*^9, 3.466082420331204*^9}, 
   3.466082812674584*^9, 3.4660839271035137`*^9, 3.4660840591928*^9, {
   3.466084883053876*^9, 3.466084895157896*^9}, 3.466085934899786*^9, 
   3.523353322372614*^9, 3.5245047195315037`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"GroundStateProperties", "[", 
   RowBox[{"Hamiltonian", "[", "0.0", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.466082762416947*^9, 3.466082774674736*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Energy\"\>", "\<\"Relative_Energy\"\>", "\<\"Ssqr\"\>", "\<\"Lsqr\"\
\>", "\<\"Jsqr\"\>", "\<\"Lx\"\>", "\<\"Ly\"\>", "\<\"Lz\"\>", "\<\"Sx\"\>", \
"\<\"Sy\"\>", "\<\"Sz\"\>", "\<\"Neg\"\>", "\<\"Nt2g\"\>", "\<\"Nx2y2\"\>", "\
\<\"Nz2\"\>", "\<\"Nyz\"\>", "\<\"Nxz\"\>", "\<\"Nxy\"\>"},
    {"0", "0", "0.75`", "6.`", "8.75`", "0", "0", 
     RowBox[{"-", "2.`"}], "0", "0", 
     RowBox[{"-", "0.5`"}], "0.5`", "0.5`", "0.5`", "0", "0", "0", "0.5`"},
    {"0", "0", "0.75`", "6.`", "4.75`", "0", "0", 
     RowBox[{"-", "2.`"}], "0", "0", "0.5`", "0.5`", "0.5`", "0.5`", "0", "0",
      "0", "0.5`"},
    {"0", "0", "0.75`", "6.`", "7.75`", "0", "0", 
     RowBox[{"-", "1.`"}], "0", "0", 
     RowBox[{"-", "0.5`"}], "0", "1.`", "0", "0", "0.5`", "0.5`", "0"},
    {"0", "0", "0.75`", "6.`", "5.75`", "0", "0", 
     RowBox[{"-", "1.`"}], "0", "0", "0.5`", "0", "1.`", "0", "0", "0.5`", 
     "0.5`", "0"},
    {"0", "0", "0.75`", "6.`", "6.75`", "0", "0", "0", "0", "0", 
     RowBox[{"-", "0.5`"}], "1.`", "0", "0", "1.`", "0", "0", "0"},
    {"0", "0", "0.75`", "6.`", "6.75`", "0", "0", "0", "0", "0", "0.5`", 
     "1.`", "0", "0", "1.`", "0", "0", "0"},
    {"0", "0", "0.75`", "6.`", "5.75`", "0", "0", "1.`", "0", "0", 
     RowBox[{"-", "0.5`"}], "0", "1.`", "0", "0", "0.5`", "0.5`", "0"},
    {"0", "0", "0.75`", "6.`", "7.75`", "0", "0", "1.`", "0", "0", "0.5`", 
     "0", "1.`", "0", "0", "0.5`", "0.5`", "0"},
    {"0", "0", "0.75`", "6.`", "4.75`", "0", "0", "2.`", "0", "0", 
     RowBox[{"-", "0.5`"}], "0.5`", "0.5`", "0.5`", "0", "0", "0", "0.5`"},
    {"0", "0", "0.75`", "6.`", "8.75`", "0", "0", "2.`", "0", "0", "0.5`", 
     "0.5`", "0.5`", "0.5`", "0", "0", "0", "0.5`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.46608276711541*^9, 3.466082816229388*^9}, 
   3.466083929215783*^9, 3.466084061966875*^9, 3.46608593500076*^9, 
   3.5233533297141657`*^9, 3.5245047195881643`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"GroundStateProperties", "[", 
   RowBox[{"Hamiltonian", "[", "3.0", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.466082832465639*^9, 3.4660828326310387`*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Energy\"\>", "\<\"Relative_Energy\"\>", "\<\"Ssqr\"\>", "\<\"Lsqr\"\
\>", "\<\"Jsqr\"\>", "\<\"Lx\"\>", "\<\"Ly\"\>", "\<\"Lz\"\>", "\<\"Sx\"\>", \
"\<\"Sy\"\>", "\<\"Sz\"\>", "\<\"Neg\"\>", "\<\"Nt2g\"\>", "\<\"Nx2y2\"\>", "\
\<\"Nz2\"\>", "\<\"Nyz\"\>", "\<\"Nxz\"\>", "\<\"Nxy\"\>"},
    {
     RowBox[{"-", "1.2000000000000004`"}], "0", "0.75`", "6.`", "6.75`", "0", 
     "0", "0", "0", "0", 
     RowBox[{"-", "0.5`"}], "0", "0.9999999999999999`", "0", "0", "0", "0", 
     "0.9999999999999999`"},
    {
     RowBox[{"-", "1.2000000000000004`"}], "0", "0.75`", "6.`", 
     "6.749999999999999`", "0", "0", "0", "0", "0", "0.5`", "0", 
     "0.9999999999999999`", "0", "0", "0", "0", "0.9999999999999999`"},
    {
     RowBox[{"-", "1.2000000000000002`"}], "0", "0.75`", "6.`", "7.75`", "0", 
     "0", 
     RowBox[{"-", "1.`"}], "0", "0", 
     RowBox[{"-", "0.5`"}], "0", "1.`", "0", "0", "0.5`", "0.5`", "0"},
    {
     RowBox[{"-", "1.2000000000000002`"}], "0", "0.75`", "6.`", "5.75`", "0", 
     "0", 
     RowBox[{"-", "1.`"}], "0", "0", "0.5`", "0", "1.`", "0", "0", "0.5`", 
     "0.5`", "0"},
    {
     RowBox[{"-", "1.2000000000000002`"}], "0", "0.75`", "6.`", "5.75`", "0", 
     "0", "1.`", "0", "0", 
     RowBox[{"-", "0.5`"}], "0", "1.`", "0", "0", "0.5`", "0.5`", "0"},
    {
     RowBox[{"-", "1.2000000000000002`"}], "0", "0.75`", "6.`", "7.75`", "0", 
     "0", "1.`", "0", "0", "0.5`", "0", "1.`", "0", "0", "0.5`", "0.5`", 
     "0"},
    {"1.8`", "3.0000000000000004`", "0.75`", "6.`", "6.749999999999999`", "0",
      "0", "0", "0", "0", 
     RowBox[{"-", "0.5`"}], "0.9999999999999999`", "0", "0.9999999999999999`",
      "0", "0", "0", "0"},
    {"1.8`", "3.0000000000000004`", "0.75`", "6.`", "6.75`", "0", "0", "0", 
     "0", "0", "0.5`", "0.9999999999999999`", "0", "0.9999999999999999`", "0",
      "0", "0", "0"},
    {"1.8`", "3.0000000000000004`", "0.75`", "6.`", "6.75`", "0", "0", "0", 
     "0", "0", 
     RowBox[{"-", "0.5`"}], "1.`", "0", "0", "1.`", "0", "0", "0"},
    {"1.8`", "3.0000000000000004`", "0.75`", "6.`", "6.75`", "0", "0", "0", 
     "0", "0", "0.5`", "1.`", "0", "0", "1.`", "0", "0", "0"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.466082833357802*^9, 3.466084065381819*^9, 
  3.466085935082221*^9, 3.523353332430037*^9, 3.524504719652616*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Plot wave functions (needs the package PlotTools loaded in the section \
additional functions needed for tutorial (3)\
\>", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"val", ",", "fun"}], "}"}], "=", 
   RowBox[{"CIEigensystem", "[", 
    RowBox[{
     RowBox[{"Hamiltonian", "[", "3.0", "]"}], ",", "10"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.466084192676034*^9, 3.4660842171396637`*^9}, {
  3.466084898799618*^9, 3.4660848993327436`*^9}, {3.4660849359337187`*^9, 
  3.466084936092106*^9}, {3.466084967878892*^9, 3.466084968052861*^9}, {
  3.466085007563006*^9, 3.466085007834263*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"i", "=", "1"}], ",", 
    RowBox[{"i", "\[LessEqual]", "10"}], ",", 
    RowBox[{"i", "+=", "2"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<Function: \>\"", ",", "i", ",", "\"\< ,Energy: \>\"", ",", 
       RowBox[{
        RowBox[{"val", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "-", 
        RowBox[{"val", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ",", "\"\< ,Function: \>\"", ",", 
       RowBox[{"Chop", "[", 
        RowBox[{"f\[Theta]\[Phi]Tofxyz", "[", 
         RowBox[{"ExpToTrig", "[", 
          RowBox[{"Chop", "[", 
           RowBox[{
            RowBox[{"fun", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ".", "Basisd1Dn"}], "]"}], "]"}],
          "]"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"Rasterize", "[", 
       RowBox[{"WavePlot", "[", 
        RowBox[{
         RowBox[{"Chop", "[", 
          RowBox[{
           RowBox[{"fun", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ".", "Basisd1Dn"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "}"}]}], "]"}], "]"}], "]"}], 
     ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.4660842228913927`*^9, 3.466084414691222*^9}, {
  3.4660845365908203`*^9, 3.466084617047512*^9}, {3.466084651702479*^9, 
  3.466084656779941*^9}, {3.466085486752186*^9, 3.4660855104248667`*^9}, {
  3.523353468533462*^9, 3.5233534801556263`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Function: \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" ,Energy: \"\>", "\[InvisibleSpace]", "0.`", 
   "\[InvisibleSpace]", "\<\" ,Function: \"\>", "\[InvisibleSpace]", 
   RowBox[{"x", " ", "y", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"1.0925484305920792`", " ", "\[ImaginaryI]"}], 
       RowBox[{
        RowBox[{"-", "1.`"}], "+", 
        SuperscriptBox["z", "2"]}]], "-", 
      FractionBox[
       RowBox[{"1.0925484305920792`", " ", "\[ImaginaryI]", " ", 
        SuperscriptBox["z", "2"]}], 
       RowBox[{
        RowBox[{"-", "1.`"}], "+", 
        SuperscriptBox["z", "2"]}]]}], ")"}]}]}],
  SequenceForm[
  "Function: ", 1, " ,Energy: ", 0., 
   " ,Function: ", ($CellContext`x $CellContext`y) (
    Complex[0, 1.0925484305920792`]/(-1. + $CellContext`z^2) + 
    Complex[0, -1.0925484305920792`] ($CellContext`z^2/(-1. + \
$CellContext`z^2)))],
  Editable->False]], "Print",
 CellChangeTimes->{{3.466084268469987*^9, 3.466084300183106*^9}, 
   3.466084338372261*^9, {3.4660843966539497`*^9, 3.4660844188730717`*^9}, 
   3.466084569665978*^9, {3.466084603204619*^9, 3.466084618347925*^9}, 
   3.4660846578658648`*^9, 3.466084901842535*^9, 3.466084974580385*^9, 
   3.4660850137878*^9, {3.466085495893323*^9, 3.4660855115277433`*^9}, 
   3.466085935412827*^9, 3.523353369064084*^9, 3.5233534827174063`*^9, 
   3.524504719883335*^9}],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnWlwVNe17/er9y3fUnWr3qebqlTFt25cNyFxbCeOHcdxnHge8BAbMGDA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   "], {{0, 0}, {360, 247}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{360, 247},
  PlotRange->{{0, 360}, {0, 247}}]], "Print",
 CellChangeTimes->{{3.466084268469987*^9, 3.466084300183106*^9}, 
   3.466084338372261*^9, {3.4660843966539497`*^9, 3.4660844188730717`*^9}, 
   3.466084569665978*^9, {3.466084603204619*^9, 3.466084618347925*^9}, 
   3.4660846578658648`*^9, 3.466084901842535*^9, 3.466084974580385*^9, 
   3.4660850137878*^9, {3.466085495893323*^9, 3.4660855115277433`*^9}, 
   3.466085935412827*^9, 3.523353369064084*^9, 3.5233534827174063`*^9, 
   3.524504724257848*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Function: \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" ,Energy: \"\>", "\[InvisibleSpace]", 
   "2.220446049250313`*^-16", "\[InvisibleSpace]", "\<\" ,Function: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"0.7725484040463791`", " ", "x", " ", "z"}], "-", 
    RowBox[{
    "0.7725484040463791`", " ", "\[ImaginaryI]", " ", "y", " ", "z"}]}]}],
  SequenceForm[
  "Function: ", 3, " ,Energy: ", 2.220446049250313*^-16, 
   " ,Function: ", (0.7725484040463791 $CellContext`x) $CellContext`z + (
     Complex[0, -0.7725484040463791] $CellContext`y) $CellContext`z],
  Editable->False]], "Print",
 CellChangeTimes->{{3.466084268469987*^9, 3.466084300183106*^9}, 
   3.466084338372261*^9, {3.4660843966539497`*^9, 3.4660844188730717`*^9}, 
   3.466084569665978*^9, {3.466084603204619*^9, 3.466084618347925*^9}, 
   3.4660846578658648`*^9, 3.466084901842535*^9, 3.466084974580385*^9, 
   3.4660850137878*^9, {3.466085495893323*^9, 3.4660855115277433`*^9}, 
   3.466085935412827*^9, 3.523353369064084*^9, 3.5233534827174063`*^9, 
   3.5245047244009657`*^9}],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzsnQdYVFfagN/sbvbPbrKbTe89mphmjDGxRaPR2I1daQIKglSR3qs0UbAg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   "], {{0, 0}, {360, 378}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{360, 378},
  PlotRange->{{0, 360}, {0, 378}}]], "Print",
 CellChangeTimes->{{3.466084268469987*^9, 3.466084300183106*^9}, 
   3.466084338372261*^9, {3.4660843966539497`*^9, 3.4660844188730717`*^9}, 
   3.466084569665978*^9, {3.466084603204619*^9, 3.466084618347925*^9}, 
   3.4660846578658648`*^9, 3.466084901842535*^9, 3.466084974580385*^9, 
   3.4660850137878*^9, {3.466085495893323*^9, 3.4660855115277433`*^9}, 
   3.466085935412827*^9, 3.523353369064084*^9, 3.5233534827174063`*^9, 
   3.524504726057475*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Function: \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" ,Energy: \"\>", "\[InvisibleSpace]", 
   "2.220446049250313`*^-16", "\[InvisibleSpace]", "\<\" ,Function: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "0.7725484040463791`"}], " ", "x", " ", "z"}], "-", 
    RowBox[{
    "0.7725484040463791`", " ", "\[ImaginaryI]", " ", "y", " ", "z"}]}]}],
  SequenceForm[
  "Function: ", 5, " ,Energy: ", 2.220446049250313*^-16, 
   " ,Function: ", ((-0.7725484040463791) $CellContext`x) $CellContext`z + (
     Complex[0, -0.7725484040463791] $CellContext`y) $CellContext`z],
  Editable->False]], "Print",
 CellChangeTimes->{{3.466084268469987*^9, 3.466084300183106*^9}, 
   3.466084338372261*^9, {3.4660843966539497`*^9, 3.4660844188730717`*^9}, 
   3.466084569665978*^9, {3.466084603204619*^9, 3.466084618347925*^9}, 
   3.4660846578658648`*^9, 3.466084901842535*^9, 3.466084974580385*^9, 
   3.4660850137878*^9, {3.466085495893323*^9, 3.4660855115277433`*^9}, 
   3.466085935412827*^9, 3.523353369064084*^9, 3.5233534827174063`*^9, 
   3.524504726133321*^9}],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzsnQVYVFvXgF/p7pTukEZARBQRu/XGB3Z3d3d3d3d3dwd2i40oghLSOedH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   "], {{0, 0}, {360, 378}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{360, 378},
  PlotRange->{{0, 360}, {0, 378}}]], "Print",
 CellChangeTimes->{{3.466084268469987*^9, 3.466084300183106*^9}, 
   3.466084338372261*^9, {3.4660843966539497`*^9, 3.4660844188730717`*^9}, 
   3.466084569665978*^9, {3.466084603204619*^9, 3.466084618347925*^9}, 
   3.4660846578658648`*^9, 3.466084901842535*^9, 3.466084974580385*^9, 
   3.4660850137878*^9, {3.466085495893323*^9, 3.4660855115277433`*^9}, 
   3.466085935412827*^9, 3.523353369064084*^9, 3.5233534827174063`*^9, 
   3.524504727851775*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Function: \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" ,Energy: \"\>", "\[InvisibleSpace]", 
   "3.0000000000000004`", "\[InvisibleSpace]", "\<\" ,Function: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["0.5462742152960396`", 
        RowBox[{
         RowBox[{"-", "1.`"}], "+", 
         SuperscriptBox["z", "2"]}]], "-", 
       FractionBox[
        RowBox[{"0.5462742152960396`", " ", 
         SuperscriptBox["z", "2"]}], 
        RowBox[{
         RowBox[{"-", "1.`"}], "+", 
         SuperscriptBox["z", "2"]}]]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["0.5462742152960396`", 
         RowBox[{
          RowBox[{"-", "1.`"}], "+", 
          SuperscriptBox["z", "2"]}]]}], "+", 
       FractionBox[
        RowBox[{"0.5462742152960396`", " ", 
         SuperscriptBox["z", "2"]}], 
        RowBox[{
         RowBox[{"-", "1.`"}], "+", 
         SuperscriptBox["z", "2"]}]]}], ")"}]}]}]}],
  SequenceForm[
  "Function: ", 7, " ,Energy: ", 3.0000000000000004`, 
   " ,Function: ", $CellContext`y^2 (
     0.5462742152960396/(-1. + $CellContext`z^2) - 
     0.5462742152960396 ($CellContext`z^2/(-1. + $CellContext`z^2))) + \
$CellContext`x^2 ((-0.5462742152960396)/(-1. + $CellContext`z^2) + 
     0.5462742152960396 ($CellContext`z^2/(-1. + $CellContext`z^2)))],
  Editable->False]], "Print",
 CellChangeTimes->{{3.466084268469987*^9, 3.466084300183106*^9}, 
   3.466084338372261*^9, {3.4660843966539497`*^9, 3.4660844188730717`*^9}, 
   3.466084569665978*^9, {3.466084603204619*^9, 3.466084618347925*^9}, 
   3.4660846578658648`*^9, 3.466084901842535*^9, 3.466084974580385*^9, 
   3.4660850137878*^9, {3.466085495893323*^9, 3.4660855115277433`*^9}, 
   3.466085935412827*^9, 3.523353369064084*^9, 3.5233534827174063`*^9, 
   3.524504728067156*^9}],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnemPVFUa/59ffn+BybwdE18wmZBJTHhnNJmEV7yZTPwlk4k44oIs6ogs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   "], {{0, 0}, {360,
    221}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{360, 221},
  PlotRange->{{0, 360}, {0, 221}}]], "Print",
 CellChangeTimes->{{3.466084268469987*^9, 3.466084300183106*^9}, 
   3.466084338372261*^9, {3.4660843966539497`*^9, 3.4660844188730717`*^9}, 
   3.466084569665978*^9, {3.466084603204619*^9, 3.466084618347925*^9}, 
   3.4660846578658648`*^9, 3.466084901842535*^9, 3.466084974580385*^9, 
   3.4660850137878*^9, {3.466085495893323*^9, 3.4660855115277433`*^9}, 
   3.466085935412827*^9, 3.523353369064084*^9, 3.5233534827174063`*^9, 
   3.5245047330471888`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Function: \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" ,Energy: \"\>", "\[InvisibleSpace]", 
   "3.0000000000000004`", "\[InvisibleSpace]", "\<\" ,Function: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "0.31539156525252005`"}], "+", 
    RowBox[{"0.9461746957575601`", " ", 
     SuperscriptBox["z", "2"]}]}]}],
  SequenceForm[
  "Function: ", 9, " ,Energy: ", 3.0000000000000004`, 
   " ,Function: ", -0.31539156525252005` + 
   0.9461746957575601 $CellContext`z^2],
  Editable->False]], "Print",
 CellChangeTimes->{{3.466084268469987*^9, 3.466084300183106*^9}, 
   3.466084338372261*^9, {3.4660843966539497`*^9, 3.4660844188730717`*^9}, 
   3.466084569665978*^9, {3.466084603204619*^9, 3.466084618347925*^9}, 
   3.4660846578658648`*^9, 3.466084901842535*^9, 3.466084974580385*^9, 
   3.4660850137878*^9, {3.466085495893323*^9, 3.4660855115277433`*^9}, 
   3.466085935412827*^9, 3.523353369064084*^9, 3.5233534827174063`*^9, 
   3.524504733059332*^9}],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnWmMVcW2+Ovl/+1+u8n7+m5icn159+YlN+Hbzb03L/GTH+7LiyYvL4wq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   "], {{0, 0}, {169, 432}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{169, 432},
  PlotRange->{{0, 169}, {0, 432}}]], "Print",
 CellChangeTimes->{{3.466084268469987*^9, 3.466084300183106*^9}, 
   3.466084338372261*^9, {3.4660843966539497`*^9, 3.4660844188730717`*^9}, 
   3.466084569665978*^9, {3.466084603204619*^9, 3.466084618347925*^9}, 
   3.4660846578658648`*^9, 3.466084901842535*^9, 3.466084974580385*^9, 
   3.4660850137878*^9, {3.466085495893323*^9, 3.4660855115277433`*^9}, 
   3.466085935412827*^9, 3.523353369064084*^9, 3.5233534827174063`*^9, 
   3.524504735499002*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["d8 system as a function of 10Dq", "Subsection",
 CellChangeTimes->{{3.46608246058114*^9, 3.466082474199586*^9}, 
   3.466085578278118*^9}],

Cell[CellGroupData[{

Cell["Define basis", "Subsubsection",
 CellChangeTimes->{{3.466082118798918*^9, 3.466082120792042*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CIBasisShellDegeneracy", "=", 
    RowBox[{"{", "10", "}"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "there", " ", "are", " ", "10", " ", "fermions", " ", "in", " ", "a", " ", 
    "d", " ", "shell", " ", "5", " ", "orbitals", " ", "each", " ", "with", 
    " ", "either", " ", "spin", " ", "up", " ", "or", " ", "down"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CIBasisShellFilling", "=", 
    RowBox[{"{", 
     RowBox[{"{", "8", "}"}], "}"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"I", " ", "have", " ", "one", " ", "configuration"}], ",", " ", 
    RowBox[{"which", " ", "has", " ", "9", " ", "electrons"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CIBasis", "=", 
    RowBox[{"{", 
     RowBox[{"CIBasisShellDegeneracy", ",", "CIBasisShellFilling"}], "}"}]}], 
   ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "In", " ", "order", " ", "to", " ", "pass", " ", "the", " ", "basis", " ", 
    "around", " ", "I", " ", "create", " ", "a", " ", "list", " ", "of", " ", 
    "them"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CIBasisFull", "=", 
    RowBox[{"CISetMultiplicity", "[", "CIBasis", "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "I", " ", "need", " ", "in", " ", "almost", " ", "all", " ", 
     "subroutines", " ", "information", " ", "about", " ", "the", " ", 
     "multiplicity", " ", "of", " ", "the", " ", "basis"}], ",", " ", 
    RowBox[{
    "so", " ", "I", " ", "calcualte", " ", "it", " ", "once", " ", "and", " ",
      "pass", " ", "it", " ", "allong"}]}], " ", "*)"}]}]}], "Input",
 CellChangeTimes->{
  3.466085580831493*^9, {3.523353522265326*^9, 3.523353525014756*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Define Operators", "Subsubsection",
 CellChangeTimes->{{3.466082118798918*^9, 3.466082142335805*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"Fdd", ",", "Eeg", ",", "Et2g"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Timing", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"OppSx", "=", 
      RowBox[{"CIOperatorSx", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppSy", "=", 
      RowBox[{"CIOperatorSy", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppSz", "=", 
      RowBox[{"CIOperatorSz", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppSsqr", "=", 
      RowBox[{"CIOperatorSsqr", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLx", "=", 
      RowBox[{"CIOperatorLx", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLy", "=", 
      RowBox[{"CIOperatorLy", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLz", "=", 
      RowBox[{"CIOperatorLz", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLsqr", "=", 
      RowBox[{"CIOperatorLsqr", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJx", "=", 
      RowBox[{"CIOperatorJx", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJy", "=", 
      RowBox[{"CIOperatorJy", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJz", "=", 
      RowBox[{"CIOperatorJz", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJsqr", "=", 
      RowBox[{"CIOperatorJsqr", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppCF", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "VOhd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Oppldots", "=", 
      RowBox[{"CIOperatorldots", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppU", "=", 
      RowBox[{"CIOperatorU", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Fdd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNeg", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnegd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNt2g", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnt2gd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNz2", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnz2d"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNx2y2", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnx2y2d"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNyz", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnyzd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNxz", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnxzd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNxy", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnxyd"}], "]"}]}], ";"}], "\[IndentingNewLine]", "]"}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4660778074018173`*^9, 3.466077831177351*^9}, {
  3.4660778798659077`*^9, 3.466077889735778*^9}, {3.4660829512058773`*^9, 
  3.4660829538541117`*^9}, {3.4660835755891857`*^9, 3.466083692904258*^9}, {
  3.4660859843251038`*^9, 3.466086009586051*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"27.366348000000006`", ",", "Null"}], "}"}]], "Print",
 CellChangeTimes->{3.466083706466501*^9, 3.466083919610579*^9, 
  3.466084053368881*^9, 3.466085613372122*^9, 3.466085979897192*^9, 
  3.466086018882333*^9, 3.523353536644518*^9, 3.524504763767117*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create the Hamiltonian as a function of 10Dq", "Subsubsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "Hamiltonian", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eeg", "=", 
   RowBox[{"0.6", "tenDq"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Et2g", "=", 
   RowBox[{
    RowBox[{"-", "0.4"}], " ", "tenDq"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fdd", "[", "2", "]"}], "=", "10.0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fdd", "[", "4", "]"}], "=", "6.25"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fdd", "[", "0", "]"}], "=", 
   RowBox[{
    FractionBox["14", "441"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Fdd", "[", "2", "]"}], "+", 
      RowBox[{"Fdd", "[", "4", "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Hamiltonian", "[", "tenDq_", "]"}], ":=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"OppCF", "+", "OppU"}], "]"}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Hamiltonian", "[", "tenDq_", "]"}], ":=", 
    RowBox[{"Evaluate", "[", 
     RowBox[{"OppCF", "+", "OppU", "+", 
      RowBox[{
       SuperscriptBox["10", 
        RowBox[{"-", "6"}]], "OppSz"}], "+", 
      RowBox[{
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]], "OppLz"}]}], "]"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"Eeg", ",", "Et2g", ",", "Fdd"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4660778514661293`*^9, 3.4660778551711407`*^9}, {
   3.4660779037788553`*^9, 3.46607802956116*^9}, {3.466082259181775*^9, 
   3.466082289094554*^9}, {3.466082411016951*^9, 3.46608241717595*^9}, {
   3.466082791187235*^9, 3.466082809161236*^9}, {3.4660849476050386`*^9, 
   3.4660849607579107`*^9}, {3.466084996503484*^9, 3.466084999859572*^9}, {
   3.4660856176165113`*^9, 3.4660856779885*^9}, {3.466085770020152*^9, 
   3.466085771297245*^9}, {3.466085812235236*^9, 3.466085850074255*^9}, {
   3.46608588915528*^9, 3.46608589060625*^9}, 3.466086063206147*^9, {
   3.466086111824648*^9, 3.466086195010604*^9}, {3.466086244578319*^9, 
   3.466086247753295*^9}, {3.466086281474304*^9, 3.466086283311263*^9}, {
   3.4660863182946873`*^9, 3.46608632095697*^9}, {3.4660863561101103`*^9, 
   3.4660863582852*^9}, {3.466086399804905*^9, 3.466086402618618*^9}, {
   3.466086436700938*^9, 3.466086442491534*^9}, {3.4660864733914747`*^9, 
   3.466086476300633*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot energy level diagram", "Subsubsection",
 CellChangeTimes->{{3.466082118798918*^9, 3.466082142335805*^9}, {
  3.466082201199407*^9, 3.4660822107268267`*^9}, {3.466082444171822*^9, 
  3.466082448167088*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EnergyLevelDiagram", "[", 
  RowBox[{"Hamiltonian", ",", "0.0", ",", "3.0", ",", "100", ",", 
   RowBox[{"AspectRatio", "\[Rule]", " ", "GoldenRatio"}], ",", 
   RowBox[{"Axes", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.466084880276795*^9, 3.466084893875984*^9}, {
  3.466085727942255*^9, 3.466085741179006*^9}, {3.4660860727133007`*^9, 
  3.466086076151639*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMFFcUhmffuyzLvkR8BBGkVuzDWkUtRc5FKlpEeVgkKCpqkNKoxdZH
izWgAkVDgRiKggoUaKOioDWISuvc+gAERAUENEhhqxRFBGHZZXksZXdOTzKZ
zMydc/7//26u89avgyP5DMNETlyW+/8lXa+4XNk1wF6bkdgddC0HzC37d3r+
oMfnYjCF6twuKwdZm+aCmKU2ZTDQ5N/5TsEgfr8Jr0PK8rMXGdiFCyx1G140
Om9WVhtwfSW0rU2ZnrDRyOpiJxWv6KiGJ/WG5qE+I/5fB01BWzJ2JgyxKzss
Cx7Bw4c1gToHE/ZrgIqARYrQIhPrZFk+4zHQurx7NV7D2L8ZylfLk0j9MGuY
E552a7AFrtbuXVYaOYLznkLJqnazm2mErbVWKxRV+5XnpIzi/DbI/7x0v3bm
GBtsfdEOOVVOC5OvjKGeDshccaxv1NfMelkH6iC9Qn9h91Mz6vsHfly+Obpz
5zjrZhk/5zn46J4fv8gwlNP7AljnaW+j/BhqP9EsdlIneGwJCHDJYCin/1+4
lpdwsfUZQzkaXeDefl1+4l0e5fx0QZlTb3TQbh59HWQR+BLmb3atkpfzKOfv
FVzICZtdIeTTJmsc3eDWlpoQv4ZPOb+v4VfHOzqPk3w6IW6iYQ+4bDSRwQ4+
5fy/gdzTH+aWvCegVnnFveDYum0seq+Acnn0Qfb0rA2urAD79YH9hrrrbVIh
5fJ5CxnZgilZwULs/xZUT5fsW3taSLm8+iF96q5GRacQ5/WDLKzg46p5Isrl
NwDJJ1vSD38vwvkDIGpR9HreFlEuTz3EO/isNtqKaaHFXoEezOu+K7q8Toz5
DsKBzIuyHXlimp1lqUEwPtZFzX4lxrwNsM9+SkX7AglNswo0QP8Xq11PHZRg
/kbYlXH4cEilhFrbJRqhp6GsXamWIo8h+FLb41W9XkoPWOKOHYLOYJczCYVS
5DME246Hjni9kdLdFnkxJtA9SgkzLZYhLxOEq2+VXTkko1HbLTUMrYFG+101
MuQ3DCHp7++ZY29DrXbDR6D5wZZ63SYb5DkCgcoTH505a4M8RqFuTW1qaL8N
8hgF/1Rej9pTjjzGoOr+olW1iXLkMQY+ih3nkh7IkYcZ7vr/IvGeaos8zOCZ
0hQ5stUWeYzDjRr5ndILtshjHBbLvV1iDLaYJ0Ou+u2Ln0sUqIch848VtT0/
qsB8GVJyr90zt0GB+hgyVzb5VJijHebNI+dXrjJpo+xQL4/MTo4Prbtkh/nz
SF5laWnysB3q5xEnSbfW5zMl8uCTM74zvxn7SYl++GRKUsjDsmYl8uGTmq3L
Ha6rVOiPT47yI3wz3VXIi09W5sfu/Xa9Cv0KiGzZz4WBcSrkJyAVHSUNHxSq
0L+AHDlUzZffU1GrvG4B8XZ+Mb+rR4X7U0h4f41H3NWoqRXvdiH5M2Jaev5i
Ne5XIYlj3Nm4cDXljhMh8cgLeBN+SI37V0RG4StHj9/UyF9Ebvyd4O9Qo8b9
LCL743IP6HvVlDvuRMTd6cb5R5M0yENM9DcbnxR/okEeYvL7pl5pyiYN8hCT
GLNsSfQRDfIQk3k5rlG+ZzXIQ0J6l0LmrPsa5CEhl56F3WX6NchDQnYc3KN/
NlmLPCTEzTFtVvmnWuQhJS//OBd8MkJL/wOzpwpr
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAlQFFcQhmdnT1iWvUA8gogSxRzGW4NIPyWiQRHBIIWigimksLyIV8QY
FcEihqCxjAIqECGWiq4Si6xE47wIggLigQohSmBVgiL3srAsR9idTldNTc3M
m+7//79Xz33dluAolmGYqKHLev+/ZCsVeSWNndz10YlNQdczwFK9a5P3N0Z8
1oEx1DAxT9nF2Vdlb51rr4eWZ0sa3s/uwu+34E2I/mz6TBM3fZq1CuHlE/e1
ylITri+Bv5cnj0pY3c0Z4px0C+tL4eljU1VPWzf+XwEPgiKPb0ro4RbVWxc8
grKHZcsMLmbsVwmFgTMVoblmzs26fPRT4Cqy7pX59GL/KigIkB8ij3s5k2f4
kdtd1fBr+Y75+VEWnFcDusV1AxPNFq7cVs/hl1L/GxnJfTi/FjI/z9+lHdPP
Bdte1EHaXbfpSdf6UU89HFt4uK3Pb4DzsQ00wOFi46XYmgHU9xIOLlgb07Bp
kJtoHe/5CuYbXh27zDCU1/sa/nAf2R7tz1DnoWZxTg3gFRkYOPY4Q3n9/8L1
rITLz18wlKfRCNPqCuQnJwgo76cRrrq1xgTFCui7IKvANzB5rcdd+Q0B5f29
hYsZYeOLRSx9ZoujCcbXpiTsX8pS3u87yHYtMnilsnRI3FDDZnBfbSZd9Szl
/bdAxulJmVc+FFKbPF0rjHr+ZX/MDiHl82iD1FFpqzw4IfZrA6dVFQW1MhHl
82mHH9OFw9OCRdi/HRQ1s3cuPy2ifF4d8P2IzU8UDSKc1wGysOypdz8RUz6/
TkhMrT4av1uM8zuBrVa0eheKKZ+nEb518Q3odpDQHKu9bCP0rfg6N2+FBPPt
gt0nLtttzJLQ9DRrdYHpqSF6/FsJ5m2Cbc7Di+umSekRm0ATtH8R4HFqrxTz
74aNx+PjQ0qk1NYusRveVurrlGoZ8uiB9dpmn9KVMrrHGndcD7wOHnsmIUeG
fHog8lioxadFRmOt8raaof5Rcph5lh3yMsMq9W39tQN2NHq9tXqhZlm38+Yy
O+TXCyFHP9ru6WxPbXbDLVD5IPKxYY098rRAgPLk5DPn7ZFHH9xfWp4S2mGP
PPrAP0XQrPaWI49+KL4/c3F5ohx59IOvYuOFQw/kyGMA6JKfpfNGOCCPAZiT
/CzKss4BeQyCvkxelH/JAXkMwlT5vLFbTQ6YJ0N+89+5/wOiQD0MmXI4t/bV
dwrMlyG6e3XemZUK1McQT7thp8JcHTFvATm3aLFZG+2IegXEI2l/aMVVR8xf
QDJL8vOTeh1Rv4C8J23S+n6mRB4sSfcb81X/D0r0wxKXQyEP9VVK5MOS0nUL
XApUKvTHkiQ2wu/EDBXyYsnCs3E7tq1UoV8hkc7/KWfZPhXyE5Ki+iuVH+eo
0L+QxB8oZeX3VNQmr0lI5rm/ntLYrML9KSLMn4MRdzRqasO7XkRuRow8enaW
GveriOxlZnD7wtWUP05ExCsrsCX8gBr3r5j0wgZXr3Nq5C8m+n8SlriUqXE/
i8nOfZl7jK1qyh93YjLD7feLj5w0yENCOm89+Uv3qQZ5SEjemlZZ8hoN8pCQ
LQN2s2MOapCHhEzK8Ij2O69BHlLSPBdOjLuvQR5SonsRdofp0CAPKdmwd7vx
xTAt8pCSCa5Hxt2Yo0UeMtJ480JwaoSW/geE2gmP
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAlMVFcUht/sA8Mwm4hLEEGk0lZr626Rc9UKVkUEigRERBskWLFKXVrU
KjgatCjGUsQNKNBGRLDEkFEhvlsXkEUUUEGidBiVooAgy8AAA2XmnZ7k5eW9
d985//9/N9dly/cBkXyGYSLHLsv9/xKHygvLWnvYG1OOtvnfSIeBhn0xngd6
8bkAeoINHoWKPta2PnvnElsdtD9b0zI9uw+/34a3Qbqs8/ON7Nw5lroLzU9c
NikqjLi+DBoDkyZrN/azhrhxBT7NFfC01lg/0NWP/1dDlf/mlBjtALuy2bKg
BsofV64zOJqwXx387TdfHpxnYp0ty6c8hVvVmeWVXoPYvx50vrJjpHaQNc4I
S77T1wCFVXuWFUUO4bxGyF2tH/EwDbFV1noBWRWritOThnF+E1z4umifZqqZ
DbC+0MOvD5znJl43o55mOOlzomvYe4T1sg40wPHS3qu7GkdQ3yuIX7EpuiVm
lPWwjJ/xGojh9Zl8hqGc3jdQ4jLpQ9QqhjqMNYsb1wILN/v5uaYwlNP/LxRl
avNfvGQoR6MV5uhvys5+xKOcn1YocO6M9t/Fo+3+FoFvYdYmtweyYh7l/L2D
K+kh7qVCPn1mjaMN3JpOaQ+v5VPObztkOd0zLE7j0zFxYw07YOpGE+lr5lPO
/3u4eHFWxrVPBNQqr6ATJr/41hy9R0C5PLogdfK5DW6sAPt1gXpD9c0mqZBy
+XyA5POCCecChNj/A8gbF+4NvCikXF7d8MvEHU/kLUKc1w2SkOwvHnwmolx+
PaBNazid8JMI5/cA0yDv9LwrolyevfCz43LffjsxzbHYy+6F4fU/5hWuF2O+
fbAvNd9me6aYnj9nqT4wPjVEub8TY95GiHWYUKqfI6HJVoFG6PzG1+3CQQnm
3w/fpSQkBJVJqLXd0X54W6fTK1RS5DEAWzUdXhWhUrrfEnfcALwKcL2kzZEi
nwGIOBM85PVeSndZ5O00gb4mKcS0wAZ5mSBUdUd3Pd6GRm211CA8X9fvsKPS
BvkNQuDpT3fPcLClVrthQ1DzaHOtIdwWeQ6Bj+Ls7EuXbZHHMFSurToV3G2L
PIbB+xSvQ+UpQx5muPdw/uqqozLkYQYi35577JEMeYzA7TW/S5ZOtEMeIzA3
6Vnk0BY75DEKukrZvaKrdshjFGbLlrruNNphngy5vmrv4Y+JHPUwZOaJvKbX
x+WYL0Nyy/WeGXVy1MeQ6TbjL4Q42WPePPLHytUmTZQ96uUR18TDwdV/2WP+
PJJRVlSUOGiP+nlkoqRNs/wrBfLgkzTvqbHmkwr0wyfjjwU91tUrkA+fVGxZ
4XhTqUR/fJLIj/BOnadEXnyyLCtuzw+hSvQrIJJlv+WsO6REfgJyt/la3cwc
JfoXkIT4Cr6sXEmt8toEBFzefN7aocT9KSRmOhpxX62iVrxbhaQkYtLprAUq
3K9CcoCZxx4KU1HuOBGSRZl+78PiVbh/RcQE25wW/6lC/iKi+0e7xrFShftZ
RGIPZezv7VRR7rgTkXnOt67UjFMjDzHpuf3kecEiNfIQk8LwTmlSuBp5iEnM
iM3C6CNq5CEmM9Pdorwvq5GHhLQvgdRpD9XIQ0LyXobcZ7rVyENCth3c3fty
vAZ5SIi7U/K04i81yENKWkpyA9IiNPQ/NWwJ3Q==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQVFUYx+/efRAWgwqGZOJYiGimaLQVJt+xsHAkFVBJwXEAeSQgoGMG
SiryUAbFB4EyyaRgWPgYc8wH6TmiSGihBgEpEayIKyCu7N7Xwu7G7j18M3fu
3HvP/b7///87c6bGpIbFsQzDxI1c9vtoada4nK/XG/Flr9y+0MvlkHurYVqk
wkSfz4JyTl7ZgKcJj2mtSFsw5hLsOvqJa/a80e/XQamy7Z6wxIT937PXTcje
WCOeih1dXw+2tq0pH283YV2m+9nPu+7Atk/9dfeKR/9vhOEzhlWxZ0w4uMu+
4AHsmHjmLl832q8JpOyvUEGHCU+xL/f6G755Pu3iZGG0fyuIEboZ5105zPtG
FdVybbC1trw8yJej8x6CcVakWxvi8B+OaoetpR57klZzdH4HGBXNw9Z0Doc5
XnTCpuQD6YcKOKqnC4wtIT3TKjgc6Biog9SFzpFXajiq7zEMVtfdC2nm8Az7
eN9uSH09O6izn6N6n8DAzsArm9U8njDSLNO9B1L7zO86efFU/1MYXHnpRJmW
xzINPSSTzR6zl/HUjx56ZvoV3kjgcX+oXeAzSP6un1m5k6f+ekFvO7VFf4TH
LY44+iBmQ1zvtvM89dsPvc1T17ne4fGIuJGGzyEBOppO6HjqfwD0P5UFa4d4
7JB39gWsd4+41uAm0DwM0PWt27y1swTazwDRz+79aAgSaD4vQR9eOClnrUD7
v4SE68EHPL4WaF6D8MRXra7eL9B5gxB1+EZGYJVA8zPCI0vWwAMs0PlGSEwM
iI1rE2ieJuj4i28VDQKutNurMMHqBRdCCp1Fmi8H7VWpN6a8JeKyo/biIGL8
LO2FAJHmzcM/2/U/fxYu4iKHQB7WPK2c8jBJpPkL0BMaXZySI2JHu1wBwn+b
7Kw4JlIeIrT5PMwqvijibfa4M0VYdrBkcHqjSPmI8GAoLKGmR8TpdnlpEqyK
d21fahMpLwn+vH93uc5Dwgnx9jJD5Pw9dVv8JMrPDM0ngwKcF0vYYTdqCELG
Ks59Hy1RnkPQknntbb9MifIYhpAnGUduHpIoj2G4tUzrElEtUR4WCL06uKv3
pkR5WKDR+xyf1S5RHlZYVJSUNI6TKA8r/C5N76x0MVMeNvhiffeKD33MlIcN
Ght/aLgbaKZ5MmgTOplmjTFTPQzKMc0MP2A003wZdN+vBGlzhqg+BuUN+Ke8
cB+meSvQ+rmPPGpODlO9CrRx7kd7j2gtNH8FGu8S6JZfb6H6FUg7lDs270sr
5cGiKGXT4+JnVuqHRfNiioRfMm2UD4t2xJ/ueKFmiOyPRW8YGlbtW8oQmReL
dPm7K+aWMkT2q0TOCwPz2/9jiMxPiT7web9+n6+CyP6V6NXg5e8sSlcQh7w+
JTq+25rFXlUQeX+q0O074wrrWJY48MarUCU+5r1/CUvk/apCQVvaJkYVs0Q+
TlSoYLZl/px/WSLvXzXy5PxinXyUROavRqU9iXHdG5VE3s9qxHiGTbp9SUnk
406NasWAdacZFZF5aNBxjfW10sUqIvPQoBXtzxV5h1RE5qFBhujaNzMeqYjM
Q4MsXvkL0rzVRObhhMoPFyxKSlETmYcTyt671GPDr2oi83BCeHFGSbJNTWQe
Tii9ur5qU7CGyDxeQWyvzW/7QQ35H4utPZs=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQVFUYx+/dF+HEoIJCY+JYiGimaMQU5n7HwkRgRFGhAlMgwHgJGRYr
lKkIOig+EJVJp0TDQnTMMR+k5wARoo6PIGCQAFFXkBVX2Pta9hG79/DN3Llz
7j33+/7//+/MnZ6wMSpJwTBM0ujluI+V8jO38419w/iyT8HAysvHYetfTTNi
WRNdnwV23s7ywddMeFxbRdaicZcg/+iH7tsWjL2/DnalffukcBMOfMdR9ZCX
WSOeThzb3wiW9m8yPsgz4V6d59mlD29C7keBvXdLx76/A+ZqY3RitQmHPnRs
uA/felff4hvG+jWDuO1LtLvLhKc5tvv8C5ufz7g4VRjr3wZ8TO+s8+4c5v3j
Suq4dsipO348xJ+j8zpgeE6sRzvi8G1ndcLXh72K0j7l6PwuMLItFls2h6Oc
D3ogK31f9oHdHNXzEIytEfoZFRzWOgf2QuZi19grNRzV9wgGqxruRrRweJZj
vP9jSJ+8LaTHwFG9T8CwVXtlk5rHk0ab6Tz1kDpgftvFh6f6n4JhzaUT5UE8
lmn0QSrZ5DU3kqd++uDJ7IDi2hQeG1Y6BPZD6iEDs2YrT/09A739dE7fER63
OuMYgITUpGdbzvPUrwH0LdPXud/k8ai40YbPIR66mk/08tT/IOh/LQ8NGuGx
U97ZF7DeM+Zak4dA8zBC93ceC9bOEWg/I6zvv/uLMUSg+byE7lXFU3asFWj/
l/D59dB9XpsFmtcQ9Pir1VV7BTpvCGIP1uZqKwWa3zB0WPMH72OBzh+GlA3B
iUntAs3TBG3/8G2iUcAnHfYqTBCz6EJEsatI8+WgrXJj7bQ3RFx+1FEcrJ44
J+hCsEjz5qE9r++3j1eJuMQpkIfopyendaSJNH8BWlfGl2bsELGzXYEAYX9O
dWWPiZSHCM1+HfmlF0W8xRG3ToSI/WVDM++IlI8I90aiUmr0Is52yMuSIDLZ
vXO5XaS8JLh979aKXi8JpyQ7ygyRC4sacgIkys8M90+FBLsuk7DTbtwIhI1n
z/0YL1GeI9Ciu/ZmgE6iPCwQ/iT3SP0BifKwQH1kkFtMlUR5WGHF1aEfntVL
lIcVbvie4/M7JcrDBtqStLQJnER52KBRmtlz0s1MedgBffF49Xt+ZsrDDnV3
fmq6pTXTPBm0AZ3KsiWYqZ7RtWn2qn3DZpovg+oCylDQjhGqj0Hpg4EZLzwt
NG8WRc9/4FVzykL1sihs/vu7jgRZaf4smuim9ShstFL9LPIfKRi/8xMb5aFA
ccrmR6X9NupHgbwTSoTfdXbKR4G+Tz7T9ULNENmfAk02NkXvWc4QmZcC3Sjc
XjH/MENkv0rELNYWdnYzROanRL5+7zbu8WeJ7F+JpKUr3lqSzRKnvAElKtpu
y1dcZYl8PlWo9uaE4gaFgjjxJqvQCXzMd2+4gsjnVYVCctq940oVRP6dqFDR
XOvCef8piHx+1WgyF5Do4qckMn81OqTfkPQ4U0nk86xGFu+oKX9fUhL5d6dG
WAxed4ZREZmHBv2ssb16eJmKyDw0KKrzObvzgIrIPDTIEF/3eu4DFZF5aFC/
T+GiLF81kXm4oLKDu5ekZaiJzMMF6XYt90r9Q01kHi7o8rLcsnS7msg8XFBW
VWPlV6EaIvN4BVn77QF5+zXkf6mXP0A=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw9lAtQVGUUx/fBsqERGRIxjvhKXc0choiIlPNljAGiPNQIkRE0QCVFBhDE
xxCpY0ZoZqaMkQqixaApkSDBx0MGBYWQh4yRwYq6wkor7H3fhdj10Jm5c+fe
+91z/v//75tv1sak8DiVQqGIG7+s9/9rneOVRsMILXc/MBhWng9ZN27NjVKa
8fkSjC4+mDfkZqaT7hXsWDrpGuw5tcwp23PiezVY1GNfuqwwU693rFUPu7dX
8hc3TaxvBLE7fduSPWaqz5x66eO+Jsj4yEvfenzi/xbgS0yfbCox04A+64I2
yHijpJltmOjXDkz2FnL4gZnOsC5374S0Z3PLpnMT/e+BOUK/4IoTQ1nd+iN1
TDek1uXn++sYnHcfni+Kcu4mDL1tqx5I/cH1UGIkg/MfgEnZIY8mMzTc9qIX
kj4/mnzsMIN6+sDUFfx4bgFD/WwD9bD9Q4eoikoG9T0EY3FDa3AHQxdYx+v6
Yevr2f69Rgb1PoLBLL+KFA1LXcabZU59DFsHxbe17izqfwKGtdfO5Xmz9AUM
A2yuSXFdHMKiHwM8WuiRU5vAUmOYVeBTiP/eqFibxaK/Aegfu5hmOMnSLlsc
g7Bxa9zA7iss+jWCvmPWBqcmlo6LG2/4DGLgQfs5PYv+h6Dv57wAb4mlNnmX
/oX1UyOqbjlzmIcJevY5e0Yv4rCfCWKethaZ/DnM5zn8tTpn2v5oDvs/h6jq
gKOuOznMaxj+1mk0xbkczhuGqO9qd/ld4DC/Eei27B1qoxzOH4F1m303xXVz
mKcZOu6y93gTRwut9grMELG0NDjHgcd8Gei8kFQ7YzZP805Zi4E1ry3yLvXl
MW8W2vcYflm+mqdHbAJZCH9SOON+Io/5c9AZFnt8236e2tod4CDwj+kOyh95
5MFD+7z7e4+X8XS3Ne5MHgK/PTE8v4VHPjy0SuEJlY95mmyVt0OAVfFOPavG
eOQlwM0/m0P1rgJNiLeWCCEfHGpI8xCQnwhN5/19HQIFarO7XoLlryovn44V
kKcEjZlVczwyBeQhQ9CjXSfrjwnIQ4b6EG/HiGIBeVgg6PrwFwP1AvKwQP2b
l9m9PQLyGAW/I4mJUxgBeYxCnTC/t9BRRB5jAJ/1r/GZJyKPMahuOXOr2U/E
PBUk/P1ovw0RIupRkLoCt9LhJBHzVZDgV7rmHzwkor7x7xnHTrudFTFvJSEP
V00pqRBRr5JUr5x8kNwVMX8lCS9vFNsHRNSvJDdn709KUEvIQ0X8vyH94jQJ
/ahIDSd/muslIR8VCd1YcWfWSgn9qcj122nLyuIk5KUiPu95XgvYJ6FfNblx
duitnhMS8lOTJS8Xn0m6LKF/NanZmeCivilRm7xBNfHpm3P4RK+E+9OO1Kzo
HV0gSNSGN96O+Px+OqVqioz71Y6Uz4w0hC6U6YvjxI7ovnaJ7l8m4/7VkOtM
W1t6lIz8NYTE5C6fnCrjftaQX5uCKvNzZPriuNMQj3e1Hp7nZeRhT67+VF/Y
UCUjD3viOynLLbJLRh72pCh1Sa5xSEYe9kT3D6/K0lqQh5aUB5alO8+0IA8t
8fot2VjkY0EeWnLVfXGsb5gFeWiJ7quBzjtbLMjjJXJupCgoNttC/wPcOFiv

     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw9lAtQlGUUhnfBhdCMDIkYR/CSikYMQ0ZEuOeLSME7mCEBGRqQESIDCoIY
kTpEhGZmyhihIFoEjqMoyOXjEmN4wbgIDDG0IOIKK+Gy//1faHc9dGZ2dnbP
95/zvu/zzb9wR0JItJVCoYg2fczf/9dHsy/f1E7QSpfDo8GVBfDlHy1LwpUG
/F0ORo8j+WPOBjqzu2jPqpnX4cBpf/ssr+l+HcjWU187rjPQlW+YqwnSd1fz
F3dOn78JYk9KvN8BAx1Mm1u+ZuAWpL63cvDeiennW4EvG/9wZ5mBBg6YD7RB
6itlt9nm6XkdoM/aRXL6DdTVfNzlPiQ/WVIxn5ue3w2G0MHll+0ZyrpFHG1k
eiC5saAgwI3Bfb3w1D3coYcw9I6l+iDpJ6fsuDAG9/fDmLJTnkxkaIjlDw3E
f3Es8XgOg3oGQNe1fnhJEUPVloWDsPtdu/Cqagb1PQBdafO99Z0MXW5e7zYE
u17OCtDoGNT7EEYy1VVJKpY6moalzR2GmFHxdVsXFvU/Au3W6+fyvVn6DIYW
YuuTnDw2sehHC0MrPHMbYlmqCzYLfAwxP+oUWzNZ9DcCQ1MX92pPsbTLEsco
RH0ePZJ+mUW/OtB0Ltxuf4ulJnGmgU/gY+jvODfIov8x0PyaH+gtsdQir/xf
iJgbWtviwGEe49B30MEr0p3DeeMQ8fheyXgAh/k8hd4tufMORXI4/ymE1QUe
c9rHYV56+NtNpSrN43CfHsJ+aNivvsBhfhPQacwYa6Mc7p+AbZ/57ozu4TBP
A7S3s938OEeLzfaKDLBl1ZX1uXY85stA54WEBtdFPM0/bS4GQl5y977iy2Pe
LLQf0P62egtPj1oEshD8qNi1N47H/DnoCI46EX+Ip5ZxhzlYUzPfTvkzjzx4
aF/am3Gigqfp5rjTeAj6/qR+WSuPfHholUJiq4d5mmiWt0eAdTH2fRuneOQl
QONftzcPOgk0NsZcImx4J7t5r6eA/ERoOR/gaxckUIvdCAnef1F56UyUgDwl
qE+rXeyZJiAPGfwf7j/VdFxAHjI0bvKeHVoqIA8jBN3QfzXSJCAPI9S/eonN
6BOQxySoj8bFzWEE5DEJNcIyTfFsEXlMgd+nQx/4LBWRxxTcaC1sua0WMU8F
2fh2pHp7qIh6FKSuyPmKPkHEfBUk4IWuZUeyRdSnIDWpx884nxUxbyVRP9g4
p6xKRL1KUrlh1hHSLmL+SkIqb4odIyLqV5L6RYcSYq0l5GFFvL8jQ+I8Cf1Y
kRpO3pa3UkI+VsRnR9XdhRsk9GdFrt7Z618RLSEvU/8tr+uBByX0a01unB17
re+khPysic/zpYUJlyT0b+rvi3W0/lOiFnmj1sRrYHHOSY2E93MGubZOM7lc
kKgFb8wM4n7tTFLtHBnvq6m/IEy7eYVMn71OZhC3bx0jh/xlvL8qco1pa0sJ
l5G/inh9krd6VrKM91lFym+trS7Ilemz152KeLxp6+l1XkYeNuT3X5qKm2tl
5GFDVszMdA7rkpGHDSlJ9svTjcnIw4a4/cNbZdoakYctKQyqSHFYYEQetsTj
aqKuxMeIPEx9F48o32Aj8rAlC74ZuX93lxF5PEcKJ0rWRmUZ6X9FWldB
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw9lAtQVGUUx3dZlg3NyJCITPDNI3IYMiLUPV/GIPgGUyRgCA1I0ZBAUHxE
+BgjQjMzZYhUEE0CJSUgHl9I5PvBQ2QYBgFRV1gJYe/7LrS7Hjozd+7c+333
nP////vmTluXEBJjpVAoYkyX+f5/fTKh9IpumFY47+sPrsiDr/6+NitcacDn
EjDO2Z8z4GSg4+7nb1kwrhx2Hl9ol+E9tl4Lkmp0j8MSA537rrnqYccXVfzZ
9WP7r4DQlrp5/k4D7UmbVLKo+zps+2huz50jY9/fBr54cM36YgMN7DZvaISU
N4pvsA1j/ZphKGMDyew0UBfzdud7kPxsVtkUbqz/fTCE9riX2jGUdYs4eJlp
gy8v5+X5uzE4rx2ee4bbtxGG3rRUByT95HggPozB+Z3wTNkijyQyNMTyogs2
bTqUeDiTQT3doG9d+nhWPkO1loE9sPFD2/DKKgb1PQR9UcOdpS0MdTePd+uF
Da9n+HfpGdT7CHTp2sokNUsdTM3SJj2G2H7xHY0zi/qfgG51+akcH5a+gKGD
uL+SHOesYNGPDno9vLLq4liqDzYLfArrftQrVqez6K8PHo6e3ao7xtJWSxz9
ELUxpm9HKYt+9fCgZVqU3XWWmsSZGj6DCOhsPtXDov8B6Pw1J9BHYqlFXsm/
EDYptOaaPYd5DEL7bnvvSE8O+w1C+NM7hYP+HObzHNpXZU3eG8lh/+cQVht4
yDGFw7yGoM1NrS7K5nDeEKz9oW679gyH+Q1Do3HXQCPlcP4wrPncb31MG4d5
GqCxib3PD3K0wGwv3wAhCy4uzbLlMV8Gms4k1LlM52nOcXMxEPyap89FPx7z
ZqFpp+5cwCqeHrQIZCH4SYFLezyP+XNwNzj6yOa9PLW028fBouoptsqfeeTB
wz+z23cdKePpDnPcaTwEfX90yPU2j3x4uCWFxFU95mmiWd4WARbH2nUsH+WR
lwCX795Y2eMo0LhYc4mwZN6Bhq1eAvIT4eppfz/bIIFa7EZI4P+q8nxutIA8
JahJq5nhlSYgDxnmPdp+rP6wgDxkqFvhMyG0SEAeRgj6c+jrvnoBeRihduZ5
dleHgDxGYP7B+PiJjIA8RqBacO0qmCAij1GY91nvx76zReQxCpW3T1y7oRUx
TwUJ+CBSGxUqoh4Fqc53ujiUIGK+CqJ9pdV1/wER9ZnWtx3OdTopYt5K4vtw
+cTiShH1KsmlZeP3kyYR81cSbcUVsblPRP2m9el7E+JUEvKwIj7fkV5xsoR+
rEg1J6/NnishHyvita7y1rRlEvqzIhdubl1YFiMhL9P373uXB+6W0K+KVJwc
eLvjqIT8VMTn5aITCecl9K8i51LiHFRXJWqR168iHt0zMo92SXg+rcnvS7pG
3AWJWvDGWhPPP3KTaibKeF6tyYWpYbqVHjJ98TuxJm7fOkT2LpTx/KpJCdPY
mBouI3818fo0O2B8soznWU1+u764Ki9Lpi9+d2ri8Z7Gy/u0jDxsyLlf6gsa
amTkYUNmjkt3CmuVkYcNKUien60fkJGHDZn+gLdK1xiRh4bkBpWl2k81Ig8N
efNSor7Q14g8NCTPeU60X7AReWjIW9/03bu1wYg8XiInhgsXR2cY6X9rzFZT

     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw9lAtQVGUUx/cBbGhGhoTkiIovIGIYIiRSzhcyig9QMEVCxpAAiQzxLT6G
SB0zAjMzZYhUEE0CxhQEET+QGBMVROSRQwgr4rqshLD3fRdi10Nn5s6de+93
z/n//79vvhkbksPjVAqFIm70Mt//r08nXLqlG6Llzgf7wspzYf+ft2dHKY34
XAwmz0PZ/U5GOq4tb/OCcVdhz6lAu3Tvse83QFKPfOOwzEh93jdXLaR+Vclf
iB1bfwuE9p2b5u81Um3qpOLF3fWwa6GPtvH42P8NwBUNrIktMtLgbvOCJtgx
uegOWzfWrxkG0xPJkU4jnWZe7twCW17MLp3KjfVvg6EIrdslO4ayruuybjLt
sOVmbm6QK4PzHsGAR5R9O2HoXUt1QMrPjoeTIhmc3wkG5UN5OIWh4ZYXXZD0
5dGUY0cY1NMN+tblvbPzGBpgGaiFxI9toyoqGdT3BPSFdY3LHzLUzTzetQc2
vp0e1GVgUO9T0KUFVGy1ZqnDaLPUSb0Q1ye+p3FmUf8z6F199Wy2L0tfwdBB
fPVWR88VLPrRgdbdK6MmgaWGMLPA5xDzk0GxOo1Ff3p4PHJhu+4kS1stcfRB
9Bdx+j2XWPRrgM6HM9bb1bN0VNxowxcQBZ3NZ7Us+u+Hf37LDvaVWGqRV/wv
RE6KqLptz2EeA/D3fnvvaA8O+w3A2ueNBQNBHObzElpWZUw5EM1h/5cQcSP4
qOMODvMahCZXa+vCTA7nDUL4jzW7A85zmN8QNJr29TdRDucPwZqN/rFx7Rzm
aYR7D9g2foCj+WZ7eUZYsuDy8gxbHvNl4P755JppLjzNPmUuBkLe8vC97M9j
3iw07tVdXLSKp1kWgSyEPsuf9iiJx/w5aAiLOb7pAE8t7Q5yEHh9qq3yFx55
8FA359G+46U83WOOO5WH4B9ODM5t4JEPD3el8ITKXp6mmOVtFmBxvF1H6AiP
vASovn9npdZRoAnx5hJh4UeH67Z7CchPhJpzQf62SwRqsbtOAvKmsiQnRkCe
ElxPrZrplSogDxn8nu4+WXtMQB4yVK/wnRBRKCAPEyy8Nvi1vlZAHiaonFXC
7usQkMcwzMtKSprICMhjGMqFuV35E0TkMQK+n/d84jdHRB4jUNZw+vadABHz
VJBFH0YHrI8QUY+ClOU5XR5MFjFfBfF/o3XuocMi6lOQ8l3HcpzOiJi3kvg9
CZ1YVCGiXiW5EjL+EHkgYv5K4l9+S2zWi6hfSf5wOZCcoJaQh4r4fE96xCkS
+lGRa5y8NtNHQj4q4rWh4t6MEAn9qUjx3e2BpXES8lIR73neV4P3S+hXTcrO
9L/bcUJCfmri9Xrh6eQSCf2rScGOBAf1XxK1yOtTE/fumUdOdEm4P61I8bKu
YTdBoha88VbEtSxna9VEGferFSmYHqlb6S7TV8eJFXH5ziG6J1DG/WtNfmea
mnZGycjfmnh+lrlo/DYZ9/Po9/qllbkZMn113FkT9w80Xt7nZORhQy7+Wptf
VyUjDxsya1yaU2SrjDxsyNlt8zMN/TLysCHOj3lVmsaEPDTk5JLSnfbTTchD
QyZfSTEU+JmQh4bkOnvG+IeZkIeGvPOtvuVeogl5vEZyhgqWxqSb6H/031Vl

     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw9lAtQVGUUx/fBsqERGRKSI4pPJGJ2CIlIOV9Ehm/BBykwiohIZICKJCpD
pI4ZoZkZMkQq+CgCJQUhwg8kIhVBFJEcMlhR1wUJYe/7LsQuh87MnTv33u+e
8///f998bhsSQmNUCoUiZviy3P+vtfYl9YYBWu66rzukPA/Sfr82I1xpwudi
kL325/S6mOiYe/mJ88Zchl3HAx0yvEe/XwFJPfS50yIT9XnTUrWQ+kklfy56
dH098G0pW+buNlF96vjiDzqvQ8p7Pvqmo6P/NwJT1Lc6ushEgzstC5oheULR
DbZutN8d6M+IIwcfmOhky3LXu7D12YzSSdxo/3swEKafXeLAUNY94tBVpg22
Xs3LC3JncN596PUMd2wjDG2wVjskfud8IH4Ng/MfgFHZIg8mMTTU+qID4j4+
nHTkIIN6OsHYuvjxjHyGBlgH6mHzu3bhFZUM6nsIhsK6psUtDJ1tGe/eBZtf
zQjq6GFQ7yMwpAdUbNOw1Gm4Wer4xxDdLb6hdWVR/xPQr7p8KseXpSMwDLCx
epuz1zIW/RhA76HLrIllaU+IReBTWP9tj2JVOov+jNA+dC7ZkM3SVmsc3RDx
UYxxVwmLfnvg7xa3dQ7XWTosbrjhM1gLD+6c0rPovxfaf8wJ9pVYapVX/C+s
Hh9Wdc2Rwzz64K80R+9ITw779cHKp01n+oI4zOc5tKzInLg3ksP+z2HlleDD
zjs4zKsfbrlrNIVZHM7rh+Xf1OwMOMthfgPQYN7T20w5nD8AoZv9o2PaOMzT
BPW32Xt8H0cLLPbyTbBg3sXFmXY85stA09mEmslTeZpz3FIMLHnF0/eiP495
s9C42/DT/BU8PWQVyMLCJwWT78fzmD8HDSFRR7fs5am13T4OyG+T7JTf88iD
h6qZ9/ccLeXpLkvcqTy8//Wx/lmNPPLh4Q8pNLbyMU+TLPISBQja5NC+dIhH
XgLQWzeW650FGrvJUiKQdw7UJesE5CdC9ekgf7sFArXajZAAXlaez40SkKcE
lalV03SpAvKQwe/RzuzaIwLykKF6ma99WKGAPMwQ8Gv/Z8ZaAXmYoXz6eXZP
u4A8BmHOofj4cYyAPAahXJjVUWAvIo8h0G3sWuk3U0QeQ1DWeOLajQAR81SQ
oLcjA9aFiahHQcryXS72J4iYr4L4v9Q6a/8BEfUpyKVPj+S6nBQxbyXxfbh0
XFGFiHqV5JclY/eT2yLmP/y9vF68YxRRv5JcmLo3IVYtIQ8V0X1FusSJEvpR
kTJO/jDLR0I+KuK5oeKm2xIJ/alIcUNyYGmMhLxUxOMt78vBaRL6VZMLJ3tf
bz8mIT810b1YeCLhvIT+1aRgR6yT+k+JWuV1q4l757SDxzok3J82pHhRx+Bs
QaJWvJtsyMyy3G1V42TcrzbkxJQ1huUeMh05TmzI1C+dIrsCZdy/GvIz09yc
Ei4jfw2Zvj5r/tjtMu5nDcm9vrAyL1OmI8edhrjP0eq8T8vIw5ac+qG2oK5K
Rh62ZMqYdJc1rTLysCV52+dm9fTKyMOWuP7Dq9K1ZuShJdkLSlMcp5iRh5ZM
uJTUc8bPjDy0JMfVK8o/xIw8tOS1L4x3b8aZkccLJHvgzMKoDDP9D+kxVIs=

     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw9lAtQlGUUhndZlg2NyICQcQQviWjEEBIZ6Z4vIsMrFzNSZBQMwUiQQURR
HCJl1AjNiJQhUkG0CMxBBEL8UkITvOEFGYYxWBHXBYnL/vd/od3l0JnZ2dk9
33/O+77PN//M2OSIOBuFQhFn/li+/691Duev60dorfv+vvDaYsj868acKKUR
f1eC7JNTOOBmpJMelWxbPKkGMo4HOWb7TfQvg6ga+9pluZH6L7BUI+xMqufP
bpo4fx249vSti/YYqS7DufLj7mZI/9Bfdyd/4vnbYKwY/HRThZGGdFsOtELq
1IoWtmli3n0Yyt5CDj02Ug/LcfeHkPRiTvV0bmL+IxiK1M0778hQ1mv94atM
OyRfLS4O9mJwXwcMeEc5tROG3rRWJyT96HogcS2D+x+DQflAHk1haIT1jy5I
+PJIytFDDOrpBkPbit45JQzVWhfqIOED+6i6egb1PYHe8qY7Kx4wdJ5lvVcP
JLyeHdzVz6Dep6DP0talqlnqYh6W4dwLsX3iWxp3FvU/A92amlOFASwdh6GH
2D9TXX1CWfSjB91839wr8SztD7cIfA4bf+hXrMli0Z8BOsfOpumPsbTNGkcf
rP8izrD7PIt++6HjwcwNjs0sNYszD3wB6+Dx/VM6Fv0PQMcvhSEBEkut8ir/
hTXOkQ03nDjMYxDa9zr5RXtzOG8QQp/fKRsM5jCfIWhdnTttXzSH84cg7HLI
EdcdHOY1DHe91OryPA73DUPo91d2ac9wmN8ItJgyB1oph/tHICwhcFNcO4d5
GuHaPfYRP8jRUou9EiOELK5akWvPY74MNJ9JvuIxi6eFxy3FwLLXvAOqAnnM
m4Vre/S/LlnN08NWgSwsfVbq0ZHIY/4ctITH5G/dx1PruP0ckEvT7ZU/8ciD
h0ueHZn51TzdbYk7g4ePvisYnnubRz48NEkR8fW9PE2xyNsmgHazY+eqMR55
CUDvtoTpXAUav9lSIpD3DzSl+QrITwR6OjjQfqlArXbXSxDwqvJcUYyAPCWo
zWiY7ZshIA8Z3n6661jjUQF5yFATGuAQWS4gDxNo/xj+ytAoIA8TXHjjHJvZ
KSCPUVhwODFxCiMgj1GoEuZ2lTqIyGMMfD7v+WShp4g8xqDq9okbLVoR81SQ
oPeitRsiRdSjIBdK3KqGk0XMV0ECX2mbm3NARH3m/s6jRW4nRcxbSfyfrJpS
USeiXiX5feXkHHJPxPzN/drr4n2DiPqVpHLWvuR4lYQ8bIj3t6RHnCahHxty
kZM/y/OXkI+5H1t3a+ZKCf3ZkNKbaUHVcRLysiGe7/rVhOyV0K+KVJ4ceLOz
QEJ+KuLzcvmJ5HMS+leR0h3xLqq/JWqV16ciXt2zDxV0SXg/bclvy7tG5wkS
teLdbEs8LxalNkyR8b7akuIZa/Vh82U6/jqxJTO+cYnuCZLx/qrJWaa1NT1K
Rv5qMmtj3pLJ22W8z2pS2LysvjhXpuOvOzXxekfj63daRh525NTPjaVNDTLy
sCPuk7Lc1rbJyMOOFG1flNc/ICMPc/8f3iZLY0IeGlKwtDrdaYYJeWjI1Asp
/WULTchDQ/LdfWICw03IQ0OcDxoe3tpiQh4vkWMjZctisk30P+P7U84=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw9lA001XcYx+/FzdSaGSa1lIpUcswwU3l+M8ekV7Umk5UKa4YclVI6Zuq0
ZjQzk2OmSG0OZbJI+q3MKXoxveB0HCHdbsjE/b//L7v39thzzj333Pv8/s/z
/X4/v/N33J6wIcpEoVBE6T+G7//rs+lVNzRjtNbhyGBIbRGk/t3sFK7U4u9K
kNyOFgzba+nUjpLdK6Zegv0n/S3TPSb7V0EwnfjGdpWWer5nqEbYH1/Pn9sx
ef4GsJ3JccsPaWlfik3lx70tkPyRZ19r7uTzd0FbMfLpjgotDeo1HGiDpBkV
t9imyXn3YSR9FzneraVzDMcdHkLcC6ea2dzk/A4YDu1bVGXJUNZlS/Z1phPi
rxcVBbgwuO8RqF3DrTsJQ28bqwvif7Y7FhvG4P5u0CgfyOOJDN1g/KMHdn51
IjHnOIN6ekHdvlrtVMJQP+PCPtj5oUV4XT2D+p6AurypdfUDhi4yrHfph+i3
0wN6hhjU+xTUaX51SSqW2uqHpdioIXJQXGruwKL+Z/B406XTBd4sfQVDA9v+
SrJzW8eiHw10LHbPvBbD0qEQg8Dn8PlPQ4pNaSz6G4DOiXN7NfksbTfGMQhb
vowaOFjFot8h6HzguNWyhaV6cfqBL2AzdN8/3cei/2G491tBkLfEUqO8yn8h
xCa0odmawzxGoPWwtUeEK4fzRiDweWvZSACH+byElo2ZszIiOJz/EtZfDTph
t4/DvEahxUWlKs/icN8orPvx2gG/sxzmNwY3danDbZTD/WMQ+IXvjqhODvPU
Qu09toMf4WipwV6JFlasqF6dacFjvgw0n024NmceTwtOGoqB4Ldcvat9ecyb
hcZDmt8DN/I02yiQhWXPSuc8iuUxfw6uhETmxmXw1DjuCAdeV2ZbKH/hkQcP
l50fpebW8PSgIe4UHpb+kDe68C6PfHhokDbE1Kt5mmiQt1sA72jLrrUTPPIS
oP6fW+v77AQaE20oEZYvO9a0111AfiLUnwnwtVgpUKPdLRJ4vak8XxgpIE8J
qlIa5runCMhDBpenB/IbcwTkIUP5Ou/poeUC8tDBu5dHvx5oFJCHDqoWnGdT
uwTkMQ5u2bGxVoyAPMbhrLCwp3S6iDwmYMnO/k98nEXkMQF/3C1uvuUnYp4K
4v9BhN/WUBH1KMjFEvvq0QQR81UQnzfaFx49JqI+Bancn1Nof0rEvJXE48la
q4o6EfUqyYU1046SeyLmrySutTfE+wMi6leSynkZCTGmEvIwIa7fk35xloR+
TMgFTt6c5SkhHxOyYHvdHcc1EvozIcW39/rXREnIS99/3+NS0GEJ/ZqSylPD
S7ryJORnSpxfLy9OOC+hf1NSvC/G1vSmRI3yBvX93vnH83okvJ9mpHRVz/gi
QaJGvNFmZMGfhUkNVjLeVzNSODdMs36xTF+9TszIO9/ZRvT7y3h/VaSMaWtL
DpeRv4rM3JYVOG2PjPdZRfJbguuLMmX66nWnIjO8zN09zsjIYwop/rWxtKlB
Rh5TyMypafZh7TLymEIK9yzPGhqWkYe+/5g3STPXIQ9zkruyJtl6rg55mBOb
i4lDZT465GFOchzcIn1DdMhD3/924OGdXTrk8RrJHSsLjkzX0f8AF1dSIw==

     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw9lAtMU2cUx0uBlikSXzBgC6s1E9kcm4w53+cbGmU6FTQTUImDiURhASdT
1yXCFHBsrKBZUHwgCoPw0iGCVcc+J0McATMwIlMiBaG0tJT29sm9tzJajzvJ
zc2997vn/P//35dvXmLa1iShQCBImrqc9/9rx4z6NrWJKoJytNGKEkiO/fNk
3MVXz1fAvP1UQ+52E532uCx91bQbIEvN37DN59X3PyBGsqak5R5Dwz90Vgsc
b9V79WUyuL4NOjOTrKXLGDoom3tl/UA7zO4fG/QzG/H/B3DSVxMXcdVIIwec
C7qAG99qDk4xYr+HcH/QN6Yj2Ejfci4PegRuNxcvDh82YP/HsLaxYdmeMgO1
LtxVcNfSCxXrM99LSDTgvCfg/UTV8b7UQDtc1QdL14Zcq2odx/nPoOGvE9Lq
yHG61fVCCe2vn969v1OPegbAUmDrNG3T09WugYOwKujS7S19Y6jvOYjAHnti
7xgNcY5fOASJ1cX1ZYwO9Q5D94rh8rosHfWdaiabqwLZRPSzupk61D8CewqL
Omsva+lLGGrwEjWUXFuiRT9q2FGnWdzWMUp10U6BGiBVTXOYPaPobxRSY3oy
lk9qaI8rDi34P0+RVp7ToF8dZI3FHV29XEOnxE01HIPPKvsPi56q0b8eMpT5
2R5H1dQl78o4KL66WLxqvhrzMMD9rqdvN7WPYD8DCKKY6V9njGA+Rlh3KOtC
hmQE+xvB2tJcdOeBCvNiYHu8MjA2U4XzGAi8t7Z+ZZgK8zNBbEiB9lylCueb
gN+SF8fTEczTDLe8xa/ZetW03GmvzAyi0JSeY4wG87XAqbxPNp/21tKzxc6y
gNRw8MKi4Fd5WyGy9s3jKyLGaIFLoBVk99rWNMfrMX8b/CJiL9R8O05d7XJs
4Neh2y3YaEAedpCv0ZXs/NdAv3PGLbPDA7nUczjZiHzs8PmNh0vOWo30gFNe
+gR0S7WTR3IY5DUBt/x7ozLnmmjyXmexoPinYUVNmQn5sZAnqzKyYWbqsruL
gyP5xXdS75qRJwdcAjNzMtqCPHg4pFR8+duABXnwkLrv96jMA1bk4YBulTF7
v5sNeTggNpS5k37ShjxewOXEM48L59mRxwtQRDXX/l1vRx6T4OE/IzwwYgJ5
TELfdXPa990TmKeArFwWv3p3DIt6BORaWUADk8ZivgKy1KcnOPcHFvUJSPWR
U+cDLrGYtxsJfb55Vt1NFvW6kfJN03NJN4v5u5FFijb24SiL+t1IhTQ7Ldmd
Qx5CsuBnMsS+waEfIam18bHycA75CIkk8WbnvE0c+hOS0o5vIhqTOOQlJNKP
w25EHuXQrzupvaR/t6+IQ37uZIF3TWnaVQ79u5PSQ8m+7vc56pKndSeSgfk/
Fik53J8e5PJG5YuQCY668O71IJKm8webZ/G4Xz3IGUmcOuodnr48TjyIz0++
8UMRPO5fT1Ji6eo6vJNH/p7E/wv5uukZPO5nT1LUvuF2ST5PXx53U98/En8Q
9iuPPEREfrGlvLWZRx4iEjgtKyCuh0ceIlKYsVKu0/PIQ0T8+u3CLLEDeYhJ
4aeNh+dIHMhDTGZfP6CrWOpAHmKSHxSasDzagTzExCtv9FHnPgfy8CJyU8WG
hGMO+h+y9VLo
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw9lHtQE1cUxkOABBEdrIJCOxSxLdJWrZRaReRcwakUX4AdhAq1UIH6aIFK
ldIZQin4GgroHyiKKMXH8FREEcfSS0WkdYIjOgJVRnmGhISQbEISdjdQEg49
Mzs7u3v3nO/7fnfu0vjkiAShQCBImL4s9//ry3l1bXIdbfTIVYY3lkJS1F+n
oi/OPteCPvJ0/dFIHXXsKk/Z4HgHMg7mhe6cP/v9T/jCM7i05SFD/T62VAtk
t6odeiQMrm8DqSTBcGkdQ/szFtVu7nsETq9H+131Wvz/MeS7KKKDrmtpSJ9l
QQdwYxF67wNa7PcM2vpddkm9tfRty3KP58A1rl7tN6TB/l1Abtev21uuoYbl
MQX3x7vhymbJirh4Dc57AXNeyKSrvDRUaq0e8N3kc7OidQznv4LKB8e8KkPG
aIT1RS88XHxmz/52NerpA02BsV23U00DrQP7YZVH2b0dPaOobwCEYIo6ljhK
fSzjlw9CRGVxXTmjQr1D8GT90OWaLBV1mW6WsUgGMRPhr2qcVah/GL4qLGqv
/l1JZ2DIQSCqL725Rol+5LC1RrG6TTpCVeEWgQoIrGhYyOwdQX8j8O2uzjT/
KQXttMahBOeBA17XzivQrwrSR6MzA/0VdFrcdMNRCLn2+ojopRz9qyGlNy/H
LlNOrfJqx6Dhu4vFG5bJMQ8NVHe8fLfh0TD204BpBzP3h7RhzEcLmw5nXUjz
HMb+WjC0NBU1P5ZhXgxsje11j5LIcB4D6tZNdQG+MsxPBwE+Bcrz12Q4XwfN
O05E83QY89RDo5N4jrFbTi9b7JXrQb3iQGc2o8B8xyHyxMbtZ5yU9FyxpcZh
iebQhQ+9Z/M2gH/1W7+uDxqlBVaBBkh82BbcFKvG/I3gJ2IvVP00Rq3tco3g
IFXtEWzRIA8THA9Wle7+V0N/tsSdYQJJvpf9UJIW+ZjA/86zNecMWppqkZcy
AdRLOZWeyyCvCShb0h0mWaSjSYmWYqHwSf36qnId8mMhNaNCy/rqqdVuDAeH
84qbD97XI08O2DjGeSp8HHnwENnb+M2NvnHkwcP+fX+ESVINyMMMD2TanP02
RuRhhu0rmeaUU0bkMQnp8We7CpeakMck3Ahrqv6nzoQ8pqBz8Tw/96AJ5DEF
3bf0yb88ncA8BWTtutjAPbtY1CMgleVu9Uwyi/kKyPL5nd5Hj7OoT0DOpp8u
cStjMW8b8t7A9gU1d1nUa0NKts09Sp6ymL8NeaexjX02wqJ+G3LOKyc5yZZD
HkLi8RsZZN/k0I+QVBr5qHw/DvkIiXv83fal2zj0JyQl0h+DbidwyEtIPD/1
vROSyaFfW3K1TP1BTxGH/GyJwKnqUvJ1Dv3bkpLDSS62f3PUKk9pSxz7lp0s
6uVwf9qRvC29kz4THLXiTbQjHg0lh5oW8Lhf7UiRZ7Q87H2ezhwndmTypEvs
YBCP+9eelIx3dBzZzSN/e+L6df5nc9N43M/25Pij0HuleTydOe7syfxPxB/5
XuGRh4jkXWy53NrEIw8RWeKY5RbdySMPEfk+LSBfpeaRh4i4vjYJs8Rm5CEm
hZ/fPrLQ04w8xOSNW6mqq2vNyENMsj1WxvmHm5GHmNidGHnevs+MPBxIju5q
aFy2mf4HCbVT3A==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw9lAtMk2cUhkspF5kzuxRJEJWhDFDxShQQON/EABkLKIgWp1kgwhjIZBtQ
QQbEeUvEqAMRNgQUM4UJiAhjG/OrA8VgcTADInjp/7elLbTQlgIVFUbL6U7y
p+nfr+e87/t8OR/FH4pK4HI4nIS5x/T5f+19t6FDOU5blh0f2dlSDvGCu+dj
Kyzf60Cz+8fGE7vHqcOTqrRAh9/gu4MFn0Yvsvx+ByJdg8vb7uupzyZTtUHu
vVH7Z3l6PN8BHXkJk5V+espm8+tCmU5weKlhFxt0+P9HUOCoit1Wr6NhjOlA
D0yPRRk8UnTY7zGIWMc9Yg8dXW46vqwXjC0bNvjItdj/CQQ1NfodqNLSSc99
Z/+e6IfK0DzvuHgtzhsA+4Eh8To3LRWb6xms3+51q/reGM5/AWXtJ91qwsZo
lPmFBNqcLn6R3DWKehiQn53qGo8epUHmgSx4L7v8Z+QzDeqTAgeMgpOJGupl
Gu8pgx01pQ1VejXqlYN4q/xqbb6aOs41y+YPwa5XO1/UvqdG/QrYe66468aV
EToPQwkzNo3ltzaPoB8lhNWqNnSIh6l6p0mgCoKqmz/UHxhGf8Mg2NOX7j+r
on3mOEZgkTTF7drPKvSrhsOa2NwgfxWdEzfXUAMh114KbQeV6H8UkiUFx3i5
SmqWVzcGNakVpYErlJiHFm70DLo3dyqwnxYMkfp3vk1XYD46IJn5l9JdFdhf
B4a2v4pFj4YwLz2E7Jc4C/KGcJ4e1Pe2NwRsHML8xoGfEBd8SCHH+eOQtqlg
ibZcjnkaYGFqseyOQE6vmuxVGSAnH2oG+HLMdwIM/34/8MljGf2p1FQTYIwu
DdUXyjDvSUiLeX+1areMnjULnISc1u1eK1xkmP8U3D7YE1MmlVJzu+NTIHp+
yXdHrRR5GGH90tzHfllSesQUd7YRRPwD16NDpcjHCGJ2geiik5R+Y5KX9grW
hPMaZlUs8noF7QOrrh27w9IvE001DUmBwSnLL7DIbxpuJj1PfpDKUrPdfa8h
SRQhEoaxyPM1uLz+w9/dnUUeb6DoB+fEB9Ys8ngDh13WFQpkDPJ4C6d6BC/F
9xnk8RaKzgQFuPzKII8ZWO8IwsDzDPKYAd+ySuKRxSCPWeCUZG7sjmeQxyyc
k25+sjaCwTw5JOC6sd5vK4N6OMS1X+Cv8GIwXw7hg9WktzOD+jik5PPur3gL
GczbiqwJuuwZNytBvVYkrLyx198gwfytSJlPk+epYQnqtyL5zl/rgJUgDy65
Xv7BkthBCfrhEl9hYH1nrwT5cEnL7xf6T/dI0B+XkNCV8sJHEuTFJQdLCo52
5lr8WhMOaVJWHGGRnzWpTF6bvHKO97x/a3JbELxml1BGzfJGrImrUJG6OtNy
P3lE1Gp18peMIWrGm8gjgrRWxd0MBd5XHpGFPHXKzlTS+XXCI/u6FzQ/FKrw
/tqQVu/PhI1Zw8jfhohnwj9emzOC99mGPMjpuOKbp6bz686G9NcaJf8c1SAP
W9JezVVpT4wiD1uS3hXfV3J6DHnYkm26WynxYZb9Z0tuntqx2O+hZX/akaLw
LfzICMv+tSMh/C1OVT065GFHSjKOPd0Uo0cediQgO2cp56keediTVc7Jtbb7
x+l/TeBKOQ==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw9lAtMU2cUx0sp0DlddAMRZMpUBsz5QInhIT2fSAZxmVSYWDY2hQBzosIm
g+FUWIbTRQxTIogi6GAR2QARUfaQrw4Q44oRCEKKyL23LW15tqW8BGVtOd2X
3Nx89373nP///zu578QlRyTweTxeguky3/9fnyyqadGM0foVJwd31RdDrOT+
uegS674KhqLO1/4YNUYXdJWmBC24C0cO5uyIfMP6vgHC3bcXNz4wUN/N5tUI
x5tHhM8yDXi+BZoyEyau+hsod9SxKpR9BMK+YW6pUY/fP4afnLTRwdV6Gsaa
D7TB+GiE0TNJj/U6oIFz2iPz1NOV5uMrOmGy3sfHV6XD+l0QUFfrH1+qoxNe
Mbn/jHdDSWjmutg4HfaTg1DeL9uwSkdllvUMNoZ437rRPIr9n0NR06lVFWGj
NMLygAGpc8HeA60jqIcFZe5k61jkCBVZGnKwdsW1v8KfDaM+BRhFU5JTicPU
29zeSwk7KwprSg1DqFcFskBVWWXWEHUyFTvq2A/i6V3PKxcPoX41RP2c3/r7
L4N0HoYGdHa1xbe2DKIfDXxQqfVpkQ3QoV1mgVrwu3HnLUP8APobAMmep6kB
c1r61BLHINgrklZdv6xFv0OQNhx9QhSgpSZxpoLDEHK9L92+R4P+RyCOyckW
nNBQi7yqUbh0qKQwaLUG89BBRVuPx51HaqynA0O44fWvU9WYjx5EaVlXUt3V
WF8PusZ7+dLH/ZiXAchnjKsksx/7GWCgOaRm66Z+zG8MJuJjtyerVdh/DGI2
5yzXFaswTyMID+UrGyQqWma2V2qEY1lQIXdUYb7joGw/Lt/WoaSXCs1rHJjI
wlBDnhLznoCY3UvWaqOUNNcicAK+/TvEe7WbEvOfhJsH23YXKRTUUu7kJEh7
r/iJKxXIYwref/tEh3+Ggn5njvvoFNx2jC+PDFUgnylo4l6TFjgr6FdmeSnT
sPBDQc2clkNe03BT/t717AaOfpFoXi9AHLQ9aeUFDvm9gPL9vQceHuKoxW7M
DIilO6XpYRzynAG3mT8DPDw45DELqT+4Jj605ZDHLOx325AnUbLI4yWcbpP0
yR6wyOMlHDsr2ur2G4s8XsEaJ0gPOscij1fgXnSVeGawyGMOZgvSNj2JY5HH
HGQptnSt38linjziVz5V7R/Ioh4eme2SBKi9WcyXR3hgM7HOlUV9PHLx0ydf
ChaymLcNWSO65hU7x6BeGxJSXNsZYGQwfxuS7VvndXqAQf02JNX1sB44Bnnw
SVnxm8ujexj0wyd+6UHVjzoZ5MMn2X9c6D7TxqA/0/vQNaq8xwzy4hNhTUyY
XMagX1vSVNdbFGXaz/OzJZIbw7/yWhn0b0sWL7srfmL63iJv0JY48nfU3TPV
n59PAdk4k+B839TfgjdRQFKTl6jb5QzOq4Cc9uDfH2QYOv87ERA/fs9hgYbB
+bUjut5gtZOOQf525GOX7o9cphmcZzuyL0kw5mDL0vnfnWnvczuyZ5GVhz2R
fG5cdtbFysOeCEcynJ3ftfKwJ1nnncKPbLbysCcP3ZcOXN5m5eFALi4p2npG
bJ0fByIVMY2B+1jk4UDEHcke5SnWeXIgXsF71//7PYs8hMRL+017SR5L/wNx
SEk7
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw9lA9QVFUUxpdlATNtoEACTQklwVJCGUYQ9lyBiR1D5U/iUpbIAJmoUJII
mdCE0Yw4oIwQgYBhA1hASCiVcjFUHAKGP6MwC+h7b3fZXdiF3WVBEI12l7Pd
mTdv7nv3nfN93+/MezM+JSqRz+PxEo2X6f7/+nBlY4dymrasPTsR2VIOceI7
F2IrLPt6UMdcbPouZpouH6xKDVp+E04czdsV/YrlfSvsdgspb7+vp77bTKsd
Tt+bXDaSpcfzHXA3K3G20l9PuUzH+jC2E2yfaLhVBh1+3wO5TqrY4AYdFbGm
A31gmIoybEzWYb0BaOWc9ndt1NF1puNrH8JMi4+Pr1yL9QchoLnJP6FKS2c9
D+T/PTMEl8OyNh+K12I/CdhJxrq83bW0y7xGwDvU63rtvSns/xhK7+a6XxNN
0SjzAwZanIsPHumeRD0scPlPu6ejJ6nQ3JCDTWuv/LV3RIP6pGAQzolzkzTU
y9TeUwbh10oaq/Rq1CuHzh3yq3XZaupkLJbpOAYR85GP6+zVqF8B7xUUdf/6
0wRdgqGESZum8ut+E+hHCcF1Kp+OrnGqjjQJVIFf7Y3X9Anj6G8cwvc/SgtY
VNFH5jgmQCBNdq8uVaFfNaRpYs8IA1TUKM5YUAPB1U/SbYeV6H8S4pm8HMEZ
JTXLq5+CgmMVJUHrlZiHFir7hj1udCqwnhaYvfqXv0hTYD46CDyZfTnNTYH1
daBuv13U1jOGeenB72PGVZw1hv30wNwLbQzcOob5TYMh4VBIikKO/adBvC1v
tbZcjnkaQHCsSNYqltOrJntVBjiVDdckjnLMdwaY/q8lOwdk9McS05qBoeiS
MH2hDPOehQ/2ObytipHRfLPAWTh8K9Rr/RoZ5v8Uyo727SuTSqm53NmncGv0
8vaIOinymAPPN84M+GdI6VemuDPnoMYxoSY6TIp85qCNe6mt2FlKPzfJS52H
Fe8LGhdVHPKahxrJpuqcVo5+mmRazyA8KCR53SUO+T2DHw6PHnlwjKNmuwcW
QNS2py1dxCHPBbBf+DPAw4NDHs8h7lvXpAfWHPJ4DuI13oViGYs8XkBOn/hJ
130WebyAU+eFgWt+YZHHv+DmBOlBF1jkYdyXVZKNGSzyWARD8cmtvfEs8liE
U1K/wS17WMyTR96tmWvw38GiHh4xDIoDFF4s5ssjSqHV7GZXFvXxSMFHvZ8J
VrCYtxWxF17xPLTIoF4r4lve9DDAwGD+VuS0b7Pn9+MM6rciaa7HdcAxyINP
8spfXR07zKAfPvFMD2rofMggHz7J+ePS0Lk+Bv3xiWPYBnlhD4O8+GTutwMi
SReDfq1JTfNoWYxxv8TPmohqNT/zuhn0b02Uzjcjeo3fm+VNWBOt1a7m28b6
S/MpIO8sJDrfMfY3400SkMMpDop+CYPzKiCpHvw7EwxDl34nArKBP3xcoGRw
fm1I72iwwknLIH8bEu4ytNtlnsF5tiEbkgXTdtYsXfrdGd/7/B49vNLCw5Zs
/8Tw+nkXCw9bwmgynJ3fsvCwJXEXnfae2GbhYUuy3VaNl+608LAjqQ5lgeci
LPNjR9qETPuOOBZ52BHRQIpHTaplnuwIL/jgln++YZHHMmKv+rK/opCl/wEE
rknb
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw9lA1MU2cUhksp4JwucwNRZMhwDHBThxIjfz0fQoQQpwKKZWNTCDAnKMwx
+TETluFYIgaV+ANiweECuKEiQ9mmfDhUCAPDjwgpgvfetrSFFtpSsYjK2nK6
kzQ3t/e757zv+5zc9xPTo5P5PB4v2fQzX/+vzxbXtymnaJPbsfGoJjHsFd09
FVdhvb8K6tjTDT/FTtGFA1UZwQtvwaG0osiYt6zPm2Gre6i49YGe+m0wVysc
uT+x4EmeHs+3QWte8nSlv55yuY5Xw9kOsHuq4ZYadPj+Qyh0UsVtvqajEaz5
QA8YJqMNXqk67NcHzZzT7k4vHV1pPu7WD4YmX18/uRb7D8Cmxgb/pCotnfaO
L/7n2SBcDM9bk5CoxXkSEEhGO9d5aGmnpZ6AT5jPjdr7kzh/BMruFXpciZik
0ZY/GLjpfG7P/q4J1MPCSPHzrqmYCSq0DOTAy+3S39ufaFCfFLRCo6gwRUN9
zOO9ZbDlSml9lV6NeuVwL1B+uS5fTZ1MzXIdR2HrTNRI3dtq1K+AsJNnu37/
ZZzOw1CC2q5BfGPjOPpRQkCdyretc4yqo8wCVbC69ua7+qQx9DcGW3Y/zgyY
U9HHljjGQSBN9ai+oEK/akjTxB0VBqioSZypoQY2Vj/Nsh9Sov8JSGSKCgRH
ldQi7+oknDxQURq8Sol5aKGsZ8jzZocC+2lhZLv+zUOZCsxHB36H8y9muiuw
vw7GWu+cbXk4innpwe8LxkWUN4rz9PDoflh90PpRzG8KDEkJoekKOc6fgp0b
ilZoxXLM0wDGtLOyZpGcXjbbqzJAZj5ckTjKMd9n8Kj3e0lIn4yWlZrrGbTH
lIbrS2SY9zTs3LXkI1WsjBZbBE7DvtthPqtcZZj/czif1rOrXCqllnbHnkPT
8MVNO+qkyMMI7u8d7fPPkdIj5rhzjVDjmFQTEy5FPka4zb3Rcs5ZSr8xy8uY
AWOkoH5OxSGvGaiUrK4uaOboVynmegFhwaGpK89wyO8FnN83vL/9AEctduNn
IahlW0tWBIc8Z4E3+1eApyeHPF5C/I8uKe22HPJ4CRGu60pEMhZ5vILMHtHT
zgcs8ngF2SeEQa6/scjjNSxzgqzgUyzyeA288krilcMijznQnju8vjuRRR5z
kC3dOLB2G4t58ohrjfGafyCLenjEMCAKUPiwmC+PDAptpte4sKiPR7I/7/5a
sIjFvG3IIuEl74Q5BvXaED9xQ3+AgcH8bchev0bvn8cY1G9DMlwO6oBjkAef
FIjfWRE3xKAfPnHNCr7W0c8gHz7J/vPM4PEeBv3xiWP4B/KShwzy4hPZ9fgI
SSeDfm3J5cbh8ljT/Tw/W7KpVvMrr4tB/7aEcb61o9v0vkXeuC1R2kQ23jH1
n99PAfGeTXa+a5pvwZsiIKL0JYpeCYP7KiBpnvy74wxD5z8nArKMP3RQoGRw
f+3I9eHNCictg/ztyMfLBz9dPsPgPtsR91TBlIMtS+c/d3aE+P4RM7TYysOe
fPKlYdmJ5VYe9qRdk+Ps/KGVhz0hp522f7vBysOeZLsvHbsQYuXhQDKWlAcd
32HdHwfSJGRaA/eyyMOBePele9ZkWPfJgRhD9qz99wcWeSwgPNV3vRUlLP0P
U+FJzw==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUx0sp4JwuuoEodspwDNgUBYyRV88nkkDIpjwUS8amEmBOUHBj
8tgmLPOV+GAK4pgIOFhENkBkKHvABzKBODAgQ0h5eO9tS1ug0JaCvJS15fQk
TXPv/e45////d3LfiUkKj+PzeLw4w8/4b67FqJXVrcpJWrfhzGhYXSEcEjdd
iSoyX1fCWOTVmrORk3R5b0my//IHcCLxYkjEG+bnDfCh4+7C5hYd3e5lrGbI
eDS+bCBTh+db4WFm3HSxt45yGbaVQexjsHqu5tbotfj+Ezhrp4oKqNLSYNZ4
oAv0E+F6lwQt9uuGes7uQLuLlm40Ht/QA7o6D4/tcg3274WdtTXesSUaOu0a
nf1wqg8KgjK3HI7R4DwJ8CXD7VudNLTdVAPgGuh2786jCZw/BD/+c86pPHiC
hptuMFBrf/3g0Y5x1MPCYPaLjsmIcSoyDeTAccOtv/YOqFGfFMZFM+Jz8Wrq
ZhzvKgNSnl9dohtDvXJo8JWXVmSNUTtDswzbYQiZDRuqWDWG+hXg90Nex28/
j9IlGkpQWtUU3tsxin6UsKNC5dHaPkLHwowCVeB45/5butgR9DcCAQeepfgs
qugzUxyjMMMlON2+oUK/YxCjjjol8lFRgzhDQzW4336eat2vRP/jEM5cPC04
paQmeZUTcPlYUb7/JiXmoYHcrn7n+48V2E8DQ3t1r3+RosB8tLDtZNbNFEcF
9tfCUHN9XuOTYcxLB56fMA7izGGcp4OWR4HVfp7DmN8k6GIP705SyHH+JOzz
urheUyjHPPWgScyTNYjltNRor0QPiVlQLrGVY75T8N/TbyW7umX0p3xjTUFj
RH6QLkeGeU9D6P7VH6giZTTbJHAaYv8OdNsklGH+L+B8Ytf+AqmUmtqdeQHF
gzd3hlZIkccMrH37VLd3upR+bYw7YwZKbWPLIoKkyGcG6rjXGq/bS+kJo7zk
WdCHCKoXVRzymoVcyfu3Tzdw9LN4Y83BNv/dCRuvcchvDnKPDB5tO8ZRk93o
efBr3NOYGswhz3lYmPvTx9mZQx4LIP7eIb7NkkMeCxAo3JojlrHI4yUc6RI/
b29hkcdLSLsk8hP+yiKPV2BrB6n+V1jk8Qp4BcXEJZ1FHosgu37SszOGRR6L
kCbd0eu+h8U8eURYNlPl7cuiHh7R9Ip9FG4s5ssjnSKL6S0OLOrjkbSPOz8X
rGAxbwsiEN1yPbzIoF4Lsq2wpsdHz2D+FiR0e63r+REG9VuQZIfjWuAY5MEn
WYVvro/qZ9APnwhT/ase9zDIh0/S/rjWd6GLQX98siLoXXnOEwZ58Unf3ehg
STuDfi3JN7WDBZGG6yV+lmTzHfUvvA4G/VuSPvsHoZ2G903yRi0JYxFSW2/o
v7SfAiKcj7NvMsw34Y0XkH1JqxVPJQzuq4CInflNowxDlz4nArKK339coGRw
f61I2WCAwk7DIH8rsnld30frZhncZysiTBBM2liydOlzZ3ju8XtE/0ozD2vi
+ql+7aV1Zh7WpE2dbm//npmHNSFX7fZ+6WXmYU3SHNeM3Nhl5mFDQlcX+F0I
Ne+PDbkrYpp9D7HIw4Y4dic5lyWb98mG9O066P7vdyzyWEY0yq+eFuWw9H/n
dktO
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUx0sp4BwuuoEgMmQIs7ioQ5jhIT2fSELDNgWZWDLmK8CcoLCN
yWBOWIaPRA0oA2Ug6nAR2ZABQ9mmfihTCCsGZAorIPfetrSFFtpSnj5YW05P
0jRf+91z/v//7+S+tTd9WzKfx+Mlmz+Wb1u9TFhU16oep01eR0dimypgt+Tu
mYSLtvN1GI4/23Asfpwu7KnMCF94EzLSTkXHvWb7/w687725ouWBkQYFWqoF
cu6PLujPNeL9VriXmzx5KcRIuRyX61FsOzgM6rilJgM+/xCOuWoSImoNVMxa
LnSBcWybaVWqAft1wy3OdYd0lYGusFz3egz6poCAIKUe+/fAe40NIUmVejop
TCy4N9EL5VG5a/bs1eM8Gcz+NyRd56OnUmv1g1+kf/21+2M4/ykU/33cp1o8
RrdZf2Cg3u3crv0do6iHhd6CqY7xuFEqsg7kwN3r8l9b+3WoTw6jomnJ8RQd
9beMFypAVF1aV2nUol4l3ApTXqnJ01JXc7MclyGImIl9WrNYi/pVEFxY0vHr
TyN0noYa1A4NFfUbRtCPGoJqNAGt0mGqjbUI1ID7tRtvGJOG0d8wiHY8yQyd
09An1jhGYJJL9blapkG/WtipSzgiCtVQszhzQx0svTqY5dinRv+jEMOcyhcc
UVOrvOtjkH/gYmn4SjXmoYfCrj6/G+0q7KeHf7caX/0iU4X5GGD1obwLmd4q
7G8AWcvtkuaHQ5iXEXw/YTwkuUM4zwjV9yPrNq4fwvzGQZu0Z3O6Sonzx0Ec
eGq5vkKJeZpAm1aiuCNR0isWe5UmSMyDapmLEvOdAOmjb2WbuhX0x1JLTUBT
XGmUsUiBeU/CB9uXvKOJV9ACq8BJSLwV6b/SU4H5T0F+Wtf2crmcWtsdnYLz
AxeCY2rkyGMaXN480h2SLaffWOLOmYZyl6SquCg58pmGKu6V5nNucvq5RV7G
DCiiBXVzGg55zUChbPXV/Dsc/TTFUrMgDN+cuqKYQ36z8MO+gf1tBzhqtZv4
DN5t3tKcJeaQ5zOYnv0z1M+PQx7P4aPvPVLa7Dnk8RwiPdcVSRQs8ngBu7sk
g9IHLPJ4ARmnRRs9f2GRx0tY4ApZ4WdY5PES1GWXyKpsFnnMAXPu0PrOvSzy
mINM+YaetVtYzJNHnKuma0PCWNTDI9oeSajKn8V8eaRTZDe5xoNFfTyS+XHn
ZwJnFvO2IzzRZeGeOQb12hFhRcPjUBOD+dsRcVCj8MQwg/rtSJrHQQNwDPLg
k8MVry9P6GPQD5+4Z4XXtj9mkA+ffP1Hce/JLgb98YlzlK+y6CGDvPhE+lui
WCZl0K89Odw4UB5vPs/zsyfCa7qfeR0M+rcnbW43YzrNz1vljdgTxi668ba5
//x+Cojzs2S3u+b5VrwpAhKTvkT1SMbgvprPfvy7IwxD518nArKY33dQoGZw
fx1I+UCEylXPIH8H4rus98NlMwzuswNxSRWMO9mzdP5150C8A36P61tk4+FI
vHea3E8vs/FwJG26bDe3t208HEnwWdetXwbaeDiSfd5Lh8s22Xg4EfGS8o0n
Y2z740TOi5iWsN0s8nAi7t3pflUZtn1yIp2bdq395zsWeSwgavVXjy4WsfR/
Bx5KzQ==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUx0tbHnPT6NbykilTmbBNHY8YQeB8ChkNcYqgWDLnK8CcILCN
ibAMWKbTRIwPoo6HRYebwIaKDO0e+oH4YK4YkAisgNx7+wYKbakIvlhbTr+k
aU773XP+///v5L6zKzsxjc/j8dJsH/u387xMmd1wTz9O5QsODm+Uy2CbtOVE
SpWzvgT65JONPySP01k91TlRs65DVmZJfNIc5/83QeIfI2u9a6FhofbTCvvv
jHr0F1nw/j24VZQ2cS7cQrkC0aU49j4IBo2cp9WMzz+Ag2JDytrLZiph7Rc6
wTyWaF2aYcZ+XSDnxFsUS810of36gkdgkgcHh2lM2L8Hwpoaw1OrTXQicOux
W096oTyuaNnOXSacp4TJ/7SKFYtMVOE4/eAXG3S19s4Yzn8MJ28fWlQnGaOJ
jh8YqPc6s31P+yjqYeGfY0/bx5NGabRjIAeiBef/2tBvRH0q0EZPSg+lG2mQ
fXygGlbVlTVUW0ZQrwZkqzUX6otHqNjWrECkhcipjY/r546gfh2EHD/d/ttP
w3SGhh60ro2yqyuH0Y8ewuoNwfcUQ3Rko12gATxrr71lSR1Cf0MQsqU7N2La
QLsdcQzDBJex6GKFAf2OQLwxpTA6wkBt4mwNjdD9y2CeW58e/Y9CAlNyQFio
pw55l8agcG9VWdRiPeZhgsOdfQHX7uuwnwmaN1he/zJXh/mYYc6+4rO5/jrs
b4a21hunmx9oMS8LeH/K+EqLtDjPAuV3YhsiQ7SY3zjoU3fGZOs0OH8cYkNL
5ptkGszTCvrM0+qbUg29YLdXbYVNxVCnFGkw3yfQ9vBb5ZouNS0vs58nIE8q
i7OUqjHvCZBsnve+IVlNjzkE2uq/Y4MW+6kx/6dQnNm5uVKloo52B231wNlV
CfUq5DEJc98u7ArPV9Fv7HEXTMKPotSapDgV8pmEC9xrzWe8VPQLu7ycKeiP
FzZMGzjkNQXHle9dPHCTo5+l288z8I+KyVh4ikN+z+DA7oE9bXs56rC79Tl8
0Ly+OU/CIc/nYH32Z0RAAIc8XsC6733T2wQc8ngBsX4rSqVqFnm8hB2d0kHF
XRZ52Oqj0ZF+v7LI4xUIxZAXdYJFHq+gueIcWZrPIo9p6D+zL6RjF4s8piFH
tbJn+XoW8+QRj5rJy+GrWdTDIx090ghdEIv58ogi2mVimS+L+nhk9ycdnwvf
YDFvF2KKOh+4c5pBvS7EX9b4KMLKYP4uJDasKfDwEIP6Xcgm3ywzcAzy4JNc
2ZvzU/oY9MMnoryoy/cfMciHT3b/car3SCeD/vhE/9ESTekDBnnxifzKVolS
waBfAdnfNFCZbKtn+AnIklrjz7x2Bv0LiNzrekKH7XmHvGEBue0S33TD1n9m
P4VE+DzNq8U234E3XUjWZc/TPVQyuK+2OoDfMswwdOZ1IiQe/L4soZ7B/XUl
JQNrdWITg/xdiYdP78c+UwzusysRZQjH3QUsnXnduRLv4N+T+mY7ebgR721W
76M+Th5u5Iox38vrXScPN/LhSfGGr0KdPNzIDn/PoYo1Th7uRDKvMvJIgnN/
3MnhaKZ19Q4WebgT767sgJoc5z65k7Y125f/+x2LPDxIr/7rh1WlLP0fwSRK
KQ==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQVGUUxy/L5ZHZCArykNASDIzIlBpey/lUJhkzAQmHihQYIFMS1IIF
TW3UhlLDBBITEBMMbUKcdCAH+Vbeg+jwEFmXVu+9uxtv4rE8BIJ29549Mzs7
3+53z/n//78z97W45B0JEoZhEvQfw7epZLvqF/sfUUKl66mB8MpCCLzwWfju
uqd4LgMm9VJBzrACFnVdTZEuqoCWlZGyNXNd+H81hKm/O3Vx+An4bDBULeQd
ta3Na+zE+43A7Jsv0WQ+BiHDrmwL3wzy0Nf9g3068PlH4HItr0f2oA1CeMOF
NhiZ9bR9N6wV+3WATdLZzrWZD2Gl4bprJ3DqPYl+4c3YvwtinAoa4+YbYNIj
OqtmQgGr6rqb/c7X4jwlKA4uqXdYIocWY/0NNoeWyqTDlTj/GRSpplzT827B
DuMPHMgvv1xzlxSjHh6Y3rLjsSEnIcg4UACSq1CV3Mihoj41MF6pRWkj16mn
YbyHBoo+iZyOV92mol4tkADX1c6KKmqvb5Zh9w+sW7asbNOhGirq7wGPD/jh
YycaqEijF6x/LDpsmd9MRT+9cO7g0Xtrqx7RwXCDwD6wOVHQX3qgjYr++iFG
maBNy+ygT4xxDEBT4Q/Tm37tpKLfQTiXsb6qtbqL6sXpGw6BT16o/ZDqKRX9
D4NXvPTanoVuapRX9i+wuvpQx9XPqJjHCGxjImL2unHYbwR2Lh+ylvryVMxn
FJK+d6wY3yZg/1HQeWtjj8WpqZjXGMgET2iXaXDeGDy+cqT4eZYW8xsHTXzs
5uQeLc4f13M/s2KkUIt56oBL+llTHaWlxQZ7V3Xw0XG4obTTYr4TUNf+jXJj
h4b+ctFQE1AecXHLWLYG856EkEjbN/t2amiWUeAkkKpgz9UuGsx/CmRJbZH5
ajU1tjs1BWGqAt+wP9TIYxqsXz3a4ZeupocNcWdMwxm7+NKILWrkMw05wkvy
Cw5qesAgL+UFKLaytxb6BOT1As4p1/52slqgnycaagZY6eZ9K3MF5DcDx/eo
9jZ9KVCj3ehZcJNvl6eFCMhzFnQzd/3d3QXkMQfBJ5wTm8wF5DEHbi5vZ0dp
TDz+g6i2qOctDTzy0J/PBgW6/M4jj3lg7SFN+hOPPOah/FIReSOdRx4LIL+Q
ur41jkceCxCvfq/LezuPeTKEKZ2+6RfAox6GNHVF+fd48piv/hxkNvmWM4/6
GBL/aesX7GIe8zYjg9IrHrELHOo1I46Ff3b66zjM34z4+tzxyOznUL8ZCXHe
PwoChzwk5KvCpSs+7ubQj4RUpkpvNndyyEdCov/KVZxu49CfhLS+76bNfsQh
LwkpLY8OUbZw6NecyO6o8nfqzyI/c7Lq+lAJ85BD/+ak0qEirFX/vFHegDmR
m229c0/fX9xPlrCzCQ739fONeBNZQpJte9qVHO4rS7zcJfcHOI6KrxOWWEu6
97O9HO6vBTmp2tRjP8IhfwvCOik+dHrB4T5bEJt97LiVOU/F150FsXvndkT3
KyYeloTZpXM862TiYUnKh9IdHNaYeFiSdeftQw9tMPGwJDGrlvdf2mjiYUV8
bfMDT4eZ9seKpARxtQExPPKwIkxHsntpimmfrEjlxt3eD77lkYc1UfR+3X45
m6f/A2iwMDI=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUxy+lPOZcBAbykKAb6ArbnFO3AFrOJ5pBCJMiwbBNJzBgTp1A
cFDQKZu41ClxExwwHoOJz22IGUZmkK+KAkEkBUSwWL33th0vYShVKlZY23t6
kqb52u+e8///fyf3jeT0TakihmFSzR/Lt632fX5zfug+NTT6HRqLbawCRcnW
2G037uG5DlyyyyuLJwZgXv/JDOm8y3B/cbx8makf/2+GfO0Ph8om7sLqVZZq
gT/3u7aUtvXh/TYQ75w9pVPcAT7PvS6C64DOmDdDN6zuxee7IOB06ZD8VjdE
cpYL3SAxBbp+IFNhP/O9XYV9QYrbsNhy3a8PnHXb00JiO7B/Pyi8K9uSZ1vh
mWTLsetPByDxxmBHyPEWnKcGRdaCm54LlNBprfuQuMdNLp1oxPkPoP7BtF9u
6UXYZP2BBWXNq9evkFrUwwEzVZefFFkAYdaBPCiLBzSnzhdTQZ8W8oOyq3Mm
z9FAy3iJDmSfxhtTNA1U0KsHlzV+/j4DTdTD3CzP/V8wur1eF551nQr6hyA/
ips4cLCVCjSGQVlYvdexooMKfoZBlbn/alBTF30UaxE4Ak3fV46ezeymgr9R
YNSp+hxFL71rjWMMFFU/GsN/76OC30cgyVvZpGrup2Zx5objML80xmNcc48K
/ifA+IX09Pa5QWqVV/cfmKZuxnj5P6BCHpPwDhOXuCOAxX6T4Lhw3FkazFEh
n8cgO+x1eSqax/6PgV2uTzqQrKVCXk9AzgdCj1yH855Ae82+2ofH9JjfFNxJ
SVqfPqTH+VMgXnV00WSVHvM0wP1dv+iaE/S01mLvpAGC8+G82l2P+T6F2p5v
1et6dfTXMks9hfq4sognRTrM+xksiXd9e2Szjh6zCjSfmzYE+vvqMP9pCN7V
HV+h1VJru0PT4KWpDJb9pUUeRrjhu783JFdL91rizjNChnvK2bgILfIxQgH/
irLEU0szLfIynoMqSnxxboRHXs+hQB10pqCZp1+mWWoGiteu37n4BI/8ZkC+
XbOj/WueWu1ueQFi5UZlTiSPPF+AauZK6NKlPPIwATnok9ZuzyMPEwT4vleU
oLPxeAmR3QkPO1s55PESogvD1vr+wSGPWWA8IEf6M4c8ZqG6vJq8lcshjzlo
KMleqUrmkMccRGo/7F++kcM8GWI4Y7wQsoZDPQxp6E8IHQrkMF+GNIXZPXvX
h0N9DFnxmeor8XwO87YjOmmNJGmORb12xFj5d1+ogcX87Ujw6ksSxSiL+u3I
Ep/dj4FnkYeI7KlyW/TJIIt+RKQ6W3qho49FPiIS/c+JgSPdLPoTkfaPAvRF
XSzyEpGj9Vsi1Z0s+rUn8kuais3ms8DPnvieGz/F3GbRvz0p9rwsU5mft8ob
syf1dlGXrpr7C/spJpMzqZ7XzPOteNPEZEW661CPmsV9FRNDgOjaGMtS4XUi
JoxocLd4mMX9dSD5mvAhj0kW+TsQg9fAx97PWdxnB2LaIZ5ysueo8LpzIC7v
N8QNvmbj4UiMWw1ehd42Ho7kp/FcT89lNh6OxOW4R0zWKhsPRyJbsnC0fJ2N
hxNxdq1Ye0Rm2x8nkhHGtqxJ5JCHE2F70peezbDtkxNpXLdt+a3vOOThTEqH
v+n5rYij/wMNvjgg
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lA1MU1cUx19LoYhA1IEU5gAjMtzcVsY2mSDnQoZ2Zk6smZONSf0AnSGj
zoDCXFaNHyxq7ObQ6cTpBIMmc42BwObwwhBhWqXAKrV9r7zHZ2ftLIpQEGFt
7+1NmpfT3p7z//9/J2/+pkJlnphhmDz3x/P0He2GluCle8xQH33Avqb+LMSF
nVDX23z1FZgFcRUnVlkgqPuCellQHUgunKsau2yhv18HU0vC234iFt5K8pxm
cJUckg6sZun9ViiLuPSp/iQLvaVhV1YIt2DP7dLNdhNL/38X9PvO1xS/wIFC
8FzoAHlqSEPlCo726wL5zcfLfi3iIMZzPdoI6rOJ7W0VHO3fDapPLhbIGzkY
Tcg59tdTEyhatoe+xHF0nhlcg9oPWkc40HsPC84JTehWqZXOdz8H7mQmhVtB
6f2Ch+S1s2o2RlupHgG29S28Fr/ACmnegb2wOzF0Sa27Jvr6QJv5rSot1gqL
POMT+kERrK0bllmp3gEIvNQwMhlihXB3s9KwQVDjFubItE//EAQWRA+3OTgg
NGzQZp8zgzX5/Ngg6/P91+1ufw/XeAT+C/UpuqZ5F33+HoDOtkX6fRkH97xx
2IEJm28s2Obz+xD4ndV39ZkcuMW5Gzqg0X5ZYojlqP//wFWUIDk+zoJX3pVH
IHO+Pyg3sDQPJ9hOf6lqrmRpPyckt67/Z9MuluYzDNrlz3PjFSztPwyBaKNj
QQRL83oMcgefru737ctjKKuICYnRWWh+T6Asu3gso9RC5z8BQ6X5N0eGheY5
Agnqd8bfCLJApcfehRFYP7a4LtJgpvk+hcaelRO//2CG06c85ynIy8/PjFlv
pnmPQtaR9l3rosxwzCvQXR+c/aL4GxPNfwxkbaEbxK33wNvuwBgkx9eZ5wUb
KQ8XaNrtyZs/7IKvPHGXusD56pnawaMdlI8LUFWuQl3eDjs88tTjoDs3h2+f
oae8xgFNpKYGl7TB1nzPmYDG6eUV7/XdoPwmwPna4a9PKprAazfnGTB79Ysy
ldcoz2fQWPBHvX9QDeUxCY3ZyhXKHZcoj0nQhF+2nioppzyeA3Nu9St5cRpM
eLjrkOz7Yz2/YMJjCpj8msKaPh0mPKYAyauO7c+tx4THNPBszGhKH8aExzSo
2YabH9U1Y5Ing7Kulv/ZqWnFRA+DVD/KDk2tuo1JvgzSxHTlNUe3Y6KPQdU3
jGEHSzowyVuEZDPPyjbldWGiV4Ri4yqu2pVGTPIXIe3c4qjIjG6qX4T4Jev+
5t+8jwkPMVL0pu1+d6GF+hEj1dKPo6MiOUz4iFHgy8sflYT2UH9iZNtwa3H1
Ph4TXmKk0eUozHqe+vVDW2q5M+vcNeHnh/TVjirmDk/9+yFVRF2W4S6PvfLs
fuiIaGVtQwePyX5KUP9EXkSTkcdevPkSlFA4e6jTzGOyrxJkixM32Xkek9eJ
BFWLLF9IbDwm++uPNFzGULiTx4S/P7LJTKsix3lM9tkfGbZLnkj9BExed/4o
OLFmrSVEoDwCkOGzEdnRSIHyCEBqR0lERLxAeQQg13fhq3cmCZRHAJLHzn3w
U7pAeUiRc9aZ1MNZAuUhRbFpfHOKSqA8pMjUWbiwWi1QHlKkTc99/fZegfII
RGW2os6fjwv4f1ctGuE=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lA1Q03UYx8d4mSHIDuEAExiRNop4iUoq8flJJ04kBSwjIxuigoYnFSEh
d+6OPIkzJSVeQgjk5ZBLgo4CLplTGK8TBmNj7I3hC2+DGu8vgvTfePa72+2e
/X97nu/3+3nu73HifOQpOo1GO0V9DN+mU3lcaPN+mgIa3C7rIhqKINAhJ7Fh
zFRXQxq8WpjzkRKsB0oTg6zrgVlaXL5YpcTnfNAK2e+Ym6ng7QDDaQbv1CuM
Z4dVeL8NGpzufC7KVcHjVIfq/cOdoO9KjdXJVfj/bghML6lL3qoGzrDhQi+Q
3bZNZfvV2E8Cga0zQXe/U4O74bqbFHhF/j3thWrsPwApxyoS/ARqWGBHX384
L4cM4dktrmo1zlNA4GhWWNucGkTGowL2c96WOIYG52uANvJoX4CjBiKNP2gh
/AizLsZNg3qGoeHJjn92empgj3HgYxD7b9n1F1Vv6HsCzJAfuXtYGvAyjGc/
hXibrPppZw3qfQa8O01zq7YacKSapTqMQN59Ie3qukn/KDgnuE23T6lhg8YY
aHX2L6nkJj9jUHzmB76O8jcZYRA4Du0f1DzYXmHyNwFk/CTjRoYaZMY4dMBx
8JAmxJv8TgInqbJbtE8NlDiq4RTVv8pCzFKj/3+Blcy2uLmsAqO86v+ApT8w
4idWYR56oBV8w20uU2E/PeS1RfWfuKDCfKahJmTty50cFfafBiaJmfJ0UmFe
MxA+pd2b+NS0LzPgXORu616jxPxmoeGz5MXgVCXOnwV5meKPqWAl5jkHfonv
LvtaK6HMYK90DgSL3vUuYgXmOw/iodCVxmwF/JpvOPPA/aVks3uUAvNeAMHV
ngtHtyngulEgVb+Z4nJOOYj5L0KUi6/n+YJBMLa7vAj6N5Ts+GODyGMJUtxz
2LHOg3DREHfqEnDXbG+elcqRzxIwpeeOZPwsh68N8hKXITBIIhOGyZHXMjDf
OrrVmyGHuNOGswKVssprzYIB5LcC4vSPT2Z/PwBGu9HPIS8t/2CF/wDypOq4
hVu0cRnyWIX4i9GfVv0mQx6rEB7guKPqExnyWIMl5nGu1WYZ8liDqCa+k/C+
FHm8AG2Tq/3kt1Lk8QLE+bl9vNekyGMdOD7bb2Uo+pHHOgTWSpM2/dSPedII
rT7ayxL6UQ+N6MPuHU7XSzBfGhH4Hgi9UiJBfTTC6jgU6hgpwbzNiKAgO9Kf
LkG9ZkSfyX9vqLYP8zcjfnszf38lpg/1m5HwUZ3vul0f8qCTcFcbzxR+L/qh
kyy214OshF7kQycsuy88w7b1oj86KY4IDb7bJkZe1HN+zeLfSWL0a07CJ3Tr
X3mIkZ85Yb3euFBY0IP+zQk3M22oZbYbjPJ05kRQ0X8j4mA37qcF4Y7ZN3Ju
PwIj3tMWhFV7RlS9JMJ9tSDaP+1ezjgkgo3XCVW7hXTIS7twfy0JL/tDSdlS
J/K3JAIvSzt9WCfusyXhchg+/OIO2HjdUXX5KN9+rh15WJHiymmf6ZB25GFF
tLk5XdH5bcjDirCy+pqjdK3Iw4rwki95je1uRR4Mwh3KmbG9JkQeDMKbiF0R
aVqQB4Nox8rpbN8W5EHVdWV1Hpeakccmwk3bdfte90P4H6csCtc=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAlQk1cUhX/CEqsiFmGMViGUaoNDJS6tXdTzpCMi4oatpZbauKPFMW0t
UmRqZqxjrFZTF6wLFGQpMpViqwWnGqPIphEDIRCyGa1LMGABkU2QJuHmzmQy
L//Lveec784fsnZb3AYex3EbHB/nt7tUq8tHvp9mQGnQHvvy0kzEBqRLS23u
cxHS8EZG+mIjhjfmSOcML8GEnKy87kIjPVdCUCF629PDhJkznFUGlrqX/3Cp
ie5Xon/s2c/Ux024nxpQtODeTXTeSl1n15vo/zWQ7M6+kDzGjOh7zgu1kM32
vZK7wEz9tIiu6Jhz7lszgp3Xg3TIypx2pyrDTP0boViVnyRWmdElSjh0/bke
xeVbRk00m2meAdLHitjKTjPUrjLh3ReyUZv4FppvgeDR7fkzAi2Ic/1ghWTF
6Atrgiyk5x64B5P+mRxqwVzXwPsQTB8166LjPKTvX0RH7ZPMFVoQ5hwvegD5
SEVJu8BCeh+i+OyVzn5fCwIdzVIDHqHgajl3YNCt/zHESUHtVa1mDNGwQdri
/4pJ7/Zjg37zD0q7w1/LcqfAZtg+KL42Id/t7wkSm9fzD8vNaHDFYYcqIESX
lOj224Jl2wtq1PPNcIhzNGxFj73QSyM0k/+niE8WeR3pNcElr+g/yNsWPhJr
TJRHG4SnvpaU5ZqoXxsKKuPr1+4wUT7t0EQNfDE52kT928HYmtbQsSbKqwPc
U+s86QP3vnRAkxnsG1xspPyewfZpcndkqpHmP0NinuGP1kgj5dkJufSd3ojh
RuQ67eV0wtYdXjJOY6B8nyPFGtN36agBJ0846zkUx7JHBMcbKO8u6A/c2bFy
vAGHXAK7oHorZdxWYxPl3w3puIjQbaea4Gq3pxss3ChKXNVEPHogC04XrRM0
Yacz7tQeSAZ8j2zR6YlPD8S6rSvkP+vxlVOetBfSOdqG8lg98epF1fSVY8L5
emza6Kw+CBsLDpapGolfH2y7P1p/9LtGuOwmvIA+7cSi/GmNxPMFVJu6TnPN
DcSjH7KdCZ8U/tpAPPohmhk4qfDjBuIxANGrqyU+IxqIxwBSrijHll/VEY+X
ECon+rd8oyMeL8GdPF4ne1NHPAZROnXCabmhnngMQvCnbvuwn+opT44JShLC
vFFPejjGFl9eurtNS/lybJl4YczebC3p45iieklMYJyW8vZg4tNH46bxtKTX
g43er3zv7vk6yt+DKeb9+Pvra+pIv+O+zR4x6FdHPHjMOnFkaIqylvzwWLEo
7JoiqZb48FiW3+ehseNryR+PieNiIs9VaogXj0mUxd1/b9eQX08mfWIf/DJE
Q/w8mWrKpa6MU3fIvyfj9qfdvfGsBi55dk8m/K3+8PJFNbSfXkxm878UfeY2
XHg3ejHV+c3qoh417asXE/7l95p8iRpDrxMvxgmjqvU5t2h/vZnw2Ifa3J6b
xN+bSaZ4+7XF3qR9dpxj+FOVWdUYet15M1neY6V/ZxXx8GHc2fap7VFVxMOH
qX5Jv5VwopJ4+DCZoq4s3l5BPHyYNXlXmG12BfHgM5k1vcP3YDnx4DOJfV2f
2nKDePCZtTmPJ4q4QTwczy/mXgjZVUY8hjHJ97POXK65jv8BmhoJIA==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cYhkuhlKGEeiFe0SIzKxMBA1M06PtPMyeIFxjbjIKr901xYHSZ
ohvIJKvzhshUtCoKM3jDTjvBxHVMUBQ6hJaWIk4rKpwDTAsoVLSytnz9kpOT
/5z/fN/7vs+fE7AyJX6NUCAQrLFfjrurmndKvTKlHErHZbXHlZ7ERVtX1ugA
17oY6m39WfwEDt4NBakzvUugClye2jvR9V6DRO+p9bEfcogId1Q51PreNV2h
rv2ViKpcZLNM5dCcNrz408dVUHlU58TB9X0Nai2TZvpHc5j32LGhDsr314ck
Jbj66eG1e6lq9AoO4x3bxxmgUL+VfpXi6t8ASfCG5+HpHHpkiQduvjJBeS85
50y2a9595G4+u09dwEHrrAcozExeubnUNf8hRmZ+dICr4RDvfGBGVMJlhX+r
S89jRM5PuzrGjccs58BmZC/Zn9Qxlid9TyC3Lio5OoNHkGO87ClUzcu0QUt5
0vsMwd1DdhRt5+Fnb5Y2vAUXQ/lN/qd40t+KjE+O+h+s4DFAw+57xvgLgzp4
8sNBKS/ry/VrQ0ecQyCPJU29RyM+biN/bdjrlXmt89s2GJ1xtGPX9Crh6kNt
5LcDsuSR4QkmHnZx9ob/QTnthdpnDE/+n0N1Sjf5xDIOTnnFLzC84Lthvsda
KQ8Lih6+OJdibKF+FgTfCxNWS1oon07sTbhkDY5+Rv07UWibE3E6/Snl1YWw
ioSJ4eonNK8LhbVeouctzZRfN6IGV9Y/GNFM87uhnaVL8rbnPpDnS4Rd9pmy
c4sZhQ57BS+RurpqwRH2iPJ9hciSC5rW3H9xLM9Rr6CwyXaJW5oo7x7Mqzlp
ey/iPg44BfagdvLWURubGin/XphGhQamHG+Es11WL1KDm2RfL20kHlaoxh+W
rRrZiO2OuNOsKLX5HFpvMBEfKyINGz9THDRhk0Ne6mukztQbb8WaiNdrSMK/
GBYsNmHdWkf1IbKhaH95WQPx64N0V8Lq3G0NcNpNfAP5D3nzz05pIJ5vYF3X
oxTwRuLxFtnbE788f8pIPN4iLMJv4vnPjcTDhsVDlss9BxmJhw0Zf2pG3PrL
QDzeIVLjP7Rjs4F4vIPk2BFdxgcG4tGPspCxSsX9euLRj8VXDFu89tVTngKm
KEkMEqGe9AhY2YIbi36y6ClfAVOFRcf8fFpP+uzruwtj/OL1lLcbW6zMjZ8i
1JNeNybfo5n+6Hcd5e/GJLN/uThhhY70u7EMrj2031dHPITM7D84cKumjvwI
mTQo6O/s5DriI2QSSVJg7Og68idk8viY2Zcqa4mXkGVrVL3XttSSX3dmaWvv
3xBQS/zcmXzS9Z4Tx++Rf3dWtmfHo4ruGjjltbuz/KL6nLj5NXQ+PZiAH3p9
3pl/4MS71oPJr3yjLbZq6bx6MOlV3zGKhVoM/E48mFk6966poJrOr4jJf52j
L7RWEX8Rk04S+Vpiq+g8i5g5Rhyiyb+Lgd+diGWcbdUMfXmHeHgy87nOkM65
d4iHJ5PmHa5OzKskHp4s/6CufEn7beLhydj36UFc1G3iIWb55sNdPvtvEQ8x
k3es6tM+rCAeYmbmfxPKQiuIh5iV/VGoDkgvJx5ezPzjtDM3am7if9B4CZw=

     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUxwu0FFAjBEgIDAWHsQWmZDLSMfV8Kps6WRBDBgMUcAPxMUFh
EXko1jFrVEDCNiAEDCDppgMWUbvNbChsZrwfAyqaTTod99HeXnm1KI+15dyT
3Nzc3q/n/M//d+7xP5SxP9VeJBKlWi7rXYjJ835OSj8KNGuK2GhNDbQsTBZ5
+wvPTdB2ZqmIXkeBy2h95laXe9D25sFM03rh/a+Q6BL2V2QgBaGbrdEO3UOm
1MlNwvlHEPEoaoEPo0CX69G0a7wTOsRdZdEg/L8X+vmgrb57KNg9bj0wAOqA
oxsPxAj5hiD4UnyLdwoFa63H1wyDqnXeLylDyD8KsuBj3OZzFMzKEksezmhB
03e8rK5UqDcG6qzGq631FHTb4imolccPZWmE+n+Dl/KdEqqXgv22H54BiWlW
+U4IesYhYm/ubR87GrbZCuqgIa74gP4NGvX9CznmqHsV4TTIreVlz+G+LqFb
Hk+j3hegmHLLV+fR4GlJluvxH7Ruok/61tKofwJK36/wvdZBwzINCraEr725
Qk9jPxRcT257Ve7JgD7aKpCG/CemitDtDPbHQIWT8u7LEwyM2OxgQeau9Buq
YbBfPZRXjyn+6WfAIs6S0AD7hjs5HwmL/XNQelV3r/g9FmzymozQUZl0aUs2
i37woMl3HJQ3s5iPB+rMxex4PYv+vITktYUPB4L0mP8lTLMbcso+16NfkxAi
vqOp+VGP9SZBy15YYTbp0b8p6HBeEV9LDFh/ChSx17nyywb0cxpaV3tma7UG
aLC2Vz8NkXWy2XQZh/7OgCprQBeRy0FVpTVmoDArduXRXg79noX+qXdvDQcY
ocQmcBZkY6NpXxYY0X8TuDr3RZ3SGsGWrsgE6nnl6R5vHnmY4XmCrD7/Qx7y
rHbnmkH2bT+7M49HPmao/mz04p9XeDhplZc5B+Y5b/ewbB55zcH1koM1dQk8
HE6zxiuYDqiTr97JI79XcOXnF615gTzY2k18DeJ9ckK58cjzNXh1Pf7mu0kj
8pgHfib5B+UDI/KYh3R/qj2h1Ig8FiAkMmMsNMmIPBZAcXqWX7XRiDwWwauu
QDoxzyGPRQjpEa9p6+KQxxKYTZdDK6s45LEE1Dr3vaeOCH6KSP9HVSl7FRzq
EZG4M/45AVIO/RURRYO6eGHYgPos7/s23RhpMKDfdsQ8d/eX5iwD6rUjruu3
Dap2GNB/O6KN+p1KcTOgfjuSmRe5FP5MjzzsiaJxyNOjWZgve1I4EB9sKNAj
H3sSNz++449IYd7sidOGI5/U+uiRl+V5P5+Rw7DYrwNpKTj9VfRPLPJzIMnq
xepAlfA9OBB+sOi2QywLNnmsA/FbXNn5dD2L8ykmmfLyZ3emGbDhTRMTrxgf
U3E7g/MqJuRc3ar0MgaW14mYpH8vD9iewuD8SojrcEu4dwiD/CVEIVJETy3S
OM8SUhj02+HuHhqW152EqD7+4OyNamGfOBLV+Z7ys8do5OFInG7F3Iy17KNl
Ho7EPPLkQYgzjTwcSbL9p1pnrbA/pUTzFsPpGoV9JyW7405K7n9BIQ8pKbxg
9vk6gkIeUpLedO7tE+4U8nAipY8d9+zSTcD/vgMZsA==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lHtMU3cUx0spTzWGAP+AKEyIrTAxkxHGpufnYxMHGY+QwUAFnA98TFBY
qDwUq8waJyBhGxoCBpB0kwGLKN0jm69NxhsRqWg26Oa4r95enq1YYG059yQ3
N+3v13O+5/s5PQH7shIOSCUSyQHrY3uLYTnr76ryp0C7uoSN19aAdn6yxCdA
/NwMulOLJfQbFLgP12dvdm+HJ2v3ZpuCxPNfQeke/iRmPQVhm2zxAJ4Mmg5M
hor3H0Hco9h5IZwCfb5X886xTuiXdVXEg/j7XugXgjf77aIgasx2YQA0gUc2
7EkU8w0CuZjS6pNBwRrb9dVDUNlm8U/LEvMPQ0jIUX7TGQpm5bvL7s/oQNd3
rKKuXKw3Am05jZfb6inotscL0KiO7cvRivX/An/V22VULwUJ9i9GISaxRe03
LuoZg5jo/Fu+DjRssRfUgya5dA+3ikZ9/4DSHNteFUmDwlZe/i881Kd2K1Jo
1PsSyJRHoaaABm9rsnyv/6AjlD7hV0uj/nGofr/K78pDGpZoUBAXuebmMo7G
fii4nn53rtKbAS7eJpAG9XNTVdhWBvtj4Lqr6s7EcQae2u1gIcpT5T9Yw2C/
HDRUj0T83c+AVZw1oQGODXXyvk4s9s9D+WV9e+m7LNjlNRuh42raxfdyWfRD
gO5C58eKFhbzCSDJv5CbwrHozwTsX1N8fyCYw/wTIOHWKSs+49CvSYiQ3dbW
/MBhvUmg2HPLzCYO/ZuCF27LUmqJAetPAUm6zldeMqCf09C/0jtXpzNAg629
+mlIrJPPZsp59HcGWnMG9Dvyebh21RYzcD4nafmRXh79ngVq6p2moUAjlNkF
zkLUyPDB80VG9N8EiW59sSd1RrCnKzGB1qLK6/ERkIcZzKny+sIPBSiw2Z1v
Bvk3/ez2AgH5mKFp//CFP78U4IRNXvYrCJnz8QzPFZDXK9CU7a2pSxXg0EFb
zMGqoDrFyu0C8puDqp9ethWsF8De7u7XIItTEMpDQJ6vIarr2dffThqRhwUi
ZtO/V90zIg8LZAZQD1LLjchjHkhM1khYmhF5zEN23qywYoMReSzAxroil3EL
jzwWILNHtvpuF488FoGYL4VdvcYjj0WQr/WMPnlY9FNCyEfXMqIjeNQjIepT
AcpAFx79lZCoBk3p/JAB9UlIZl/ojacNBvTbgZC5Oz+35BhQrwOJCtryWL3N
gP5bz+N+pzI8DKjfgSgLYhYjRznkISWkcdDbq0WcLylpHUgJMRRxyEdKsi1j
2/6IEedNStLXHf6k1pdDXlLSkSBkKRkW+3Uk/UV5X8T/yCI/R6LWLFSvV4v/
B0cSMVhyyzGJBbs81pGkLyzvfBHE4nzKiE5ROXp7mgE73oMyokz0NZU+YHBe
ZaT4TN2KzAoGltaJ9fw7ReDWDAbn14kkD7VG+mxkkL8TIZKI+KkFGufZiaiD
fzvU3UPD0rpzIuUff3D6RrW4T5yJ5mxP5emjNPJwJslNiTeTrPtoiYczKR5+
fm+jG408nIlS+qnOTSfuTxfS8SbD6xvFfedC0pNPOP3yOYU8XIj2nNn3qx0U
8nAh6uYzbx33pJCHK6l65rxrp34c/gdIaBnC
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lHtMU3cUx0spb40jwD8wXhMiDydkMuPY9Px8bOogEwgZDFTAKeJjAsIC
8hBWx6xRgRG2FUKQAJpuTmARpdvIVnWbTt4iUpFs0s1xX729PFuxwNpy7kma
5tf76znf8/2cewIPZicclkokksOWj/VbDPNnAc7yAArUfhVsvLoRuhenK7wD
xXMbjJ9erqBfo8B1tCVni2sXPFp7IMcYLD7/BapdNz2KDaMgaqM17oJ22Hh4
OkK8fw/i7u1dFDZRoCvybNs18QC0sp6aeBD/3w/jQvgW3z0U7J6wXhiC7qBj
G/YnivmGYef5lA7vDAr8rdf9RkDVaQ5Iyxbzj0Lk+uP8xjIK5kP2Vd2Z08L4
wIma5mqx3hio865e6myhoNcW46CWnziYpxbr/wWR8jerqH4KEmw/PIO4xHaF
76SoZwIOxRTd8LGjYautoA66kyv3c6/SqO8fKDHt7VJG0xBqLR/yLwzqUntD
U2jU+xzIjHuJqpgGL0uyIs//4H4Enet7mUb9k9D0rtL3y99oWKFBQVy0/zU3
jsZ+KGhN1yzUejHAxVsF0nDxqVEZtY3B/hhodZbfmjrJwGObHSzEesgDhhsZ
7JeDjoaxzX8PMmARZ0moh/KRB7yPA4v986C8pOuqfJsFm7w2AzyqSzv/Tj6L
fgigLXF8GNrOYj4BJEXn8lM4Fv2Zgiz/8jtD4RzmnwIZt66w5hMO/ZoGIrup
bvyBw3rTILBn3UxGDv2bAc7FLeUy0WP9GSBJTXztBT36OQvaNV75Wq0eWq3t
tcxCcnPIfFYIj/7OQWfekG5nEQ/1ddaYA0Ve0qpj/Tz6PQ/CzFvfjwQZoMom
cB52j41mfl5qQP+NkOgysPeU1gC2dBVG0JjlBX3eAvIwgTk1pKXkfQGKrXYX
mSDqm0F2R7GAfEygPjR67s+LAuRa5eW8gMQFb49N+QLyegGaqgONzakCHMm0
xgKQ4ObQNTsE5LcAmp+edxaHCWBrd99LeCUulFDuAvJ8CeU9T77+dtqAPMyg
nE+/Lr9tQB5mUAVSd1OrDchjEdJjs8ei0gzIYxEGC+aF1RsMyGMJyptLnSbN
PPJYAlWfzE/TwyOPZSg0XYiqq+eRxzKkr/WIOXVU9FNClB/UZ8Rs5lGPhChO
BxYGOfHor4RIrqgqF0f0qE9C1AMRVx636tFvO5K1cOvn9jw96rUj1cFbHyq2
69F/O5Ic9zuV4a5H/XZEXRy7HP2MQx5Sorg67OXZLs6XlHQMpazXl3LIR0pU
5ontf8SK8yYl6nVHP7rswyEvKdEmCNmFDIv92hPnMwVfxP/IIj97olEtNYQp
xPfBniQPV9ywT2LBJo+1J01Lqx6MB7M4nzLiHFb77OYsAza8mTKiSPQxVt5l
cF5lRFPWvDqrhoGVdWI5fxcatC2Dwfl1IMkjHdHekQzydyAmyeb4mSUa59mB
dIT/eqS3j4aVdedAqj9878yVBnGfOBJneV/tmeM08rCcrydeS7LsoxUejmRw
9OntSBcaeTiSQunHWhetuD+dyP3XGV53Vdx3TqQwOdeh+1MKeVienzX5fLWT
Qh5ORNtW9sZJDwp5OBPqieOeXbpJ+B8qGSDz
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUx8ujUMDonO1UlJeDWJQpC2jElZ1vG2zoVFJWB0HUSUBRmRbF
iQUnqzBxjqcs1s2BA2K6jCE+Bp2ZjmgzCDIoItgxskF1ektL6fsBrawtpye5
ubn3++45////9+VGZB9Ny/Wm0Wi5zst195T9i3CGMJwCSWi5iitpAKlDXx4c
4Xlug2en5sqVqygIfNLMTwzsBPnre/iWKM/6PagP3Ph42xoK4uNc9QDUQ5Zc
/XrP/m7I6U51aDdSoBAw2z6Y6IVx34d1XPB83w9j2rWJIVsoSJlwbRiE3yIP
rdvN8/QbgqTzme3B+ygIc20PHYb22/bwvUc9/Z8AJ+awJu4MBWZ2VvV9kxzU
A/l1TTWeeaMgOX6t8nYzBX3uGgOJMD/7uMQz/x/gCDdUU/0UpLlfjAOPd70i
5IVHzwTkfCi4tcJLCW+7ByqgK6Nqt3qlEvU9hTJraqdosxKiXePZz0Cm2NUX
nalEvf9BimFxibhYCSxnMwHzOfStVxaENCpR/wuQJotCaqVKmKdBAX9z2E9B
aiX6oaD9k66ZetYkqLkugUoQ/W0Rxb8zif4mQcIQduiOTMKIOw4V5C0Rhg81
TKJfNbRfGd30r2wSnOKcDaegZrhXs4KuQv8auFqp6Kx6SwVueW3TIL+89zyn
UIV5aGGsxO9R9HUV9tMCTXCuMFOtwnx0UBRWen9wrRr764CpXl1U96ka89ID
8f1F0nBDjfP0oFWdDbJa1JifAewBQZmNZArnGyAp/aqm/sIU5mkE4yJWoVw+
BS0ue81GyGlim/PYGszX5OQ7qEgSaODby64yQc3x9AWH+jWYtxmMhoTW4chp
qHYLNMO20Sf7y05PY/4W4AUMpB6TT4O7XbkFZHbhyT+DtcjDCvZd7OaSrVoo
dsUtsMKmSzLVe8Va5GOF1rvyneE/a6HAJY9vA86bF1oXjmuRlw3EkqHyIKYO
Dux31QxkRLPeX7JFh/xmoOzzpZGrzujAbTdrFroO0t+I79Ahz1kQ/8FPSdbo
kIcd8np3crir9cjDDryPWTc+2qdHHg7I4e/dkHJFjzwcMF7p/+4auR55vATO
4ruJJqYBebwENrO5tCXNgDzmoJX7ID2u1oA85kDakcH4XmbAPGmkRa55NPaK
EfXQCCOWZ57iGjFfGrE37b758KIR9dFIF1+wtWDEiHl7kZaIZYzR5SbU60Vi
a0c4XntMmL8Xaf/u6yRFkwn1O9d3hJ4rokzIw5u0DkQJfl9nRj/epKKY33Tz
hBn5eJPYMe432++a0Z9zPbvfdoFuQV7O70cazx/cYUG/PkQqYr2quGRBfj6k
Z/BRoW7Cgv59iLwnX3wxxgpueSofwjmtkkhPWvF8+pKUX9f1lD6wghvvfl/C
uJWwULrIhufVl4i2H/jrqywbzP9OfEnGbEXV4I82PL90ImbrxfUWG/Knky76
sTuy5Bk8z3SSdSTxsLB+BuZ/d3QyVtN76trTGeThRx4/b7yTEDeLPPwIW7N0
WcLZWeThR+RzwXU/DM0iDz/C+1KWyI+0Iw9/kn8vJbnphB15+BMRM/xFfLcd
efiTmNCQz6KWO5CHP1nA6s0oOOxAHgyyUhwY8No9B/wPkF8bIg==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lA1MU2cUhgu0/C4OZzsRB4KDCOqQBTTiYOfbBhs6lJXhIAiKBvCPaRGc
WHCSKlPnAEEW6+aAUWJYxhCVYWfEESXDIONf7BjZpDq9bS/l9r+FVkbL6Ulu
bu693z3nfd/nyxe853BKriuLxcqdv+x3Z7FFQZ6iIAqkgeUqvrQOum3acv9g
53MrUMfnyhUrKfB+LBHEed+CiTd3Ckyhzu93ocF7w2jSagqio+x1H5gRU652
nXN9D+T0JNuYDRTIhdzWjyZ7gWE/rOGD8/9+eMasiQvYTEHipH3BEHSFHIjI
SnX2G4HMcxlt/rspWGFfHvgI2tutQbsOO/s/hvi1B9VRJykwhmVW3TPIgB7I
r2m84Jw3Dl2FVyvaJRT0OWoCukT5ewqlzvn/ABGtr6L6KUhxvHgCmanXzga8
cOqZhPyPhTeXuyjgXcdAOXSnV2bRbyhQ31OoNSffEm9SQLh9fNgzoOQ7+sIz
FKj3P0jSLS5tLlEAb76ZkPsc+tYpCgLqFaj/BTxIEAdUdytggQYFpzet+NmH
VqCfeZ3ZXTO1PCXQfLtABTT8bRJHv6dEf0qQeoo6NIeUMOaIQwWCJaKgkTol
+qVBemV847+DSpgXN99wCsSPetXLOSr0r4aGCvmtyndU4JDXOg0Tl3ediy1S
YR4MMKXuw+HXVNiPAbbwTFEGrcJ8NFC6ouze0Boa+2uAS68qrvmcxry08An7
V2nddRrnaUGvOuVjNtGYnw6sXj4Z9WQK5+sgKa1BXXt+CvPUA8uXVySTTUGT
3Z5EDzmNYcZ9YWrM1wB3Cofk8UI1fHfZXgYQF6a9cqBfjXkbwaqLaXkUMg1V
DoFGSBp/nHf6xDTmb4J0r4HkI7JpcLQrN8GoVXTsT38GeZjBuiNMUrqFgRJ7
3EIzkEuDqg9KGORjhpZO2fagXxgosMsTWCD+7fMti54wyMsCbdKRch+uBvbm
2WsGssN5Hy7ZrEF+M3D6y6UhK09qwGE3cxZk+zlvRXdokOcsDP4hSExQa5CH
FfJ7t8fyV2mRhxXSP+Nd/3S3FnnYoFiwa33iFS3ysAFT4fH+apkWebwEsrgz
zsDVIY+XEMmVlDWl6JDHHLTx76dFVeuQxxz0daR7/jCowzxZpEmmHp7w1aMe
FvGLTDVO8fWYL4uwJVk3Hl7Uoz4WGRUItxSM6TFvF9IU7Oc5vsyAel1IYvVY
rMtOA+bvQtq//yZe3mhA/S5k47bAM8WUAXm4kvaBUOHvEUb040pqSwSNN44a
kY8rSZzgf7u104j+XIl4T7/lPMeEvFzJnbH6c/u3mdCvG+kW816TXzIhPzfC
Gh4u0kya0L8boR/kN19cawaHPJUbiT+hknYfM+P+ZJOk3yIelN03gwNvHpv4
3oxZ1P2qBfcrmzRs3fvX15kWWDhO2CR79mzl0E8W3L8c0hKmba41WZA/h/Rx
jtweTJjB/cwhOYfiDopqZ2DhuOMQ+kLv8atPZ5CHO6Gf19+OiZpFHu4kUr3U
L+bULPJwJ7I5/5ofR2aRhzvZ99VgnCDEijw8SNndxITGo1bk4UGauEEvonus
yMODpAYGfBG6zIY8PIgvrze94KANeXiSyGZvr9fv2uB/ay4a6g==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cYhgu0gGAcajsRB6LDCOrUBTTiZO+/Tbbq5qUOp2FV0URFZVoE
JxacpsrEOW/IYt2cbGBMlzFFZdqZ6YySSZAhl4kdIxtUp6f0UHq/QCuj9euX
nJycc/7zfe/7Pn/+SRt2rNgYKhAINg5f/nuwxqgSI1WJHLQJpUaZ9hwafNbS
uEnB54vg9wyVGiZziHpUrciIug7zq2sVrinB77egiZr75wfTOKSl+usuzO2u
jdZZwfX3kHtvmc88l4NeKb74Xk8j7ML75TIE/2/GE/P0jPhFHKQ9/gWtaEja
OnNNVrBfO3IOZ9fGrecw0b884SHq6ryJ63YE+z+CdMY2U+o+Ds5k+fE7Dh3M
D/LKq04E53WivuDC0bpqDk2B6kK9Km9DgTY4/x9IVXOOc80cVgRedCMn61JZ
/LOgnh6Uva+8OiHEgDcDA/VoWn1sDf+KgfQ9xln3suvq+Qak+McnPwGn/7gp
JdtAev9Dlm10iabYAMlwM6X4KVpmGfLjKw2k/xkaMtXxJ+sNeEGDg3r+xB+j
eQP54dCVc3ugQtILXuYXaIDmb5c67a1e8teL25Gqa5btvegIxGGEYqwqsf1c
L/nl8evZznn/tvRiWNxwwz6oHzaaJoiM5N+EmqP668feMCIg72I/uDPrDi8o
NFIeZrhLwttSLhmpnxkxykOF2byR8rGgZOL+O63TeepvQSw/taj8E57ysmK5
8Gftucs8zbNCwB+Idrt4ys8GQVR0diXro/k2yFd9Z6o40kd52iGIkRTqdH04
77dXbUdeVbIzN9lE+TrQVNCqX6g04esz/nJAU7Bq5NZmE+XthNieXvMwqR/H
AwKdWN75aNPBvf2Uvwu5Ix4s26nrR6BdqQvdXtXuP+LMxMMNgTy5umSxGcX+
uJVusNMtxneKzcTHjdqbupWJP5mR75en8GDh60dqRnWbiZcHtdr20mixBZs3
+WsAOSmSd8cushC/AZR9Ni5p8j4LAnblg9BtEb2Wds1CPAfR/btCmmmyEA8v
ihpXLpBNtRIPL+QfSS5/uN5KPHwoUqybIz1rJR4+uI9GvD1NZyUez8FG38xw
iG3E4znmiav3n19hIx5D0Mrurko9aSMeQ9BdWx35bYuN8hQwjc7U1hVjJz0C
Fjs7y9kns1O+Ajayes2V+6fspE/AuhTKxfkddso7hNVMio3sHO8gvSFMerJj
QchaB+Ufwpq++XKhvspB+kPY8qUJh4o4B/EIZXUPpih/m+kkP6FMXayourLL
SXxCmbRL9tWSm07yF8q0G5o9R0Qu4hXK6jsqD29Z6iK/YaxBLRmjP+0ifmFM
2NZWaOlxkf8w5m7I05ya4UZAnjGMZe01aut3u2l/Cpnil5kN+++6EcC7Schi
rqaPqn/JQ/tVyGqWbP7rC7kHL44TISsaLDvW+oOH9q+I1SZbNRUuD/EXMZ1o
542WzAHazyKm2J6xTVUxgBfHnYjxJxr3XHg8QDzCmfdp5Y301EHiEc7STONi
0w8MEo9wphuKK/++fZB4hLPcz1syFEle4hHBDt6SZlbt8hKPCFYrTnyWds9L
PCKYPCH+0ynjfcQjgokljavzt/mIRySbrYka8fItH/4HqX8aBA==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cYhgu0UME4nXQiClaHEdSpC2iGg73/NtnQeVkdTsLwGtSpTIvU
qUUnqaIy78gibkw2MIZlzmunnZnOqJkOGRZQ7BjZSnV6Sg+l9wu0Mlq/fsnJ
yTnnP9/3vu/z5x+7cuPCVeECgWDVwBW4hypeJRWrpBw0iWUmmeYktH5bWfzY
0PNZWLb1lxnHcYh+VCfPjL4Cx6tL5e7xoe/XoY6e8WDuRA5pqYG6BUere5Vt
amj9HRTeWeC3zOBgUMaefb+zAULRvQoZQv83gbNMykyYzSG7M7CgGY1J66Ys
yQn1a0VBed75+BUcxgSWJz7EA7VPumxjqP8j5E5eb07dycGVnH/4plMH3/3C
itojoXnt0BafPqiu49AYrA7oVYUrizWh+f+gQDX9MNfEYWHwhR4FOef2JTwL
6enEkQ+Ul0aFGfFWcKABHbmHlvCjjaTvMao9C65UzTQiJTA++Ql4wyeNKXlG
0vsfcu3DtteXGCEZaKaMfYqOqcaihBoj6X8GbVZVwtHbRrygwaFq5pgfY3gj
+eHAL7/RWynpAi8LCDRC87e7Ku3tLvLXBa1Yddm6oQttwThMUAxXSVtPdpFf
Ho3V7W/8q+3CgLiBht2oethgHiUykX8zNAcNVw69aUJQ3tkecCeWlWcoTJSH
BZ7tkS0p50zUz4Khyr2KPN5E+Vixe0zpzeZJPPW3YjQ/YWvFZzzlZUOO8GfN
yQs8zbNBzO+K8bh5ys8OcXRMXg3rpvl2LF/8nblyfzfl6UDGUIlCp+vGqYC9
OgfktcmuT5PNlK8T+uJmwyylGV+fCJQTmuLFg9c1mSlvF6Y50s88TOrB4aBA
Fz5sf7R6944eyt8N+aD7CzbpehBsV+aG3qfa8me8hXh4IMxPrts+x4KSQNxK
DwqPa03vlliIjwfqa7pF0p8sKArIk3sx9/X9Z4boLcTLi/Oa1rKYWCvWrA5U
L5anSN4bPttK/HpR+cWIpHE7rQjaze/Dk7Wi19IuW4lnH/S/y7OzzFbi4UNp
w6IM2QQb8fAh/2PJhY9W2IiHH6XyZdOzq23Eww/Pwah3JupsxOM55g67lumM
tROP52CxdaWnFtqJRz80sluLU4/aiUc/HJdzxd9q7ZSngKl15paOoQ7SI2Bx
03Jc3TIH5Stgg+uWXLx3zEH6BKxDrpxT1OagvMOYemycuH2kk/SGseyjbRlh
S52UfxjTfnNglqHWSfrDWM78xL1bOSfxCGea++OVv01xkZ9wVl0ir7242UV8
wll2h+yreddc5C+c/bqyybtf5CZe4YxvqylfO99NfiPY3SrJy4bjbuIXwYQt
LQprp5v8RzDxH4X1xyZ7EJRnimD5O0ya21s8tD+FTPHLlLultzwI4l0tZHGX
0ofcfslL+1XIzsxb89eX+V68OE6ErLRv36HmH7y0f0VMnWyrr3R7ib+ICSI3
XdVm9dJ+FjHFhsz1qspevDjuRMxypGHb6ce9xCOS+Z7WXE1P7SMekSzNPCIu
fVcf8Yhk+v74iu9b+4hHJJPv0WbKk3zEI4oduJ6dVbvZRzyi2I1Y6bO0Oz7i
EcUKEhM+Hz/STzyimFTSkFu03k88xCytPnrQK9f9+B+48BqH
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lA9Qk3UYxzfYYIJnmiwRAdGDc6hpHdMTg55fBYWm0gxjEWpygH8gHToT
hyY3JSESBekkIyjmeXSZppIuD42TXRgajv+LuBrT9B17Gfv/fxKbz5679957
3/f3Ps/3+/387rcob9/mgiAGg1EwffnugYqWxnGkcRTIYyt0AnkTUF5TRdSi
wPNl8ByeqtAupiBsWCZKDbsJM+O3iewJge93YCBs9cCGpRTwk3zVCZ5+e4Fp
ZWB9FxR3ZXoNqynQSCIuvzPWDRz2/ToBBP7vAcqwLDVmHQUZY74FvWCI37Ni
a1agXz/sqsr5OWoHBQt9y2MHQd3midu+L9B/GHYtL9InHaPAxss9fdeqgjXK
4rqWM4F5I6A8cPFUm4yCB/4aBUpanHdAHpj/D4ilq05TPRRs9r9QQ37WlcqY
pwE9Y9D4ruT6AqYWXvcP1ADjw5qtdLQW9T2CAUfmzYa1Wkj0jec9Btajjx4k
5mhR73/wsXnOkdYyLXCnm0kingC9UlsS06xF/U9Bnd4QU6vQwnMaFFxau/DH
cFqLfijg7Ohw1XPHgRb4BGrh3t/2Bv4b4+hvHNQc6Q3j3nEY8sehgxNzpXH9
TePolwZ148iaf5XjMC1uuuEEXBjs1i9g69C/HhSnNDdrXtOBX97lSeCf316V
ItZhHgZwHAnpS7yiw34GiJacFOfQOszHCA0Ly+/2LqOxvxH49JLSuk9ozMsE
QtYv8qarNM4zAYc+Hu6w05ifGXhh4TnNZALnm0Gc/Z2+vnoC87TAhtlcsUo1
rdtnT2aByhaebRdPj/lagSPu1aRJ9HD+a19Zof1A9sw9PXrM2wZrLMmXBuMn
4bRfoA3yR4YLTxydxPztUDnjYeZ+1ST421XYgfJID/0ZZUAeDuDk8mRH1hug
zBe3xAGic0rdW2UG5OOA9tuqLXE/GaDEJ0/khKxXqy/NUhuQlxPk8v6K8Agj
7Cz0lQvyE7lvz11nRH4uuPDZvPjFx4zgt5vrBmo3+2X+DSPydAP9uygjXW9E
Hh6o7N6SIlhiQh4eyP+Ae/X9HSbk4YVy0fZVGY0m5OEFRk3om0tVJuTxDIRz
bqdaI8zI4xmQCFn5hc1m5DEFHYLO7KRaM/KYAssNIedbpRnzZJB2lb5vdLYF
9TBI5CtZtgmBBfNlkGjZ1mv3z1pQH4M8FknWlwxZMG8maV8UyRmZb0W9TPJe
7VAKc5sV82cS1TdfpmlarKifSYSbYk+WUlbkEUQUDxMkv62woZ8g0lomarl2
0IZ8gohwVPDVxts29BdEOvJ6nNVsO/IKIvRQc9XuTXb0G0zuNXBf1JyzI79g
Et3XJzaO2dF/MJn5R3Hr2eUO8MvTBRPxUZ1ccciB+5NFxL+uuFfe6QA/3kIW
ibyePEvxghP3K4u0bdz51xe5Tnh+nLBIpbuypvcHJ+5fNungmVrr7U7kzyas
kP23lOku3M9sUro3tUha74Lnxx2beM50H774yIU8QojnSfOt5CQ38gghafp5
kcnH3cgjhKinouq+73cjjxBS+rkyVRTvQR6hpPFORnrLQQ/yCCWKiLin/C4P
8gglxbExnybM9yKPUMLjdgtLirzIg0NSWsNmvHTHC/8DNOkXkQ==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMk2cUhkvphYsBnGWgGxWXGitsjkXcSgTPFxXXOUTKZDQG5+bwNm9F
6q0Ca1AGiENFFpU5cGCWmjAWnZPOiRJhgzGnBSJ2BDeoOJ39+enl773AaDk9
SdO0/f5z3vd9Tr8FW/Zlb2WzWKyt0y/fe6CyeHEr2k7YQCssM8q09aBRvlN4
RR743ALJNS28OyIbhD1qUqSFtUJ8JOsxe5zB328DO4OZp2plIHmprzpAzNu/
IKGEwfNdkDe1ojJ2FQMGlaDl3ZEeEJy/LnyfF3j+Prgj9z3u6rKCdMR3oBdE
vRPG2nIr9usHyb26c9p0K8z3HRc+hPwyen0K24r9H0H25NPGuDYL2MV5p+7a
9ND9doNk90ELzhuEzBLFg8QlFrjnryGQyyMkn46acf7fwFnWL5t7wQzZ/i+G
QfFrIj8nw4x6RqA5NWFt3KQJVvgHGsCwYeXsIy0m1PcE1OVvbti3yQSLfePF
o6BR8UL54SbU+xRuVY+urN47DtHTzVSCfyFKuzxqTyeN+p9BiKUmVRtDwwyN
52DSxRQW7xhDP88hq714Vc8NCiiZT+B/ID2YKGxmU+jvBQhCfslKyjDCgD8O
I5yeUxrfX/8C/VIwenFQ8o/uBUyLm244Btcf9tCvcI3on4bRLw2t1cuN4JfX
Mg7JdZsrU5VGzMMEziJe3+IfjNjPBGJVuXIjZcR8zHBpvvpubyKF/c0goRYd
rtlDYV4WUHJ+0tZfpXCeBfKoY+FOB4X5WSEpLHxjAxnD+VY4nXuJrq0awzwZ
yI+KVur1Y3DZZ6+JAU2j2L5DTGO+NohV9hpWq2iou+ArG7QX5s767D6Nedsh
lUlpfigah1N+gXZQDz7adrx4HPN3QEXog/X79ePgb1fmAMpbeujPeSbk4YRZ
eeKmorUmOOqLW+WE5nM646qjJuTjhM42fU789yYo8MlTuED+VlVzxLAJeblA
q+0vCxeYYfs2X7mhaHH0mjnvmZGfGzQlMaLXPjeD326eB6id3DeSb5iRpweY
3xTSdDqwn1442ZOTKlsU2Gcv5H8YffWDTyzIYwLUis3LpBctyGMCQqr5KxP0
FuQxCfLZbWk2gRV5TIJU0KS+nB34v01Bu6wjd+kZK/KYAlarPOQbnRXzZJFO
Pd03FMWgHhaJT9pgH5MxmC+LvNq06dofZxnUxyJOhWptwUDgPggitxbEhgzO
taHeIJJ/ZiA16CMb5h9Ehr4+udrQaEP9QeTjTGH54ec25MEmugcLVXeW2NEP
m2iOKhqvHbAjHzaRD8m+WtdmR39s0r7lvquK60BebOIdaKjcmelAv8FEdz76
JcM5B/ILJqK+PqV5xIH+g4ng992as687wS/PGEyKio3azkNO3E8OOf7zkm51
hxP8eLdxSPyPKRGdkS7cVw7pXrf9rxN5Lpi5TjikwlNR3XvFhfvLJffEFk2t
w4X8uWQWb/9NXbob95lL1HvTdpXWumHmuuMSzpmeI989cSMPHmE9a7iZstSD
PHgkg46JTTnmQR48Mjw1r+bbfg/y4BH1F7o0hciLPPjk8m1peuMBL/Lgk25B
/LPkLi/y4JPdwriDC+dOIA8+kUT3yAt2TSCPEJKhCQt9+fYE/A9iiQrk
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQlGUUhpdluYgMXlpADREMRijFCJmkAc5nI7KmMC4BkUNAxCUGw4UA
EcFQQ1EINbbCUFEgBx1kJijcLMiEENDhOgEiIqAJAS77X/bKArHL+c/Mzs7u
fnvO+77P+X7n2MMh8Xwejxe/9DK8cxVqvtG/8ZwSZI7502LZVRgui2l3T+M+
10KoZ1Xo9x8rwWqgUuJndQdGWiee8XdxvzdBTORbyYfdlLDDy1DN0E2lqJ6s
4s4/AP8zdSdEahbGs4W1gWMd0Omgsv51hMX/d0JCnU+pcysLojHDgR5oC8x9
o/g2i/36IOHpvVqdlIVNhuOO/wCbJngvMYfF/gMQZSn6u+8zFlRukefvKwdh
6ErhAbKPmzcEkV5dT2reYeGRsYZhqm1t4voN3PwRyI4Kp/NNWAgxfjEKI8yl
XHqSQT1jkHb2qWV0NwP+xoHjMOXoLH14h0F9zyHql7hNO8sZcDeMd3sB8r3V
t6pOM6j3X0h4Nu29JoUB26Vm2cKXIE/f/lduGIP6JyDK6sv9U74MLNOYBMG1
hoFwFwb9TMJpb11s80oGZsQGgf+BrsNPvp2h0d8UHI85cfTyEA39xjimQaBq
Eay4T6PfGUgrtLyQcZOGJXFLDV/BjNP+18cv0OhfDicbzt8IzqLBKK92FlT7
+jx/j6YxDwXkjNk1bgnk+ilgJvOgSOpBYz4UpFhf7ePZcf0pUFwfi/pinsK8
aEh713Xq8QsK59Ggf/R5xp5HFObHwLXYGl59PYXzGZhUzxZuKqMwTxak33jZ
F52koMpgr5IFdvORCk0ShfkqoUh2d1u8mIIfLxlKCQtBC7KenRTmrYLM57t2
+ztRcN4oUAVsVn7XLQsK81dDgU37QftZBRjb5avBocr65al+BfLQQJ7PgVRF
owKOGeLO1oC+s0Qf+ZMC+WigpXEwzOm2AlIN8iRaiPAsrLEZVSAvLchkffkr
hRQkJhhKBznutnte20shPx3UHLd32fwVBUa7kXMwk2S2bUcDhTznQNMqEQXI
KeShh9KOMF/xFo6HHuLCbX/+8FOOxzyUSqK9RZc5HvOwutji/TcHaeSxABFr
Gv2UQgZ5LIBIWJlXFcLt8yLcEzd/5HWRQR6LILgTYXmlm9tfHmkblPcOr+bu
C4+4vB2qeiVmMV8ecaj8pO5hCXffeEQvyf4gtZ+7rybkD+d1lkPrlajXhBy6
2O9rEqXE/E3IaFnR7vEKJeo3IXHBjmeyJpXIg0+Gu1yz//RQoR8+qT4mqajL
UCEfPkkfFn8X1KhCf3zSEtupLTRTIy8+0feXn00KVqNfUzJcart2/Ac18jMl
W3t706kxNfo3JU7th6pLtmrAKG/alHydOy1rOaLB/RSQC795tOU1a8CIN0FA
3Op9bFpWaXFfBaQtKPHxuUgtLD9Ols7PFRT33NTi/pqRGTe6WqrWIn8zYm2e
drc7QIf7bEYKUvyST0p1sPy4MyPCix1HbzzXIQ9zYj1RftfHaw55mBOJ3H6d
z6k55GFOXixu+PZ63xzyMCfS091+Ehc98rAg1U2igIoMPfKwIN1Cp4kdD/TI
w4KkO27MdF0/jzwsiMi2IyI1eR55WJLQaqsVdk3z8D/EIB5w
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lA1Q03UYx7exN3GnaQPEFEfCiZWIgZd0wvOzE5mpHDMk80iJBFQKB4EK
RuELmEIwYpUGvgF56CFnaLqsUQnJiyYoBqiogCQECPu/7B0kNp//c7fbbfvt
eb7f7+f5/b3jdq6PF/B4vPjJl+Odqyjx3FD9ESPovHKGVLoT0FUS27Qwlftc
DXFLKqK++8AIrh3l6hDXK9B3vf+xYAX3ey3sink9aaefEYICHVUHfVSy6cF0
7nwD7DhUs09pZqE3U14d3tMM3XNMsp8fsfj/W5BQE3zU+zoLyh7HgdvQG541
v+A8i/3aQP3wj2qbloV5juNe/4ApVfh24ucs9u+ABKnyr7aPWTD5xRReM3bC
wPG8SLKGm3cf1IEtD6reZOGms7rA0Dgz0XM2N/8RZG+OpnP4LKx3ftENFuZY
Fj3AoJ4e2HX4oXRLKwOhzoG9YPPy1t64wqC+J7Dj0tZ5y04ysNAx3q8PbKsr
z1XkMqj3X0h9PLR0RjIDbpPNMuVPwZK2+M+sDQzq74c018/WDi5n4AWNARCf
utwR7cOgnwHQLLXF1U1lYFjlEPgfyG6EjCxmaPQ3CPmx+zJK79PQ7oxjCKSm
euGUazT6HYaDeVJN+lkaJsVNNnwGFsXaV3o1NPofgYOXC89E7KHBKa96FCxr
2pb8uoXGPAyQ3eOuXxDO9TOAePcmpdafxnwoOCE70cZz5/pTwJ7u2fzpOIV5
0ZD7lu/gvT4K59Eg+Htb+qqbFObHQGVcFe/iRQrnT/o2j+bNK6EwTxZKvw70
yN9PQYXDXjkLXvN3l1m2U5ivESp0VxfFqyj44ZijjCCLeK67vYzCvE2gebJi
ZaiCgkKnQBPMychpOSehMH8zaKY1bfIYNYCzXY4ZgipkTw+0G5CHBS4FR6YY
9AbY64g70wLCluKxmB8NyMcC9frODYrzBkhxyFNbIXZJXtW0bgPysoJO15Yz
VU5BYoKjbKBd6Lbq5dUU8rPBb194+Lz6JQVOuzF2kO0QLQq6TCFPO/Aa1Mqw
EQp5jEFp84blqgUcjzHYFu3203sfcTzGoVS9ZamylOMxDrMKJO+81kkjj+cQ
O0MfYpQzyOM5RMrLsyvWc/s8ATdVde8HFjHIYwKkVzZKj7dy+8sjjZ0jd7pe
4u4LjwQERJmeqVjMl0cU5R/W3Cjm7huPyFIy301p5+4rn9z1niW972lEvXyi
Lmpfzt9sxPz5pLskf2VvmRH188nWCK9DewaMyENAult8M3/3N6EfAbmwV11W
k25CPgKS1qX6dp3ehP4EpDHuljVPZEZeAiLsOHl4e4QZ/bqQ7qNuM3u/NyM/
FxJw504a1WNG/y5E0fRJZfEbFnDKG3Ih+VlDuvrdFtxPIbnwi39jdp0FnHgT
hCTgYvC0+ulW3Fchubsu8d6RGCu8eJwISan9q4LbZ624vyIy7EdXas1W5C8i
cnHq1dYwG+6ziGiSQ5L2a23w4nEnIn5FzRlnntiQh5jI+k9eDQ60Iw8xyR/x
mBV8wI48xISdmP3N6TY78hCTU7mtIWqfMeQhIfW1yrCy9DHkISGdckV/UMMY
8pCQNK+5u3w9x5GHhBx0a96YkjSOPKQkqtJ1invtOPwPm68Yew==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lA80lXcYx6/r4iZHsota8qe02Eoazujg+bWTumtyuoZZxzBLVjZRk4il
mlkxkbs/LWXjzrk5cjY27mzMYiksSkNSoRajuO+f+9ef5l7P+zvnPfe87/29
z/P9fj/P73WNPxiWwOfxeAkLl+GXW9Hmq4OazqhA4ZQ7KVFcgtELcTc8DnH3
NXBosyz8q3dUYNlfkRJo2QBPro095G/l/m+GI9GvJB10V4GPt2G1gpJKVt9b
xu1vhyN5tSfEGhZGM0U1O0Y64LGj2uqXByy+fxP21fp/43qNBfGIYcMtsBZn
ry28wmK9Xii431Kjl7LgbNju9A/wDwu2JGaxWL8fDgjFf/W+z4LaPfrsVdUA
KC/m7yZvcv0G4ah3973qV1noMq4h0F+3TVz5Itf/AeTERNK5JiyEGR8MgzV7
PpseZ1DPCHxy+r4wtoeBIGPDUbBxdpV2NjCo7xFk/rzX2a+MAQ9De/fHYLlT
XiX7jEG9/0LWw0nf5ckM2C0UyxQ9Aae0TX9mRzCofwzOWR4OmQhgYJHGOFh+
V98f6cagn3H43Vcf37qUgacSg8D/QNQZOLWJodHfBDTHncgoHaShzxjHJKxR
twmWXKXR71P4NF9YlHaZhgVxCwWfAc81ZNVoEY3+p6Cw/mxl6FEajPJqpsE2
pHfzb7E05qGEqhH7pvU7uHpKEKbvEUs9acyHgharS708e64+BY7lIzEfzVGY
Fw3S19ZN3H1MYT8aXvr7g7TtXRTmx8BEfDWvro7C/gy4aafznS9QmCcLlV94
OxScpEBmsFfBwpa16eXa/RTmq4IuRePGBAkF3543LBU4hs4rbvlRmLcafny0
dVuQCwVnjQLV4J6R211lQWH+GpBZ39jjMK0EY7lcDfjIrJ6c6lMiDy0o/Hen
KpuUcMwQd6YWVnSXzEb/oEQ+WuhqGohwuaKEVIO8FB3Ebc6vth5WIi8dtCh6
c5eKKEjcZ1h6kHvYbX/hDQr56cHquIPbmuMUGO1Gz4DNAbONPvUU8pwBq/YU
cfAUhTxmQdYRESBZz/GYhaJIu5/eeo/jMQfylFhfcSnHYw4cCy1ef3mARh7z
sHd5U6BKxCCPeYgSVeTIwrh5fg5dkta3vYsZ5PEchA1Rwos93PzySNfA1O0h
G+688AjxClc/k7CYL49sqHi3trOEO288YpWauTO1jzuvJkSwZoVwcKUK9ZqQ
rOK+AJMYFeZvQmxKC7aNlqtQvwnJCXXKOzquQh58ouxel/mHpxr98MnAsZTy
2jQ18uGTgiHJl7ua1OiPT8bjb+ryzTTIi09E/WWn94dq0K8pEZ63sx39WoP8
TInf7dsfUyMa9G9K3G58KC/ZoAWjvElTUp09qWhL1+J8CojiV8/rOa1aMOLd
JyBedf7Wbct0OK8CcmdX4t0z0TpY/JwIiHzm88Jbl3U4v2ZE607LpRod8jcj
juaHGnuC9TjPZkSaHJh0UqqHxc+dGfEr7siofKRHHubEbays0d97BnmYk+Ep
hxX+p2aQhznh8Vad+753BnmYE6+8nsAUt1nkYUHuNIuDy9NmkYcFYUUuYz7t
s8jDgsidVh9Zt3IOeSzc23VEpSbNIQ8hCZdbLrFvnoP/AWKnD24=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lA1ME2cYx6/X67VUmIuiRlREMA61Lk4xGFSeRwRhmVuwGnSIyFBxQafd
ZhRBi8EA8hVUnDgijumCHyCyiKwqGgQFptjhHOAcc6D4AaiA0OsHLR3tPTzJ
5XJ37z3P////vXlnxO5Sb2UZhtk6cjnuoxXDTwu8mWkAnWdqz2rdafDy0Upz
0kefyyC+xVD3OMsAytazmmXK32Bcvj7u8/zR77dg5mqX6xkXDOC30FG1ENk8
T+JTM7q+HqbeNXteaDfAs0T3stCOe+Bl3Bt+kRPofz3sz/55SeU8AcI6HAse
gvWrO6ExGwTq9wiyoztDl+cIMN2x3LMZjnuEZ5tqBOrfCs9ule9RWQUQfKNy
awyP4aB7U2nmYiPNewLFv3/INew1QqOz2kB/Q7ek6JqR5j+F+CMP85ttRlA7
X7SDb5t//PxgE+npgFm8Pk+bbYJA58BnkNb/gMtrMZG+57BjeweGeJthtmO8
byfUBXR3aXaZSe8LqBqYtsZw0wwTRpolur+EgsJF0666WUj/K9iR2/LPD9EW
EGm8BssZQ21yuYX8vIbDmbrYjdIheLPaIbAL+DD/qCnrhshfN5Qd1nxyvmQI
Wpxx9EB2Z7XrIGMlv2+giV9wvC/CCiPiRhq+Bb99zO0jl6zk/x1MnVR7o4Gz
gVNeWS+ExZVW5UTZKI8+WH98e29zhY369cHuexB50m2Y8ukH18tt9Y1xw9S/
H4pU965srx6mvN7DyV8HFu/0sNO89xCzdCar322n/AbAr8Rvaeofdpo/AKW7
24JDJzAo5jkI6n32pPdBDP7isHd2ELwnnbLc1jAo5muAlBXNZ6+cZrDgR0cZ
oOm7Fyl3GxkU8xZgpX9evcHCYK5ToADBeZLaoNkSFPM3gl73sPPiOgk626Ua
oXxBjk6VJkGRhwkGD4U/r6uQYJIj7kQTsHB5RsJzCYp8TFD09f0QGMfitw55
GjN4VxQsmrKcRZGXGbLvrO1SaljcFucoCwwu4uPdfmJR5GeBtKLgphl6Fp12
o4bAGsisCLWxKPIcgjmgEfarpCjysELf+ElzazZIUeRhhfZv2lQTs6Qo8rCB
qiZAnXBdiiIPG+xM0g696pKiyGMY3OdOOLZlMocij2FI8e9JfxvGocjDDpXl
LREpCRyKPOxQ5P7BQe/zHOXJoNB7IetBK0d6GMzcNF9xSC6jfBkMyJudGeQv
I30MatOrSsZsk1HeEkwJXOP69ISM9Erw3aOQ8Gt1MspfgurWLK9CQUb6Jdi5
+fs5GbN44sHizgMbpx+I4MkPi7FByRUJaTzxYfHjnHNnkip58sdidKmiOPUl
T7xYPP23THtiopz8SjHGl3t7aaWc+ElROBOou79HTv6luDay8FxvsRyd8npG
cp6bmzq5VU77k0MvxUvPT+UKdOKN4zDl2NUgrb+C9iuHxf8urNFtU6B4nHC4
RXVKY8pX0P6VYeLh8T7LGhTEX4bqsbnlaSYF7WcZrm+90f+XrwuKx50MT656
Xf3Rly7EY8RX7zuzNsOFePC4aoN34pNrLsSDx5V7ArwCul2IB4+VDUGNhR5K
4iHH7j8zNsk+UxIPOUZEH63SJCmJhxwjK+x1/5UoiYccvyg5ulndpiQeCoxN
dktocB2D/wPE4+T9
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU3cUxm9vb28fwmYm4sSJCoShVuNUgkHkHCuKewbRaKaIRicuaLDb
DFaYlTBBeQUEBxsR58aCKIgsoquKDosiU+w0CjjXOV4iDxUQWtrSwmjv4SRN
c9v/Pef7vt/Jf86OfZG7WIZhdo1/nN8TtZ2fGXo93QQ675TedbpTEOCrFWcd
nXiuAG2Tqe5JhgkUzcXqFYrfwavAEPNpwcT/N2DeOvnVtLMmWLrEWbWgaVwg
8tVPnL8Dkbet3mdbTNCW4FER3noX/IYPRJzjzPS+AXIzf15+eYEZ1rY6DzwE
zx23wrdvMVO/R1AY3RG+MssMs5zHvRuh1Csi06I3U/9mcPujMl5pN4M5ICpb
b3oCOR4PytOXDdO8p1Dx52Su/sAwNLjKCMZruuWnrwzT/GegznlY0OgYhkjX
Dy2wyBgUuyjMQnpaQcUb8rSZFgh1DWyDEwP3ubwmC+lrh/w9rbjaxwpzneMD
OsAY3NOt3mclvc+hbXDmetN1K0wdb5bg0QklRYEzL7nbSP8LqM5u+uf7aBsI
NLpAUWyqPVxpIz9dkJuu27FVPAIv1zkFdoP/2qCoGZtGyF8PDB1Tf1BaNgJN
rjh6wd5R4zbE2MnvS2jhF5/o32iHcXHjDV9B0kHmZs55O/l/DbpptdfqOQe4
5FX0QVJMeXVWlIPy6IekE3v6Gqsc1K8fdHdh8w/uo5TPAPhdMN5piBml/gOg
U969uKdmlPJ6A+W/DS6L8xqjeW+gOsSPNewfo/wGIaRsaUjKX2M0fxAM+41h
4VMZFPIcgr0HxxLfqBj81WmveAj8pp203VQzKORrgtRVjcUXTzFY+KOzTGD8
+nny7QYGhbzN8FlQ3h2TjcFsl0AzbMgT1armilDIf3xPdA87zm0SoatdyjDc
WJylU6aKUOBhAbcjEe11VSJMdMadYIH34MIcTbsIBT4WaPvy3mp4h8WvnPLU
VlhYVRg4YyWLAi8r5N/a0K1Qs7g7xlk2GA3kY91/YlHgZ4PU02EP5hhYdNmN
GgE3YFaFO1gUeI7AR6A2f6sUo8DDDkNTps3XbxGjwMMOTJxR6ZkhRoGHA4L1
wZGaq2IUeDggM1E78qJbjAKPUfCcPzX3i+kcCjxGoSSo9+irtRwKPMY5VTZt
TNZwKPAYg3KPt5J8SjnKk0H//rMZ95s50sNg/rZFsu+kEsqXwbC8uemqIAnp
YzDzaHXZpN0SyluE6aHr3Z7lS0ivCCc/Xh1xpU5C+YswrjljdpFZQvpF+HLn
N/PS/HniweKRQ1tnHdrIkx8Wk1WHqzSpPPFhMSTrzC+Jl3nyx6K6XFaS0skT
LxZL/5Zo8z2l5FeMsQHcq/NrpMRPjO8Wh+ruxUvJvxj3bi4601ciRZe8XjEm
zM9Omd4spf3kcKGs0/tDqQxdeGM4TM69pNIGyWhfOaz5d4let1uGwnXCYZLy
pNpSIKP9lWD+sSm+K+plxF+C0W9nV6ZaZLTPEtQ0Xxt4HCBH4bqT4LlPumre
/1xOPHi09b22atPkxIPHiC0+CU+vyIkHjxvig2cH98iJB4/6elVDkZeCeEhR
+Shtm+RjBfGQ4ubo49XqRAXxkGJq1Vjdf2UK4iHFhLLjOyONCuIhw9jD7pp6
t0n4P3sV5Qc=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMFFcUhmdn36s2oCBbiviqQdQItQ1Sip6jJYhQra7WIBBrebexskak
iojEBG2o6FpQikWrQnWxgi1tUVMFRQQrWB9EQKLggiyvBZfXvoGyO8eTTCYz
c+ec//+/mzs3OkkRxzIMEzd52e9vK1Y0a+WtrFG47pnZt/H6WYiXb+OH33j7
XAqeD5MaW3pGQdZUqFwhuwYVw5lDgR4G+l4B2xc935G8wQAffWivu/D6ZsqW
lMMGWl8LutzCNr8KA7SnupSu0TyA2ITX+4uNb///D1zMj4R3lhkhRGNf8AQ+
C+3VJCUZqV8DoJd2trrECLPtyz2fwZXf6/Ij+43Uvwnc7xQ6pS01gWFh1PGq
0Wbo7UwItipNNK8FtAUzXOv+MkG9o15AVlP9oZdmE81vhfAXSxveRzMoHC9e
wc6MhpM5R8ykRwPjkZ+WeTw2w0rHwHaoOpK+6893LaSvA8LZLzLDYi3gbR+/
8DVMVd2f9vyqhfR2ws7EsoINNgu4TjZLddFC1IXO5ZfWWkl/F9wuF0Q8zbMC
R6MbVjcGDtVqreSnGyLKXWPS/Wyg22gX2APBvIwM3WEb+euFZNeQbGmzDRod
cfTBnNB3/B96j5FfHRT9ocnzSRuDSXGTDfvBZdOphd6Pxsj/AOh8dDVl88bB
Ia/0DTg551+5lzJOeejh1YKgHZF149RPD4EtB/u/nTNB+QxCt7ku0bhngvoP
gvwTdcxQ3QTlNQR7a7c1LnFmkJs3BEEnnJfkBjLI5TcMh7dqXi5JZJCbPwzN
SW/+HslhkMtzBNafav25p5LBIru9whFwigvIkeoY5PIdhbI1gzcUch6ezrfX
KJQ7aYLvBvGQy9sAuYN7vt+6i4fHHQINEHwgsmPGWR5y+RshC+CJ/gEPHe0y
jaCLKmobMPKQ42ECv7O1pVMXsLjfHneqCUJW5+hDFCxyfEwwvet8woWDLO6y
y1Oa4ebzz7VuJSxyvMxQ496yTt3CYkK8vSwgiM/KVkj4yPGzwEzVm/Oufnx0
2I2yQr1qbq4+ho8cTyuE5Djtaz/BR46HDXYqW5W9lXzkeNhAbl51UTzAR47H
GPgeGF73sYcAOR5jsE0872J6qAA5HuMgr9WPNu4VEI9JzottR1ddEhCPCTjm
r6269UxAPCag8VKPIVQgpDwZZBN2H+9eJiQ9DFpmVJlPfiWkfBkMdvuhWKES
kj4G2/m/yj0rhZQ3D7GnvMbYLyS9PFwUpvNv8xBR/jx0SS4xN4SJSD8PR1oj
f3qWKiIeLHrsnV7cUSwiPyymp3xdPdYsIj4sRuSvODJfIiZ/LFarUn/cvFxM
vFgcie7OUsWLyS8fl52xyptOiokfHy97qbu97onJPx+DT/gVHxoRo0NeHx8D
rr43rWu+hPanALXfPP138yYJOvDGC3D8zLW8ukMS2q8CvP2y64OwMglyx4kA
78+cvaVBI6H9K0T3tvzqGGcp8ReiKs4ENpTSfhZiRse87AKlFLnjTogBB3x2
B52TEg8Rvkpb+8/wIynxEOHph/m+lyekxEOEj0t8zyX4yIiHCEMO6psXfykj
HmJUqPf9ZjgmIx5ijPjOrbe2QkY8xLjeWJL4y4CMeIgx+rLaluY5hXhIMHVW
b9r29VPwfyIc8ho=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQVGUUx+/efa/aQEKQraioIygjZA5SqedoDCKMpisxKAwR7xwalhFJ
EZFhAhtLQRGUQlIxAQs0KtRJIVGhBPJBAjKytKA8F1xe+wZi9x7PzJ07997v
nvP//3/ffEsiExUxLMMwMbOX9f66okULN94+Ngk3XLKGdt4ohr3O4fyQm6+f
K8GtObG1Y2ASZG0lyg2y6/BoPGtsvVxH32sgYeWzhOQdOlj7nrXuguZWSnBK
to7WNwCbX9LlXaOD7lSHyi3qB/BV3ItD5frX//8Di40PhXfW6MFfbV3wGIIC
BtWJiXrq1wIRK3oXlVXoYZF1uctTuHWtsTB0WE/922DjnRK7tNUG0LmF5dRN
tgPTG+dnVhpoXgfIzs13bPzNAE22eg5FbU2ZnUYDzVdBwvPVLcvQCArbi/8g
O6MlP++okfSowS7soyr5IyNstA3sBtXR9KRf3zaRvh5IZz/JCow2gbt1vNsL
cM79a96zqybS+xIy46uKdlhM4DjbLNWhFxIuvlxXutVM+vugrlqw58kZM3A0
+mF76/qxhl4z+emH5GrHqHRvC2h2WgUOQCQvI0OTbSF/g5Dm6H9c2m6BVlsc
Q+AR8IZPs/sU+dXAtV/UZzzTpmBW3GzDYVi7q8DN/eEU+R8BiZemvsp1Gmzy
Kl+Bg33hz/dTpikPLViW+yaENk5TPy1EdxwZ/mLxDOUzCnNNjfH6/TPUfxTk
H5ZFjTXOUF5jcKohvNXDnkFu3hj4n7T3OL2eQS6/cSjYre70iGeQmz8O3Ymv
fp/IY5DLcwIiClTfD9QyeMlqr2QCFsR8kCfVMMjlOwlNW0ZvKpx5+F2htSZB
Zaf2u+vLQy5vHVSO7v96dxIPc2wCdRB0OLRnfjEPufz1UADwWPuAh7Z2WXoY
CbvUNaLnIcfDAJuLGyrnLmfxkDXuVAMEbM7T+itY5PgYYFnfhbiLR1hMsspT
GuHPZx/3OlWwyPEyQv2Cjm1lHSzGxVrLBILYY8cVEj5y/EywMvfVBUdvPtrs
hpnh39wlp7VRfOR4miEkz+5g90k+cjwskK1UKQdr+cjxsICPcdNl8QgfOR5T
4Hd4fNv7cgFyPKZAKXa9nB4gQI7HNMgbtJOtBwTEYxoiVlm+3VQqIB4zcMun
t+72UwHxmAFV6YAuQCCkPBmUxe3L6V8jJD0M2jnUGfM/E1K+DAY7fVOuyBWS
PgbH+D86u9QKKW8e+g1U1+uHhaSXh16BGp8uuYjy56FbcoWxJVBE+nko7wo9
+zRVRDxYXHzgzfKechH5YTE95fN7U+0i4sNieOGGo0slYvLHYmtu6qmgdWLi
xaIlsv9YbqyY/PJx8zmzc1u+mPjxsXpFWf+K+2Lyz8c9J73LMyfEaJM3xMft
V9+Z17dUQvtTgNq9T/4O2iVBG97Y2RyLr59pzJTQfhWgqrPv3cAqCXLHiQCf
vLUouEUtof0rRO+uwntR9lLiL8SzMQawoJT2sxAzelyPFymlyB13Qgw57LnP
97yUeIhQm7b1j/GHUuIhwkvNhV5XZqTEQ4TdFV7n4zxlxEOEiiPa9lWfyoiH
GPeUHfxJd0JGPMQY+6XTYEONjHiIUaGviP9hREY8xJhypcyS5jKHeEjw8sLB
tIjtc/B/RCjv6Q==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQVHUUxu++HyYDCUKGoKgjKiNGDZKp51gOImQpmpPCWMmzomFBJV15
DTMIQyIgomJKKqSLBRYV4pQw4gMSCJUEZHi0gLxccFlg30C7ew9nZmfnv/u/
53zf9ztzlx6MDY7gMgwTYflYv+cqU7h4852sKahyS3+5q6oIEl0O8D69PXcu
h9VNsa0dw1MgbSuWbZLegn8n0jUbXbX0fzXEr34ec3inFt5521r3YOyvhL0J
J7R0vw6kBcU9vtVa6JU7lm9TPoJTUf3HS3Vzz/8DnoZmwV0fHQQorReeQEzg
iDI2Vkf9WiBm5YC7okwH7tbrbs+g8ZeGwpBRHfVvA7xbbJ+4Vg9az9Cc2ql2
cByI8jfJ9DSvAxZdWuDU8LseGm3VCdfaGtO6DHqa3w1pnWtblqMBgm0//AeK
1JaC/AwD6VHC8tAPKlwfG2CzbWAvaDKS4357w0j6+iCT+0l6ULgRVlnHe/aD
f279/Oc3jaT3BVyIrri402wEJ0szueMAyK6+WH99u4n0D8LjSv7+p+dMwNIY
gp2tGzV1AybyMwTySqewZF8zqHZZBQ7DV5zUVNUJM/kbgSqngGxJuxlabXG8
BAy082taNU1+VVD/q/Kcd+I0WMRZGo7Ch7vPeq5qnib/Y+C4TvWwwmMGbPLK
X4GfQ+HPDxJmKA81mFdsjQlpmKF+ajjZkTL6zZJZymccPI0N0bojs9Tfcn5P
EaZpmKW8NHCh7kCrlwOD7DwN7Mlz8DqzkUE2vwko2afs8opmkJ0/AUOxr/6Y
zGeQzXMSZGe7vx+uYbDEaq94EjwiNuRLVAyy+U5B+7bx28EuHLxQaK0p0Ngr
/e9t5SCbtxZqx49k7ovjYI5NoBZCk0L6FhRxkM1fB2cBnqgfcdDWLl0H6tCS
njEdB1keeggoqit/bQUXj1vjlush/P18dUAwF1k+evAbvBJ1NYWLcVZ5MgPU
P/94wLmMiywvy3lRxw5FBxejIq1lhIWRWdnBYh6y/IyWfXl1xcmXhza7oSbo
zF16Rh3GQ5anCfbn2x/rzeMhy8MMN2TdspEaHrI8zOBn2HJNNMZDlsc0BCRN
7HjXlY8sj2mQizyuJQfykeUxAx516qnWo3ziMQPRa8wnt1znEw8LR7+B2jvP
+MRjFlTXh7WBfAHlyaBd1KGcIR8B6WHQ0bHWUPCFgPJlMM35u9LgXAHpY5Dh
/+jiViOgvDkYP1z5UDcqIL0c9AlS+fW4Cil/DnodLjO0BAlJPweX9IScfyYX
Eg8u+hx9vbSvVEh+uJia8OX96XYh8eHiwcJNGcvEIvLHxf5c+ek960XEi4t2
YUNZuZEi8stD/0sml7YCEfHjYe1KxdDKByLyz8PwPN/StEkR2uS95KH85pvz
B5eJaT/5aPf107/37BajDW8kHwOLbp1rSBPTvvLR2DX4VlCFGNnXCR97F7rv
bVGKaX8FuKGn8H6Yg4T4C/B8hB7MKKF9FmBJn0f2RZkE2dedAKOTvA9tvSwh
HkLUJG7/c6JZQjyE+LCpcN2NWQnxEKK5bN3lKG8p8RDiwRR1+5rPpMRDhKcU
x37SnpISDxHGf+s8UlctJR4iPK0ri/5hTEo8RJh1Q2FOdJtHPMRYvXgk8fOP
5uH//Y/zTg==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw9lAtQVGUUx5ddYA1SM+8TRBQxtzLDIBsqOUeI8YE28RgBX+Ogbio+yGlQ
SRE1GMGZyETBTEfcDTcYNzMcF+IhaIgKMoiBioKwCPKQkF2WhwKxy7mdmTt3
7r3fPef///+++WZG7QzZJJfJZJvGLutdKs+U86qU8wwapid2BhvOwsq84fV/
//+sB31ByaJYDYNOdZqYhU5XAVRVx05rpe9FUGw0KX2yGPTxttZ16AVLkJ9O
Wn8Toiu0/YZsBpvjGP3iptsw6tWefv6i9P9dKFj7+OLgJQaXNFkXVMPnex79
XpAr9asBX/sTTh0GBt2ty6f/A5efzvRIKJT618H8SofQ/aUMWlRrUkv7HsC9
pb6mxpvSvEdQXPpOaFYlgxW2egw9XGbR3RppfgMkZVfvD3/EYIjtxVPwDnar
9WuS9DQBHz/qdPg5g362gc1Q51+/zqNH0meEzmslU10HGHzXOl7VAk13P9gW
LWNJ7zNIyMrNmfIGi+xYszimFV4dzeHffJsl/W2QuLO0P8KVxXEazyH27PGT
Fk+W/DyH4ByVv3Eei13BVoHtsKz42+Vuviz564A76TecNQEs1tri6AT1Ps/6
XV+y5LcL7iUUuByNZHFM3FjDF+Cxa5ZXx0aW/HdDW5Uu6YcYFm3y9P/CnE9P
psbuYymPHogv3Fx67ojUrwdmb5WfcT7BUj4vYbn2vuZKptT/JbSeUkSd0bOU
Vy9UBB3eUvKXNK8XRtPmhc64xVJ+Jlia8aDIUCvNN8Gl1xGhyS0s5WmGbZHH
i37sZVFrtacxQ5133JVKGUf59kFU+0Sz32QOfz5lrT540hi+0OjGUd4W2LIi
anXeXA5TbQItkN811/3aZxzl3w9q49n1lmUc2tol9sMiVezIqlUc8RiACJ1P
Q9cWDr+zxh03AOrtzl3ZezniMwB/Dl93SUvm8BurvJhBuOCl23DhFEe8BuGg
bnOZ8TcOv1ZbawicZ8mXLsnniN8QpFZk9tfc5tBmd80rKCg60pJYzxHPV3Cm
unvO2i6OeLyGmKaWxohhjni8hrasBV57JvHEYxjiApb757vzxGMYdmQ4B06f
zxOPETAcytum8eeJxwjkvVXfuySMJx6jMK2M4yapeeIxCitlnEvvbp7ylGFe
snqxOZknPTLMjV7TOfUXnvKV4XEnc/hXep70yfBWRq5Rd42nvO2wqu2n9mk1
kl475LX3y3Oe8ZS/HbqPmFrCBiT9dth8+/CvvLNAPOS4YAYTa3ITyI8cD8Xw
ZW1eAvGRo8t75RPMAQL5k2NYw6QrfLhAvOTo27M5MGSrQH4V2F1V9Ylmv0D8
FNhffG6i0zGB/CswXpUYlKQV0CavU4H87tV7eYNA+9Mev0+Z4VF4R0AbXrU9
5uY8rIltFGi/2mPQlAPuX5gEHD9O7BFftGZ4KkXavw6YqfijlncVib8Dppd/
tMvtQ5H2swM6KjYqPw4Qcfy4c0DefMdnXbhIPBxx9siO0xnRIvFwxLDKggbj
AZF4OOKNoXgtpInEwxGj3i9Py9GJxEOJT7KMkXMKReKhxMINgecuV4vEQ4kP
k+K4Fa0i8VDi1RCX7ZYhkXhMwIOJV1fqJ7vgf8Ho0gA=
     "]]}},
  AspectRatio->NCache[GoldenRatio, 1.618033988749895],
  Axes->None,
  AxesOrigin->{0, 0},
  Frame->True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.466086027961499*^9, {3.466086067398335*^9, 3.466086077718972*^9}, 
   3.466086252384753*^9, 3.523353547580832*^9, 
   3.524504765118313*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Chop", "[", 
   RowBox[{
    RowBox[{"GroundStateProperties", "[", 
     RowBox[{"Hamiltonian", "[", "0.0", "]"}], "]"}], ",", 
    SuperscriptBox["10", 
     RowBox[{"-", "6"}]]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.466082762416947*^9, 3.466082774674736*^9}, {
  3.466086202186468*^9, 3.466086226260439*^9}, {3.466086332963504*^9, 
  3.4660863518735*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Energy\"\>", "\<\"Relative_Energy\"\>", "\<\"Ssqr\"\>", "\<\"Lsqr\"\
\>", "\<\"Jsqr\"\>", "\<\"Lx\"\>", "\<\"Ly\"\>", "\<\"Lz\"\>", "\<\"Sx\"\>", \
"\<\"Sy\"\>", "\<\"Sz\"\>", "\<\"Neg\"\>", "\<\"Nt2g\"\>", "\<\"Nx2y2\"\>", "\
\<\"Nz2\"\>", "\<\"Nyz\"\>", "\<\"Nxz\"\>", "\<\"Nxy\"\>"},
    {
     RowBox[{"-", "1.2443310657596403`"}], "0", "2.0000000000000004`", "12.`",
      "13.973450787969636`", 
     RowBox[{"-", "0.10033428111284251`"}], "0", 
     RowBox[{"-", "0.0009929247038949303`"}], "0.02863143317691623`", "0", 
     "0.991333504782691`", "3.7968927954189065`", "4.203107204581095`", 
     "1.7993657613748735`", "1.997527034044033`", "1.201074573824054`", 
     "1.2029468663471905`", "1.7990857644098508`"},
    {
     RowBox[{"-", "1.24433106575964`"}], "0", "1.9999999999999991`", 
     "11.999999999999995`", "14.980635722300937`", "0.14199443570048897`", 
     "0", 
     RowBox[{"-", "0.0114444293753563`"}], "0.07863997130139037`", "0", 
     RowBox[{"-", "0.9688048173399875`"}], "3.7781301626080053`", 
     "4.221869837391991`", "1.7960339364755586`", "1.9820962261324468`", 
     "1.210113912791912`", "1.2210369351917039`", "1.7907189894083755`"},
    {
     RowBox[{"-", "1.2443310657596394`"}], "0", "2.`", "12.000000000000002`", 
     "11.596950749312429`", 
     RowBox[{"-", "0.38739999449841694`"}], "0", "0.5287180225931525`", 
     "0.09774887783668937`", "0", 
     RowBox[{"-", "0.12062519206140539`"}], "3.036821462960629`", 
     "4.963178537039371`", "1.7935723864331705`", "1.2432490765274584`", 
     "1.7823932344874078`", "1.875137030413921`", "1.3056482721380422`"},
    {
     RowBox[{"-", "1.2443310657596391`"}], "0", "2.0000000000000004`", 
     "11.999999999999998`", "13.44746786730973`", 
     RowBox[{"-", "0.22137754097363344`"}], "0", 
     RowBox[{"-", "0.7403549972230953`"}], "0.0012015867458356835`", "0", 
     "0.05191418169041204`", "2.3034115645445663`", "5.696588435455434`", 
     "1.1713715522072776`", "1.1320400123372896`", "1.9278975983814448`", 
     "1.9047589066506276`", "1.863931930423361`"},
    {
     RowBox[{"-", "1.244331065759639`"}], "0", "2.000000000000001`", 
     "12.000000000000004`", "15.841722224015609`", "0.22189023917046968`", 
     "0", "0.021936877696262513`", "0.16154819398078335`", "0", 
     "0.14708851258785988`", "3.330428825436579`", "4.669571174563424`", 
     "1.7241960312569686`", "1.606232794179611`", "1.4731438558352046`", 
     "1.5395985663367138`", "1.6568287523915053`"},
    {
     RowBox[{"-", "1.2443310657596385`"}], "0", "2.`", "12.000000000000002`", 
     "12.83439694413785`", "0.1957030717157602`", "0", "0.5151882860390156`", 
     
     RowBox[{"-", "0.07030304153627123`"}], "0", 
     RowBox[{"-", "0.039710481286060584`"}], "3.3924069977170013`", 
     "4.607593002282999`", "1.6026370060765158`", "1.7897699916404843`", 
     "1.430182289097198`", "1.522321115143597`", "1.6550895980422036`"},
    {
     RowBox[{"-", "1.2443310657596385`"}], "0", "1.9999999999999998`", "12.`",
      "10.099767852570636`", "0.2095197447061335`", "0", 
     "0.7463627269533913`", 
     RowBox[{"-", "0.03676998540381785`"}], "0", 
     RowBox[{"-", "0.7604083093233414`"}], "3.356269331362728`", 
     "4.6437306686372715`", "1.683272995440937`", "1.6729963359217916`", 
     "1.5379521673172152`", "1.4125418769759863`", "1.693236624344069`"},
    {
     RowBox[{"-", "1.2443310657596385`"}], "0", "1.9999999999999993`", 
     "11.999999999999996`", "16.45831708152708`", "0.19588722452240714`", "0", 
     RowBox[{"-", "0.2714650443859715`"}], 
     RowBox[{"-", "0.012331919756201924`"}], "0", "0.11859963776012844`", 
     "3.5459624792735336`", "4.454037520726463`", "1.6972270236644484`", 
     "1.8487354556090847`", "1.403938609389285`", "1.3094646373276821`", 
     "1.7406342740094969`"},
    {
     RowBox[{"-", "1.2443310657596385`"}], "0", "2.000000000000001`", 
     "12.000000000000004`", "15.639375423952139`", 
     RowBox[{"-", "0.5684512703295193`"}], "0", "0.238857206325923`", 
     "0.15440148400245127`", "0", 
     RowBox[{"-", "0.0808544199489761`"}], "3.2763278040280728`", 
     "4.723672195971929`", "1.4862745361629055`", "1.7900532678651664`", 
     "1.601030322846841`", "1.4303232281500402`", "1.6923186449750485`"},
    {
     RowBox[{"-", "1.2443310657596385`"}], "0", "2.`", "12.`", "20.`", "0", 
     "0", 
     RowBox[{"-", "3.`"}], "0", "0", 
     RowBox[{"-", "1.`"}], "3.5`", "4.5`", "1.5`", "2.`", "1.5`", "1.5`", 
     "1.5`"},
    {
     RowBox[{"-", "1.2443310657596385`"}], "0", "2.`", "12.`", "18.`", "0", 
     "0", 
     RowBox[{"-", "2.`"}], "0", "0", 
     RowBox[{"-", "1.`"}], "2.5`", "5.5`", "1.5`", "1.`", "2.`", "2.`", 
     "1.5`"},
    {
     RowBox[{"-", "1.2443310657596385`"}], "0", "2.`", "12.`", "8.`", "0", 
     "0", 
     RowBox[{"-", "3.`"}], "0", "0", "1.`", "3.5`", "4.5`", "1.5`", "2.`", 
     "1.5`", "1.5`", "1.5`"},
    {
     RowBox[{"-", "1.2443310657596385`"}], "0", "2.`", "12.`", "10.`", "0", 
     "0", 
     RowBox[{"-", "2.`"}], "0", "0", "1.`", "2.5`", "5.5`", "1.5`", "1.`", 
     "2.`", "2.`", "1.5`"},
    {
     RowBox[{"-", "1.2443310657596385`"}], "0", "2.`", "12.`", "10.`", "0", 
     "0", "2.`", "0", "0", 
     RowBox[{"-", "1.`"}], "2.5`", "5.5`", "1.5`", "1.`", "2.`", "2.`", 
     "1.5`"},
    {
     RowBox[{"-", "1.2443310657596385`"}], "0", "2.`", "12.`", "18.`", "0", 
     "0", "2.`", "0", "0", "1.`", "2.5`", "5.5`", "1.5`", "1.`", "2.`", "2.`",
      "1.5`"},
    {
     RowBox[{"-", "1.2443310657596385`"}], "0", "2.`", "12.`", "8.`", "0", 
     "0", "3.`", "0", "0", 
     RowBox[{"-", "1.`"}], "3.5`", "4.5`", "1.5`", "2.`", "1.5`", "1.5`", 
     "1.5`"},
    {
     RowBox[{"-", "1.2443310657596385`"}], "0", "2.`", "12.`", "20.`", "0", 
     "0", "3.`", "0", "0", "1.`", "3.5`", "4.5`", "1.5`", "2.`", "1.5`", 
     "1.5`", "1.5`"},
    {
     RowBox[{"-", "1.2443310657596383`"}], "0", "1.9999999999999996`", "12.`",
      "12.57128155323583`", "0.039162800338481046`", "0", 
     RowBox[{"-", "0.7709845737237302`"}], "0.19535637693600114`", "0", 
     "0.5507997121739713`", "3.2721092653910384`", "4.727890734608959`", 
     "1.6365094314302848`", "1.6355998339607531`", "1.4235417805649513`", 
     "1.5813545337960242`", "1.7229944202479828`"},
    {
     RowBox[{"-", "1.244331065759638`"}], "0", "2.0000000000000004`", "12.`", 
     "16.873250461835298`", "0.15670468445606672`", "0", 
     RowBox[{"-", "0.714648835788774`"}], 
     RowBox[{"-", "0.027656246060706723`"}], "0", "0.14691064975477414`", 
     "3.2248234535741003`", "4.775176546425899`", "1.571881838847629`", 
     "1.6529416147264717`", "1.5558432868633965`", "1.6519604034181417`", 
     "1.5673728561443605`"},
    {
     RowBox[{"-", "1.244331065759638`"}], "0", "2.`", "11.999999999999998`", 
     "14.020744499876034`", "0.07935767238158806`", "0", 
     "0.9913453021042224`", "0.04404168674292493`", "0", 
     "0.0010014975287181462`", "3.335700716657554`", "4.664299283342446`", 
     "1.7354474926680206`", "1.6002532239895328`", "1.496869021608362`", 
     "1.5042612343958053`", "1.6631690273382786`"},
    {
     RowBox[{"-", "1.2443310657596376`"}], "0", "2.`", "11.999999999999996`", 
     "13.662638831956789`", "0.037343213923013`", "0", 
     RowBox[{"-", "0.5325176165111426`"}], 
     RowBox[{"-", "0.6145084179659972`"}], "0", 
     RowBox[{"-", "0.037244476318783144`"}], "3.5507151410272844`", 
     "4.449284858972718`", "1.9022100079614084`", "1.6485051330658744`", 
     "1.5560193469927255`", "1.444294665852566`", "1.4489708461274267`"},
    {"0.4138321995464822`", "1.6581632653061225`", "0", "6.`", "6.`", 
     RowBox[{"-", "0.0013404740174378928`"}], "0", "1.9666412528704207`", "0",
      "0", "0", "3.1476501498209277`", "4.8523498501790705`", 
     "1.7143201868140756`", "1.4333299630068526`", "1.5696449723103405`", 
     "1.5716306711328973`", "1.7110742067358329`"},
    {"0.4138321995464831`", "1.6581632653061233`", "0", "6.`", 
     "6.000000000000002`", "0.15971090243590952`", "0", 
     RowBox[{"-", "1.6470442659222209`"}], "0", "0", "0", 
     "3.1185329859645803`", "4.881467014035418`", "1.673864467475969`", 
     "1.444668518488611`", "1.491844507789451`", "1.735343164315463`", 
     "1.6542793419305053`"},
    {"0.41383219954648354`", "1.6581632653061238`", "0", "5.999999999999999`",
      "5.999999999999999`", 
     RowBox[{"-", "0.7052947561463595`"}], "0", 
     RowBox[{"-", "1.0224807698676115`"}], "0", "0", "0", 
     "3.387613393171037`", "4.612386606828962`", "1.565929824513112`", 
     "1.8216835686579242`", "1.5203392895857855`", "1.4966942510241577`", 
     "1.5953530662190192`"},
    {"0.413832199546484`", "1.6581632653061242`", "0", "6.`", "6.`", 
     "0.5469243277278876`", "0", 
     RowBox[{"-", "0.2971162170805884`"}], "0", "0", "0", 
     "2.9176320424720266`", "5.082367957527973`", "1.4744569497682714`", 
     "1.4431750927037548`", "1.9181712303144205`", "1.6963319135274821`", 
     "1.467864813686071`"},
    {"0.41383219954648465`", "1.658163265306125`", "0", "6.000000000000002`", 
     "6.000000000000001`", "0", "0", "1.0000000000000002`", "0", "0", "0", 
     "3.428571428571429`", "4.571428571428572`", "1.5714285714285714`", 
     "1.8571428571428577`", "1.5000000000000002`", "1.5000000000000002`", 
     "1.5714285714285718`"},
    {"0.7539682539682508`", "1.998299319727891`", "2.0000000000000004`", 
     "2.0000000000000004`", "3.2811798227261786`", 
     RowBox[{"-", "0.13983690106499466`"}], "0", 
     RowBox[{"-", "0.04746988197239911`"}], 
     RowBox[{"-", "0.012559336731631985`"}], "0", 
     RowBox[{"-", "0.9612063177615702`"}], "3.2000000000000006`", 
     "4.800000000000002`", "1.2284827787155435`", "1.9715172212844572`", 
     "1.7858123562861428`", "1.7857048649983154`", "1.2284827787155435`"},
    {"0.7539682539682524`", "1.9982993197278927`", "2.`", 
     "2.0000000000000004`", "4.098634731838381`", 
     RowBox[{"-", "0.0018691922504404477`"}], "0", "0.9998235502186674`", 
     RowBox[{"-", "0.32091159152274085`"}], "0", "0.05432808566159018`", 
     "3.1999999999999993`", "4.800000000000001`", "1.7999931404727891`", 
     "1.4000068595272108`", "1.5015699230410045`", "1.498436936486206`", 
     "1.7999931404727891`"},
    {"0.7539682539682528`", "1.998299319727893`", "2.`", "2.000000000000001`",
      "5.892289963722391`", "0.005248176010784293`", "0", 
     "0.9948238942300632`", "0.3201808277941104`", "0", "0.9411694468756775`",
      "3.2`", "4.800000000000001`", "1.7999839150763157`", 
     "1.400016084923684`", "1.5099880997886932`", "1.4900279851349918`", 
     "1.7999839150763157`"},
    {"0.7539682539682528`", "1.998299319727893`", "1.9999999999999998`", 
     "2.`", "4.371183032225968`", "0.06262331581215963`", "0", 
     RowBox[{"-", "0.08841484090562148`"}], "0.5950230133497243`", "0", 
     "0.6152075297143992`", "3.200000000000001`", "4.799999999999997`", 
     "1.2531066124411663`", "1.9468933875588337`", "1.7738576131102564`", 
     "1.773035774448577`", "1.2531066124411663`"},
    {"0.7539682539682535`", "1.9982993197278938`", "1.9999999999999998`", 
     "2.`", "4.613411150196232`", 
     RowBox[{"-", "0.02118838460114763`"}], "0", 
     RowBox[{"-", "0.934787573866667`"}], "0.019902711958357543`", "0", 
     RowBox[{"-", "0.019729449792897345`"}], "3.2`", "4.800000000000001`", 
     "1.7735911885966786`", "1.4264088114033207`", "1.5245940674474285`", 
     "1.5018147439558915`", "1.7735911885966786`"},
    {"0.7539682539682535`", "1.9982993197278938`", "1.9999999999999998`", 
     "2.0000000000000004`", "1.324024059460176`", 
     RowBox[{"-", "0.06186494363713175`"}], "0", 
     RowBox[{"-", "0.9279983525948061`"}], 
     RowBox[{"-", "0.1702602530215765`"}], "0", "0.8967719669430235`", 
     "3.1999999999999997`", "4.800000000000001`", "1.7725279396590936`", 
     "1.427472060340906`", "1.5070092254589498`", "1.5204628348819573`", 
     "1.7725279396590936`"},
    {"0.7539682539682542`", "1.9982993197278944`", "2.`", 
     "2.0000000000000004`", "2.138408537772123`", "0.0297427816115258`", "0", 
     "0.9557569306440439`", 
     RowBox[{"-", "0.016669060171680874`"}], "0", 
     RowBox[{"-", "0.9696056186324218`"}], "3.1999999999999997`", 
     "4.799999999999999`", "1.7988940449649375`", "1.4011059550350624`", 
     "1.4831445671170305`", "1.5179613879180316`", "1.7988940449649375`"},
    {"0.7539682539682548`", "1.998299319727895`", "2.0000000000000004`", 
     "2.000000000000001`", "5.4262780947148`", "0.235091647512007`", "0", 
     RowBox[{"-", "0.653979044866023`"}], "0.11251683821718617`", "0", 
     RowBox[{"-", "0.6210217823174305`"}], "3.1999999999999997`", 
     "4.799999999999999`", "1.5941619552627773`", "1.6058380447372238`", 
     "1.601872648105652`", "1.6039653966315721`", "1.5941619552627773`"},
    {"0.7539682539682551`", "1.9982993197278953`", "2.`", 
     "2.0000000000000004`", "4.8545906073437575`", 
     RowBox[{"-", "0.10794649939276227`"}], "0", 
     RowBox[{"-", "0.29775468088725804`"}], 
     RowBox[{"-", "0.5272231498717483`"}], "0", "0.06408613930962921`", 
     "3.1999999999999993`", "4.799999999999998`", "1.3792584248106983`", 
     "1.8207415751893015`", "1.7121514996448437`", "1.7085900755444585`", 
     "1.3792584248106983`"},
    {"1.34637188208616`", "2.5907029478458004`", "0", "19.999999999999993`", 
     "19.999999999999993`", "0.18004637282432145`", "0", 
     "0.8819419276160838`", "0", "0", "0", "3.33471780762152`", 
     "4.665282192378479`", "1.679170942379248`", "1.6555468652422718`", 
     "1.4687661139541563`", "1.4188609704679744`", "1.7776551079563478`"},
    {"1.346371882086164`", "2.5907029478458043`", "0", "20.`", "20.`", 
     RowBox[{"-", "1.2643019274373206`"}], "0", 
     RowBox[{"-", "0.24154972544100362`"}], "0", "0", "0", 
     "2.9828555715840483`", "5.017144428415952`", "1.8983742674649802`", 
     "1.0844813041190684`", "1.6698688968147606`", "1.3792200807716062`", 
     "1.9680554508295829`"},
    {"1.3463718820861645`", "2.590702947845805`", "0", "19.99999999999999`", 
     "19.99999999999999`", "0.6151915703714245`", "0", 
     RowBox[{"-", "1.6855930582801526`"}], "0", "0", "0", 
     "3.3328832832457866`", "4.667116716754212`", "1.8472162994988175`", 
     "1.4856669837469696`", "1.2328662942679998`", "1.657334069405872`", 
     "1.7769163530803374`"},
    {"1.3463718820861654`", "2.5907029478458057`", "0", "20.000000000000004`",
      "20.000000000000004`", "0.5093424615638534`", "0", 
     RowBox[{"-", "0.8769291421005398`"}], "0", "0", "0", 
     "3.0883167835713317`", "4.91168321642867`", "1.933048733239707`", 
     "1.155268050331625`", "1.5358927617098697`", "1.4658634819100083`", 
     "1.9099269728087922`"},
    {"1.3463718820861672`", "2.5907029478458075`", "0", "20.`", "20.`", "0", 
     "0", 
     RowBox[{"-", "4.`"}], "0", "0", "0", "3.`", "5.`", "1.`", "2.`", "2.`", 
     "2.`", "1.`"},
    {"1.3463718820861672`", "2.5907029478458075`", "0", "20.`", "20.`", "0", 
     "0", "4.`", "0", "0", "0", "3.`", "5.`", "1.`", "2.`", "2.`", "2.`", 
     "1.`"},
    {"1.3463718820861685`", "2.590702947845809`", "0", "20.00000000000001`", 
     "20.000000000000007`", 
     RowBox[{"-", "0.05896708507291928`"}], "0", "0.9972986039788448`", "0", 
     "0", "0", "3.0616318834635874`", "4.938368116536414`", 
     "1.918072030643893`", "1.143559852819695`", "1.5000410328835945`", 
     "1.4999314575800025`", "1.938395626072818`"},
    {"1.3463718820861699`", "2.59070294784581`", "0", "19.999999999999996`", 
     "19.999999999999996`", 
     RowBox[{"-", "0.04015888484551734`"}], "0", "2.871087761613552`", "0", 
     "0", "0", "3.5198276654306575`", "4.480172334569341`", 
     "1.5535587143011385`", "1.966268951129519`", "1.5075660336584353`", 
     "1.4937910731533623`", "1.4788152277575435`"},
    {"1.3463718820861716`", "2.590702947845812`", "0", "20.`", "20.`", 
     "0.05884749259615915`", "0", 
     RowBox[{"-", "1.9462563673867854`"}], "0", "0", "0", 
     "3.479767005083065`", "4.520232994916935`", "1.570559012472216`", 
     "1.9092079926108494`", "1.4849988667111844`", "1.4849988667111724`", 
     "1.5502352614945774`"},
    {"5.158730158730155`", "6.403061224489795`", "0", "0", "0", "0", "0", "0",
      "0", "0", "0", "3.199999999999999`", "4.799999999999999`", 
     "1.5999999999999994`", "1.5999999999999996`", "1.6`", "1.6`", 
     "1.5999999999999994`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.466086227247417*^9, 3.466086255179283*^9}, {
   3.4660863266200333`*^9, 3.466086361991495*^9}, 3.466086446701502*^9, 
   3.466086482546035*^9, 3.523353553175832*^9, 3.524504766123851*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Chop", "[", 
   RowBox[{
    RowBox[{"GroundStateProperties", "[", 
     RowBox[{"Hamiltonian", "[", "1.0", "]"}], "]"}], ",", 
    SuperscriptBox["10", 
     RowBox[{"-", "6"}]]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.466082832465639*^9, 3.4660828326310387`*^9}, {
   3.466086272304007*^9, 3.466086274454055*^9}, {3.466086339179538*^9, 
   3.466086348994314*^9}, 3.4660864240649776`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Energy\"\>", "\<\"Relative_Energy\"\>", "\<\"Ssqr\"\>", "\<\"Lsqr\"\
\>", "\<\"Jsqr\"\>", "\<\"Lx\"\>", "\<\"Ly\"\>", "\<\"Lz\"\>", "\<\"Sx\"\>", \
"\<\"Sy\"\>", "\<\"Sz\"\>", "\<\"Neg\"\>", "\<\"Nt2g\"\>", "\<\"Nx2y2\"\>", "\
\<\"Nz2\"\>", "\<\"Nyz\"\>", "\<\"Nxz\"\>", "\<\"Nxy\"\>"},
    {
     RowBox[{"-", "2.4443310657596395`"}], "0", "2.`", "12.`", 
     "13.999999999999998`", "0", "0", "0", "0.06777217409200728`", "0", 
     "0.00733573775681354`", "1.9999999999999996`", "5.999999999999998`", 
     "1.`", "1.`", "2.`", "2.`", "2.`"},
    {
     RowBox[{"-", "2.444331065759639`"}], "0", "1.9999999999999996`", "12.`", 
     "14.`", "0", "0", "0", 
     RowBox[{"-", "0.14148221492466195`"}], "0", "0.9899407774211635`", 
     "1.9999999999999996`", "6.`", "0.9999999999999999`", 
     "0.9999999999999998`", "1.9999999999999996`", "1.9999999999999996`", 
     "2.`"},
    {
     RowBox[{"-", "2.444331065759638`"}], "0", "1.9999999999999993`", 
     "11.999999999999996`", "13.999999999999996`", "0", "0", "0", 
     "0.07371004083265463`", "0", 
     RowBox[{"-", "0.997276515177977`"}], "1.9999999999999993`", 
     "5.999999999999998`", "0.9999999999999999`", "0.9999999999999997`", 
     "1.9999999999999993`", "1.9999999999999993`", "1.9999999999999996`"},
    {
     RowBox[{"-", "1.4443310657596413`"}], "0.9999999999999982`", "2.`", 
     "12.000000000000002`", "13.956237514867283`", 
     RowBox[{"-", "0.3178724850799585`"}], "0", 
     RowBox[{"-", "0.325132857526712`"}], "0.7686889337549981`", "0", 
     RowBox[{"-", "0.3323250648777146`"}], "3.0000000000000004`", "5.`", 
     "1.4955372494022903`", "1.5044627505977102`", "1.652701598427476`", 
     "1.674681400775578`", "1.6726170007969468`"},
    {
     RowBox[{"-", "1.4443310657596404`"}], "0.9999999999999991`", 
     "2.000000000000001`", "12.000000000000005`", "14.476167981449453`", 
     "0.24557706782136332`", "0", 
     RowBox[{"-", "0.012722540187742555`"}], "0.5210957499541572`", "0", 
     RowBox[{"-", "0.11968951852444962`"}], "3.0000000000000013`", 
     "5.000000000000002`", "1.6662357936990104`", "1.3337642063009907`", 
     "1.953525786424254`", "1.6014552718410944`", "1.445018941734654`"},
    {
     RowBox[{"-", "1.4443310657596395`"}], "1.`", "2.`", 
     "11.999999999999998`", "13.938496677714992`", 
     RowBox[{"-", "0.1133086648098241`"}], "0", 
     RowBox[{"-", "0.012552934957119715`"}], 
     RowBox[{"-", "0.18563312447442312`"}], "0", "0.5397690609956006`", "3.`",
      "5.`", "1.8951941168066675`", "1.1048058831933323`", 
     "1.9798265778787336`", "1.8804322445301564`", "1.1397411775911097`"},
    {
     RowBox[{"-", "1.444331065759639`"}], "1.0000000000000004`", 
     "2.0000000000000004`", "11.999999999999998`", "12.988342272753215`", 
     "0.15568727310035224`", "0", "0.40140508268938924`", 
     RowBox[{"-", "0.050969873208426046`"}], "0", 
     RowBox[{"-", "0.6464900321280608`"}], "3.0000000000000004`", 
     "4.999999999999999`", "1.3662598759989866`", "1.633740124001014`", 
     "1.4493967074222722`", "1.705616460576376`", "1.844986832001352`"},
    {
     RowBox[{"-", "1.444331065759639`"}], "1.0000000000000004`", 
     "2.0000000000000004`", "12.000000000000004`", "14.57066957519149`", 
     RowBox[{"-", "0.15520979470259305`"}], "0", 
     RowBox[{"-", "0.10482318658009626`"}], 
     RowBox[{"-", "0.5531196533432`"}], "0", "0.14561837067720368`", 
     "3.0000000000000004`", "5.000000000000002`", "1.5699197952241184`", 
     "1.4300802047758823`", "1.5048553975801953`", "1.9217043293852962`", 
     "1.5734402730345094`"},
    {
     RowBox[{"-", "1.4443310657596387`"}], "1.0000000000000009`", 
     "2.000000000000001`", "12.000000000000009`", "14.73691192598406`", 
     RowBox[{"-", "0.16697866794964322`"}], "0", "0.3420850394012406`", 
     RowBox[{"-", "0.618463374958019`"}], "0", "0.29217248318706107`", 
     "3.0000000000000013`", "5.000000000000003`", "1.400416622155466`", 
     "1.5995833778445354`", "1.635070433267867`", "1.5654850629394215`", 
     "1.7994445037927134`"},
    {
     RowBox[{"-", "1.4443310657596384`"}], "1.000000000000001`", 
     "1.9999999999999998`", "12.000000000000002`", "13.882039251657401`", 
     RowBox[{"-", "0.07281244305797611`"}], "0", "0.2738603020642478`", 
     "0.5764421855896567`", "0", "0.3512539627269348`", "3.0000000000000004`",
      "4.999999999999999`", "1.2976329964192805`", "1.7023670035807192`", 
     "1.5802471696543043`", "1.4832634922380694`", "1.936489338107626`"},
    {
     RowBox[{"-", "1.444331065759638`"}], "1.0000000000000016`", 
     "2.0000000000000004`", "12.000000000000002`", "13.350670755179937`", 
     "0.1681725386387388`", "0", 
     RowBox[{"-", "0.16696611273210824`"}], "0.09175130288393098`", "0", 
     "0.5245981743366225`", "3.0000000000000004`", "5.000000000000002`", 
     "1.4015327385508465`", "1.5984672614491537`", "1.6395291215160093`", 
     "1.5625145298851206`", "1.7979563485988712`"},
    {
     RowBox[{"-", "1.4443310657596369`"}], "1.0000000000000027`", "2.`", 
     "11.999999999999998`", "14.100464045202182`", "0.25674517603953817`", 
     "0", 
     RowBox[{"-", "0.39515279217111215`"}], 
     RowBox[{"-", "0.5497921461986751`"}], "0", 
     RowBox[{"-", "0.7549074363931976`"}], "3.`", "4.999999999999999`", 
     "1.4072708117433355`", "1.5927291882566652`", "1.6048472078288907`", 
     "1.6048472078288902`", "1.7903055843422198`"},
    {
     RowBox[{"-", "0.7506689892189116`"}], "1.693662076540728`", 
     "2.0000000000000004`", "11.339915812106335`", "12.788603698842365`", 
     RowBox[{"-", "0.26938721629691337`"}], "0", 
     RowBox[{"-", "0.3850320545336898`"}], 
     RowBox[{"-", "0.1382090349210554`"}], "0", 
     RowBox[{"-", "0.5949828827225899`"}], "3.561757498177628`", 
     "4.4382425018223755`", "1.6704354048760197`", "1.8913220933016082`", 
     "1.4558295831860473`", "1.461495370011528`", "1.520917548624799`"},
    {
     RowBox[{"-", "0.7506689892189111`"}], "1.6936620765407284`", "2.`", 
     "11.33991581210633`", "14.87437427902935`", "0.01720393151730129`", "0", 
     
     RowBox[{"-", "1.333957365669084`"}], 
     RowBox[{"-", "0.7212758639009149`"}], "0", 
     RowBox[{"-", "0.5961396943877446`"}], "3.5617574981776268`", 
     "4.438242501822373`", "1.8903045002941983`", "1.6714529978834287`", 
     "1.500757276500387`", "1.4991920392552998`", "1.4382931860666863`"},
    {
     RowBox[{"-", "0.7506689892189089`"}], "1.6936620765407306`", 
     "1.9999999999999996`", "11.339915812106325`", "13.02124349018532`", 
     "0.19622564436533824`", "0", "0.18584622297157455`", 
     RowBox[{"-", "0.12904510738270122`"}], "0", "0.8039881122060865`", 
     "3.5617574981776263`", "4.438242501822373`", "1.6228998947989335`", 
     "1.9388576033786924`", "1.4540342667421342`", "1.4454273700510896`", 
     "1.53878086502915`"},
    {
     RowBox[{"-", "0.7506689892189071`"}], "1.6936620765407324`", 
     "2.000000000000001`", "11.33991581210633`", "13.558612823564884`", 
     RowBox[{"-", "0.21656715096074533`"}], "0", 
     RowBox[{"-", "0.140631716318328`"}], 
     RowBox[{"-", "0.16205603498463939`"}], "0", "0.6876601843167871`", 
     "3.5617574981776277`", "4.438242501822375`", "1.8135139958433653`", 
     "1.7482435023342617`", "1.5171129606572211`", "1.4539793369318237`", 
     "1.4671502042333304`"},
    {
     RowBox[{"-", "0.7506689892189069`"}], "1.6936620765407326`", 
     "2.0000000000000004`", "11.339915812106332`", "12.046511402247841`", 
     RowBox[{"-", "0.12335696638886014`"}], "0", "0.7195966585791362`", 
     RowBox[{"-", "0.19692665611116025`"}], "0", 
     RowBox[{"-", "0.28155561382629574`"}], "3.5617574981776254`", 
     "4.438242501822374`", "1.817258829703421`", "1.7444986684742052`", 
     "1.4868404364137113`", "1.4856591281219877`", "1.4657429372866744`"},
    {
     RowBox[{"-", "0.7506689892189069`"}], "1.6936620765407326`", 
     "1.9999999999999991`", "11.339915812106321`", "12.754333287828937`", 
     RowBox[{"-", "0.2326274382744092`"}], "0", "1.2698407118420496`", 
     "0.9515362107348349`", "0", 
     RowBox[{"-", "0.15624526784609588`"}], "3.561757498177624`", 
     "4.438242501822373`", "1.8778667457088456`", "1.6838907524687792`", 
     "1.5061917531611007`", "1.4890835926475388`", "1.4429671560137334`"},
    {
     RowBox[{"-", "0.7506689892189067`"}], "1.6936620765407329`", "2.`", 
     "11.339915812106334`", "14.183435416615861`", "0.10700264444610005`", 
     "0", "0.5854082230468978`", "0.06726727259189792`", "0", 
     "0.65348260221492`", "3.561757498177627`", "4.438242501822374`", 
     "1.882572911997062`", "1.6791845861805652`", "1.4563801098211409`", 
     "1.5406637609769565`", "1.4411986310242761`"},
    {
     RowBox[{"-", "0.7506689892189053`"}], "1.6936620765407342`", 
     "1.9999999999999996`", "11.33991581210633`", "12.283947563992287`", 
     RowBox[{"-", "0.0374138514721`"}], "0", "0.03462213310617017`", 
     RowBox[{"-", "0.06872735377459147`"}], "0", "0.014720819027691665`", 
     "3.5617574981776263`", "4.438242501822372`", "1.6501147072023887`", 
     "1.9116427909752374`", "1.4599587752720775`", "1.4497298855724199`", 
     "1.5285538409778745`"},
    {
     RowBox[{"-", "0.7506689892189033`"}], "1.6936620765407362`", 
     "2.000000000000001`", "11.339915812106328`", "14.548180346650119`", 
     "0.5589204030642889`", "0", 
     RowBox[{"-", "0.9356928130247152`"}], "0.3974365677483292`", "0", 
     RowBox[{"-", "0.5309282589827591`"}], "3.561757498177627`", 
     "4.438242501822375`", "1.8029417513750856`", "1.7588157468025414`", 
     "1.4776223437132994`", "1.4894970218984758`", "1.471123136210599`"},
    {
     RowBox[{"-", "0.4820629730807213`"}], "1.9622680926789182`", "0", 
     "9.331081354281226`", "9.331081354281226`", "0", "0", "0", "0", "0", "0",
      "2.0822215738988437`", "5.9177784261011555`", "1.0411107869494254`", 
     "1.0411107869494183`", "1.983688849201382`", "1.9887478761357533`", 
     "1.9453417007640188`"},
    {
     RowBox[{"-", "0.4820629730807211`"}], "1.9622680926789184`", "0", 
     "9.331081354281253`", "9.33108135428125`", "0", "0", "0", "0", "0", "0", 
     "2.0822215738988428`", "5.917778426101158`", "1.0411107869494214`", 
     "1.0411107869494214`", "1.9614967681993891`", "1.956437741265018`", 
     "1.999843916636751`"},
    {"0.4493370018317857`", "2.8936680675914253`", "0", "7.849385660103321`", 
     "7.849385660103325`", 
     RowBox[{"-", "0.13289524917583423`"}], "0", "0.009038182427480192`", "0",
      "0", "0", "3.1123172654020084`", "4.887682734597992`", 
     "1.9866049115093234`", "1.1257123538926852`", "1.8841685653585212`", 
     "1.875596601811087`", "1.1279175674283828`"},
    {"0.44933700183178704`", "2.8936680675914266`", "0", "7.849385660103322`",
      "7.849385660103321`", "0.0577019673743816`", "0", 
     "0.43290192248359627`", "0", "0", "0", "3.112317265402009`", 
     "4.887682734597991`", "1.3434380727791218`", "1.7688791926228873`", 
     "1.2845972514339288`", "1.7261174750070882`", "1.8769680081569742`"},
    {"0.4493370018317937`", "2.8936680675914332`", "0", "7.849385660103328`", 
     "7.84938566010333`", "0.07519328180145318`", "0", 
     RowBox[{"-", "0.4419401049110885`"}], "0", "0", "0", 
     "3.1123172654020093`", "4.887682734597994`", "1.3384329138145663`", 
     "1.7738843515874432`", "1.7189169178055423`", "1.2859686577798164`", 
     "1.882797159012635`"},
    {"0.7296238664270573`", "3.173954932186697`", "0", "19.066918584650217`", 
     "19.066918584650217`", "0", "0", "0", "0", "0", "0", 
     "2.405389951511312`", "5.594610048488691`", "1.2026949757556522`", 
     "1.2026949757556602`", "1.864870016162897`", "1.8648700161628966`", 
     "1.8648700161628966`"},
    {"0.8603061774275167`", "3.3046372431871562`", "1.9999999999999991`", 
     "2.6600841878936667`", "4.206982895080519`", "0.030607872202469223`", 
     "0", "0.8262242593777899`", 
     RowBox[{"-", "0.6027073951149556`"}], "0", 
     RowBox[{"-", "0.1280843384188853`"}], "3.438242501822372`", 
     "4.5617574981776245`", "1.855648007981626`", "1.5825944938407455`", 
     "1.50260051868909`", "1.4985465170208112`", "1.5606104624677233`"},
    {"0.8603061774275171`", "3.3046372431871567`", "2.`", "2.66008418789367`",
      "5.428785425964062`", "0.5945966854604974`", "0", "0.3281557819252967`",
      "0.023407076022948524`", "0", "0.48906183968489503`", 
     "3.4382425018223737`", "4.561757498177626`", "1.6512816849602856`", 
     "1.786960816862088`", "1.5351439000653313`", "1.5259158339767516`", 
     "1.500697764135544`"},
    {"0.8603061774275171`", "3.3046372431871567`", "1.9999999999999998`", 
     "2.6600841878936707`", "5.220367317532736`", 
     RowBox[{"-", "0.4792911749125476`"}], "0", "0.3769493543957841`", 
     RowBox[{"-", "0.16783059599479855`"}], "0", "0.635476234899498`", 
     "3.4382425018223737`", "4.561757498177626`", "1.6727313662746326`", 
     "1.765511135547741`", "1.520422946661469`", "1.5343485287922656`", 
     "1.5069860227238903`"},
    {"0.860306177427518`", "3.3046372431871576`", "1.9999999999999998`", 
     "2.6600841878936694`", "3.47042803225567`", "0.2754344699354177`", "0", 
     "0.1203956156251625`", "0.40378212120087376`", "0", 
     RowBox[{"-", "0.30050301516765016`"}], "3.438242501822373`", 
     "4.561757498177627`", "1.7184308906284038`", "1.7198116111939699`", 
     "1.4896709989883898`", "1.5517030547372777`", "1.5203834444519584`"},
    {"0.8603061774275202`", "3.30463724318716`", "2.`", "2.6600841878936707`",
      "4.155044056689748`", 
     RowBox[{"-", "0.011126034717699676`"}], "0", 
     RowBox[{"-", "0.4398561232413759`"}], "0.1879980953421348`", "0", 
     RowBox[{"-", "0.22403919063471922`"}], "3.438242501822374`", 
     "4.561757498177627`", "1.8401600722859375`", "1.5980824295364366`", 
     "1.5328716786033005`", "1.472815850889559`", "1.5560699686847674`"},
    {"0.8603061774275211`", "3.3046372431871607`", "2.0000000000000004`", 
     "2.660084187893668`", "5.518594830120905`", "0.007454463662499212`", "0", 
     RowBox[{"-", "0.33093826090310197`"}], "0.33624249856904087`", "0", 
     RowBox[{"-", "0.29057355724299044`"}], "3.4382425018223746`", 
     "4.561757498177626`", "1.6197734297415456`", "1.8184690720808276`", 
     "1.5401571034454886`", "1.5301396935431`", "1.4914607011890384`"},
    {"0.8603061774275211`", "3.3046372431871607`", "1.9999999999999996`", 
     "2.660084187893671`", "4.588191087040933`", "0.1867571663631034`", "0", 
     RowBox[{"-", "0.2726408160683904`"}], "0.14524933089810144`", "0", 
     "0.00876646085363914`", "3.4382425018223732`", "4.5617574981776245`", 
     "1.6842951160860633`", "1.7539473857363095`", "1.5040299652652596`", 
     "1.547351443548343`", "1.5103760893640221`"},
    {"0.8603061774275216`", "3.304637243187161`", "2.`", 
     "2.6600841878936703`", "3.6580616667854446`", 
     RowBox[{"-", "0.24001855854419332`"}], "0", 
     RowBox[{"-", "0.2429652603441439`"}], "0.10024052644441558`", "0", 
     "0.14856732283566929`", "3.4382425018223737`", "4.5617574981776245`", 
     "1.7644899612701914`", "1.673752540552182`", "1.5237422627746018`", 
     "1.504128963459601`", "1.533886271943423`"},
    {"0.860306177427522`", "3.3046372431871616`", "1.9999999999999998`", 
     "2.660084187893669`", "5.6943023795730054`", 
     RowBox[{"-", "0.3644148894495454`"}], "0", 
     RowBox[{"-", "0.36532455076702014`"}], 
     RowBox[{"-", "0.42638165736776035`"}], "0", 
     RowBox[{"-", "0.3386717568094563`"}], "3.4382425018223723`", 
     "4.561757498177625`", "1.6652807289719933`", "1.7729617728503795`", 
     "1.5366331200399468`", "1.520322608565169`", "1.5048017695725087`"},
    {"1.1463718820861741`", "3.5907029478458137`", "0", "19.999999999999996`",
      "19.999999999999996`", "0", "0", 
     RowBox[{"-", "0.5000000000000054`"}], "0", "0", "0", 
     "2.9999999999999996`", "5.`", "1.7500000000000013`", 
     "1.249999999999998`", "1.5000000000000102`", "1.4999999999999896`", 
     "1.9999999999999998`"},
    {"1.146371882086175`", "3.5907029478458146`", "0", "19.999999999999996`", 
     "19.999999999999996`", "0", "0", "0.500000000000007`", "0", "0", "0", 
     "2.9999999999999996`", "5.`", "1.7500000000000009`", 
     "1.2499999999999987`", "1.4999999999999896`", "1.50000000000001`", 
     "1.9999999999999996`"},
    {"1.1463718820861755`", "3.590702947845815`", "0", "19.999999999999996`", 
     "19.999999999999996`", "0", "0", "0", "0", "0", "0", 
     "2.999999999999999`", "4.999999999999999`", "0.9999999999999998`", 
     "1.9999999999999996`", "1.9999999999999996`", "1.9999999999999996`", 
     "0.9999999999999999`"},
    {"1.8422670547133837`", "4.286598120473023`", "0", "16.668918645718747`", 
     "16.668918645718747`", "0", "0", "0", "0", "0", "0", 
     "3.9177784261011563`", "4.082221573898841`", "1.9588892130505782`", 
     "1.9588892130505782`", "1.041110783005596`", "1.0411107908932462`", 
     "1.9999999999999996`"},
    {"1.8422670547133846`", "4.286598120473024`", "0", "16.668918645718765`", 
     "16.66891864571877`", "0", "0", "0", "0", "0", "0", "3.917778426101155`",
      "4.082221573898842`", "1.9588892130505777`", "1.9588892130505773`", 
     "1.6803702662602982`", "1.6803702583726479`", "0.7214810492658967`"},
    {"1.9108670798008518`", "4.355198145560491`", "0", "18.15061433989667`", 
     "18.15061433989667`", 
     RowBox[{"-", "0.2545323174852856`"}], "0", "0.048997169934299485`", "0", 
     "0", "0", "3.8876827345979903`", "4.112317265402008`", 
     "1.9966600883107843`", "1.8910226462872066`", "1.1399098755809598`", 
     "1.1154667640129832`", "1.8569406258080647`"},
    {"1.9108670798008562`", "4.355198145560496`", "0", "18.150614339896666`", 
     "18.150614339896666`", "0.5121649661924499`", "0", "1.972237095712047`", 
     "0", "0", "0", "3.8876827345979903`", "4.112317265402007`", 
     "1.918423177099677`", "1.969259557498313`", "1.4755313195060291`", 
     "1.4999744311676797`", "1.1368115147282982`"},
    {"1.9108670798008731`", "4.355198145560513`", "0", "18.150614339896677`", 
     "18.150614339896684`", 
     RowBox[{"-", "0.25763264870716834`"}], "0", 
     RowBox[{"-", "2.0212342656463593`"}], "0", "0", "0", 
     "3.8876827345979925`", "4.112317265402009`", "1.916440836486524`", 
     "1.9712418981114683`", "1.4968760703150192`", "1.4968760702213453`", 
     "1.1185651248656452`"},
    {"5.375478174389282`", "7.819809240148921`", "0", "0.9330814153497903`", 
     "0.9330814153497903`", "0", "0", "0", "0", "0", "0", 
     "3.5946100484886894`", "4.405389951511314`", "1.7973050242443451`", 
     "1.7973050242443447`", "1.4684633171704378`", "1.4684633171704378`", 
     "1.4684633171704375`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.466082833357802*^9, 3.466084065381819*^9, {3.466086275359989*^9, 
   3.466086287943673*^9}, {3.466086340040854*^9, 3.466086365183564*^9}, {
   3.466086406950326*^9, 3.46608644885184*^9}, 3.466086484597069*^9, 
   3.523353556903653*^9, 3.52450476649137*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The idea of temperature averaging", "Subsection",
 CellChangeTimes->{{3.46608246058114*^9, 3.466082474199586*^9}, 
   3.466085578278118*^9, {3.466088646585359*^9, 3.4660886522306356`*^9}}],

Cell[CellGroupData[{

Cell["Define basis", "Subsubsection",
 CellChangeTimes->{{3.466082118798918*^9, 3.466082120792042*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CIBasisShellDegeneracy", "=", 
    RowBox[{"{", "10", "}"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "there", " ", "are", " ", "10", " ", "fermions", " ", "in", " ", "a", " ", 
    "d", " ", "shell", " ", "5", " ", "orbitals", " ", "each", " ", "with", 
    " ", "either", " ", "spin", " ", "up", " ", "or", " ", "down"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CIBasisShellFilling", "=", 
    RowBox[{"{", 
     RowBox[{"{", "8", "}"}], "}"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"I", " ", "have", " ", "one", " ", "configuration"}], ",", " ", 
    RowBox[{"which", " ", "has", " ", "9", " ", "electrons"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CIBasis", "=", 
    RowBox[{"{", 
     RowBox[{"CIBasisShellDegeneracy", ",", "CIBasisShellFilling"}], "}"}]}], 
   ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "In", " ", "order", " ", "to", " ", "pass", " ", "the", " ", "basis", " ", 
    "around", " ", "I", " ", "create", " ", "a", " ", "list", " ", "of", " ", 
    "them"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CIBasisFull", "=", 
    RowBox[{"CISetMultiplicity", "[", "CIBasis", "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "I", " ", "need", " ", "in", " ", "almost", " ", "all", " ", 
     "subroutines", " ", "information", " ", "about", " ", "the", " ", 
     "multiplicity", " ", "of", " ", "the", " ", "basis"}], ",", " ", 
    RowBox[{
    "so", " ", "I", " ", "calcualte", " ", "it", " ", "once", " ", "and", " ",
      "pass", " ", "it", " ", "allong"}]}], " ", "*)"}]}]}], "Input",
 CellChangeTimes->{
  3.466085580831493*^9, {3.523353590938096*^9, 3.5233535934866877`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Define Operators", "Subsubsection",
 CellChangeTimes->{{3.466082118798918*^9, 3.466082142335805*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"Fdd", ",", "Eeg", ",", "Et2g"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Timing", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"OppSx", "=", 
      RowBox[{"CIOperatorSx", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppSy", "=", 
      RowBox[{"CIOperatorSy", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppSz", "=", 
      RowBox[{"CIOperatorSz", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppSsqr", "=", 
      RowBox[{"CIOperatorSsqr", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLx", "=", 
      RowBox[{"CIOperatorLx", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLy", "=", 
      RowBox[{"CIOperatorLy", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLz", "=", 
      RowBox[{"CIOperatorLz", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLsqr", "=", 
      RowBox[{"CIOperatorLsqr", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJx", "=", 
      RowBox[{"CIOperatorJx", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJy", "=", 
      RowBox[{"CIOperatorJy", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJz", "=", 
      RowBox[{"CIOperatorJz", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJsqr", "=", 
      RowBox[{"CIOperatorJsqr", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppCF", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "VOhd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Oppldots", "=", 
      RowBox[{"CIOperatorldots", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppU", "=", 
      RowBox[{"CIOperatorU", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Fdd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNeg", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnegd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNt2g", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnt2gd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNz2", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnz2d"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNx2y2", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnx2y2d"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNyz", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnyzd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNxz", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnxzd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNxy", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnxyd"}], "]"}]}], ";"}], "\[IndentingNewLine]", "]"}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4660778074018173`*^9, 3.466077831177351*^9}, {
  3.4660778798659077`*^9, 3.466077889735778*^9}, {3.4660829512058773`*^9, 
  3.4660829538541117`*^9}, {3.4660835755891857`*^9, 3.466083692904258*^9}, {
  3.4660859843251038`*^9, 3.466086009586051*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"27.09314899999999`", ",", "Null"}], "}"}]], "Print",
 CellChangeTimes->{3.466083706466501*^9, 3.466083919610579*^9, 
  3.466084053368881*^9, 3.466085613372122*^9, 3.466085979897192*^9, 
  3.466086018882333*^9, 3.4660891989637947`*^9, 3.466089484850807*^9, 
  3.523353625629615*^9, 3.5245047946261377`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create the Hamiltonian as a function of Magnetic Field", "Subsubsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "Hamiltonian", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eeg", "=", "0.6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Et2g", "=", 
   RowBox[{"-", "0.4"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fdd", "[", "2", "]"}], "=", "10.0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fdd", "[", "4", "]"}], "=", "6.25"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fdd", "[", "0", "]"}], "=", 
   RowBox[{
    FractionBox["14", "441"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Fdd", "[", "2", "]"}], "+", 
      RowBox[{"Fdd", "[", "4", "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Hamiltonian", "[", 
    RowBox[{"BmagX_", ",", "BmagY_", ",", "BmagZ_"}], "]"}], ":=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"OppCF", "+", "OppU", "+", 
     RowBox[{"BmagX", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "OppSx"}], "+", "OppLx"}], ")"}]}], "+", 
     RowBox[{"BmagY", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "OppSy"}], "+", "OppLy"}], ")"}]}], "+", 
     RowBox[{"BmagZ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "OppSz"}], "+", "OppLz"}], ")"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"Eeg", ",", "Et2g", ",", "Fdd"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4660778514661293`*^9, 3.4660778551711407`*^9}, {
   3.4660779037788553`*^9, 3.46607802956116*^9}, {3.466082259181775*^9, 
   3.466082289094554*^9}, {3.466082411016951*^9, 3.46608241717595*^9}, {
   3.466082791187235*^9, 3.466082809161236*^9}, {3.4660849476050386`*^9, 
   3.4660849607579107`*^9}, {3.466084996503484*^9, 3.466084999859572*^9}, {
   3.4660856176165113`*^9, 3.4660856779885*^9}, {3.466085770020152*^9, 
   3.466085771297245*^9}, {3.466085812235236*^9, 3.466085850074255*^9}, {
   3.46608588915528*^9, 3.46608589060625*^9}, 3.466086063206147*^9, {
   3.466086111824648*^9, 3.466086195010604*^9}, {3.466086244578319*^9, 
   3.466086247753295*^9}, {3.466086281474304*^9, 3.466086283311263*^9}, {
   3.4660863182946873`*^9, 3.46608632095697*^9}, {3.4660863561101103`*^9, 
   3.4660863582852*^9}, {3.466086399804905*^9, 3.466086402618618*^9}, {
   3.466086436700938*^9, 3.466086442491534*^9}, {3.4660864733914747`*^9, 
   3.466086476300633*^9}, {3.4660893221347437`*^9, 3.4660893886900578`*^9}, {
   3.466089470224725*^9, 3.466089514231423*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Temperature Average General small example", "Subsubsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"val", ",", "fun"}], "}"}], "=", 
   RowBox[{"CIEigensystem", "[", 
    RowBox[{
     RowBox[{"Hamiltonian", "[", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"1", "TeslaToeV"}]}], "]"}], ",", "45"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"val", "=", 
   RowBox[{"val", "-", 
    RowBox[{"val", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4660895789695873`*^9, 3.466089588382811*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "Z", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Z", "[", "T_", "]"}], ":=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], 
     RowBox[{"Length", "[", "val", "]"}]], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"val", "[", 
        RowBox[{"[", "i", "]"}], "]"}], 
       RowBox[{"kB", " ", "T"}]]}]]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4660896088413553`*^9, 3.4660896206394243`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mzi", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Conjugate", "[", 
      RowBox[{"fun", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "]"}], ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], "OppSz"}], "-", "OppLz"}], ")"}], ".", 
     RowBox[{"fun", "[", 
      RowBox[{"[", "i", "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "fun", "]"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4660896514211273`*^9, 3.466089654498136*^9}, {
  3.4660896858581057`*^9, 3.466089695366343*^9}, {3.466089778436915*^9, 
  3.4660897797135773`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.000463067187588`", ",", "0.0004630671875877068`", ",", 
   RowBox[{"-", "1.9995369328124137`"}], ",", "2.5005970364583727`", ",", 
   "1.999536932812412`", ",", "1.500596900989184`", ",", 
   "0.5005970364583693`", ",", 
   RowBox[{"-", "0.00046306718758781784`"}], ",", 
   RowBox[{"-", "0.49940309901082025`"}], ",", 
   RowBox[{"-", "1.4994029635416275`"}], ",", 
   RowBox[{"-", "2.0004630671875865`"}], ",", 
   RowBox[{"-", "2.4994030990108165`"}], ",", "3.3344220332615704`", ",", 
   "2.`", ",", "1.3344220332615735`", ",", "0.6644642766641276`", ",", 
   RowBox[{"-", "1.6263439615544813`*^-22"}], ",", 
   RowBox[{"-", "0.6655779667384303`"}], ",", 
   RowBox[{"-", "1.3355357233358691`"}], ",", 
   RowBox[{"-", "2.0000000000000004`"}], ",", 
   RowBox[{"-", "3.3355357233358736`"}], ",", "0.0004914619133599626`", ",", 
   "0.00015787291656060853`", ",", "0.5378031936322049`", ",", 
   RowBox[{"-", "0.0004815694550199118`"}], ",", 
   RowBox[{"-", "0.5375039142026061`"}], ",", "0.0017655079251777117`", ",", 
   "2.834938822346689`", ",", "1.9999999999999996`", ",", 
   "1.1649809302800582`", ",", "0.8349388223466894`", ",", 
   RowBox[{"-", "1.6283061391225763`*^-21"}], ",", 
   RowBox[{"-", "0.835019069719942`"}], ",", 
   RowBox[{"-", "1.165061177653311`"}], ",", 
   RowBox[{"-", "2.0000000000000004`"}], ",", 
   RowBox[{"-", "2.8350190697199418`"}], ",", "0.500191560600314`", ",", 
   RowBox[{"-", "0.0007316363995861774`"}], ",", 
   RowBox[{"-", "0.49980836017118785`"}], ",", "0.006616996252248208`", ",", 
   RowBox[{"-", "0.0011832304407878302`"}], ",", "2.037312274373794`", ",", 
   RowBox[{"-", "0.006626888710588141`"}], ",", 
   RowBox[{"-", "2.037994754232519`"}], ",", 
   RowBox[{"-", "8.514001363986445`*^-6"}]}], "}"}]], "Output",
 CellChangeTimes->{3.4660896964072113`*^9, 3.466089780676194*^9, 
  3.523353637569212*^9, 3.524504802721695*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Mztot", "[", "T_", "]"}], ":=", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"i", "=", "1"}], 
    RowBox[{"Length", "[", "val", "]"}]], 
   FractionBox[
    RowBox[{
     RowBox[{"Mzi", "[", 
      RowBox[{"[", "i", "]"}], "]"}], 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"val", "[", 
         RowBox[{"[", "i", "]"}], "]"}], 
        RowBox[{"kB", " ", "T"}]]}]]}], 
    RowBox[{"Z", "[", "T", "]"}]]}]}]], "Input",
 CellChangeTimes->{{3.466089723346403*^9, 3.46608974663291*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Mztot", "[", "T_", "]"}], ":=", 
  FractionBox[
   RowBox[{"Mzi", ".", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox["val", 
       RowBox[{"kB", " ", "T"}]]}]]}], 
   RowBox[{"Tr", "[", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox["val", 
       RowBox[{"kB", " ", "T"}]]}]], "]"}]]}]], "Input",
 CellChangeTimes->{{3.4660897309604883`*^9, 3.46608974936817*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Mztot", "[", "T", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "0.1", ",", "1000"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "100"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "3.0"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.466089767522793*^9, 3.4660898002375393`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1Gc4FQ4bBnBRZLxoSvG3Q4gyQngee4uSlXE4dvYoIRyOrcwoOzKzV5FK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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  PlotRange->{{0, 100}, {0, 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.466089771067439*^9, 3.466089801354164*^9}, 
   3.523353646613459*^9, 
   3.524504803443912*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Mztot", "[", "T", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "1", ",", "100"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "100"}], "}"}], ",", "All"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4660898223563004`*^9, 3.466089831639926*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVz3k41HkAx3GNpaiIUDsi8pDasg1mcv8+BjHGGkfG6Frr2IpKjpWJLCqK
REVFtlSSehyJymTdHbRJpcMq55At57CukP3uH5/n/bz+/Gj7BLn506SkpJzJ
/i/Xz0uTJjVCLfl5tvJm0ycq+tpxNe+oEerSe5s93mZ91N3OYoXKqRFKO9gh
KzW3j1q5U35eKJFQL7XafpyN+4f65FHeIekeo2jSe1a3cL5QcfYaV7seT1In
Bu2SA2hD1MP1XTo1SfPUMO9mmmRolEqLKFWpTloI74Hhcf0NMxT9r3drtYxU
MCDSbpB+JgubpFOMQKVVEI3teqYrVEStm3789z3aeOnw4ar1AhUU3ftUvXG5
Huh5zBbf6yvBKa4Jfvp1HW7liPfbTKzCHdp0kBLLAOL3ZpZ/vNbCmert/c8N
GDhrfPFFlaYOtJwa/m7WNMKmuijhAFsX52m9Q3dNmFCOKlv6Jm0tfGQUq94Y
bEZ0UFlKXeU6lF6OqlNVN0XHobu9vLYfMOBzcciAYY74bHmnwHUGiAytfZOo
Y4kF+l8qXultwkhhZlclRWE8zD4wl8dAOLYryd0CZiLePawOMcQV3kHFrdnW
oEXo9k7GGsE87KNWUj4bviXie29vGoNW1ZQizrVBTEIwWkRMWK6mK+vft4WV
QnFkaDcL5Y7xBlHVdijYdibOS8YEflnCPEnZFnSL2o6GqZgiRvoR0/2JPfYd
T1y0wswMT1PTtd7VOEBWKWl0gmsO188nbuwp46BZmiY0FFjA2bPZsq/OEXy1
neM9hy0R3p9jlFDBxRhTSaH3pBWU0xstlj93wjntyDTnIgoSuZWdhW9/wlT1
A6+E3eRXzufOwEZn+Kamnjo/CER4KI+rtPLgMtVJfx1tjWVqv5QEBbjgpH7O
MmtZNmT6OKIdvS7gxUW3ihPZKGW311cFuCJrzXTPbboNIhisBKM+V+wKWBVa
kG2DidumPI0DbnhxYDyzkWGLkw+knqwYcENselbyRpEtKm+1yGXudoeZ/o38
R5Z2yNfb4Xl2kHiszy240Q53WNfdLwVshav/r13+7ltw4FW6F310K96elufv
7dmCRteMDdqHPDD7oeDC1RB7sP29C03GPPAlI1xu/aQ9Dko3mz4R8lG+OZ0h
indAqbFcmN8kH0dtWx9lLeEgg+sSmRjiiZhs1qWKFA5MBtmn9KY8UZ/80bhN
wxED2tPc5jABFmboWHpdc8S2rm2qEzMCBPU+jGlkcGGVKraQnRWAPXYkp514
DbXPT424NgT1w8T9WUdKWMS+j+sUlQ25iBJkux4iLhbVXeYTX2nqTZ4iTunI
+7ODuKfioOzMnACtqxdNSYy4qN83vXHxNwGm+SJ1aWMuCtTjPNSJu77tpVSI
w4XncsyJv15riGcRL2TeZ0cR/24WpxpJvD5/JnqO+H1ui+F3TC4Uth/LXTov
gPpoDF+VeFRu6QsN4mOF+of1iMt3a2pYEZdEhtc4EDvpWJdHE9f6LXZJJt70
uqH7NLGPWVHoZWLVWDf5K8SmsW4Xiojb2329qojP+lxof0VcmzwQ00SsM2dC
ExPnWvyW10H8YVGr7r/Eif1zTcPEhvGHOTIsLoIy4yfnibPD6PvViP8DKtk9
XA==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  PlotRange->{{0, 100}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.4660898262598*^9, 3.46608983309116*^9}, 
   3.523353650214632*^9, 3.524504804128586*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Paramagnetic susceptibility of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["Ni", 
    RowBox[{"2", "+"}]], TraditionalForm]]]
}], "Subsection",
 CellChangeTimes->{{3.46608246058114*^9, 3.466082474199586*^9}, 
   3.466085578278118*^9, {3.466088646585359*^9, 3.466088682959777*^9}}],

Cell[CellGroupData[{

Cell["Define basis", "Subsubsection",
 CellChangeTimes->{{3.466082118798918*^9, 3.466082120792042*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CIBasisShellDegeneracy", "=", 
    RowBox[{"{", "10", "}"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "there", " ", "are", " ", "10", " ", "fermions", " ", "in", " ", "a", " ", 
    "d", " ", "shell", " ", "5", " ", "orbitals", " ", "each", " ", "with", 
    " ", "either", " ", "spin", " ", "up", " ", "or", " ", "down"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CIBasisShellFilling", "=", 
    RowBox[{"{", 
     RowBox[{"{", "8", "}"}], "}"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"I", " ", "have", " ", "one", " ", "configuration"}], ",", " ", 
    RowBox[{"which", " ", "has", " ", "9", " ", "electrons"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CIBasis", "=", 
    RowBox[{"{", 
     RowBox[{"CIBasisShellDegeneracy", ",", "CIBasisShellFilling"}], "}"}]}], 
   ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "In", " ", "order", " ", "to", " ", "pass", " ", "the", " ", "basis", " ", 
    "around", " ", "I", " ", "create", " ", "a", " ", "list", " ", "of", " ", 
    "them"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CIBasisFull", "=", 
    RowBox[{"CISetMultiplicity", "[", "CIBasis", "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "I", " ", "need", " ", "in", " ", "almost", " ", "all", " ", 
     "subroutines", " ", "information", " ", "about", " ", "the", " ", 
     "multiplicity", " ", "of", " ", "the", " ", "basis"}], ",", " ", 
    RowBox[{
    "so", " ", "I", " ", "calcualte", " ", "it", " ", "once", " ", "and", " ",
      "pass", " ", "it", " ", "allong"}]}], " ", "*)"}]}]}], "Input",
 CellChangeTimes->{
  3.466085580831493*^9, {3.52335367480084*^9, 3.5233536840625677`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Define Operators", "Subsubsection",
 CellChangeTimes->{{3.466082118798918*^9, 3.466082142335805*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"Fdd", ",", "Eeg", ",", "Et2g"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Timing", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"OppSx", "=", 
      RowBox[{"CIOperatorSx", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppSy", "=", 
      RowBox[{"CIOperatorSy", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppSz", "=", 
      RowBox[{"CIOperatorSz", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppSsqr", "=", 
      RowBox[{"CIOperatorSsqr", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLx", "=", 
      RowBox[{"CIOperatorLx", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLy", "=", 
      RowBox[{"CIOperatorLy", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLz", "=", 
      RowBox[{"CIOperatorLz", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLsqr", "=", 
      RowBox[{"CIOperatorLsqr", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJx", "=", 
      RowBox[{"CIOperatorJx", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJy", "=", 
      RowBox[{"CIOperatorJy", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJz", "=", 
      RowBox[{"CIOperatorJz", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJsqr", "=", 
      RowBox[{"CIOperatorJsqr", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppCF", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "VOhd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Oppldots", "=", 
      RowBox[{"CIOperatorldots", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppU", "=", 
      RowBox[{"CIOperatorU", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Fdd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNeg", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnegd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNt2g", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnt2gd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNz2", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnz2d"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNx2y2", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnx2y2d"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNyz", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnyzd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNxz", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnxzd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNxy", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnxyd"}], "]"}]}], ";"}], "\[IndentingNewLine]", "]"}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4660778074018173`*^9, 3.466077831177351*^9}, {
  3.4660778798659077`*^9, 3.466077889735778*^9}, {3.4660829512058773`*^9, 
  3.4660829538541117`*^9}, {3.4660835755891857`*^9, 3.466083692904258*^9}, {
  3.4660859843251038`*^9, 3.466086009586051*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"27.790781999999993`", ",", "Null"}], "}"}]], "Print",
 CellChangeTimes->{3.466083706466501*^9, 3.466083919610579*^9, 
  3.466084053368881*^9, 3.466085613372122*^9, 3.466085979897192*^9, 
  3.466086018882333*^9, 3.4660891989637947`*^9, 3.466089484850807*^9, 
  3.52335372494174*^9, 3.524504832132043*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Create the Hamiltonian as a function of Magnetic Field and Exchange Field\
\>", "Subsubsection"],

Cell["\<\
I need the Hamiltonian as a function of the magnetic field and local exchange \
field in order to use a pre-defined function that creates by one command the \
function M[T_].\
\>", "Text",
 CellChangeTimes->{{3.4660932897631702`*^9, 3.4660933310317707`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "Hamiltonian", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eeg", "=", "0.6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Et2g", "=", 
   RowBox[{"-", "0.4"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fdd", "[", "2", "]"}], "=", "10.0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fdd", "[", "4", "]"}], "=", "6.25"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fdd", "[", "0", "]"}], "=", 
   RowBox[{
    FractionBox["14", "441"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Fdd", "[", "2", "]"}], "+", 
      RowBox[{"Fdd", "[", "4", "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Hamiltonian", "[", 
    RowBox[{
    "BmagX_", ",", "BmagY_", ",", "BmagZ_", ",", "HexX_", ",", "HexY_", ",", 
     "HexZ_"}], "]"}], ":=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"OppCF", "+", "OppU", "+", 
     RowBox[{"BmagX", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "OppSx"}], "+", "OppLx"}], ")"}]}], "+", 
     RowBox[{"BmagY", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "OppSy"}], "+", "OppLy"}], ")"}]}], "+", 
     RowBox[{"BmagZ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "OppSz"}], "+", "OppLz"}], ")"}]}], "+", 
     RowBox[{"HexX", " ", "OppSx"}], "+", 
     RowBox[{"HexY", " ", "OppSy"}], "+", 
     RowBox[{"HexZ", " ", "OppSz"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"Eeg", ",", "Et2g", ",", "Fdd"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4660778514661293`*^9, 3.4660778551711407`*^9}, {
   3.4660779037788553`*^9, 3.46607802956116*^9}, {3.466082259181775*^9, 
   3.466082289094554*^9}, {3.466082411016951*^9, 3.46608241717595*^9}, {
   3.466082791187235*^9, 3.466082809161236*^9}, {3.4660849476050386`*^9, 
   3.4660849607579107`*^9}, {3.466084996503484*^9, 3.466084999859572*^9}, {
   3.4660856176165113`*^9, 3.4660856779885*^9}, {3.466085770020152*^9, 
   3.466085771297245*^9}, {3.466085812235236*^9, 3.466085850074255*^9}, {
   3.46608588915528*^9, 3.46608589060625*^9}, 3.466086063206147*^9, {
   3.466086111824648*^9, 3.466086195010604*^9}, {3.466086244578319*^9, 
   3.466086247753295*^9}, {3.466086281474304*^9, 3.466086283311263*^9}, {
   3.4660863182946873`*^9, 3.46608632095697*^9}, {3.4660863561101103`*^9, 
   3.4660863582852*^9}, {3.466086399804905*^9, 3.466086402618618*^9}, {
   3.466086436700938*^9, 3.466086442491534*^9}, {3.4660864733914747`*^9, 
   3.466086476300633*^9}, {3.4660893221347437`*^9, 3.4660893886900578`*^9}, {
   3.466089470224725*^9, 3.466089514231423*^9}, {3.466090394290072*^9, 
   3.4660904245266733`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create the function M[T_] by a single command", "Subsubsection",
 CellChangeTimes->{{3.466082118798918*^9, 3.466082142335805*^9}, {
  3.466082201199407*^9, 3.4660822107268267`*^9}, {3.466089176156999*^9, 
  3.46608918340355*^9}, {3.466090381604998*^9, 3.466090388706251*^9}, {
  3.466090520445176*^9, 3.466090529441987*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Bmag", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], " ", "}"}], "TeslaToeV"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Hex", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateMofT", "[", 
   RowBox[{"Hamiltonian", ",", "Bmag", ",", "Hex"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.466090692773109*^9, 3.466090738224597*^9}}],

Cell["\<\
The call to the function CreateMofT creates the function M[T_] M[T] returns a \
vector with the magnetization\
\>", "Text",
 CellChangeTimes->{{3.466093340228133*^9, 3.466093381920989*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M", "[", "1.0", "]"}]], "Input",
 CellChangeTimes->{{3.466093397823556*^9, 3.466093399315543*^9}, {
  3.5233537512787952`*^9, 3.523353768394392*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.`", ",", 
   "1.40282422997402582975147212138`11.35335421292842"}], "}"}]], "Output",
 CellChangeTimes->{
  3.466093400080626*^9, {3.52335374794702*^9, 3.523353769193383*^9}, 
   3.524504832387989*^9}]
}, Open  ]],

Cell[TextData[{
 "It is nice to define \[Chi] as M/B in units of big-birds per small animals \
(emu per mole) Furthermore it is nice to plot ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Mu]", "2"], "[", "T", "]"}], TraditionalForm]]],
 "Whereby we use the Curie Weiss laws:\n\n\[Chi][T]=",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     SuperscriptBox["\[Mu]", "2"], 
     RowBox[{"3", " ", 
      RowBox[{
       SubscriptBox["k", "B"], "(", 
       RowBox[{"T", "-", "\[CapitalTheta]"}], ")"}]}]], "+", 
    SubscriptBox["\[Chi]", "VanVleck"]}], TraditionalForm]]],
 "\n\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Mu]", "2"], "=", 
    RowBox[{
     SubsuperscriptBox["g", "S", "2"], "(", 
     RowBox[{
      RowBox[{"S", "(", 
       RowBox[{"S", "+", "1"}], ")"}], " ", 
      SubsuperscriptBox["\[Mu]", "B", "2"]}]}]}], TraditionalForm]]],
 " For spin only systems\n\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Mu]", "2"], "=", 
    RowBox[{
     SubsuperscriptBox["g", "J", "2"], "(", 
     RowBox[{
      RowBox[{"J", "(", 
       RowBox[{"J", "+", "1"}], ")"}], " ", 
      SubsuperscriptBox["\[Mu]", "B", "2"]}]}]}], TraditionalForm]]],
 " In spherical symmetry\n\n\[CapitalTheta] ~ ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["T", "Curie"], TraditionalForm]]],
 " For systems with ferro magnetic correlations\n\n\[CapitalTheta] ~ ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", 
    SubscriptBox["T", "Neel"]}], TraditionalForm]]],
 " For systems with anti ferro magnetic correlations\n\nIn our case we can \
calculate ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Chi]", "VanVleck"], TraditionalForm]]],
 "quite easily, as we neglected Spin-Orbit-Coupling we know that the \
saturated moment at 0K should be 2 ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Mu]", "B"], TraditionalForm]]],
 "anything larger is mixed in by the magnetic field and this is exactly the \
Van Vleck moment.\n\nIn more general cases one needs to calculate the moments \
of the lowest 2S+1 states and take the average to obtain the Van Vleck moment."
}], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]", "[", "T_", "]"}], ":=", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"M", "[", "T", "]"}], "[", 
      RowBox[{"[", "3", "]"}], "]"}], "\[Mu]B", " ", "NA"}], 
    RowBox[{
     RowBox[{"Bmag", "[", 
      RowBox[{"[", "3", "]"}], "]"}], " ", "eVToTesla", " ", "10"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]VanVleck", "=", 
    RowBox[{
     RowBox[{"Limit", "[", 
      RowBox[{
       RowBox[{"\[Chi]", "[", "T", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"T", "\[Rule]", "0"}], "}"}]}], "]"}], "-", 
     FractionBox[
      RowBox[{"2", "\[Mu]B", " ", "NA"}], 
      RowBox[{
       RowBox[{"Bmag", "[", 
        RowBox[{"[", "3", "]"}], "]"}], " ", "eVToTesla", " ", "10"}]]}]}], 
   ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"spin", "-", 
    RowBox[{
    "orbit", " ", "coupling", " ", "is", " ", "not", " ", "included"}]}], " ",
    "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Mu]Sqr", "[", "T_", "]"}], ":=", 
   RowBox[{"Evaluate", "[", 
    FractionBox["1", 
     RowBox[{
      SubscriptBox["\[PartialD]", "T"], " ", 
      FractionBox[
       RowBox[{"\[Mu]B", " ", "NA"}], 
       RowBox[{"3", "kB", " ", "eVToTesla", " ", "10", " ", 
        RowBox[{"\[Chi]", "[", "T", "]"}]}]]}]], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Mu]SqrCorr", "[", "T_", "]"}], ":=", 
   RowBox[{"Evaluate", "[", 
    FractionBox["1", 
     RowBox[{
      SubscriptBox["\[PartialD]", "T"], " ", 
      FractionBox[
       RowBox[{"\[Mu]B", " ", "NA"}], 
       RowBox[{"3", "kB", " ", "eVToTesla", " ", "10", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Chi]", "[", "T", "]"}], "-", "\[Chi]VanVleck"}], 
         ")"}]}]]}]], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.466091187295075*^9, 3.466091262870233*^9}, {
   3.466091515018428*^9, 3.4660916172031717`*^9}, 3.466091647652733*^9, {
   3.466092106370509*^9, 3.466092123888052*^9}, 3.4660922746163187`*^9, {
   3.466092305805415*^9, 3.4660923111376667`*^9}, {3.466092374537966*^9, 
   3.4660924939716377`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"\[Chi]", "[", "T", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "1", ",", "100"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "100"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<T (K)\>\"", ",", 
      "\"\<\!\(\*FractionBox[\(M\), \(B\)]\) (emu \
\!\(\*SuperscriptBox[\(mol\), \(-1\)]\))\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.466090583056981*^9, 3.466090590769412*^9}, 
   3.466090677979405*^9, {3.466090758223274*^9, 3.466090881103959*^9}, {
   3.466091022013708*^9, 3.466091033322241*^9}, {3.466091303378274*^9, 
   3.466091306699058*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd0Hk41IseBnDHviQlY8swxjBoTBhE4vtN6SRkiaKSk7RRyBXqjKIie0hO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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameLabel->{
    FormBox["\"T (K)\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*FractionBox[\\(M\\), \\(B\\)]\\) (emu \
\\!\\(\\*SuperscriptBox[\\(mol\\), \\(-1\\)]\\))\"", TraditionalForm]},
  PlotRange->{{0, 100}, {0, 0.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.466090594410225*^9, 3.4660907604917173`*^9, {3.4660907997882557`*^9, 
   3.4660908847839813`*^9}, 3.4660910360992603`*^9, 3.4660913099726553`*^9, 
   3.52335381685281*^9, 3.524504838701045*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"\[Mu]Sqr", "[", "T", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "0.1", ",", "100"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "12"}], "}"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<T (K)\>\"", ",", 
      "\"\<\!\(\*SuperscriptBox[\(\[Mu]\), \(2\)]\) (\!\(\*SubsuperscriptBox[\
\(\[Mu]\), \(B\), \(2\)]\))\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.466091315116971*^9, 3.466091328662322*^9}, {
  3.466092139103758*^9, 3.466092158071726*^9}, {3.466092560948132*^9, 
  3.466092589156105*^9}, {3.466093981996478*^9, 3.466093982823148*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd13c8Vf8bAHArsvfIPNcd1qWIss9D9i6RbJKkKKO4ZtnJqIimVcpOGWVG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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameLabel->{
    FormBox["\"T (K)\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SuperscriptBox[\\(\[Mu]\\), \\(2\\)]\\) \
(\\!\\(\\*SubsuperscriptBox[\\(\[Mu]\\), \\(B\\), \\(2\\)]\\))\"", 
     TraditionalForm]},
  PlotRange->{{0.1, 100}, {0, 12}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellChangeTimes->{
  3.4660913317914124`*^9, {3.466091531175989*^9, 3.466091588369604*^9}, {
   3.466091622341053*^9, 3.466091631280498*^9}, {3.466092145282647*^9, 
   3.466092160321279*^9}, 3.466092597471587*^9, 3.466093985292671*^9, 
   3.52335382136935*^9, 3.524504840640848*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"\[Mu]SqrCorr", "[", "T", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "0.1", ",", "100"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "12"}], "}"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<T (K)\>\"", ",", 
      "\"\<\!\(\*SuperscriptBox[\(\[Mu]\), \(2\)]\) (\!\(\*SubsuperscriptBox[\
\(\[Mu]\), \(B\), \(2\)]\))\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4660925102483788`*^9, 3.4660925110940437`*^9}, 
   3.4660926010731077`*^9, {3.466093969044326*^9, 3.466093969430327*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1nk4lVsXAPCDjJkzdULv4RyzHPPsXYQyC5UMESpDmefMZCpE0qUIRWgg
lTKG3EZxM3x1hZAxko5k5tvu/mc/vz/2ftbae639bJKbn81pegKBoE5HIOzM
BSfGnJe8Z3DCf0MKwoc5SMKtM7grqSWi8ZUkGKzdXyA2fsfNvG5p6CtKAruA
eeveulk8btV3r8Z9CehXnM0SejSH75GijzVUlYAii3QXwfs/8HqV5vrgdxTw
9JJWELg7j2eOVcvJelNA6eKbLb7Sn7hXk2YBxx4KxPyjPJVmuYD/1FzWXnlJ
BreTDFasnQv4ea+eh4sXyHBorqcu1eQXXsvlTCevRQa5yFJRlte/cNszz91+
booDN0tgcoohDfdocOO99Uoclq7pzzO10/DEJH+Tp1fFYUCc51gyvojbldpO
NXmIw4tHI82MzYv4GQbleitNcbiD11Auav3GDwyY6/DxiIOvo9VSouoSfuf5
yRnCWzGwnRF1Zni8hHOuxJiWV4iBRth8RwL1D1427uIdki4GwowtcvQP/+DR
jJrvdX3FgO5qRm687DJu7BUi0WcrBpOY8wahchkvCLN5yaMtBu8eynnESazg
v3NEJnvFxSD33XvlWNIq7rF2e9pnlQQR9jdubBWt4hFewprskyQ4OenNECO8
hlvJLRj+3UsCSXq23ijBdTw67QEztZYE7Ff+1drIXcc/fyNdai4lwYJIZekF
3g3cgsZM2JdLggbNw4GRHJu41bHKWI4IEtx6LTiwmr6JM8eqOKSdI0HS0Sn9
CJYtXOirf3qpKwksApJ5whm2ccPbYkIXTUmgtH00YjluG/eLbovWARIIZFBG
Q7e28YJ7keTzaiTwt3P73BBFAO81HScRMgnIG27Nba0EqDTP4x4kkuDzbffS
N7vo4ENZUT8rLwlg0ePc/y7TAf3/umuv05Hgd8HpI0P/0IEe3nRzdhWDCoMz
auN89JBzdz85j4YBT85ZAu0mPRzuP2j2ZRyDV5qeEysj9LD4rmrm3DAGkaOe
77bJDBAU82vPwc8YjFG9czkeMICHsZHhw04MarvPSUk37wIRqsIrynMMzoSd
56DSMcLW2TX/2McYEPf70tSMGCEx1b6GsRqDBF+/JsMPjFBC/x2yyjFQE/Av
MeNhggZidVZmKQbfm/2TbY4ygU3caa/aIgxsOAKtXYeYYJFu4I/rdQyYngaq
niUxw8VLQRenr2LQ4BRE9D3NDBRpiyOZVzAQux88fuEHM/QPSBgppGOwaBoW
fn2TBcIrGnnKYlD+tDDnIn1W+N7G6rlxAQOngnCDsouscOji+1XPCAw6ZiLY
H3OwQc+mnWNMMAa5qVHFXSK7oaMk3CDJB4PD1OiL/ad2Q2jk2iE/Lww2PkV7
D5btBs2Yp2VeZzHwkIxV+S7PDpaua8R0dwxUXsW/YdTjgB9j3Fo+ThhMn094
wJ7AAQXuQULtDhjc5E/M2fOKA4IOSdmRT2Cw63SSE8mSE9K2y81Zj2HQz5Cy
oHOSC262+PGYWWOQfi+l/2ApF0Q9P51Cs8RAzza1wXSSC3hfjV0rtcDA9qOh
gZw6N8jMDjntM8OgETNm13rBDQqd5+08jTEI7qsM2xjmBhq93WsXIwzkUjm+
tWxxg6O5CoOzIQaFP/vqD+rxgKfVkKynAQaxLe5nLZp5YF4s6EeTHgYaga97
uIZ4wHhRwmRYF4MFiqxezwYPuLF76e1CPpVB4zuuwwttwx0hztoYHHSKb3dt
5IVJ/rVefQ10XlwT8uJfeOFZDFNNkjoGT14ezp9Y4wW9j8LwXg0Diiy3v7fW
HrhD6CK6q2LAvFYkEly/B07iLzUblTB4f70pPOUZH9wvVrJZl8cgyQwbN/nE
B3v6t/z9kHW2E63Yl/lAyC6NbVIOgwdnzCSy1fhhr3B+4IAsBlmqA70FT/lh
1ORK1rA0us8ZXdy5nx9uRdBWPZAJhSVV+5f4wYdFNOiHFAYBu7zi76gIwIb+
v267kG17lw88fCwAKQPrBBMJDNhTHAv8ewXg0BGrimEKqh+tF4zKiwJQ+jaS
JRRZtTR58JmSICzQN3yoJGMgGMCf3vZIEGI3qIFkcQy+cCpP9FULgenELJcL
hkFRD3PfcpcQ1D7dWOBAds0bbCfOC4HJdDZdy34MxkWSi13l9sKYw1g+CXle
7l/HuYq9cHl0he2PCAb0ZrE9DKVEOEY/Eda9D8XDadcm0UYEsR/nPmUip/RI
1ZiMEIE2bSBohczu0JORJboPjDTfSvYQMeD3opjsu7EPuv+8xMb2YiCV8v6F
Uq4w1LHlOUgIof40LX549LEwtIpzstIE0flyhhSG9wjDTOeAawuyUp7ohRZu
ETjlIEZ3AlmnLEDNNEMEBtginl8TwMDqpeCDU8miUHGosVuGHwPelLkbSWWi
YFAvOLTNh0GfaVv63Q5RcLxx71w/sn2Pt+cP+v3wSf4IWwKy22izeETsfsgd
fswyugfV97aixWEdDKJ+O0Q84cWgM3/siizqA7v2zNcZyMPKV/s4T2JgLO2c
cRaZ3vO3Y38sBk2FkuHCyIf/qfN2e4nmAeL1Szyo34q1U6PQu8zF/TUqmhuD
Sa259y6OJCj4FRLojLzSd5PrIHrX3ycK/q2LLMy6lceaSYIjFpMXtrlQfAGt
ZXkfSaA2zsWWgvxT3+hljb0YOMqXZpVxovoaXGLK9RIDu2cujenIvKHlpmGR
YlAXcZXqj6xWxdyje1MMNO+pLmojR/G+G3n3VQxGW82b/8eBAes3y63xM+IQ
5G+YI4QsnmSvuTeEDKlLXUGvd2NA7opc/ZJEhrpf3Kee7liosL4olwyn4zrD
biNL3B/VJD8hg+OH5/vjkGX6vLUUFskglkxnro1MJUdrGwVQ4MqH9ZrnbBgo
+t5aZ46ngGur91YFstLztsZ3Vyiw74WWbz6yijmTjnUNBfJwv8eRyOrBWTqO
PymoHjPe6iHrdZToBpyXgO77WF8nKwY4Z8emcrQENKTf2fcCGewnm/9clgB3
mYnYR8gGczJ6UejfQ75zsjAP2YjviV7KrAR4udSKuyGbe7zCC70kgevtQZEt
Fgwcds3qvz0tBaHrmT8PIV9Ktu0aCpWC0V3/uukgN7E0OdBSpCDVX2eeiryf
IyNoX5UUDJ4wNCcij/MrlJ2fl4IT6vqi88wY+EkGsfCGSUP20K9v+cjFlV9y
JVKlgZRn35iF3CNrSNLOlwbZT1x3LyKrUPm1PBqlQac1ryEAeU3jmU/dtjQk
DJt1miInma53OaTKwPuaLF8C8tNOd0e/fBnIpt8XtMyE6suycyqxSgZ6XcZT
55FNbAsJDzplwH0pfmoQmdMJV9rmloW6II1zDch/nU+8djtfFqpTuv3CkR9c
2e00VyUHUtsKDtuMKJ8COZlHjXKwFjXhuIJMLLNYCemUg5ee3V6/kJPrs3K3
f8iBrG535Tfkk2N7PvAqysPQVMSzN8jcKsJ6ms/kwY/LkpaLHPxJDkt+eQAS
Hh7QVkWuGrWYN+07ADe/KOQoII/M+jZxTRyAKzVnaNLIFoRH9vlMCtARTe4S
RZaQVs2+b6IAQqdbF1iQP0fq0vd2KwBEEnuGd2EgyiVJ4/Klwt3GXZevICue
8xccC6HCAHOc2mVkw7f1Ok+iqcDVS55KQfZKNE+xz6DC895Gh1jkJ8sBwiX3
qUC/8DXNF9l0pMlYaZYK/7af2LJADn1kc8POUxE4X48ucyOncd5slfBXBG7s
qw0H8k2fiYmVMEXIftxay4rcRgmnFqYoQoM+Rzw9MntB4d8T5YpgtTl07DcD
BqUJ0z9DJxTB2pI48hm5yzbGMN9NCX6ZJSqVIa92frfi81GCv473fypBJhsf
d8wKUoKEhFfxRciRGtTAi0lKYHnA49t1ZAmRsVsB5UrQMXBnMB05etJo3eS7
EnSXKxUHIMtFcNSuBShD0kSPmgHycVpEc0ikMkwcXnHFkRN8Jt8sJCiDfXN3
pg7yZ+cXXyevKsO+bxFLashJBgEcvU+VYbaYY14WeXB3v+e9VWVQjf2SLIB8
qejmfqd4FTjbuXVgnh6Dhz/1Z4zTVED0n+W5WeR/YKpWMVsF2u5fejCDLPBN
0Zi5RAUC3garTSAXS74+V9uqAiGzQ2cGkZ/U/KpnIahCb/kjvffIQ+3Gdk9j
VEF3lv5RFTKBb06kOFkV5ChSjRXIYqezp9IzVWG9L+R1ObIn82Cka5Eq5DTH
TJYi08wCSna3qAKW/UP3BjJT/435U5uqkCleYHUZWWFqIZUzSg2sS1m/+yHb
RQUGfUxUgy/PKTq+yJE8v51zL6kBHr2ZdQ65Q3tZiXhDDdqwTzpeyPZXNgcp
DWrQXzZf5YYcp8mmqLuiBn1BNf87upP/JfF/fYLVITgBd9ZFXsLKXh6IUgdi
W+yYNjKxTuLhr0R1GFhS89JC9hiRTgy7qg6033QX1JFXVKjyibXq8Fd+f7Ui
MmlYJ75gQR3GcnqdJJADqcek357TgLXWjmfcyNWja6sqIRpwff+0GRfyXM6t
d8XRGtCRkTDKgXx2adonPFMDslv4eHYjOzVceChZowG+IaHxjMjGhiXKyYsa
IOseV7ZGh+Kzn9M9GKkJPjmdPyaQX8Ym2DSnaEFuxHNSK/IKi+voX1la0JH2
TOgFslyOrn/wdS3wDyzhbkHOu7OSIXtXCzIFFBmakL3f+r7Nf6UFD+LEFp8h
8+xxhFBGbUgv99isRnYpVz6gkKgNjl1uT4qR1zvHWUtidGBGtiQ8Cflw4EQM
JUUHVFneXUnc2V9wcrEySwdaZdsrE5CpblNDtcU6IBIvPByH7LE886ijXQeK
Rk5aRyN3kn6emGbShdk4E4dQ5KLQ1UqFLF1weRq66Ymsj3GattzSg5ZUsLVG
vsI6+5VYoQduhSM3rJBHaK9Dwmr0gM9FYMISOe7v+BJqmx4E79aPsEBu8V5a
KR3TA3GPuApTZK2ng3dTKDiIXBUWM0JWMr3HeOQeDlf/uROthcyrdWckwBHg
w2GVZxLIdcRqNnsXAPWGcZkdn1ivV9FzB+CWWi2iIBc3daey+QDYLZunkpEV
8HXq7UiAZr9rLmLI5oY28X35AI+JDpgo8kVLgpj6Z4C5JL1p/p37cnNy37DT
B9GPsrFMyBUfwwnqJ/SBfR22GZHt4VphgLM+jNx4HLvjZyJdnyZP64NXaHX8
LuTQz7j5x1B9uNq5kkaPvGghrlr+lz6MkZLubRHQf1LjO5P1oD4YOktRl5En
OMOrbrsbAKFV98AM8t/1D58buB4EbeVClh7k+1OHL20FGIKVXsTtJuRv13wi
WmKMIJE/o7IKmeNg5YHQCGOINmoTvomsF2RaYZp2CJLH2Owzkd1LmWYEUg6D
UHs7TyLypyNmRlOxJnBKrswwAtkmafF0X4YpQBG5zw+59WmdRX2aGZhEf147
i6zqPbTaUGAOPb0MLq7Ia0WX21rLLcD7bFr1CeTanmPWLcWWEN71gdMOOSAt
6fbnaiuYXr6Qaomcc2vyZMgxazgie3bABPmqVndEXI81nFSbrzBCFrw+82fv
iSPwJsYhTh+ZPyj7ePX/jsBq4N80XeQ8bh9i70kb8Kge9dJCzpbvaaUN2cBD
O55T6shP0jeDcx1sQeXuu2IVZIdKh0sdo7bgbps/rIgcecjo4oKLHZw5fj5K
AVnk7qnRqmk7sP5uJSiPPG1sYDblexT4zTxnZJDlz9T8tX/uKMT73N0ljbxk
bH14MugY8OX4ECWR1e9Gf6mgHYO5cT4/CnLJIb+oH77HQVFNZlIcObMyJ7Z1
6Ti82sw7JrazPv3gmawge+jPebOCIX+Vl6ieW7eHgLFHufuRhVervslv2MMv
IY7/bN+hIOSH3CXpeXXHPQ6a8b+QXzeI5uy4I8Xc9s+mPdy4dSlrxwTbjynq
W/ZA5pjK3LGu6LGmcOSQNIP/XPfEhbKO3K6yennHtNjxEzrb9pBdZ/efFcy8
MqORJ2erL+34nMB8ewsyXeru/1wxGri8jeytdDZ9x/8H/rf3vQ==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameLabel->{
    FormBox["\"T (K)\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SuperscriptBox[\\(\[Mu]\\), \\(2\\)]\\) \
(\\!\\(\\*SubsuperscriptBox[\\(\[Mu]\\), \\(B\\), \\(2\\)]\\))\"", 
     TraditionalForm]},
  PlotRange->{{0.1, 100}, {0, 12}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellChangeTimes->{3.4660925151223717`*^9, 3.466092605366241*^9, 
  3.466093974096519*^9, 3.5233538269386787`*^9, 3.524504844640346*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Spin dynamics of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["Ni", 
    RowBox[{"2", "+"}]], TraditionalForm]]]
}], "Subsection",
 CellChangeTimes->{{3.46608246058114*^9, 3.466082474199586*^9}, 
   3.466085578278118*^9, {3.466088646585359*^9, 3.466088682959777*^9}, {
   3.466088716540003*^9, 3.4660887207446127`*^9}}],

Cell[CellGroupData[{

Cell["Define basis", "Subsubsection",
 CellChangeTimes->{{3.466082118798918*^9, 3.466082120792042*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CIBasisNFermion", "=", 
    RowBox[{"{", "10", "}"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"there", " ", "are", " ", "10", " ", "spin"}], "-", 
    RowBox[{
    "less", " ", "fermions", " ", "in", " ", "a", " ", "d", " ", "shell"}]}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CIBasisNElectron", "=", 
    RowBox[{"{", 
     RowBox[{"{", "8", "}"}], "}"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"I", " ", "have", " ", "one", " ", "configuration"}], ",", " ", 
    RowBox[{"which", " ", "has", " ", "9", " ", "electrons"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CIBasis", "=", 
    RowBox[{"{", 
     RowBox[{"CIBasisNFermion", ",", "CIBasisNElectron"}], "}"}]}], ";"}], 
  " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "In", " ", "order", " ", "to", " ", "pass", " ", "the", " ", "basis", " ", 
    "around", " ", "I", " ", "create", " ", "a", " ", "list", " ", "of", " ", 
    "them"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CIBasisFull", "=", 
    RowBox[{"CISetMultiplicity", "[", "CIBasis", "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "I", " ", "need", " ", "in", " ", "almost", " ", "all", " ", 
     "subroutines", " ", "information", " ", "about", " ", "the", " ", 
     "multiplicity", " ", "of", " ", "the", " ", "basis"}], ",", " ", 
    RowBox[{
    "so", " ", "I", " ", "calcualte", " ", "it", " ", "once", " ", "and", " ",
      "pass", " ", "it", " ", "allong"}]}], " ", "*)"}]}]}], "Input",
 CellChangeTimes->{3.466085580831493*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Define Operators", "Subsubsection",
 CellChangeTimes->{{3.466082118798918*^9, 3.466082142335805*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"Fdd", ",", "Eeg", ",", "Et2g"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Timing", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"OppSx", "=", 
      RowBox[{"CIOperatorSx", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppSy", "=", 
      RowBox[{"CIOperatorSy", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppSz", "=", 
      RowBox[{"CIOperatorSz", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppSsqr", "=", 
      RowBox[{"CIOperatorSsqr", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLx", "=", 
      RowBox[{"CIOperatorLx", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLy", "=", 
      RowBox[{"CIOperatorLy", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLz", "=", 
      RowBox[{"CIOperatorLz", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLsqr", "=", 
      RowBox[{"CIOperatorLsqr", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJx", "=", 
      RowBox[{"CIOperatorJx", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJy", "=", 
      RowBox[{"CIOperatorJy", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJz", "=", 
      RowBox[{"CIOperatorJz", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJsqr", "=", 
      RowBox[{"CIOperatorJsqr", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppCF", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "VOhd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Oppldots", "=", 
      RowBox[{"CIOperatorldots", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppU", "=", 
      RowBox[{"CIOperatorU", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Fdd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNeg", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnegd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNt2g", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnt2gd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNz2", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnz2d"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNx2y2", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnx2y2d"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNyz", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnyzd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNxz", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnxzd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNxy", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnxyd"}], "]"}]}], ";"}], "\[IndentingNewLine]", "]"}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4660778074018173`*^9, 3.466077831177351*^9}, {
  3.4660778798659077`*^9, 3.466077889735778*^9}, {3.4660829512058773`*^9, 
  3.4660829538541117`*^9}, {3.4660835755891857`*^9, 3.466083692904258*^9}, {
  3.4660859843251038`*^9, 3.466086009586051*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"27.569200999999964`", ",", "Null"}], "}"}]], "Print",
 CellChangeTimes->{3.466083706466501*^9, 3.466083919610579*^9, 
  3.466084053368881*^9, 3.466085613372122*^9, 3.466085979897192*^9, 
  3.466086018882333*^9, 3.4660891989637947`*^9, 3.466089484850807*^9, 
  3.466139991712132*^9, 3.523353883541668*^9, 3.524504873494652*^9, 
  3.5245050483643913`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create the Hamiltonian as a function of Magnetic Field", "Subsubsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"Hamiltonian", ",", "BmagX", ",", "BmagY", ",", "BmagZ"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eeg", "=", "0.6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Et2g", "=", 
   RowBox[{"-", "0.4"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fdd", "[", "2", "]"}], "=", "10.0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fdd", "[", "4", "]"}], "=", "6.25"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fdd", "[", "0", "]"}], "=", 
   RowBox[{
    FractionBox["14", "441"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Fdd", "[", "2", "]"}], "+", 
      RowBox[{"Fdd", "[", "4", "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Hamiltonian", "[", 
    RowBox[{"BmagX_", ",", "BmagY_", ",", "BmagZ_"}], "]"}], ":=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"OppCF", "+", "OppU", "+", 
     RowBox[{"BmagX", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "OppSx"}], "+", "OppLx"}], ")"}]}], "+", 
     RowBox[{"BmagY", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "OppSy"}], "+", "OppLy"}], ")"}]}], "+", 
     RowBox[{"BmagZ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "OppSz"}], "+", "OppLz"}], ")"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"Eeg", ",", "Et2g", ",", "Fdd"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4660778514661293`*^9, 3.4660778551711407`*^9}, {
   3.4660779037788553`*^9, 3.46607802956116*^9}, {3.466082259181775*^9, 
   3.466082289094554*^9}, {3.466082411016951*^9, 3.46608241717595*^9}, {
   3.466082791187235*^9, 3.466082809161236*^9}, {3.4660849476050386`*^9, 
   3.4660849607579107`*^9}, {3.466084996503484*^9, 3.466084999859572*^9}, {
   3.4660856176165113`*^9, 3.4660856779885*^9}, {3.466085770020152*^9, 
   3.466085771297245*^9}, {3.466085812235236*^9, 3.466085850074255*^9}, {
   3.46608588915528*^9, 3.46608589060625*^9}, 3.466086063206147*^9, {
   3.466086111824648*^9, 3.466086195010604*^9}, {3.466086244578319*^9, 
   3.466086247753295*^9}, {3.466086281474304*^9, 3.466086283311263*^9}, {
   3.4660863182946873`*^9, 3.46608632095697*^9}, {3.4660863561101103`*^9, 
   3.4660863582852*^9}, {3.466086399804905*^9, 3.466086402618618*^9}, {
   3.466086436700938*^9, 3.466086442491534*^9}, {3.4660864733914747`*^9, 
   3.466086476300633*^9}, {3.4660893221347437`*^9, 3.4660893886900578`*^9}, {
   3.466089470224725*^9, 3.466089514231423*^9}, {3.466090394290072*^9, 
   3.4660904245266733`*^9}, {3.466094037519212*^9, 3.4660940427439528`*^9}, {
   3.466140104393997*^9, 3.466140112247431*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Time evolution of a spin in the 112 direction and a magnetic field in the z \
direction\
\>", "Subsubsection",
 CellChangeTimes->{{3.466082118798918*^9, 3.466082142335805*^9}, {
  3.466082201199407*^9, 3.4660822107268267`*^9}, {3.466089176156999*^9, 
  3.46608918340355*^9}, {3.466090381604998*^9, 3.466090388706251*^9}, {
  3.466094025585935*^9, 3.466094025935471*^9}, {3.4660944045598307`*^9, 
  3.466094420725308*^9}, {3.466095990065403*^9, 3.466095991010131*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"valstart", ",", "funstart"}], "}"}], "=", 
   RowBox[{"Chop", "[", 
    RowBox[{"CIEigensystem", "[", 
     RowBox[{
      RowBox[{"Hamiltonian", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], " ", "TeslaToeV"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], " ", "TeslaToeV"}], ",", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "TeslaToeV"}]}], "]"}], ",", "1"}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4660944283499737`*^9, 3.4660944704248867`*^9}, {
  3.46609600135071*^9, 3.466096022059596*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "fun", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fun", "[", "t_", "]"}], ":=", 
  RowBox[{
   RowBox[{"MatrixExp", "[", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", 
     RowBox[{"Hamiltonian", "[", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"1", " ", "TeslaToeV"}]}], "]"}], " ", "t"}], "]"}], ".", 
   RowBox[{"funstart", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.4660944772124434`*^9, 3.466094596642754*^9}, {
  3.466094659577347*^9, 3.4660946603707952`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"fun", "[", "t", "]"}], "\[Conjugate]"}], ".", "OppSx", ".", 
      RowBox[{"fun", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"fun", "[", "t", "]"}], "\[Conjugate]"}], ".", "OppSy", ".", 
      RowBox[{"fun", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"fun", "[", "t", "]"}], "\[Conjugate]"}], ".", "OppSz", ".", 
      RowBox[{"fun", "[", "t", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "100000"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.466140154606316*^9, 3.4661402301274223`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV2Hk8FP8fB3CJSKhEjuSWpJDokHzeRa6kkiMqKXIWpRzJFxVCuUqXDinp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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVmHc8Vt8fwCmVokEpDUVDw0yI0PmoFCqj0uCbjCIzIyOFhoxSSaVCkWRG
9gqHKDtkr+e591JZz2M9j5X0u79/eL1f995zz/l83udzPs+VsLh26soCHh6e
YvrP//9XvNkx/CvXDHlLvmkrEu9Ed4UdQ2aTD0JRmt4nF5VONGz+Iy03WQ82
7b/SI2TQid4F8WmGJZsCR6uMvcK3E918IxZ0P9kRMpsOVfJ2d6KrO/fIeCf7
wGFrkZj8p13okr38P8/kxyBuH79ldKgbDUoUfGiOfgJ9it3na3h6UMGQhKTo
8RAYeTEW8VikB2m9S651hadQHq74p/ZgDzIWxOulpJ5BxIPsQztDetB96mfm
a56XUDht+N9hWQbqfLyv3z35LfxJGNuceI6JlFNi7Nzlo6Bwzfb3lC0TPasR
GnHLjoKDSTkf/nozkSTftFfBpWgIP9LX1faeiRjQeiff5h30GB4W3MhmIv2C
0Ce53u8h4pfmNauDBPLR0TXcX/Ie+jPmhpYdI9DHdt7VuQti4XyHf3iUPoH4
p5zCcgJiQTu23O61GYFK9um/yX76AVY7XZmpu0OgvSkCyZkf4oHRsb5yXymB
zNTL7Pf1x4Pv4caItkoCPa7xks3ckwCNM3rb7BoINDgwkJ7xKQGMjUHenEmg
GMnKvPT8RCg488sjcI5Aq6P9vn2qSwalt/wxRftIdEhOPVBu1UewW6JmceEA
iZyKJ3Q+nfoICoVz1n1Aotpui7rUto+g5Ne8p/IkifzWazankClgdnOC+dWK
RNzQv2Qy9xNoST75/vwFiQQZd0rI9WlgpiZrUx5OorfjfCEslTSwKb276WcU
iUo3Csgt8kiDW7J/Ps8kkojfcZ2D4kQaKD8psL5WRKIXwvIDoUPpoL35dX8g
SSLJnZl5b5dlgO/lixKVP0mUp6YcmLQ7A0w6jfZND5Co+7L6zi/WGfBGqLR5
zziJtuZqXxnrzYDOFVdTOngplGZiTup3Z8K1i9ZM480UOuTUl2byJxP4mndt
jpOgULOf9W3rDVmwt+PaQmo7haZSHLb4ns8CvCohR0qKQgd5vC6mNmfBzuwT
7ov3U6hhzV/pgoksqKZso1pVKWS++/bcV+Fs8L343PilOoX8TvlH9Bhkg0xa
mfegJoVqYkM7BOuygXEvSLXtOIX+yxdJFB3OhuqMyCwpPQqx6155bhfIAdNQ
vzQnAwoJT71dp66TA9m28ttqz1AoVmDr72NXcyBy+ZEw6iyFlMQ/5JwOyIGk
yzV3B85T6LxOspHd1xwYnbYqrfyPQoMXZXd49OWAaNa+Ve9MKXTLJZ1zd2Eu
+Mv+arQxo1BURO6zcM1cENn2L77WkkK/WGWNVUW5UHdrwqPNhkKlqwryVbtz
gV307oG0HYUi96W9S5zNhcGzCdEu9hQyvBHpHLQ/D1rkPvxodKSQdGTohRmj
PHB9kTI8eI1Ci3Ggps31PDjF3LuY60ShQj43IZ30PChNuaDY7UKhsJ12M3n1
eeB7yelYviuFnHXNyV3sPFBPGDwbcJ1CJxzOVb0SzAexe+IWR90oJBlyMp1f
Kh8a37pfnaSZN/Pwa0+dfLiUddHmpTuFultU7/Rb54Mlderybg8K5UzL2Zz3
z4d3/zHPf6T56UZJw8rYfDhk/OqouCeF7A9uUlUpy4cWaovMfZqPmgtLJJD5
UFu9TbCLZgk//qWiPAVwteRir8QNCs3FzY8GbC6A4VvPMy7Q3FrFaZ9SL4Bt
xeE37tKcPjxYYm1SADv+6alE0hy8kkxou1EA/qGR7DiarRTaQo69KoD8WK/I
GJo1jeo8c3MKwPnWsOYTmjd5lpntbCkAsf8WMO1pngzP1345UQA17W2uajQ3
Fn2SXyL8Gby0XvD8oef3kfgg6iH/GSaFrt1Pptl/YSTPb73PoP/zw4KTNJtL
hvafdfgMvosDPJn0+tV1Ahu+PaSvZ9r+tqB5rb1PnnLSZ7ihm6vfRsdv7PH1
6LjKz8Dv3JOuTnNtum3g2t+f4W2lyYpndLzjms2c/BcVwkbO5yuddH7uTJ09
P7mtEHSEnucJ0/zfhpNgdagQwnr9l6jT+RQyU1111LcQBC3uRZo7U2j4rtx0
9ptC4BFe2XeR9uHbhx3EjsJCcDqbv+c47cutIaG0RTOFUG/EyZum/Tq7gv+V
27oiEAm8uiCf9m/v3nnfn0pFwDb+omdrS/vqPqj/1aUIesvdOVHWtK+vif1K
T4sg9uRag+1WtK+FrVs+fCoCrTs7Ml9fpn1dUDbiN1wEW4Tin58zp33dkd/G
WVYMy8ywSPQl2lftT/jy7mIoyHzxvuMi7eujiCdHrGheajC0xZj2Ne2pR5Zf
MUzvVEuQpvebc1PApe3vi6ExmOOxh96Pkuuvy/ERxVA4b3V2xpD2LfZEfdkF
DD7FS6FPm0Knzp/cVumFYfbseMKRo/T+FtTzqI3A0JAYHvrsMIVCXfW3tPRg
SIOH43MaFNKVSNw/IV8CNeH0yvdSaM/NRHM3zRKwqBwa+iFLoWUtiQ+nDEtg
S0ubRhhdn2oCk5h/XEqAoVec2U/XrxOjyQF82SXg+zP6UNFaer26H9P9v5aA
pNcFoSWrKSQY+7GLv7UEYpLIp2glherOpcgtnyoBocmBnFtLKKSHU9tEVEth
6Wk0u3OKRPqP03fuLCoFY3H131pNJJLvTzdMrCsF12rNxFvfSbTqUMZNKUYp
bKzNMY2pIlEDN6Ne7l8pRMu9yCnAJDK4mOWhovkFBOBg9JZkEp2Szq3Q+foF
VoScKy32IZGCf+5YTcsX2BxvJ/Dbk0TCRO5GvV9fQO0BET7vQqKmZ3nXTi0p
g2Nb30b/oc+bM3/y15nolAH3b86AjB6JzlYXWtvXlYHgkc35nutJlFW9Kqi5
uwxk2+5uW7GaREI1l5PUh8vAErDBC0H6PKsRZAkKlEPNc7OlN/4R6FDdfy4p
2uVwUtHwUVgfgWQb5m6xy8qhMr2tVfYjgRa3qoc6FXyFkTHt4Hl5Al1uDcls
r/oKzQafE9t2Eai0ta8ZOr7Cn8qzJ9+LE+hWW/A6oemvMO3pdEh4FYHG27sj
05W+QRN71cmobrpf6LoVP572DY59bdvwxoCJcsnCwuvxFVBc+eCtxA4GCtyz
ds3OvArYqlgpyVrJQOddr9l1VFbA8qEAjYjZHjTNt3XDwcEK0E/caxtV34MO
7ArwWCJTCRHm/St1PXtQkaOhQnhGJQwcG7dWK+9GZX9+xuOiKujUS+nac6wL
1YusfLasuQZeRaw0uDHfhsp/vpt07KuBD/w/osR721BetqJxE6cGVE/UW6RX
tKEYI2OJSJFaOJGxI+lJSBtyf/Hhk8y5WpgYfSV6SKINiYmo1xp01kJ7ferD
Fwdbkd0am0UviTro0T0dl2nTjJasLvPYxqqHbQHn3o8FNKCqc2miPcxG0IqQ
q/9oWorsFHcpXxtvAuO/O16vY7viXGLNwRKyBSQrrix3vFqKnzkr1J2qaIOl
N2zVOrwb8KpgZ4XH9W1wWO7ipMjbBhwcl/ayqq0N0qNFGIeKG7B/l6wF9LdB
hNHFfPv5BuylJTUls7Qd4lRW6/z1bsRm67dLLD3eDhUN03pTN35g2VIRN/y9
Hd64nTH1udyMq1fNbJJu7QCB7fWcR3/bsP886d3Z0wGjJj7zG9a1Y83hakbg
zw74d7RzxXP5dpxXERn9k9MBLEnFER3LdhznA9ujVndCRZOo5ZeKdnx3OEBK
2LATrreu4TYFd+ADlWsPTNd0gonM5wPDi7vwZPa/8LimTjjbzOf1Q6wLp7/v
/3OmqxNkzsVpxCh24V2+BUXpg50QZWS4eN68C69VNtW0W9oFyuccQ2I/d+Hx
9x+0GUe76P5azPSNbTdO9lU8V17aBWHHHYNKcnpwtJB407rqLshpdeq+VNuD
n78X0Lf70QUjR37spMge7FNBHRXu7QI1S74zTwQZ+NTKp8pmfN1wotK8OMiM
gWffskTmjnYD47j5RtYCJtYtjmveV9sN4hsVZl1ECYwMQg0CmruhOEmNaypB
YEXKu7azuxumyqxU1fYQePNio/I7rG7wqUzxKlcj8PjJhVn1K3ogIWDFhKgp
gV/3XHpmZ9gDMa1vfL5EEbh/TvTU+9YeCPoecJpcS+JrpySa6xk9IL3dvDxO
jMST8bvPzv3qgTQJrW3/bSfxotMHjI2mekCMKRgatpfEWxNNLJaIMqA3acpf
5ziJTYzeuthdYMBr60URMTdJTCXFcV6aM2Cb9tT6y3dIbMvzyb3chr6udHK3
SACJPZOxl5gXA0JYXb1aoSR+zkverQ+neWmKMhlP4u8p257t62ZA2B+fqdl6
EhstlBYx62NA9rUbYpnNJO4+r/gyeJgBG21i7xt3kHhooVbEzzkGPLixVsCD
IjG/sdX7l2JMSNPjuf5rgsRPPjnuKN/BBLatn6LoNInXLvKIH5VhgipzVkR1
jsQ70gKSdQ4yIZCtL63NR+FDixMz/5gyYcRvRCNiNYWrTNKVdlkz4fDMVKTW
OgobpOfnnrnGhEsNH/8xNlD40n/Vn1N8mWBwL/ELQ4LCtzKGyi5FM8Fiu2qf
kByFF/JztIITmJAR4b9IUYHCDy7OVeSlMUE2XlVIS4nCr/iX1wqVMuGe9enu
fWoUzjaVbS4j6fEvZXMOH6WwVwBhaDnAhHSe0h9p2hR9kIXWLxhjQiTp9GXF
cQr/un3zpzgPAXbSa+rf6FNY58WZ2NGFBAg+0uv/bkjhj4kyliVLCNAwKBQY
O01hlx9M4tJKAiYkj9nyn6dwy6+8KLnVBBzyWBHz9wKFVf48Nf23lgBdB5Oe
XhMKz2870v12MwHmR4zP37tE4SC3hLYeGQIkvj/Zv8KKwsNBd8JS9hKwM6TE
4qE1hfXeGht5KxEgrWflP3OVwmsqBJs2aRBwYdIuI8GOwh5dP58OA/28Z0Te
gD2FO0eKDQqPENDt35Ox0ZHC0aLO301OELA7N8/3lBMdPxndR1IGBMSr+hmc
c6awlea2E39OE7D3WLnQSRc6P0Zzy2rOEaD+5tOXfa4UlrZtqQo3ISB8baCF
wHUKP/FJDbS9RIDb3+jRJprHQwOOHbCkn790xv6RG4WN4s0WL7MmwKFgact+
dwrnfVb92mFLQPJGlT1NNG9sEPZLdCTgsIqZ3SUPCvv0DR264UKAXuLKV900
k9PlvDruBBS0Mz7pelL4yPK3JaJeBIgauGUk0hwv4eHb703Aene/qBmalykb
HMy7Q4DR4lr3AzcobK+7+2/AfQJOXlinQvenuN50QeG5IAJ8NdR6H9Os4Nrl
tfMRAZeNNnvS/S1+HpClOhVCQOyiT5N0/4unIh5Nf3tOx8tgwJTuj7FxmlVu
2CsCDoS1pdH9My4qR+5WkXR8aoKH6f4ai3eIKilHE3BRW1p4K833WGMTi2IJ
QL6UBN2f41+8NRkt8QSwn/VvpPt3rLM21vlDMv3+o/48dH+PP+7xlnf7RPsm
uaIhmV7/SnR25EgmAemyjAe7aHY5LZe6JpeAIj/zvWF0/Fqs+R36Cghod15Z
zqHjrXKLlMoqJmA/r+PhIzTPxz5LPP2NgHyne8ty6PyZ59tf3VZNQGPO7dPt
dH7L67R2TtQRUL805+EQnf8Hk1OxoS0ERI0xa/uuUZi1rNHSooOAmB3ebdW0
PwZbkrYq9BDwjBXd/M6BwiLa/0U39tH+H7+QtJX273lqzvBEPwHNwt1kqg3t
p4iQ6loWAUoLZW12/99X6mujMZeACAt5h4HL9P3a4pu9ZwjYajE/LGtJ4dWf
vGyj/hJwP6L7i4U5hYVvyS3sW0SC2Grs8eIihUOpIP3Fy0jw8rQzfk7vH2Gd
vohdK0iwtXQLv0PvL6G1rxUd1pKwqzXxwE4jCq9KW2A1KUlC4/c7+6Po/Ryy
9mKGqBQJo9tCQUiHjq937vwBORIslSrynOl6sELX/qXvfhLcv1fyzAOFl/e1
VPJrk5D/hKl6hK4nwbryIlInSAhv+2/xHrreCKY/MD9pQMIhZd7z87I0+6DZ
p+dJiLOaC3PZRfsomii10YaEv9J7eoLoevbAZ6GnhgMJV3rrpfrWUnjpz4vl
l5zp9TyoXy9D10P+DOGLsTdIcB7aSz0QoPCSE7ceyzwgQeX0o2D3PyTmu60/
hpJJaI52LBZqJ7Hfr0QNi08kaKUbNZ1rIvHCk3wP/DJJ+GV4ozL4O4kXbMjf
WvWZBF6VyStl5STmzdp65lQtCWOqWeOWaSSe/83NucwioSEpPc3dj8RiKjvu
wBgJ3yY/GK7yJbF64Jnjm7gkROks14u4QWKvXZnMpjkSUn/esbvvSJ9nV534
DwtSILtm6HPSORKzBwYvSEhRcE68ZExjJ4l7hphzPVcpOKiVtC35M4Hn1FZW
5NtT8HKQf+pGFoE3BB98+sKJAh7VK/UHUgh8XvrNDvp3IEz9vRIf+pbAzfbG
eoUBFBhqK7+LuE3gWlZzVHgcBZs9nh8TPUTgwpGqQ+f6KNB8+GFPqxsTTz/1
Cr/fT4FBiGt2iAUTKypKjWcOU/B5eK+NtD4TJ3sGv1vFpaDjeuvLJbuYOJxX
n6d6US8Yvi2Q1W9nYI/VzUXqO3sh7kdNsOI+BlbYz1DZatsLslLtFv0/unGC
z7gsa6QXjML/3G0u7sApd9OX8nN6IbU3K28utgNn+Dv1bZ3uBXEF1VjBhx34
82P26/M8fTDwZni+92wH/v52kK98VR9s9ArxdGW1Y24x1Rm+tw8K1xAuUmvb
8aF/P/y1Xfug3cUuK/NsK+72zWS8n+yD/PCdCwXCf+Cf/akLC4Z+Ap9bw1ol
8ive1DEf6Mr9Ba+C0ZnbotF4196ge8Gs32Ba9Zoq/JaPbv1J1vxG9MPJ5ROb
+xtq0Zf2HTk/+/qh8Qyv0aXVdYg/J2rPooF+GOVMfikwqkPPnZ6tPjLWD1/i
duiIddahjz+9fpbyDoBjVZPIA/I76q7XCSraOgCMv1K9V9wakEbs74asywNw
+6q8aJTLDzR/YpvZ+/4B8ItS7TBVbkV9q11O3RoegKnJaSktw1ZU1VlyxGh0
gD4f84ZF7VvR86umu5dMD0Bls8ClwHetaLff63HbJYNA2FW+9hNoQ2c+r7yv
IDkItpH9e5ldbShp91xiqeUg8L86/8LfoQOFjOpGhlsPwkXns1Gj9zuQW+7r
x652gyDX4m6v9bYDgdZ+1x2ug/T5cfhf6vcO1GLmoh50dxAO85k3+8p2Ip5X
/d8N3g2CE1XVu3iwExktbplgMgbhoKhk2DaDbnR+ywdXgd5BkO2v+v7YuhsZ
q7hNKP8eBN2TC48wfLqRqa3IxKORQai0PBG0O6UbWX03GlfjGYKI9vol1/h7
kHtY6+hLiSEYX2/kFpPfg15KtrP0Lw/BQ2/nTpHFTBSOEhxuXh2CzT+mIxnr
mSjyvCcrzn4IPn23nAmUYaLoB6Ksv9eHIG/3hn13zzBRAvv8cPL9IQipknnJ
946J8nI6BpfED8FUD8d90wYCdRzt+o0HhoD3sKOayzsCxZbmD7axhqBF3o2h
mkggJ/VXrJGxIZj+Y1E/lkb/PlQwmtgyS7+PS3krlBBIQax+3nfZMJx/+lhr
sodAwRNfREBqGLTtZp3urCXROcd3ouflhqGzzChJV4xEWwd8NzrtG4ZrClC+
cDuJ8hnqEtFqw8BpdbuttZdEv6pypHlODENWeKP94uMkQtFJh0vshyH8UHOn
500SLdsYdLTdaRhipZyPatwhUesLa53R68PArbuuOOZPIvuH2/XFvYch8pTG
3Z2hJHrl/tb49qNhEOCiU3XxJBo/EeoMqcNQkRZsMVNPoqIKp+vnM4ahqXDm
Kd3PosBD+h5OOcPwb+1u7n8dJNqiIugdXTwMf9F5LW+KRCe2+Qfy1A/Dt/nu
FxMTJPowcyOqZGQYeF7tc81cTaFVpjLioRPDsKL57FHxdRTy+kJEW04Ng4fr
Hy2fDRQyeHgsZvG/Ydirk4eXS1BodpPIhxMrWKC1teWUlwyFLt+p3LFZmAV7
r+oiJ3kK1f+8GTciwgLrxpuHz+2jUGwqFR8qxoInfR+CplUopAdpSe3SLNB/
5lIXcJhCebGWUknyLLBvHd6/+CiFti1d9/GmIguK9N0T3LQpNN3onbJZnQUf
28ue7TxJIQvlvbKjiAUpTp+W2epTqC68L7X0MAvOvh73fWNIoRjL42mXj9Pj
eVmZthlRSLByXl5ZnwWma7eU95yjkId0RvqS0yywOXJEouUChU5wRTOTjFnA
6Lv+OewihSb9f2WP2rAgjGGkdeUyhcyGXit/cWDBw3dC6hNXKFSjfzL3mTML
Ip5mb3axplC0aFae8g0WHE36FnPIlkLLvK1V+b1ZUDY4oPncjkJu5IaCjtss
4JKGla32FNJNuvP5ViALVs0T/rLXKJS1QkldL5gFwbJiRYedKLTFtb9wSwgL
NEq+teo4U+hBW4TG2DN6/WMCTeBCIY6afvGXl/T63MXSd7lSyDR6AXoewYJM
jroT73UKVfHl4CtRLAjpLVxZQ7OijQ3sf8+CLXmTj++7Ueht3aZS/nh6/DcG
LHl3CvErNGh2JrGgpwX21NHsGnbvS3IqC3w9kJaxB4UYs8qHvTNYwA7s1Win
WfvSYJleDgv2LcGrj3lSKKPszRHxAhYkIY9vcTSL7TL8OlbEAr492GiK5sBg
vqNlpTSzzpaq3KDQ+Gjut+dfWbB846KldjT/Z2R3zKqKBZ3W76XpfhVV5G+u
3F/Hguu1q6X//z1WYfMP7aWNdLzqjiyJpzny7v2qzmYW3HqlWPz/77mLf6vo
fmxngRmj3+Aezc7Hh6u9u1lgGe+JjWnu/hR1XJ+gfZxdtGwbzUfXnK4V72OB
VGqxfDc9v7rqgM4j/SxYkHoa+dB85k5h/9VhFoyb29xeQXP3/rHJ4FHaH/IK
J5hevyV7x6J0DgvqxasjZuh4DcYar26ZZsG8yg6PMzS7mDyRmJljgWD26oA3
dLxnhMrlxHjZ8KXuSG0znY/bldMamovYIOvjeWyWzt8SX5kTV5ay4VdjwMxy
mh8rWRgHLWeDfadh70o6329iatwbRdiwqmfenEH7sv0Cz33uejaYsOenkxwp
9HGl0rP1m9nAOz1Rc8WBQgW33n4yl2TDsZa8PXG0j5r7moru72GDBCGdL2VD
ocqBJbWJsvT4fL8C//99tu2sc/+YMhvu3t85bkj7bro8blJEjQ1nPHoeh1hQ
6FdZJ98BxAZ2pJJrkRntn/wRibvH2FApxFxP/Uehm7895eKO0/evGmB2GFNo
wdsUjWp9NkzELObi8xQSElhnLHyeDRu/vVxz7gyFZH8OhMZcpa/nLrFK16VQ
dsTmd9/s2TDj+I/YSO939VOnPw06saFWV7TouhaFjuPCGoUbbNi+dzZmDFHo
6usnfGVBbJDmyjiLKlJoRL9c+Pcjej267jBJ1x/3xTPiAqFsOPBbLuALXZ/u
u1ponA5ng26ZSYDkTro+nFRy701igyFnW8qm9RTazWfrt+QTG/Lk+EMdRSiU
VvA2VCqTDfHQx/9JiEJ4J/8n189suEUs+vxnKe0Db9fvhbVs6JXXCy+fIZFI
zu0L21lsmPP493VdK4nUzz74yTvGhqGbshDXSCKLyWfOTA4bdohuKNtRR6I0
5fig8Dk2dBufHp8qI5Fubl3+KsER0LmlZDmQRiKfvA0b/u4ZgdAf97bwBZIo
9vz2uE7ZEeApf7D4w10S1UzLKOQpjMDhix9V9nuTSFRVU9f1wAj4nLkRIudC
oox8a68BnREYG5kNcTIh0e+CrM6WqyNgZhq6WkWKRCtMiq0y7UfgituqwRH6
PFP8UzEe4jQCrGsXjF9vJtFdta5lJzxHoFI5WqxUiESbCnnVvgSMwJ2odRWX
pwhkUKQXkRo3Akrzmx7x0udpPu43CegbgeZdjU8LjhIooZTHzrB/BB4+d73T
cZBAr8pEvTYOj8D63tNnhpQJ5Fmh/erTxAgsJwKKfksSKML6zKAd7yioLQ48
fWQxgYyvZUk+XzUK/Cn3irbfZ6J2n+tRfbKjMASH9l6xZKAGX574KvlReGJ2
55C7AQNV3g5OTVUYhf0VS7sdNRgo725skafyKJgf9v+5dh0DvfRv7hI8OAod
Pmy+I1U96OxjRVGlk6Pw7lDoCfHdPajpDSfkvt0oxGvfjjvd1oU6j2kynzmM
grKYpPdL3IWIsUcyMdfo580pTkl8FxrW2lld7ErP195y61ePLsTHvrBw+uYo
aE50cp+v7ULKB7GbbfAoqIgJN1npd6LXjCBj/ZRR+OO/Y9YrtR1d2rJl+/qR
UZC6+aJveGcLam3+5dxtMwY3ZWJqjUJqUF9d+7Ux9hgosNX/3PyXibpnrXcp
241D4XK9sgdkMp42Kzsk8HMceNer2dhrVuDkZTrLFWwmYLeDv+lARRPeGnbR
eovdBLgkHTlo1deEX0m4lAo6TIDO/N07P3iasZ9KhNtvpwn4l5je5KnajE2t
WD2RnhPgt9JWaDaxGQt/eZq6JHAC7mbrehYEtGCvG536PXETINH1d2eoUhse
5RtJrE6YgPs9ps+/67dh65CFfHlJEyCvpR40ZdOGz8RL54WmTkC9p1j2irdt
WLbFR1w7ZwIsy/Kz9Re1Y0p+21jG1wkQuS3wfGlDO9bptwsN7JuA3vqWldVG
nfj7Js19Ub8mwFzZi2l9rROfMlzbnN0/AZUfM78MBXbi/wpKRHqHJ6Bg/Pel
D587sVOwyGsN7gTobtuEerZ04TB5HDW+iAPrTxju0+3twn2ewin/7eSA57Ih
d1ejHmyT8vuk624OFM6qHPhg14PZZCE7SIoD1zLjthXc6cFTutbyuXIc+Pvc
U/hRSg9eJlaYKaTCAb7XF/lbFjLw3tIrBd+0OdCxY+tMZxID+yzNr5C35YBa
icNSBYqJ+x1FkjTsOTCz9eGa4xwmNmx2DtZ15ICBbT5360ICb4/aY3jZhQMV
r83+G11D4CrFyM6XXhyobT3r07yfwGvMfFnzDzhwjmdotMCLwD5fu+oFHnGg
TSBmuvEugX/vUckQfcIBYT+hKx0PCFzAHXVXeMYBy5qvJ/PDCXzpoQWPVQQH
3OD9o8J8AiflaK2uS+aA/JSuczWHHn9TDLcjhQNhFxTO9v0hsPed+bZfn+j5
bzCVYS8gscGJ3EieLA5U35192biKxFxyl6RiIQeWcz/Ft0qRGJYLqkbU0uP5
8Mk1m5I4yeXqxoTvHFgwoa82eJnEq9vL/2Y1cKBrIqJ1xJbEv2K8v3xv5oC0
hff7KncSB6uMHF/QwwHNpeRsziMSt1n+MLVhcUCyf9eUax6JVx1cz3N6hAM9
Kau27ikisa6o2Tv1MQ68sKnNbiwlcWEtq3cll56fpyc/t5rE0UpLbXLmaE53
HH/YTeKOlQbLouc5YCJu9qeWILHwYFhyEA8XIuTa9P/1kdjv7Xb2f3xcUAx+
XLefReKrS8B1oSAXNv9xKp6aI/E70n8NazkXsvb5ff3CQ+HOz3XZrSu5EKJU
/9eHj8InnEymE1dzQfJlB7dagMLyHe7eBhu50BMem5a2nsLTSSkBb/ZwYaRD
kkxToPDe+5xdAdJcqMv8/eGREoVtL6lVO8lyQTX+hpOJCoW7V1cJHlHgAuNp
5/JqDQqX3Op7OqjKhSByTmriGIVnzkrta1bjwn+/TpLndCmssNeluUiDC9GW
Rg9TTlA49ue/tU81uXD1AiNbypDCQXobI/frcKEbb1VwvUDhL7ssNCSOc6FQ
ZpnxJRMKzy1IZCw7yYVNgzFX1S9S2DFXWYJhwAXzlrZ9VWYUjn/q/aXiFBce
SgexPC0oTNiVW6af4ULqmEjg+ssUPiV+Ks7vPBcqA52NZawp/HD21TFHYy7w
fSx4En2VwuXNzP5z/3Hhm1x9NJ8thZWDHKSkzLgA7U2GUfYUvmaZVbvGgguz
b6NHWhwonKDxx2HekgtflcYu/3Wk8IbxwLRGay68mj/3Y7MzhS3cQl712XAh
NPH9bhkXCidOv7w9ZceFsSL7pN2uFB69GXV1mSMX7F/nnl5zncIq/+IMxJy4
oOKUtJ1Fs+/dVBV5Fy7orrTflOVG4W+LcsQPX+dCYILGARt3Cq8IKuI/686F
9P1u3oIeFDYS/Dp61ZMLnqkOP9/QHPmktv2mFxeMsqKcxTwp3CfcXPL4Fu3T
7UcSD2mWCutKeOfDBeRYy/lFs8v63pCs21yQ+L5gSP4GhQsiBz0r7nLB6/TI
QhuaecXHzTr9uDD11wg9oVn7/Yw2y58LVr5Cb97THCLJu5cniM7XGmGx/3+f
bU/kX7/6IRfEmw1wGM1bZFbxSj7iwnwjec+NZqu0dQMqT7gguoxhe4jm1H1b
Go8/5UJRg8/1v/R8JnMk802fceGTE887uj/HGgdk3zm/oH1dUTSqQbNfkVKQ
30su5KkIXy6j11sLGs4vX9P+Wvj+UaZ5TfmRC0kRXLgm6pf7io6XybETmkVv
uMARLX7VT8czpvr07oYoLgSsaIuSpHnwpIlQ7zval+yAulN0/Pc2Wsxw33PB
2jN6qwOdL88ztiR/HBfUy/5FudH5XGJyI102iQvtCy6sM3SisB7j9mvNj1xY
U3V59fZrFA4zD7xzJpX2ObVH7Sfty/arLw29MriQLcZaq2BHYfuht6qPsuh4
1UnUFtlQONMxTiI6hwsnVKYy9tM+HnLLHvtawIXevHsbJ2l/H0wXdrQXcsGU
eTH6gCWFG2+Wlw4Vc8FVasdFB3MKm91teipURq/X+dH9N/T+8HkytvdiDRe4
9QXfdhnR/gjPrHeq44K2xQvEPEXh5WE8C+7V0++XVODxM6B9iVz5I6GJC6Ma
neavjlM4P1HGhdNF54fsHxwGCvPIKBkvYdCceOqnyEE6/2nqhzYQXMgQeKUm
o0bh1pzjwtBHP3+VZ8lOul5wymwyHg5zgV8J7I/torBAocmFm2wuOLBqy8R2
UHhr1kkeu1EusGfFGvokKGwQu1dPl0PXB32OkNZGCn/0mxngn6P357qEIL3l
FL6iFSThLzAJj3mFWAFsEt/SuFnptnwShPwZ47aDJH6u5HDtyspJuFDzm3Hw
F4m/7DAsOrJ6EpQVGzzye0i8efH6Cws3TsL1zIfCszUkbv2WEHJ7zyR4SY9q
fvxAYlZx+H4n6UnYLn3UISqaxHy5wYxLspMgfF2g6F4EiRXinaSRwiTcbNvT
teUpiZ8EqFT+VZ2EmnmzR3E3SaytXfnPS2cSZDcF14+dJHF+1W9Ht6uTYLFe
727MbwJnjZudM7GdhE/Vi9V+EQRO29iJNO0noUQ39NimTgInONSuWu40CSmH
ZVwu1RI4TCg9I9ZjEt4/E006lEZg1wtek03+kzB+9FHqHTcCywwI+ih8mASB
kNXb1g8z8S5hfyvR+ElYp8ryPdHFxNvV/unNJ0zClTS/FVbVTLzp0diW6o+T
cGp3xdTxBCZetre11DxrEvQezPj0WTDxb8+oRU/L6Pv1/SrONDHwO36FRyPk
JEislUx+/a4HJ3XaFc73TkJGQ9jWvw97cNbHD0PLf03COfKBwxH3HlxpsF5X
enASVrxZ2+ij24NHX/EssRmfhF1W3aIfxrox7K6/TS2YAut6l7PVB7oxoWN/
vWXbFNxaEb1POL8Tiz+MM/l8ZQpGLv+8V2zbhmcbq3XirenrlTHuiQZtuEl0
ZP8zmykoeN6z/I5yG/aP27/GzmEKNiUF357kbcOs0sraDW5TwPdXqmvuZSsu
mB7U8PKbgkeFLXkPSlqwkZWcuOr7KUh8/b5Zm68ZP9DM68shpmBdgs1DO5MG
/FCNI8ZnNQ0tcSPtV5Zj/H3WePkamnUjBscllmIsXFA6t43m/XGdixh8GIer
POk6/P/7bTeuOztXjJOU9ry+R3PSusJfWkPFuFrObM1C62lwj1NR215VjJdt
r1224Oo0NJjm4C6/YqzXqzArRLMTZ8F82O1iHBrzekCC5r4UM6VTt4rxBgnr
Sk2aVXonn1S6FuM9mxf436F5g7rTRJZFMd1fqPDy2kzDHqM4t2Aoxo/b3o6u
ovngpYfHjqkX4x9hiwhxmmWlIoUXqBRjY5GmYqD58q+E5x5yxdhW2PHWbZr/
7J49ZrG5GKc2NtuF0Nx4j6dv04ZiPB6iZhJN819rsxttIsXYa+XSAyU0z16r
fnJieTEu/n5tdwPNUWdEhJYsLcYLHreKEjS/FQp8WMpXjI+e1OAfpTnmweF/
N3mK8QPB2Kl/NCtO29orzxXh/wGty05t
     "]]}, 
   {Hue[0.1421359549995791, 0.6, 0.6], LineBox[CompressedData["
1:eJwtlHtU03UYxhEVdHgH1LwAOnSiQjoJ01QesTzQsUMHj5qhRorCAEUSCzwF
lslVOApesjIxEIG5QhFQLiItwQnI/SqDTXcFxi5sYypJtXd/7PzO5zzP93nf
9/v+9ltyMDLgsLWVldXh/37/P2uvLRuSlQZ5+762O17pMuD9RcSa8RhuOpxM
xD3p6xRfc39D7qxpZl7Ls+MW3bwFOyXphox/xFzDn7gkIi4M/FLs31sEdz2x
TMVvFlSWwptPvMkvqakmtRwT6ogv5Oxo5O+tQnwWsX/6HRarshobF1K93U8r
QiIa+DBqSLfp2JRxvOwx8i39lYorKqJv1WIJi/z8N9JbVZUCeDaT3ug4M5PR
VocWV9LDHTiTr4gaIIwjtrXnf8NUNUKaSf5cjW/Y+sEmCC3zCfYUzhf2NyOa
Tf4F2yNYy5UtuMi05Hmu8IrUtSJghmWeFKeyeQNt2OxFeqnIYcsjcTsyl5K+
LD/7bHJbB+znkJ4ZxW4IqO2E0xJij2rHk1XPugBL/aezXi1a3dGNtCrSNz6Z
u9FU14PYr4i58Z57/q5+jtR08n/8MLdtXX0vikJIV4zND8juEOJuJ+nPeMzM
db19SNs53czFBzza+OJ+fOpI+v3yDY+7w0RIEDPM7Oi7L6tZIkKTL+mM+fmr
FnLECL4w1cxv5YaSYJUYsxqpnnCwf0wY+gLxE4gr1AKfPZIXyMugPPb6vveX
hr1EHJvq58XpPFTql9hQTn6f8ZYE3xMSeOVQvd74or5sowRPJMRBnmu1HlFS
xGwhlir+mFg2KIXtKjpvJd5dc/m4DImRpC/qfpt0wiBD6WbSl07+0OZ0lBxN
n1A/K9YmnzmnkmNNPXHA5Z8PuoUo0GrZ77dvuFtrRAqwnShvc4686V6wEmmT
SX+7gxmUrVAiXEZc4DaWX31oAJmdxLts2kf6+wbgPpfOX1nepfIPHgRPS9y9
/bm8SjmI4kRi76yCbY8ihlDhQPdz81Xs9UfqIbCeUH/GBFmxhqPCL/6Uv91h
Z72LRAXGRcv7I1Vm/B46DJN+Cu2v5PReV9UwOjgzzCwvu9fTHqrGsYOU96BK
EZgoUePpGPm74qKvSzw0+G4S+Vuv6c+fDdcgdQbx1b7kz/15Giz6yfK9cHZ2
fUetwe1zlLfgtXXdqdVaPHSm/jvaZFG9HC1sj9qaeX9zv+bIbS2SteSXNHRF
aoe1WNxKHBTsUm/vrsO8Hy37fx2ywitcB3UCvW8DvEvFLnk6SM7QvKYgvo+d
VIcEJukt79nkObFG4Owwm/4fDL/pbM4IQidS3qnYHn9h7giOymaa2U8RnpEk
GUFlnqWfmDm8fSw97OzIHzf1Qe2aMD2asiz7LfnIvoGrR8Ewzdd5qOUAR6XH
hTfkNxXwEq+tNEAwTrxAl1TYHGLALmu6P9vA2DseBQbE/EXn9XzO3dQhA9Zf
tdxXTd750yuNiEgj/wOB/NjJUCO8R6k/d+W0OPZNIzyZpN+Ywk5Ti40I/JXm
F/lFRLczR6GKpH26pOYGlh8ehdHyvdx15F2XDdmjuCGgeVK23peUiEbx2Q+U
l7Jl9/f7mSZwZpOe+oF+8aQjJvg4ETNc6xnWoSZMl1C9lGk5o+McE6LcqN6/
7tcfkg==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  PlotRange->{{0, 100000}, {-0.5773501222649213, 0.8164965809634203}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.4661401823682747`*^9, 3.466140220879999*^9}, 
   3.46614026068368*^9, 3.523353928743189*^9, 3.524504905511664*^9, 
   3.524505079792501*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"PlotMagneticVector", "[", 
    RowBox[{
     RowBox[{"fun", "[", "t", "]"}], ",", "OppSx", ",", "OppSy", ",", 
     "OppSz"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "100000", ",", "2000"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.466094692211862*^9, 3.466094793086563*^9}, {
   3.4660950269383173`*^9, 3.466095043640356*^9}, {3.466095076054916*^9, 
   3.466095076131579*^9}, 3.466095120110469*^9, {3.466095162532278*^9, 
   3.466095187988675*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 100000, 2000}}, Typeset`size$$ = {
    359., {3., 10.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`t$5470690$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$5470690$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`PlotMagneticVector[
        $CellContext`fun[$CellContext`t$$], $CellContext`OppSx, \
$CellContext`OppSy, $CellContext`OppSz], 
      "Specifications" :> {{$CellContext`t$$, 0, 100000, 2000}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{404., {51., 57.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.466096068499113*^9, 3.46609619104742*^9}, 
   3.4661401445866547`*^9, {3.4661402779489326`*^9, 3.4661403012284803`*^9}, 
   3.4661403327844057`*^9, {3.5233539350035686`*^9, 3.5233539678516207`*^9}, 
   3.5233540059221277`*^9, 3.524504905735417*^9, 3.524505079975498*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["d7 system as a function of 10Dq and tetragonal distortion", "Subsection",
 CellChangeTimes->{{3.46608246058114*^9, 3.466082474199586*^9}, 
   3.466085578278118*^9, 3.466086594503604*^9, {3.466086639185638*^9, 
   3.4660866436416407`*^9}}],

Cell[CellGroupData[{

Cell["Define basis", "Subsubsection",
 CellChangeTimes->{{3.466082118798918*^9, 3.466082120792042*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CIBasisShellDegeneracy", "=", 
    RowBox[{"{", "10", "}"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "there", " ", "are", " ", "10", " ", "fermions", " ", "in", " ", "a", " ", 
    "d", " ", "shell", " ", "5", " ", "orbitals", " ", "each", " ", "with", 
    " ", "either", " ", "spin", " ", "up", " ", "or", " ", "down"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CIBasisShellFilling", "=", 
    RowBox[{"{", 
     RowBox[{"{", "7", "}"}], "}"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"I", " ", "have", " ", "one", " ", "configuration"}], ",", " ", 
    RowBox[{"which", " ", "has", " ", "7", " ", "electrons"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CIBasis", "=", 
    RowBox[{"{", 
     RowBox[{"CIBasisShellDegeneracy", ",", "CIBasisShellFilling"}], "}"}]}], 
   ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "In", " ", "order", " ", "to", " ", "pass", " ", "the", " ", "basis", " ", 
    "around", " ", "I", " ", "create", " ", "a", " ", "list", " ", "of", " ", 
    "them"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CIBasisFull", "=", 
    RowBox[{"CISetMultiplicity", "[", "CIBasis", "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "I", " ", "need", " ", "in", " ", "almost", " ", "all", " ", 
     "subroutines", " ", "information", " ", "about", " ", "the", " ", 
     "multiplicity", " ", "of", " ", "the", " ", "basis"}], ",", " ", 
    RowBox[{
    "so", " ", "I", " ", "calcualte", " ", "it", " ", "once", " ", "and", " ",
      "pass", " ", "it", " ", "allong"}]}], " ", "*)"}]}]}], "Input",
 CellChangeTimes->{
  3.466085580831493*^9, 3.466086598303808*^9, {3.5233540469853163`*^9, 
   3.523354054237155*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Define Operators", "Subsubsection",
 CellChangeTimes->{{3.466082118798918*^9, 3.466082142335805*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"Fdd", ",", "Eeg", ",", "Et2g"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Timing", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"OppSx", "=", 
      RowBox[{"CIOperatorSx", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppSy", "=", 
      RowBox[{"CIOperatorSy", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppSz", "=", 
      RowBox[{"CIOperatorSz", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppSsqr", "=", 
      RowBox[{"CIOperatorSsqr", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLx", "=", 
      RowBox[{"CIOperatorLx", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLy", "=", 
      RowBox[{"CIOperatorLy", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLz", "=", 
      RowBox[{"CIOperatorLz", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppLsqr", "=", 
      RowBox[{"CIOperatorLsqr", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJx", "=", 
      RowBox[{"CIOperatorJx", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJy", "=", 
      RowBox[{"CIOperatorJy", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJz", "=", 
      RowBox[{"CIOperatorJz", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppJsqr", "=", 
      RowBox[{"CIOperatorJsqr", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppCFOh", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "VOhd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppCFD4h", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "VD4hd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Oppldots", "=", 
      RowBox[{"CIOperatorldots", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppU", "=", 
      RowBox[{"CIOperatorU", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Fdd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNeg", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnegd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNt2g", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnt2gd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNz2", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnz2d"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNx2y2", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnx2y2d"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNyz", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnyzd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNxz", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnxzd"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"OppNxy", "=", 
      RowBox[{"CIOperatorCF", "[", 
       RowBox[{
       "CIBasisFull", ",", "CIBasisFull", ",", "1", ",", "All", ",", "All", 
        ",", "Vnxyd"}], "]"}]}], ";"}], "\[IndentingNewLine]", "]"}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4660778074018173`*^9, 3.466077831177351*^9}, {
  3.4660778798659077`*^9, 3.466077889735778*^9}, {3.4660829512058773`*^9, 
  3.4660829538541117`*^9}, {3.4660835755891857`*^9, 3.466083692904258*^9}, {
  3.4660859843251038`*^9, 3.466086009586051*^9}, {3.466087370743093*^9, 
  3.46608738375245*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"63.717408000000006`", ",", "Null"}], "}"}]], "Print",
 CellChangeTimes->{3.466083706466501*^9, 3.466083919610579*^9, 
  3.466084053368881*^9, 3.466085613372122*^9, 3.466085979897192*^9, 
  3.466086018882333*^9, 3.466086668623012*^9, 3.466087448769763*^9, 
  3.4660970439200583`*^9, 3.5233541001931133`*^9, 3.524504970971586*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create the Hamiltonian as a function of 10Dq", "Subsubsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "Hamiltonian", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eeg", "=", 
   RowBox[{"0.6", "tenDq"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Et2g", "=", 
   RowBox[{
    RowBox[{"-", "0.4"}], " ", "tenDq"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fdd", "[", "2", "]"}], "=", "10.0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fdd", "[", "4", "]"}], "=", "6.25"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fdd", "[", "0", "]"}], "=", 
   RowBox[{
    FractionBox["14", "441"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Fdd", "[", "2", "]"}], "+", 
      RowBox[{"Fdd", "[", "4", "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Hamiltonian", "[", "tenDq_", "]"}], ":=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"OppCFOh", "+", "OppU", "+", 
     RowBox[{
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]], "OppSz"}], "+", 
     RowBox[{
      SuperscriptBox["10", 
       RowBox[{"-", "7"}]], "OppLz"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"Eeg", ",", "Et2g", ",", "Fdd"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4660778514661293`*^9, 3.4660778551711407`*^9}, {
   3.4660779037788553`*^9, 3.46607802956116*^9}, {3.466082259181775*^9, 
   3.466082289094554*^9}, {3.466082411016951*^9, 3.46608241717595*^9}, {
   3.466082791187235*^9, 3.466082809161236*^9}, {3.4660849476050386`*^9, 
   3.4660849607579107`*^9}, {3.466084996503484*^9, 3.466084999859572*^9}, {
   3.4660856176165113`*^9, 3.4660856779885*^9}, {3.466085770020152*^9, 
   3.466085771297245*^9}, {3.466085812235236*^9, 3.466085850074255*^9}, {
   3.46608588915528*^9, 3.46608589060625*^9}, 3.466086063206147*^9, {
   3.466086111824648*^9, 3.466086195010604*^9}, {3.466086244578319*^9, 
   3.466086247753295*^9}, {3.466086281474304*^9, 3.466086283311263*^9}, {
   3.4660863182946873`*^9, 3.46608632095697*^9}, {3.4660863561101103`*^9, 
   3.4660863582852*^9}, {3.466086399804905*^9, 3.466086402618618*^9}, {
   3.466086436700938*^9, 3.466086442491534*^9}, {3.4660864733914747`*^9, 
   3.466086476300633*^9}, {3.466086680066646*^9, 3.46608668570986*^9}, {
   3.466087611836711*^9, 3.4660876121800947`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot energy level diagram", "Subsubsection",
 CellChangeTimes->{{3.466082118798918*^9, 3.466082142335805*^9}, {
  3.466082201199407*^9, 3.4660822107268267`*^9}, {3.466082444171822*^9, 
  3.466082448167088*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EnergyLevelDiagram", "[", 
  RowBox[{"Hamiltonian", ",", "0.0", ",", "3.0", ",", "100", ",", 
   RowBox[{"AspectRatio", "\[Rule]", " ", "GoldenRatio"}], ",", 
   RowBox[{"Axes", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.466084880276795*^9, 3.466084893875984*^9}, {
  3.466085727942255*^9, 3.466085741179006*^9}, {3.4660860727133007`*^9, 
  3.466086076151639*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Eigensystem", "::", "\<\"arh\"\>"}], ":", 
  " ", "\<\"Because finding \\!\\(120\\) out of the \\!\\(120\\) eigenvalues \
and/or eigenvectors is likely to be faster with dense matrix methods, the \
sparse input matrix will be converted.  If fewer eigenvalues and/or \
eigenvectors would be sufficient, consider restricting this number using the \
second argument to \\!\\(Eigensystem\\).\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.466097044328722*^9, 3.523354109960088*^9, 
  3.524504971511711*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Eigensystem", "::", "\<\"arh\"\>"}], ":", 
  " ", "\<\"Because finding \\!\\(120\\) out of the \\!\\(120\\) eigenvalues \
and/or eigenvectors is likely to be faster with dense matrix methods, the \
sparse input matrix will be converted.  If fewer eigenvalues and/or \
eigenvectors would be sufficient, consider restricting this number using the \
second argument to \\!\\(Eigensystem\\).\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.466097044328722*^9, 3.523354109960088*^9, 
  3.524504971590507*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Eigensystem", "::", "\<\"arh\"\>"}], ":", 
  " ", "\<\"Because finding \\!\\(120\\) out of the \\!\\(120\\) eigenvalues \
and/or eigenvectors is likely to be faster with dense matrix methods, the \
sparse input matrix will be converted.  If fewer eigenvalues and/or \
eigenvectors would be sufficient, consider restricting this number using the \
second argument to \\!\\(Eigensystem\\).\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.466097044328722*^9, 3.523354109960088*^9, 
  3.52450497168125*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], ":", 
  " ", "\<\"Further output of \\!\\(Eigensystem :: \\\"arh\\\"\\) will be \
suppressed during this calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.466097044328722*^9, 3.523354109960088*^9, 
  3.524504971745097*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAlQVWUUx9963/7efbwnkIRKgvoGHUEwawTOJ2pPKiiWhAyZ1MBJRcCl
KUAokUyiGC0XlKDAis0d9MVUfIoso49FDRQXAhRUIPZ9jfc4nJk7d+693z3n
////vvnstkb4hfI4HE7o9GW6z1biFxENOesF1DAvsd3XkA6huRk78nfMPp+H
idTlJ4ZTBFR6PyvSXXoNnnav80sunP3+N8hZ9kLoIwF1dTFVCYz8W1N+kCvE
9eVw4XLPjabFQtocrT2vb7oFbmFWd7/0EeL/VeD65+IVIfuFdEOTacEdGKx5
y/HzNCH2uwdpx4xsZYmQzjctn1cLxVKXNR+1z/a/D9c8Jx3sNAwdXBKccmPg
AVyJTXexXc3gvIdQG+H90nsbQ43megwXdM9rLn3L4PwG4DkWx+kLGOpnftEI
+rf3HFU8YVBPE7z+qPASjxFRD/PAZniWYn/MYbkI9T2FtDhJ174gEdWZxi95
BsN5uu+7vhKh3haI3ZPs8WOeiM6ZbhatbYWllmsfbKkVof7nsOr2crfAKRGd
ofECDJFG/706Mfp5AdarethCfzHt8DUJfAkuYWfCbeLE6K8NrCMKdv6aLaZ1
5jjaoSKyXut3T4x+O8DLf2H0gkkxnRY33fA/qDredUWlk6D/Tkhqy2maFyCh
Znnnu+Bi4Qmdd7wE8+iGioPphtRcCfbrBov4uTf4dRLMpwcOMJnxSVwp9u8B
oXe907JlUsyrF95ZusamPUiK83rhhI04qeSQFPPrA8PGx5WFF6U4vw8SVxa7
XX8sxTz7Yc7VeucWsYyeNdnL6gfrN/0UditlmO8AVOxe6Lpvi4yeTjXVABTu
7Vc1fCfDvAdh1LpXGVIkoylmgYMQGJCT1dcqw/yH4Fxt87p0jZya2yUOwQ9F
8eGbiRx5DMPvwYFpTuFyGmOKO3oYGlwsA6xOy5HPMLhV2Nqoy+U0yiQvcgQU
eaExtv1y5DUC7ns389zsFHR7mKlG4VZBNdnlo0B+o8DtLL11LkZBzXaDx+Du
1vBVnBwF8hyDh43jC7bVKZDHODh9csa+jq9EHuNw86S+OchZiTwm4JCOjreF
KJHHBBzp2PVKcrISeUyCU8mGxtVFSuQxCb94GcdGniuRxxTMd6u3LpujQh5T
0Hr0t9aMtSrMk0Nc9ecsD0epUA+HlNQcD47JUGG+HJKwYtHu2EoV6uOQ7AIn
ftKYCvPmktxT19vuaFnUyyVd0TtrnjmymD+XMKkfH53wZFE/l2QO+ype3cQi
Dx6xNVbbkygW/fCIPMrzj0+/YZEPj0zmP80/lcGiPx75zMHQbLzKIi8e2aM+
4sFUseiXT7a/1nB2XQuL/PjkZObQ6OFxFv3zieU/2QnFVmpqltfOJwejAz8M
81bj/hSQm9yW9zUJamrGGyYgh9+9v77MoMb9KiCG6k5tfKeazhwnAqKztU5z
t7fA/SskHV4hRdxNFshfSBznN7x3O8UC97OQ1IqL3E+XWtCZ405Iyi8rw3aP
WSAPhkx5vcjTO2uQB0OOfPBGn8N2DfJgSJCtcYHkJw3yYEjK8bVze+5qkIeI
LCoVlz0Ra5GHiCz9WS+r9tAiDxHZ6NN65+Y+LfIQkYC6A7ziXC3yEJP9S/y/
/qtRS/8HS//u/g==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAlMVFcUhmd9780MzI6oFJBE2kGKS8TWQOBcpAQxxeqIiIjEDbRGLVTa
KoobpWKLxdiVcUU0BbVTNywZEG4VNS3LBFEQWQIUkK0IgizDVmY8nOTl5b13
3zn//383123LZ/oYAY/Hi5m6rPfp+vCIsCInSETzXFK6Vuedh4sDSeHXd04/
G0Fnlh8bThdRaXVWnJ/0T9hhcPdPy53+XgjNt14bYmpF1HuxtR6AqyX39jG+
GNc/Bkl+jbHpPTFtTtQag5v+gbulgsIjK8X4fzlYOma4RH8hpsubrAsqIE/n
47jvrBj7VUJ+XPFY6QMxdbUud3kGpocLvDZ0TfevhlBPntpNw9BBXVT6/TfP
wbPhiquzL4PzXoD/qchnoVsZWmqrOli4wlJw8zsG5zeAOPX5zuA7DNXbXjRC
ttPpJPt6BvU0QVpY3TkBw1J/28BmKGlcfch9AYv6/gX6xK82IYKlHtbxuhbY
5hmT+Oooi3pboSzAPO/Hayx1mGqWqG2DzPCTxZufsaj/JWjPHNWtm2TpWxrt
oOtyJ3s9OPTTDjkJ+vE7azjavdoqsAPKDooinQ5x6K8THD53j7iSzdEqWxxd
sCxez9dXcui3G7w2XY6dM8HRKXFTDf+Dtvx9FxUeEvTfA9e9fctdwiTUJs/4
CobeXzgj9LAE8+iF/fPJlYyrEuzXC/Xbio3CKgnm0wdZ88J2fcuXYv8+CL/1
g7OXlxTzeg3vPhVyXRFSnPcaFjOVXz74Wor59YNz8h+m3BtSnN8POZkGj7/q
pJjnAHRH33Np5WT0stVe1gDsne1vmbNEhvm+gfJkR7eEzTJqyLDWGyi62ztW
f1KGeQ9CePLg6EaTjKbbBA5CS0Puqf42GeY/BCn7hhad19hRW7uUIVi6+2zk
RmKHPIZhwuHgiYW77egBa9yJw7C+c1mAo8EO+QzD7Xg9p3psR+Ot8uJGgPW7
tMN5wA55jUBBc+YrXzd7uj3WWhZIH3Sav2ulPfKzQOjgrLzfD9hTm92oUch1
/3suL8ceeY6CUL9JvrXKHnmMgc9XjLpKKEceY1ACJnPEIjnyGIfT6306O6Pl
yGMcTv3Sw6SlyZHHBJTVVpT5muTIYwI234/qGHkpRx6TsIONZx45KJDHJExm
Bj29EKjAPHlk7fdrRMfjFaiHR+QBgSsOXFBgvjzCL3yx4WCZAvXxyMbQ7t4T
owrMm08MLZeaKrRK1MsnMbDqcYunEvPnE555eer4MiXq55OZGX6idyKVyENA
RsyFTiReiX4EJKTC+8anqUrkIyA/b6nJ+vWCEv0JSIzHzZrSu0rkJSAFUSlL
mHIl+hUSjbH+zEetSuQnJMbtlr7jY0r0LyQjldnJRY4qapPXJSSxievWx4aq
cH+KyG/81lWaZBW14Y0VkT0fVwc9ylPhfhWRM+Ye7eEeFX17nIiIg/PMs35z
1bh/xaQkJNrEj1QjfzFRuTZ8UpKuxv0sJvmcyc/wUE3fHndiYrwlj90zqkYe
DGkLab8WvEiDPBiyc+3SfvftGuTBkEDn0jmScxrkwZD9PwXO7nuiQR4skT3k
HtVzWuTBklkXg2Vmfy3yYIn/yraK4gQt8mDJB1VJgqKrWuTBka26Nd/ca9TS
/wFCmevR
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAlMVFcUhmd9b5h9UzAURSsBFFqJWEqmci5gi6bBBrQtUDRFA7iBYAFb
UKjiVsTShbSCAlo1LBUCgpVqxYtUqUqlQAFjgcgiDKsgM8hOmfFwkpeX9959
5/z//93c5Tv2+4fyOBxO6Pxlui9U74mfq/LfF9Dypcf7/cqzwTMo2OvqnoXn
IphRDUWMpwmouPlS1HrxDeD4MqtSry98r4CE4MYTof8JqOtaU1VB4ZJzOUe5
QlxfDZ3VlZnt9kLaEa8t8ml/CIzbUP7Xm4X4/2OwtGbE22OFdGO7aUEdhCc7
8788L8R+DZDs94e+pkpIl5mWL20Eq2SnJZ/1L/RvBsvFvFlbDUPHHILT7hqf
QJFnocRGx+C8p5B+LbzSdydDa8zVAgn7ZPklpxmc3wa53SOf+JQx1N/84hmk
D5XslrUyqKcdAmt5KTyGpR7mgR2gWpu0x+5tFvV1wjqHA9UxASx1NI136ALF
1QthL46wqPc5eKvVlum/snTRfLN4bTe8c7a5OKSRRf09YNzboP10jqWvaejh
UliS0xeOIvSjB11paW/ZFhEd8DMJ7IXA9IgPrBNF6K8PhHE/bbiSJ6JN5jj6
oeDAo0G/BhH6HYCuCLsttrMiOi9uvuEg3O/gnlE4WqD/IchKqrm5dKsFNcsr
egETlx/wfJMsMI9haHna/n1GgQX2G4boDyPP8ZssMJ8ROPMRE5jCFWP/Edho
tVns7CzGvF7ClUP3DX0BYpz3EmJHsnZWHRNjfqNgU3w093qxGOePQqg8bnFl
ixjzNICr6KLkuUhCL5vsXTJA4LRjj+06CeZrhIgMiTwmREIzM0xlBPfJgd7W
MxLMewzeG5rUb7spoWlmgWPA7rl7eLRbgvm/gk5r6bJsjZSa2x1/BUG2v/ts
I1LkMQ71tRfi1kRIaYIp7vhx8Ly4/y3LTCnyGYds65NGZbWURpvkRU1AbG3b
xzYGKfKagFL/7hbdchkNDzPVJJS9u8t632YZ8psEZi7iSmGCjJrtBk8Bt3el
mpMvQ55T8EtV1dSOJhnymIbvUqLnGvly5DENbnqn2wEucuQxA5qUsua+7XLk
MQMTXlGG06ly5DELDwxBt3Q35chjFhJ1g00TPXLkMQfyBpHh3iIF8piDuGtd
lTneCsyTQxoaJ0ZORCtQD4cUlQy7JeQoMF8OadyUtunQ3wrUxyGfd+e2fTOl
wLy5pHTNsSd1WiXq5RKxYF1F12ol5s8lK4QuSTNeStTPJcXujlPWQUrkwSMz
DYVqEq1EPzxS4mKfu/uUEvnwSIBVbebZHCX645HDzgX/1PymRF484px3xIl5
rES/fNLq3vrDhudK5McnXU4z+pPTSvTPJz8aU8kdSxU1y+vnE+553eIwXxXu
TwHxfvOBTJOsoma8YQLCi7zFu1+uwv0qIK4j9XWJQyr6+jgRkDyP6YD1K9W4
f4Vk+16vg9wgNfIXkjxyV/ooTY37WUi2rsqezLinpq+POyHx/PflisgpNfJg
yFd7a3b5uGiQB0PYg28U24VrkAdD6jyKW0VZGuTBEMkN++bheg3yYElm98DR
VpEWebCkoHL1X489tMiDJfX7H377Z4wWebCk6VXInYoCLfIQEeMmN+/bz7T0
fy2e880=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQVGUUx/d5d9n3sisFGYpGgsj4IHKC4HwJSlja+JiGEJmQBB8gYoIF
DBRliLwKKAXRHUZQEUUUQVwTP0GkDJhAQQfBhHjFGxZkeceuhzNz586997vn
/P//3zef1Z6Q7Xs5LBZr7/xluC/UmSS7kryNPFpqebx3W+k52N0f2J5/YOG5
AKabx+X6FB4VPT1/2EV0C144SKsTihe+lwF/xzObvc959D0HQ1WAblnGR7Fs
Pq6vAs3Y7Q9bV/BpW4S6wKP1ETjk/fPJd1v5+H8trJobzN8dxqcftxoW1MGA
Sp57LIuP/R5DakP6yeoKPl1iWG7ZAMVbprTevQv9n0LR8YeapSqGvrLxSSkf
ewbX7gVcXezM4LwmqLuxyH+LP0OrjdUMuUHXNl9PYHD+C5gIjtNvusnQ7cYX
L8EpyUksbWFQTyvYWkbbcRgBdTUObIOm+j6x9WoB6vsXMu/X7TvqJaC2hvE2
7TA8MCwY/F6AejsgpnhnaVq+gC6abxah7gSbL8Tb/RoEqL8LHGT64s/nBPQ1
jW64UpRec8RWiH66QRlx++TNHULat80g8D+wy/PvsogWor8ekN2I6si5JKSN
xjh6QVuUnbztsRD99sHG33p1S2aFdF7cfMN+aHh2y15ua4L+ByDe/sguy50m
1CivYBAu6H3PfxpjgnkMQXllwLqMyybYbwgk5W3O3EYTzGcYwj0PTMSzRdh/
GGZTsi+vshdhXiPgFmLya4+XCOeNQIrv39yKH0WYnw7yM3I8igtFOF8Hsd/E
ldBmEeY5CuYT2fntQjHNMdg7PwqqKIu4pY5izHcMKq73Xv3aT0wzMww1BtqS
3+NbksSY9yvo26U9sVsrpilGga9g86nQt3WdYsx/HC68mV92ViWhxnbHxyFx
xqPLh0iQhx7SNUvM1gRLaKQh7gg9NIe/qDHLlCAfPTiJO9MVVRIaapB3eAKY
AfuxxaMS5DUBLiXWUc5WUhoYYKhJqB8/pT24VYr8JmF2TbL71UgpNdr1mYK6
XMfrc5ekyHMKniyvzNzTKEUe07Dqov+5Bq4MeUxDeZPcx2utDHnMQEzQifAe
XxnymIH41Y5pCYky5DEL6xmlt7NWhjxm4UpiethElwx5zIF5THZq5SI58piD
5ieHvtS4yTFPFll5Muznn0LlqIdF7qh8GyM0csyXRaLDBroia+Soj0XyxvVR
8VNyzJtN7LW5F+vUCtTLJkFZnyW12ykwfzaJ1bpvndmgQP1sYmXx/qO3vBXI
g0My+otaIVSBfjgkPvXd8P0nFMiHQyJrq/af1ijQH4foNmVpqksUyItDBtcF
T/FrFeiXS7rdyv3cOxTIj0ssHjy/FTetQP9c8u1YIrn3hpIa5fVyScsZZ7OA
LUrcnzxitfxPqeoHJTXiDeCRvuA7nIelStyvPGI+XF8XPaCkr48THklznfZy
eccU9y+feB7ccIztbYr8+eQXUi75K8UU9zOffLDy3GRGpSl9fdzxif2TkWWH
pkyRB0O+Oli9z2OtCnkwpCd8caF1oAp5MIS6FrYIz6qQB0N0JSueDtWrkIeA
xHX2xbYI1chDQE7ft/uj1lWNPATkbsij5AdH1chDQMrG/e6VXVYjDyHp9Fzv
dvelmv4PP4wEFA==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAlMVFcUhmd7b4bZZwBtRwqiRSFALZWWEoLnBnGvWrQYimAUlQoWFGVJ
oKFAQKRg0VZFqEIFUlFSinZk08oVLC5FCqGIcQGhAygIZWfYywyHk7y8vPfu
O+f//+/mWgcc2XGQx+FwDs5dhvtCbT9bWXB1nYCWWSb1eJVlQ6bL+vrC4IXn
IrBRN0+OpQuouDnvqLu4FAJf9pam3lz4fgeej1SYHXwuoM6rDVUN77rHOiZw
GVx/H2amL9u2rWRoe7RZ0Ya2R3Bd8ZdL3DYG/6+DMYfWDP8Ihm5sMyxogOLD
vDNRFxns1wjlv6dF1lYz1Mqw3LIJtCL9L749C/2bwSP0QepSU5aO2vqlV408
BRvr0EwLNxbnPQOPxmXbt+5naa2xXsCqU1WfXE9lcX4LTD/6Wbdey9Idxhev
IH+P75j0JYt62iAtI38xjxXSNcaB7VC/XKN/f5UQ9f0Lt81Z73AfIbUzjLfV
QWCo43BfvBD1dsDDxIz8HwuF1HyuWbRZJ1zK9F6zr0mI+ruAadmUu2tWSOdp
vAbLD/rKj9mJ0M9rKCjVRGl3iuhbL4PAN1BXWduoiRWhv25YfLO3Ib9ARJ8Y
4+iBtVpNjFejCP2+BZu8r19ZzYjonLi5hr3QMUM0CjsT9N8HhVH8jZZfmFCj
vKL/oPeIPv2zb00wj36ICBNZZV4zwX790HIlzZb/xATzGYDsEIvOFK4Y+w/A
5yO7MxwcxZjXICxbXBvf7SPGeYPgtOmn/qpEMeY3BJqaKOebxWKcPwQ5uoA8
+kKMeQ7D88tJF3QiCc032MsbhkP+bPjSjyWY7wg8rmnNOr5PQrMyDTUCN8bL
Il+ekmDeo7Cr5k6Ef4WEphsFjoLOOlY81CnB/Mcg4VZl4SVTKTW2SxoD5+ID
//gRKfLQQ6+PJ//DECmNMcQdrQcvR8mtRVlS5KOH37SaBOV9KQ0zyDs6Dpy4
4HaLYSnyGocqm+AgN2sZ/SrQUBOQ5qq7cnibDPlNwFbXdqdfY2TUaNdvEq4f
OpM9WyBDnpPAOWd7MuCJDHlMgWNFXWoTX448pqA6IWGTj5MceUzDDxd5B7r3
yJHHNHz/rCQuNU2OPGag1jJrg1uFHHnMgD9js3+8S448ZmHvZte4P80VyGMW
JnWybTlrFZgnh2xpWBJ7IkyBejiEmyi5F52jwHw5ZIKT1xTzWIH6OMTrtDY4
ZVKBeXOJhk3ObjBTol4uad/rnKizV2L+XPJNv8O6aQ8l6ueSsxXWd5f4KpEH
j4QP5D6FMCX64ZGHg++EBJ1UIh8eWZT4x94LOUr0xyO6zefO15YokRePuMQG
DTJ1SvTLJ+l/3/Xx7FAiPz5xSGkpSp5Son8+6ap5sKLeVEWN8nr45NhHg/L3
7FW4PwVEf/V2VqiHihrxBgpIzIjpjXtfqnC/CkhAX7y7VZiKzh8nAuJXZrci
9qQK9y9DupdXe7flqJA/Q05/er5kY6kK9zNDgjoiV2vrVHT+uGOIRTMtXd6p
Qh4scQzbuSpjWoU8WPLozakTcnM18mAJm7zlWoqDGnmwpG2yNVnkqUYeQmKv
M5Wl7lYjDyFZusfaVnVcjTyEREeL72d9p0YeQuIT2vRsZa4aeYjIi0qxV1m5
mv4PmmX1aw==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMFFcUhvc5u+xzZnlEWwEpoiJaJAWsRT23oNVURFdBUZAUtvgoBaUW
DazVaqHyEnxA6gvRqhVfq6SiSBp6gVZaCitIwUbAuIiggorIAoJA2fVwkslk
Zu6c8///d3NdorasjBbweLzosctyHy/B8VXHLywS0WKnlE5t8UmYkzflt0tf
jT8bwBx8o6M/W0Rl985snS+7Cb3ZxjMZRePfS2F7fh4vuklEvT+yVAUYwnUT
9/LFuL4SHsjS7UzTxLQ1yc6w2FQFoqQbrt8HifF/I7ARxh/WJ4jpEpNlQR2E
3zbv3HFCjP3qQZ+THFVdIabOluVODTDhdu+hdZ3j/e+BfG3Vjsm2DO2bHp5d
bv4PziUnpEzyY3DefThk9vRbpmNotbWaIfZqwweFGQzOfwCn3UtqP7vO0JXW
Fw/hsFfSI0ULg3pMEKr5RyhgJHSBdWArcNsXt03xlKC+RzAz5pNPvw2VUHfL
+OltoH656eGLPRLU+xj8Qu4fOHxJQu3HmiXZtYNbU/6MyAYJ6u+ALsPxrNWj
EvqOxhM4eWHxL9+4S9HPE/Dt0+uur5LSLq1F4FMIvOdD39slRX/PgH8rovRs
gZQ2WuPohLyiwxu19VL02wWPrj2vdh6R0jFxYw2fQ6VbFaN2t0H/LyCnPMfb
KdiGWuUZXsJgx8GdgbttMI9uaHW8KD960Qb7dUN0lq+9sNEG83kF+kPGu2l8
GfZ/BQFhDskzZ8kwrx449XtW3LNQGc7rgTjvDS3lyTLM7zU4vv7cpeiaDOe/
hhDtggO0WYZ59sKspZtT2qRyetZi70wvLIWeLyb7yDFfM3zdXL9vW6ScHjtq
KTMEzi/SteyXY9594OtVEbW+RE6zrQL7wHQ5vb+nXY7598PjiH+P5NkqqLVd
Sj8E6/aUhRMF8hgAo2Zzt2esguotcScNwIq2OQUOxxTIZwDORizfwlYqaLxF
3tY3EKc5f2dSrwJ5vYGruYbVfi5KunGDpQbhin52bkyQEvkNAt/f1/mKXkmt
dsOHYMDjecZogRJ5DkE2k5kQ1ahEHm8htWZuYoNQhTzewiwPs2+olwp5DIOi
Zqf2WYQKeQxDd8rHcRmZKuQxAuVzXH38SlTIYwQSdxWteNOhQh6jIHWoi/3T
Xo08RmGT+bJffoAa8+SRugnlMT/Gq1EPj1zuLS5MyldjvjxSm7mmQl+jRn08
Euy+NTRtSI1584nvyk25dXYs6uWTNLeJ+jYPFvPnk1NT7ecN+7Oon08+DFMW
v7+ORR4Cstd88A7Es+hHQDxWyb/cnMoiHwFpnPvrmiP5LPoTkJGgrP3VN1jk
JSDn/45+Kjay6FdIwsPKli98zCI/IdEFmc7te8uifyFJLDU61tpy1CqvU0hO
hAyJHT043J8i0vzqr4Nx/hy14t0gIivCXC/8sZbD/Soi2pgcb+d4jr47TkTk
4iJw3JXK4f4Vk5aSpkBTPof8xSTxbuGVJTc53M9iUqjPnXHdyNF3x52YzNa1
GlzbOeTBkO1dO6b+NMwhD4bULyv6TmWvQR4MiaxJOJ02U4M8GOLipNwtXahB
HhIy2BQgygjTIA8JmecW7Mxt0yAPCZFo20uPpWuQh4SElCnvTvtZgzykJOvO
oiXFtzT0f7/O7SA=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQE1cUhvPYTUISkk0IFpGHtiIiOlHAqWLtuQVfdRwVaylVfMQKFosK
xKoDo4gVDSqltVNFxgI+ito4SEtElFGvD8Y+kIppRDRUobwEFEUSQIyUxMOZ
2dnZ3bvn/P//3blj1mxaEifg8XhxQ5fzPlymY63ZZ2YztNwvsyOqPB9iJk9e
aVw//FwMvf40qzeHodLaE0kzpRegbotl9v7zw9+vAHuo8PjahwwNC3XWDWiK
01Vk8FlcfwsKpu0qexzI0sZUTfHchj9hQuepyvSFLP5fDe9GlAes+Jql8xqc
C2rgWXSt39ajLPYzQ7bXCqbqBkv9ncv9LFDx3Y2wZR3D/WvB+Pu3I0d7iKh9
fGzOddt9OCXQBvrMEOG8B3DLVm9d8IWIVrnKCofObb1Zsl+E8/8FW8milDkm
EV3ievEYyB1BprxehHoaIEA352e+SEw/dA1shFrP85ljtWLU9x8cZPIa9TFi
GuQcP74JWqdcyniWIUa9zbClzyfkB6OYeg41S9W0wNij5r9WW8SovxUmRVFt
9KCYvqXRBmfssXNTgiTopw2ElzMY0ycS2hnlFPhkKL9gnfcOCfprB7lt1qqT
pyX0niuODrhqT5BEmSXotxM+qivd4P9GQofEDTV8CpWjdp5SBLmh/2eQlhRu
8V3qRl3yirugeEag74J0N8zjOZRKtGdzf3HDfs+BYY3nBffcMJ8XkHQgRJ/F
l2L/F2C7mzB24iQp5tUNU3+rUbTHSHFeNxiO5W6/vluK+b0EozXxmqlEivNf
QnrFosnUKsU8e8D7g/UBTRIZPem0d6IH3K828kZPlWG+NqjoKQ3U62Q074iz
bHChf7ewPluGedvhcf4uwYpLMprjEmiH+Q+mH+5ukWH+vVC4XD/tJw85dbXL
7IXvCaeLJXLk0QcHG1tztBvkNM0Zd2ofWC8WzR2RJ0c+faBdWKzgbslpslNe
Uj+Ip9g3+vTIkVc/hPY/tYWPcafr4p31CqrCV4d9tdAd+b2CQX30lbNp7tRl
N3YAqtscEwZPuyPPAaiJz9asueeOPF5DQHuwl0WoQB6vodL3vuWzKQrk4YD0
c4ufP1mpQB4O2J7ikO8/oEAeb2Dix3Xm8EsK5PEGDv0d29XXqkAegzDieoK8
0lOJPAah9p33H+RHKjFPHgm5PVO6J1mJenjEFD1ucWqBEvPlkW3lZbq020rU
xyNHwq/ZDQNKzJtPzjzMWluj4VAvn7RfDp3fFMxh/nzCs46XOSI41M8nx2Z4
7x21jEMeAuKlzM2HZA79CIjEJA1NMHDIR0DsXcZxuQUc+hOQTV/ujK0q45CX
gCQtjSpnqzn0KyTr44r8ZjVzyE9Ifmy+unnvaw79C4m27B/NHQ8VdcnrEJLO
bYzDJ1iF+5MhndMtho0RKurCG8+QyGshhTc/V+F+ZYiurSjYP1lF3x4nDBlp
XqrZYVDh/mXJy6ieyIYCFfJniSHx9sl5F1S4n1nirTaNMVWr6NvjjiWruoRF
77WokIeIPFp31PewQ4U8RGTgV+tmhacaeYjIXY/C3KyJauQhIt+Q8C2SWWrk
ISZdZv3AvuVq5CEmmzr3jFDp1chDTCIbRpXl7VMjDzFJ1Mz5I/C4GnlIyKeP
dkL5RTX9H14G7zA=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUx9vSe/tu7y3FuI2CbC6V4GJ8bBo2PZ+ijKDiRJ1YUXyBU3xQ
0SwCyvAxFHU4RUU2xQcGBgZBkIdZlk9kMsGhhgAbopNSEESxKtBaXqP1cJKb
m3vvd8/5//+/L5/Puu2hkSKBQBA5cjnvo5X0+/Sw3+aJaZnXwa7FZechLU4d
nLd59Dkf9Msyd9lSxVTeeDlmprwUIsaVTD5yY/T7H9A4Y/9PGx6J6bSpzroN
7j8EZicJGVxfBUNk86WnBoaa43T5X7dUQ07oycLEEAb/r4Xn27P5VbsYGtTi
XPAQcvOr5d//ymC/OijqW2qtuc1Qb+dyr3q4Np+OM3aN9m+EgMLjzDh3lvZN
CE+t6P0H9Bu+cPf8ksV5TTB1TNdfC9az9J6rmsHwIKWg4AiL85+AXbVpdWAx
S0NdL57CuYsfm5SPWdTTAvubtvwsZCV0lmugGaqjzKbxkySorxVKw2prY8Mk
1Nc5foIFQgt7t3YnSVBvG1RWRXidzJNQj5Fmcbp2ONOsL1tTL0H9z4D10Xp+
Oyyh72l0gLepZOoOXyn66YDzDrO1aImUvljsFNgJVaJTCz/cK0V/z0FpvzE/
K0dKG1xxdIG/zdzzTZ0U/b4Ar/ZpRu8hKR0RN9LwJTTMlqWpfWXovxuybtbc
0i+VUZe8/FfQcZ3KFiTKMA8rRBU/SE/PlWE/K9Q/X3pJ1CDDfF7DiQJLxGGh
HPu/hsAZ4/mJn8kxrzfwgTGtvzNMjvPegOHo+s0VB+SY31vgZCS/uECO89/C
WYOfnjbLMc8euG9ZqLVIFTTLae9yD6y6UPvS+3MF5tsLd2U5uti1Cppx1lm9
UPJVkrX5mALz7oMgWfKr8JsKmuoS2AePNgQeeNOuwPxtsHso+dNz7krqanfQ
BpPfTgwJJ0rkYYf2X5R7Jm1V0nhn3HF2CI6pmzYmQ4l87JBtM/drqpTU5JQX
8w5sFVPCPXuUyOsdlH83pdXfR0U3RjnLAfsSrvpEh6iQnwNmJeTmXY1XUZfd
8H7Iy1sxdjhHhTz7wdFoFa5rUCGPAfAePM3Uu6mRxwDc+TP49vLJauQxCMf+
q37cuVqNPAbhuD7RkXJUjTyGgK5dd8v/php5DIEx6GWz/ZkaeQzDsmNCR6WH
BnkMQ6ehoep8gAbzFJBgncV20KRBPQIycKduZlymBvMVkL6A6EXxf2tQn4As
qkuwHOrXYN5CctoQvfKhjkO9QhKxb+xsix+H+QuJjedFg3M41C8kumZm70dG
DnmISI82+RSYOPQjInN0g76bDnHIR0ROXLmoT8/k0J+IrNmye8m9Eg55icj1
zIXXmFoO/boR1esrHnPbOOTnRrJzK6KTBzj070YiO6623nfnqUtelxvpXtJQ
4+nH4/4Uk501F5Zvm8NTF94oMXk3xr6tcgWP+1VMnmiiHF4mnr4/TsSk8V9V
655DPO5fhkTOy9a2ZPLInyFiY1xsUCmP+5kh7exKa1EtT98fdwzJsGft/KSd
Rx4syTsx/cXpQR55sCRQsSNA7aFFHiz5MWfSxsMTtciDJWv0lXOlc7XIQ0Jy
GPvdlJVa5CEhlxOZNi5WizwkZJM57UBGihZ5SEhTavkZwyUt8pASY0u3qqxc
S/8HnY32kA==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAlQU1cUhpOQ97KSvASwUxfiNkWKrUPrgjJ4bq0LIGWUoghExh2qlF2t
bCojU0XEGWkRaIABrXWp1KlQl1a9oi0tuBSp6ECQTZY0FAwgBCFQEg9n5s2b
99595/z//925s7ZFB+wU8Hi8nROX9T5ZC+9V+15YJaTXndON668XwsLm7kWX
dk8+l0L/6dStQyeFVPrsTIyX9BoMPcmZcbx88vttiGndmbijQUgXfmyte3Cu
yC37MJ/B9ZXw/LOArGYXhrYmOpauaamC0d9SCw76M/j/I5AW51i0exnq3WJd
UAMbJbcH9+kY7FcL8c/89NX3GKqxLnd+CgrJLXmIcbL/M5DpTpk0DiwdnKc9
WfH6ORRUeo1P82RxXj2c8DCX+W1n6QNb6SGmr0B35TiL819AUWSa7+oylgbY
XjRDesKKzfJGFvW0gHZDdgqfFdHltoGtILyhDJu7QIT62mB2qeDX+E0i6mod
P+8l2H3kHtJzWIR622F5bok0+5KIOk00S3TsADfniLNbnopQfycYTNvFG8dF
9C2NLsjvVs6McxWjny5YtHRl49XPxbR7vVWgAdZOHVs6NVWM/v6F0ZH3PM6e
F9M6WxxGyDGHtqyrFaPfbqjrL1+tGRPTCXETDf+DOxGnDilcJei/BzKZzaUz
AiXUJq+0FwzvhwyuPSjBPF5Bw5a49NyLEuz3CiJqxrIEdRLMxwSpT3P8jvGl
2N8EnxS+sLh9IMW8+qBEENRl2CTFeX0Qvv/DoIojUsyvH95d7PBd2RUpzu+H
oG9YKdVLMc8BmJ/lPt4mltGzVntnBmBd2s16zSIZ5vsawjQ6fvxWGc3Ps9Zr
cD2U0qg/IcO8B2FxwnG99qaMnrQJHARjb0BsX4cM8x+CpmKdusBBTm3t0ocg
6JyPp5bIkYcZqja4717wpZwmWeNONIOvC2/2lHw58jGDrvgdg7JSTmOt8mKG
YceGaJ/pA3LkNQw/PN/397JZ9jR8l7XewE+3zYo9/vbI7w0MHxnL/THJntrs
akfAFFXOjJ+3R54jkOMT2Lu1zh55jEIaJ+j/x06BPEZhXtStK0HuCuRhATG3
qtoQpkAeFjD8yevKyFQgjzGoTDSWLrupQB5jEHc3pcrcqUAe4yAMzuu876RE
HuMQ6bG3vPBTJebJI3+FZrSnxypRD48ULTnsllikxHx55OFjjVfSQyXq45F1
kR5Pjo4oMW8+uRzvF1DjyKFePmHXWJa8dOMwfz7ReA+bR1dwqJ9PLiSbEqaF
cMhDQMxT9mVCLId+BORSQu/ML45yyEdAAkNPO+YWcehPQA7ExPk++IVDXgIy
y+hzjnnEoV870pD8vXxlO4f87EhT9O/bvh7l0L8dGWr6uf6xg4ra5BntyLT9
TRXT3VS4P4Vks8Nl/6gVKmrDu0tIqpJFu+4Hq3C/CklN5lcm51gVfXucCMnc
8Dn1KUdVuH8ZEqa/I2kpUiF/hgz3f7vb+5oK9zND3AsOdF59pKJvjzuGXDzy
x545HSrkwRKTvbYtx6JCHizxj85bpnBSIw+W1PUEhx2br0YeLNGByVO8Uo08
RGS/xeVuRqgaeYjI1dUeei5ejTxEJC2uKik/Q408RKS21ZTlUqJGHmIiNrky
12+o6f+CE/Tn
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lHtQE1cUxpOQ7Oad3QC1VoQBSoVSB8TSoqjnjpbBwaL1VVDQAhWrtCo0
YscI+CjQgFSLOArUghbq4KMMFXn5h17EVq0Wh0kFRKsiTwV8QDAoIZTEw5nZ
2bm7d8/5vu93Z93jtq2IFwkEgviJy3afrK7rX8w/FSKmta4Zfctri2CVbqTl
dMLkuhwG4gwO5oNiKm8pSZwvr4Gmul8uZVdNvr8IltZNLhvuiumHs23VAD1l
PoF7hRLcfxXyd4X5P5whoY/0TuWh7X+Dp18i7F4qwe8bwT1jT3F0soQubrdt
aIInBcX5O45JsJ8RsqK80m40SKibbbvrbagw7i9f0zfZvwXOKiLy3BwZ+tI7
+uDl4VY4GWI+Pi2YwXltUB908vNPv2ToTXvdg7xBWFCxn8H59+H50JT+kPMM
XWF/8BA+crxhVfzHoJ52cClVuwkZli6wD3wEzZGp455+LOrrgPTQuGhdJEt9
bOO9O6Fr+77Rgb0s6u2CxOCuM4fOsNR5opneqRtcHvwcEnObRf098N5hw6nV
4yx9Q6MXiuZ41Sf5SNFPL4gFYWmVK6W0f7lN4GPw8DO1TU2Tor8nwASp7pSU
SWmzPY4+qJ4TsO8zoxT99sMcl5QeV6uUToibaDgADesXu6t9ZOj/KSRXipZN
XyWjdnnlz6As7dmRJbtlmMdzOLfE7JV/Wob9noM5VOcnapZhPi9g863X/Qah
HPu/gCHngCLfmXLMaxCChgsMjyPlOG8Q0jtjzPXpcsxvCH5zCww+XyHH+UOg
t045femeHPM0gXZ3QHGHVEFLbfZKTMCIzujdAhWY7zBc+DjlxLexClpYYKth
qJoXnnrvRwXm/RLa28NSoi8o6EG7wJewYLqIH+xWYP5mOFoUfO6Yo5La22WY
Iev71rYookQeI5DnVSHz26Kku2xx60eg0bK13rlQiXxGwDt3h0FzVUmTbPIS
X4Fw+8XeaSYl8noF/vOqt811V9GvNtrqNTSkepcnLFUhv9cwWO0adHaXitrt
Ro/CNd+/Sq1lKuQ5CpdPrT4Q26xCHhbwnGnK/ddBjTwsUBNzfFnELDXyGIOE
wbcTHq9XI48xSKn6MzM7R408rOCRcyJ87gU18rBCjtZr80iPGnmMAycJyLzi
rEEe42BcO76yaJEG8xQQD45Jz0jSoB4BqSx4en1nsQbzFZAdo2l39f9oUJ+A
5KdmJRpGNZi3kLw7tsW9yYlDvUKy8cEUttOXw/yFRD+mvGZZyKF+IXlnnXXR
tLUc8hCRXP+UKEji0I+IZN5++myTgUM+IvId/1PH0WIO/YnIQNaGqTerOeQ1
sU4OTJY0cujXgXRmZt9d1MUhPwfCs6WzfrBw6N+B/N5S23TLkad2eX0OJKGw
t87Fl8fzKSbfRNWFbF3IUzvejWJy+dFb666s4fG8ikmHbH+vaxJP3/xOxOSQ
Kagp1cDj+ZWQnbpWQXsxj/wlRHbgj9jFNTyeZwk5PDv/fmUjT9/87iTkDtcb
59nNIw+GxGftaTsyxiMPhuw00llqZy3yYEh4YPrqrA+0yIMhY7Gus6WfaJEH
S7YOR9RmR2mRB0v6VV8bOZ0WebCkQSTQFWZrkQdLugPfz5zxqxZ5SIlREG+p
qdPS/wHXs/Cx
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQVGUUx3eXfe+ye3cBI56iNIBotiFNwcD5xEhMBhEJUIE0fNRaCiKl
7AjjCLaCSuFIBAgqTD4WyAJDKeBDbBjJREKQEElEQB4+eCOwa+x6ODN37tx7
v3vO////ffM5fbYnZDuHxWJtn7uM9/nKvjO6/KI/l151SB1cfzUfjle11l1S
zz+XgnX2zucTGVwqvlcY6yOugLCYJF3alfnv1dCkWSvcdp9LV3gYqw6kdTKn
Q2werq+HkcPv2j104dFHiZalq7sa4Nypze7JQTz8/zb0/ronPTKBRwO6jAua
oGg4M+XrPB72a4aSD+zVf9XxqKNxuUMLnDmhzdk4ON//HniPRSQ7WvDphGtk
xvXxNlh83nDM1puP89pBtbHMLzCGT2+ZqgNsLDYsuZzOx/md8CJY1eZfzqch
phcPIevxwIDkAR/1dME39p4SNl9AfU0DH0HtxUuDi5cLUF83/JybFRAfIaBu
xvGujyFkrKrv6SEB6u2BP8Su2Zk6AbWaa5Zo2QvfOfaqtrQIUH8fGGLaT33y
SkBf03gC1uVJJXFuQvTzBLJ8dOqyDUI6tN4osB+q/KPq30wSor8B4Hgn/Vl4
QUhbTXEMgoeXbndwsxD9DsFCN32zg0FI58TNNXwKbSlN5jI3Efp/Bnn6k972
oSJqklf6HPrGtYfXJoswjxewbTJbmX1JhP1eQMMyeztOqwjzGYZTo8X/atli
7D8MvpqhNPdlYsxrBCxPRyb0R4hx3ggsanR/XJsixvxGQRwodC2/LMb5o5Cj
Hs2q6RBjnmPQ6LLgWLdQQouM9grHIKo7a6ejpwTzHYfqwNgTe7dKaM6PxhoH
XfIadcdxCeY9Af6B676IrJTQDJPACWg6LzMM90ow/0mIXRlckGchpaZ2qZPg
8t54/WYiRR5TMNh5d+Ltr6RUY4w7cQoCynJLrXKkyGcKCrx0CfJ6KY0zyot9
CVO8mRbbMSnyegnFuulILydzunOHsabhYM2+XHWQOfKbBp+avW8Va8ypyW7k
DBQ+c8o0XDBHnjMwYXNNs7XVHHnMwhvk0+S7ZjLkMQtVQgufcJUMeejh6KKT
4f3RMuShB82W1fvSjsmQhwF+L1ri7VUpQx4GCEq/EjbVJ0Mer2DDnZvxN6zk
yOMV9KvzV+avkmOeLPJReHFcapwc9bDItCiv4kCBHPNlkWdHPG4m/i1HfSwS
sMA/Wjsjx7zZRL5mnXWTJYN62eS/wll9tzuD+bPJfo/x6lk/BvWzyQl9v5ft
JgZ5cEjsil0hEMegHw657tnV+7mWQT4cIq9Pbf+hgEF/HHL/eBRz6zcGeXGI
R63qS95tBv2akXRl2j+rehjkZ0acb/3k+u0sg/7NSI/o+zONFgpqkjdoRnYl
VGrt3BW4P7lkbCjFcrefgprw7uCS/e93uN/YqMD9yiWbVB9XOMQp6OvjhEtC
Z4YLDmoVuH95pGdHeuPDAgXy55FUTfQ7ARUK3M88EuMKJWW3FfT1cccjNjZH
VYt7FciDT5zLbS9m6RXIg0/o0jCWzEqJPPiE1WDhfHSpEnnwyQPfC2zhh0rk
ISALXTqOpG1WIg8BsTnbf5aJVyIPAek0O7AyJ02JPAQk9JfToS7nlMhDSJo5
zQ0V15T0f9yw8Ek=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQE1cUhpOQ7IY8N5H0ITaMrwLVgii2jo6eO2oQFZ0KVhBQGlCKqBUU
tIKACmikdsA6Gh4OdIpSHx3UQQSdqb0KQrWWShFi5SEvUURRBALIqyQczszO
zu7ePef//+/OnRq8y3urgMfjbR27LPeJWmk6Ou2CTkiLtckd64qzwXV64eWL
4RPP+dD+xKPWnCqkElNuxGJJEXRqgowphRPfb8GumS49IbVC6j7PUiWQ1dwt
O8QX4fpy+DdtsrjRUUSbY+zyVzTdB/Oox4cJa0X4fwWIWzfvC4wWUc8my4JK
8Pc6ErH3jAj7VUHUZM2Gv0pE1MGyXFsNUq/kIxs7JvqbgHnqv91hEkPNToGp
d3ofQ4aE2W+/iMF5TyAplrp4hTD0gbXqYOv80A+u/MDg/AbIvLyqVHeNod7W
F41wsEhiktYzqKcJVqcH9PEYli6xDmwG4ZDJNN2VRX0toO26777Hj6XOlvFO
rTAYNVD1+hCLep/B3NrwpJ8usVQz1izGrg1m6udov6lmUf9zaHCfffjrUZaO
03gBJ10fZ0Q6i9HPC3A+IPMt8BHTV+ssAttBt6ms4ON4Mfp7Ca+WvLmae15M
a6xxdMCpRTMCvqoSo99X8OiLeKodEdMxcWMNX0PxJf/3cmdb9N8JBs+ZTp+s
t6VWeflv4OXOaRGrE2wxj7fwMHfhqPGiLfZ7C5vsysWCGlvMpwuiPwoqM/Al
2L8LFjXl7Zv1uQTzegdGnUNwu58E572DkJvmh7eTJJhfNyj219pduyLB+d2w
xlSR+EedBPPsgU8rB75vEUvpWYu93B7Q3T283mG+FPPtBd/gLbG79VKamWGp
XnAp0fnW/SjFvM3gVuSzIfCmlKZaBZqhZa59R1ebFPPvg5rWLcfPTJJRa7vk
PvBqVxUGEBny6Idb6QMtLjtlNNYSd0w/zAn/M0uTKUM+/ZDW+jRYWS6jkRZ5
EQOwPf3LEvseGfIagF/tYdXCqXL6bail3kMe/7YhfK0c+b2HrvIy9W+xcmq1
GzgInVfjEkbOy5HnIKQdn7JNXyNHHkOQ6HN/xyMbBfIYghlXkz/zdVMgj2EY
9pbr2jcrkMcwNEjv6VOOK5DHCNz4vcBp4U0F8hiBHUKP5f3PFchjFMxZen2p
Rok8RiEkdrFr9jIl5skjd7O9g5IjlaiHR7JiVp7bn6PEfMe+q19cj/lbifp4
ZO1lnpdhUIl584nTqTnKSjsO9fJJYlhTT8ssDvPnk8xt9YVDSznUP7Y+u9rN
3p9DHgISvcB/JURy6EdAnE9X1YcZOOQjIBUHYiuNORz6E5CeExvYB9c55CUg
uTKXEFEFh35tiF/2sXvLnnHIz4b4n7jgcHSIQ/82JIpvNP4zSUWt8jpsyKn0
koQps1S4P4XkP/cT0u+WqqgVb6iQrMjumFa6UYX7VUjW5AfmayNVdPw4EZJz
BtYYZ1Dh/hWR2uHcssYcFfIXkb2aGEfPIhXuZxG5cGvT2YIKFR0/7kTEJe+i
0/Q2FfJgyG5X8vPpYRXyYMi9tLg+uUaNPBjiyy2xPzZbjTwY4qCv7meXq5EH
S7q1sviUADXyYMm8sCkZ3B418mDJ6Mn8BZkpauTBkjXCmtWOv6iRh5gcVCvu
FN1Q0/8BjNPqdw==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAlMVFcUhof7ZoEBBuax2ipglQiCodVi3cq5iAWMVWREQKRKrYAxKCAK
EbQuiBYRlyBaVFxY2kBwUNsCItqrtUoUtRQBi3QiIFvZlR3BMuN5J3l5ee/d
d87//9/Nnb4pUhVKRCJR6OSlvQs18e/HFnlfiVmJTVKHb8lFWOGVSEIWCs9q
6LC297acI2by2uyoL+XFMNL8ILXCTvh+Bxqvb6k6aC5mn8/T1h+g2iufslBf
WP8Q9nsXbOgZ41hjvLnaq+ERXDZblZPbw+H/TyFD09O+volj3g3aBZWQnHfK
ha/lsF8VRO2ct6v8EcdstcttqiEQqku/v8Nh/1pwkseJXG9wbNAh+MS9gRfA
VVt7duQK8+qg5lJpypUMjlXoqh7ytwZXBqQK8zUQ5zphqTjAMZXuxStYJroc
fH+noKcBrB+7Z8Vv4ZibbmAjvExvav00WNDXBOqQpDmtPhxz1I53eA2xTrNi
Mj0Evc2weLC8ZM0XHLOYbBZv3gLjbOuEgZOgvxXupBgtYzYc+0CjDdL81cmx
vOCnDdZOX/3MWcqxTl+twHaY1tln3jRC0N9/0FSUFpTRRViNLo4OyDzgetmn
gaDfTgj/urZZUk3YpLjJhl0wx2q3U1k5Qf/d0N3wUfSOMsJ08tQ9cKOgrMjh
GsE8eiEibsM7TbbQrxfmLxUtTT9LMJ8+GDbKOrIiRejfBw9qPZ7o7SOY1xtI
zmrmS3YI894A3XYkcHsYwfzegnSB48WZQcL8t/CCPG6qW0kwz3449iTC8ZQ7
YTlae9n9sOpHRaSXK8F8B6DH0+pKSyxh5zK0NQB28dP3PdcQzHsQAm9J0js8
OXZCJ3AQNpdfN5ldKOQ/BKH2ny05biVmunZJQ5BkV3TIcr8YeQzD80XD2+62
iVmCNu74YVitqT+d6itBPsOwqT2kYHephEVr5UWNwP2u0oRDM6TIawRqHQvr
C45JWXiYtkZh5nyT0r4BKfIbhQXzQxSqjTKmsxs8BqPy7MaKchnyHIPqzEUr
v52rjzzegYOmM0pxQR95vIPDu8cSqiQGyGMc/H7z/bkw0gB5jMNy+z9ds/4x
QB4TkOYWHpPvIUceE/Ba2vLrw6ty5PEewlSj/iNWhsjjPeTObbztdtAQ8xTR
n0Ja/M52GqIeEZ16oj2VBBhhviLqe03UsO+uEeoT0aAAswqFszHmrUfbohP/
Vp8xRr161Ez9cs9GPQXmr0f13yQG2kUoUL8e3bEuYai3RoE8CDV0s+r9y90E
/RDqV/eg/vcCE+RDaOXJrqsaQ1P0R6j5orwjm91NkRehuV1rVvXFmqJfjtbd
U9UcKjBFfhw9b5s5YNNoiv45OnvkwvFnZkqmk9fB0eZbFbFTnZS4P8W0dU8m
2b5UyXR4w8R0sXhsyv11StyvYvqNU2SuTbSSfThOxJS3nHZ87w9K3L8S2nO6
7ParS0rkL6GJhek23sVK3M8Sar12z/lfnirZh+NOQoPmVtjOaFEiDynV5G8+
e2ZciTykdKA/p9vYgkceUvrUfwuf7MwjDymNTyS9smU88pDRFsslu46u55GH
jEa4+Jw0jeGRh4x6zXztcu4ojzxk9LsAhcesLB556FPVJ8tvFt/k2f8E6+/4

     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAlMFVcUhh8zb2N7vBkVYmtQECoWrNVKGkA4F1FcGkWeVlBRKQG0BgTE
mgAVUEFwwSWpUCjQCGqrQaCIQHHpdScEpYBAy1Z4yBNkV3ZEynucOclkMjN3
zvn//7u5Fn4hqgBGJBIFzFzau1D5r/NkN9aJaYl5fLdnSSaY+r+Y3OcgPOfC
uE2Iq+kyMTWozw51NiiGp4PKhIpFwvcHcPZuQcWJuWK66ittPYai+O28g1xY
/xz4rSNe/ZMsVUfOzV3fVg6nP/k541o/i/+/BK7DoX13O0s3tGkXVEFBXqMN
X89ivxrwiDx2qKycpQu1y81rYWztwsLoByz2r4dMk4fjqwpYOmLjc+HR8D+w
scEPuq8J8xpg4qo4/koqSyt01QS3Q66XeyUJ81vA13GDUnGcpSrdi1aYL3n7
7ZMjgp42KK88+0vkAZa66Aaq4VTasrYvfQR97QABlZ+98WDpUu14m9cwtDws
KMNN0NsBuRN8wbavWTpvplnkXA0EPS0c1bcV9L+BZRd3OFNzls7S6AT1rrET
R3nBTyekWKeV2UlZ2uOpFdgF3gNOivZxBv29BdO7zdtSexlap4ujG6rjY1I9
2hj02wOXtlr8J6ll6Iy4mYa9sOnTx1b3yhj03wdyjf/Bw/cYqpOX2w/P86X5
NvkM5jEAp6N+H27JFvoNwBr3TU6XUxjMZxBEXE/sN2eF/oNQ0pj0TC+Gwbze
Qcz15UYlh4V578A1rMrzUCCD+b2HCafwFKtdwvz3UCSd19ywmcE8hyCyqsjy
kitDr2rtZQ/B6nTvA+vtGcx3GBLcza5ojjI0LVVbw0AjLGJetTCY9wj0lEou
d7uz9IJO4AjIy/4w+TxPyH8UFNYrVp83E1Ndu/hRsFtUFGcaK0YeYxDsOBb8
sFNMo7RxR45BX3PTT0meEuQzBvIu35yIUgkN08oLHYeI3tKouMVS5DUOiUvz
mnLOSen+QG1NQJm9SengsBT5TUCrva9CtU9GdXZ9JiHLIFtdUSZDnpMQm+G4
+buVcuTxAdTNPaGKdDny+AArIiajaiT6yGMK2Duev+WF6COPKTCwfmqf9a8+
8vgI2132h990M0AeH+GmVFP4/JYB8piG+aqJHeNmhshjGrxXqu+7nDDEPEXE
z1ezPaXHEPWIyKvzXUmMlxHmKyJG+aK2mIdGqE9ELL3mVCjsjDFvPXIn7GR1
brIx6tUjHbcaf9ynp8D89ciTwZPei4IUqF+PLNkZNTpQp0AeDKlxNhv429UE
/TDEpOFZ0185JsiHIcUXe2+1GCrRH0NGHW4k+LsqkRdDTvVu2zJ4VIl+WXL3
kaouLkeJ/FgSvTBj2FytRP8s2Wv7w57KORzVyetmiSY5c90CWw73p5iEKr6v
Cl7DUR3eQDEZ2Uk7H+/kcL+KSYPqiyPmYRydPU7EpGZBnc+xRA73r4T4J4ac
a/2VQ/4SMp2+pnd9MYf7WUJaNi4+ePslR2ePOwlJdgrus9RwyENKrtZOByRP
cchDSlZvcbxvPI9HHlIS3T3ammjHIw8p8fY990C2lkceMpK5gbqd2c0jDxlJ
ffRirzKcRx4ystt6z8fUMzzykJHK6uPckiweeciJyqo4ofhPnv4PvCv3JQ==

     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAlMVFcUhmfumwUYGWcGKHVjqxYI1FqluMRyLiJKA4qIgRQQpAhqtVVQ
UVBRRBNcEEsVg6FaRdpiYUCEslTkIm2hSlXcsGjYBXTYcRAEocx43kleXt57
953z//93c62/3r42nAgEgvDJS3fna+/ERO2v7iJWbHFU41N8Achqc23IYv5Z
DZmWJUs++ETEjOoydnxhVAQ5XQGHaqz47zfhdPHYX4dNRcxpga4qgRy5IFts
wK+vgsXe1Kd3lGMtsabqlc23wWt6S2pmL4f/3wWPFwnPA1s55tGsW1ALLnlz
bFR1HPZ7CLb7qjZV3+aYpW65xWMQr9iSE3eTw/510KCQDTrlc2zILij5lvYp
/P4se5Emk59XDyd/Xh13KY1jNfp6DmGRfZX+Sfz8Bpi7NMVQHs+xtfoXTTAi
cfL+cxevpxkqax+fid3MMRf9wBY4lb6nfl4Qr68VgjZNs+rw5pi9brxdG9jM
/yP8Rzde7wvQjAX95ruQY2aTzWJN26GgarzP0IHX3wF7U35yZhYce0+jE5au
X7Y/WsX76QShXVuFo4RjXT46gS/hzsBRaesIQX+v4HSZ7aq0bsKe6OPQwLrE
f1K8mwn67YIPfbc+FT8mbFLcZMNuaJxlbHGjmqD/HrjUqQ6LukGYXp66F8Kv
r8myyyOYRx84xA30NGTw/fpA43HG6ew5gvn0wzUT51jPE3z/ftjVUFcuPEgw
rwFYmBUjLo7i5w3A6M4Znt9FEMxvECpcyk7PDuDnD8J+w5An9asI5vka3B8J
Zn7vStgVnb2M1yC5eDl05ecE89XCy2ON09ujCTufpistzCx7OfywgWDeQ+Az
/q9cs4JjyXqBQxAsiz1mn8vn/wY2bh4pTDIXMX27o28gPixu3OyQCHkMQ+kB
1sE6RWyfLu7YYfCzzpQn+YiRzzCEONp/HFMqZpE6eTtGoHBegjbhIwnyGoHa
bXv8sk9K2KYIXb2F2TF1C/q1EuT3Flxi7BJ9QqRMbzdoFLSrtgbVVEuR5yg8
bCJVG+YbII8xsLIufGWcboA8xiD5RqX2gdgQebyDDcPTrHO3GyKPd+CxOSn3
0n+GyGMczsV/2p3lZoQ8xqHpS/Xcqhwj5DEB/mdv3R82lyGPCUjbfXWhy2EZ
5img2Rnqu6ldMtQjoCYPrkmJ/xTMV0C9B6sDDlZMQX0Cuub8M3e5ozHmLaTN
BZ5e6lRj1CukM/ozhoKFcsxfSEecvB5YbpOjfiGNSHeL7HsiRx6EiuMbt9x3
nYp+CPWclexXnj0V+RC6Or/2mwaZAv0RejIwaflGVwXyItRm6iJZf7QC/XLU
r835hyPZCuTHUXPX+HyLFgX652ivzb5190yUTC9Pw1GT0l+WznRQ4v4UUX+/
3dXfLlMyPd4IEf27/F5j5VdK3K8iWn2PbrWIVLL3x4mIWl7V+B5IVOL+FVN/
y8SEpotK5C+mvc7BbSuLlLifxdSuyTX0+l0le3/ciemVqlMvbNqVyENCe9bM
Xp/6Tok8JNQ9P7TA2EyFPCT00Wc2TxMdVchDQtMOlxRKl6uQh5RG0b4lxwNV
yENK844J/BQ7VchDSg8WpmjTjquQh5TemVNqYHtZhTwMqMBpIK6oRMX+BxFV
8Wc=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lHtQVGUYxnfP2QuwsOxuIEKGWMpAYjIshvwR70eIl4EVkUYTKAxvZJqQ
uq1rXkCcAQSxNArHvK0MmtyiDAKST7Egh5CbQKLIRVaE5arAAoKx63vemTNn
zjnfed/neX7ffAui96zfxvB4vG2zl+nOlVJ05s7VQAEtdj7eF1p8HoJTgr6J
8uWe88AQ0X/LfomAWjXrYj+wKoJht3RxtQv3/SY0vvBUJdgJqLfSVBUQSOu/
W27Bra+ExBP7WgamWNqptctb1XEXMjfMcc4aZPH/GshYULwlooulqztMC+og
0bDpmryZxX4NsKdoaqDyLkvnm5Y734d1CT95H77JYv9meFcFWu9Clo65Rabf
Hm2BcYeO8t4sbt4DaOhMEF7KZGm1uR5Cdu7CoI1p3Pw20Gj+PmUTz9L15hft
4BcQ01Sxj9PTATKp1TxtDEv9zAM7ob7l+meekZy+LjivU2XrQ1jqbhrv9gRi
vhw0nAvg9HaDt++3XmE+LLWfbaa108M4q9RYLub0P4XymsY/y51Z+ppGD6Rm
qlm1gvPTA2u3zl3jIWKpIdQk8Bk4Li052TnBoL9eaJqIaPyxn6FN5jj64PKd
aceQDgb9GiA6/UKU8D5DZ8XNNuwH13D/rNIqBv0PQPfCrt64Moaa5eUNwtXB
RE+3AgbzGIK4Eld1m47rNwQ+x6tKz/zAYD7DMBmykx90gus/DNTJehX/CIN5
jYC2Oze16Ctu3gisLgip372dwfyeA//gsMPCcG7+c/gr8PQnD1QM5vkCUmXL
dKf8GXrFZE/3Ata1NvWsXMZgvqOgTX7spFcz9GymqUbhWtkzY0Mbg3mPQef0
v9K+lSxNNwscAwuJNtk9n8t/HAQxEzfSHATU3O74OHhuOTxjf1SAPIwQdYg+
pT0CetAUt9YIQy5Z0rRQIfIxgsjD3fVAiZDGmeTFTsBez2Ojx94RIa8J2L/r
6w05qSK6Y7upJuGOplk5PCpCfpOg17glhUaJqdlu5BRcUX0RWV0lRp5TENvO
VG72skAeL+GRy41em3MWyOMleJRVjNYLLZHHNIiMjgvy91gij2mY2ZGWf+k/
S+QxA2vjl/ZfC7BCHjNwcU3ee5W5VsjjFbz5/e1ao4MEebyC9ft/9vFLkGCe
PBKuy6vJMEhQD4/8U/eLmNlojfnyyMxIVfiRW9aoj0fmnm0NlHrYYN58cuG3
oOC8DBvUyyePhnRjn/KlmD+flHoH18/fJUX9fLLoXEDcUJMUeTDk5tHHn9f6
26Ifhti8lb6hPMcW+TDEu7BuZ5tEhv4Ysj8ibcVWfxnyYojAdrlkWC1Dvyzx
ffL+6cQcGfJjyUsSX+jcKUP/LMl2ig+694acmuX1sST6UYFy3mI57k8B2XI+
vnz3h3JqxrtdQEoWPW6q2CTH/SogrcFh0c5xcvr6OBGQkz78oENJcty/QrL7
94va9gty5C8kvLoDrauK5LifheS0evPHv9bI6evjTkgawgoevq2XIw8RCa9e
/VHGtBx5iEjsnOTrNvYK5CEiKk3wvSQPBfIQkakr+hzxCgXyEJPo5S5eKREK
5CEmPeuUKtleBfIQk/LAKkNmigJ5iEmHZuSV62UF8rAgtQFL1EV/KOj/9a30
Ng==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMk1cUx797v6+AxiGFkr2wQ5mzhhEWy4Lg2LlO8b2hlThEuhEGjKgI
6txihSFTpoBMDWMIYcgGDDJJJR0GUAd3c7OKPBTjA6EyUIFaXzwK5VXXlvud
pGna3u+c////O73zY5JUcZjjuDjby/4u1t05itrKUIHWyTNMm+qKwaMib9/n
QeJnLYzsCLzg6SfQ2XdKk0Nm10JjQAfX7C3+3gBZVs2q72QCDVDa6xJor3gd
W+ointeDNLfhxrNJnvZqZNrVPU2Qo45+tfw5z55vBakCq7c94OmaHvuBG1Ax
VPqr9A7P+t2ElX+GDuibePqW/bj8Fgwc6ff7toFn/e9Avipzb4COp6OKqON/
m+/C2nm+9Y/LxXn3wNLfbC0p4Gmzo7qgSrdr5ac54vz7EJHqlvVKOk9Vji/+
g1lrdG2XvhL19IDePdxTk8DTDx0DeyHNYI58L0rU9wCUlfklfWE8XWwfr3gI
pj1BfUUrRL2PoDKk03dzIE89bc00sj6Ic0ndPctX1N8P3jfltY1yns7QGICO
n+nUPnfRzwAUJ8R89K4TT59ssgs0QrhSONo7jpm/x+BqLW859RTT2444TNB0
ZbVHWA9mfp/AyVxjhOQWpjZxtoZPgXyWXXzhCmb+n4FV4fdw90VMHfK0z6Fx
uHWxohqzPF7AwYbkpPulYr8XEJLpfu7HfMzyGQTL5pqJddli/0Gol28hKA2z
vIbgG+NYRu0ecd4QLK0puJYYj1l+w4DSlknfjhTnD0PVWsOWex9jlucIxMrS
ik4sx7TMbq90BAK7vXtXvY9ZvmaQflFdM63AtLDAXmbo9FNN/OGFWd6jcNoy
DNvdMD3uEDgKGy7lZXgLmOU/BrIfAq/dHkPU0S5jDEwRHW45JsR4WKDE58CW
Fd2IHrDHrbFA/DOvovF2xPhYwKe+oefsZUR32+Ulj8O9Q9GL4s8jxmscKj7B
iV5aRL+Mt9cEfP16ma79F8T4TYDiYajlaB6iDrtRk/BE2x8CmYjxnATt/sxD
5hTEeEzBzpW+V88kI8ZjCgLmtrjGxCLGYxqGO3aFvxaBGI9pOFvmVti6HjEe
VtibpOs+DIjxsIJ/cPjCZUrEeLwEszC6ffAdxHi8hIq2/OqKNxDLkyOawqBR
tauohyPBcZ3LZBixfDky5p+a3mTmmD6OXJyQ6w8aOZY3Igf/pXMCDRzTi8i6
EzGqp9c5lj8i3DbhVOk/HNOPSO3C3wxb6zjGA5P9L1b7uFVxzA8m5IIx4fJp
jvHBZO732dqUXI75w6Rpo9/IkiMc44VJ+pttQUYNx/zyRB3cWXMtk2P8eDL9
+9Ztnuc55p8nwWuGYmMfc9Qhz8QTFw91SZ0tj5n9FMjGHcX3pbZ8HXjjBVKi
eTSUdACxfRXIue6duvYziM5cJwLJ2qUeCepCbH8lZHmX7mT5HMz4S8jWJQvi
PEPEfZaQ631ofWYipjPXnYSEapTzUbG4307EJ91Vn9Iq/l+dSMv4hnlTVnHf
nUiqwSJJ8xfvPyeib4uMlUSL948zWWQweh0/Id53zuSnJR94ev3FMx7OpLLR
oqwa5BkPZ7Kn+mo0LBAYDxeSqAs7fEsl0P8B2Bjxyw==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQlFUUx797v+XRDikahA9ChHiYliIQMgTnMj6yRInHUBGKw8C6ASKm
jM1KEBnparQQEQJGNMTwRkLNHWLoogQCDZPQgg+QFgrl/X4tC8Yu9zszOzu7
e79z/v//7+zdGnbKPwJzHBex8tK9C5X+Uk1x0X4RVVolD/kpc0Gb2hMT6i58
roDssKSb5q+LqLgzP9ZTfBuKd9pqWqyF32vh8mI9fGEmoi7OuroLuFGSvMdY
ON8Irt8at4wu8rRXZlbxtroZ9h0tMS0Y49nzreDn6BP0UR9PD6p1B+6D29RI
zrpOnvVrh421CnVjM0+36I5bqQDLnRwSannWvxO6AtqjXap4OusYorgz8wBu
WcVVDRYI8x7BpYGX5/OyePqnvrog6KbS8/0UYf4TeC0x+MKLSTz113/xD2je
0d67e1bQowZqlrtGJuWpl35gL3zTA4G7QgR9fRBQos7q9+XpNt14x39hU9yF
nmt7Bb3/QS/Y2QW48dR8pZnMrB9+ETdGvrBd0P8UZCpp5e9WPF2l8Qz25Iln
49YLfp4Bjirz2GHI02E/ncABaHY9ktS7gJm/QUjlxhuujmDaoY9jCA60pJn4
qjHzOwwm3zv7G6gwXRG30nAEmo6rMn+7h5n/Ucjcfq77dA2menkVY/Dx7AZb
x0rM8hiHzXXV0if5Qr9xGLwSUvFdJmb5TEB50PLUu1eE/hNwdmueO0rELK9J
cBn2Trz9iTBvEkZ/7as/KcEsvymoTUoWvxoszJ+CZB+H9x4dxizPaXjLoikj
1RvTn3X28qdBq458fMAVs3xnYFqiKV9yxDQ7S1czcMvp2tQNS8zynoVPtZ7u
kaaYKvQCZ+HNxp4EaxFm+c+BNi2pvmMOUX275DmoDLEVpwwhxmMe4h3+8N3b
g+h5XdyyedgxKclYaEOMzzzM1xg/vt6A6GmdvNgFKLpYYi2pRozXAkj8fSSW
FYiekOhKA7tfGS1t+wkxfhoYfKqYuJSBqN5uyCJUVTm5gRwxnosQ/Vl7/Ew8
Yjy0YH8w7k5pLGI8tDC+3sI4LBwxHkuQ1608vOEDxHgsgbQoOL31EGI8lmHX
Ge2DLwExHsvQ75lr5eGMGI/nUG5MwifsEePxHMLa1cWFmxDLkyO2uRfGjq4R
9HBkXGrnaoYRy5cjJc6NsuYZjunjSMyylH4+wLG8EXFoEhu6dXNMLyID6WWH
Rv7iWP6IlBw7kpZfzzH9iEi3jXd8qOQYD0xsptMsTcs45gcTda1zWMOPHOOD
yQ9yVWF8Osf8YRITeG5k90WO8cLEdstG5wEZx/zyZEmVeb1FzjF+PHGLNAky
r+aYf56Yn8gJDR/kqF7eEE/2tWizlSt5rO6niMinXR6uW8lXj1ciIh3iMyOn
ziO2ryJiUjpR1laK6Op1IiLhhQ9H3bsQ218DEnnD/usCE8z4G5C1nSmh5p7C
PhuQnK8i9stPYrp63RmQDG/FZpQr7Lchac4Oq4tvFf6vhiRQkWWhXRb23ZA4
WHhxiTuF+8+QVP599ZjBceH+MSKaNmsLRapw3xkRD6/otZZ1PONhRFpENm+U
TfCMhxGJ8hsOBhsR42FMXO9HJaj8RfR/9gDw6Q==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lA1Uk1UYx99737EhGTpjWkSgWIpCoaigiT7XICzxA5amoqQSH6YR6iEy
GAL5gSAKpiDYRA04lOOQ5SFQQi5qaKAcmwp+gDG0BWMg4/tT2sZ9n3N2drbd
93n+///v2Z0WFCEPwRzHhRhfpnehltn6KX/6UERL7A+2+pdkg9ed13o/WyR8
LgRNdtFi2bsialWXs2uJVTG071yfUD1V+P0q1HsMVCbYiOj8eaa6Dt78D+MX
Wgrnb0Jcjae8fYinTdE2hcs1VXA86+mp3Bc8e74GUoLjGwKe8fQjjenA36Bw
dZwureNZv3sQNHh9+80qnjqYjts/gNV/hhTGXuVZ/zqYkSbpnvcbT3udNqde
63kI/QE/L9LlCfMeQ/U7vnHnsnh621z1oOzQ3/j0qDD/KewuPWb1agJP5eYv
GsHz0By/65GCHg3w/ur0b7fzdKl5YBPcfTPyietmQd8zOK2VTdOu4eks03in
5xD8a3Go0kvQ+y+4KDYWyD14KjM2i7bRQqfPkMHSWdD/HxRLz3iU2/N0jEYz
xNQvjf16kuCnGUh+4zVnMU/1/iaBLWC95zvLpgHM/OngjufbqzPbMK01x9EK
mZLKE6s1mPnVQ6A67JHoAaZGccaGbWB3ZpxD6S3M/LeDJkwVvPsPTM3yCl9A
ttuqCzMvYpZHB4SNtL9oyBH6dcD8W2kLTp7CLB8DGL53i1lxROhvgIuB9ykX
h1lenRDpFCUu3iPM6wTPrikrw0Mxy68LBssuH58eIMzvgmuHN9U9WoVZnt2w
75MRu7RlmOaa7OV0wwf2Z4N8FmCWbw9UfOGdP+KE6eksU/VA8nyt/pIdZnn3
wsrRRLcdEzFNNQvsBeuqWXunijDLvw9un6wuq+1D1NzuYB9kbAnnj7YixqMf
1sye8LHXP4jGmOKO7ofJPRePDagR49MPteXy+79UIrrbJG/XAGQmd78RegUx
XgOwYV3GFrtCRMNCTTUItlMX5qnPI8ZvEJ7oHukOpyNqtrt5CM4VxcyBJMR4
DsHW+LeiehSI8RgGZ9/yUtUuxHgMw3PZNhQUjBiPEchuxMtf34AYjxHYrspN
qfFFjMdLcI3yUR8AxHi8hCbSPGXxPMR4jILqleRAwwzEeIzCjlrnnHxbxPLk
yOzzd5oDrQU9HNHtjHjPBiOWL0cK3KWRVT0c08eRr9Cly/EtHMsbkbm31466
N3BMLyIdGb3ebXc5lj8iqm2ZyTk3OKYfkXCX9+9uLOEYD0zc+57IJhZwzA8m
3RWxmyrPcowPJkUpDucVJzjmD5OI9RVat0SO8cJkluPnLi3RHPPLk0t71l6o
TuIYP57oZ5f7ya5wzD9PQhK9A4J1HDXLa+VJ2QFleokxj7H9FJG5cdX3pMZ8
zXhDReRLJdccEYPYvopI3jdR+WoVomPXiYikaNa1LKpHbH8tyMMjpw/ljceM
vwXRKwY2ypYI+2xBfpz5FySFYzp23VmQOVatMpQt7LeY7C/6vVRRI/xfxWTS
DK10+KWw72Iy7L9/cJ+rcP+JSebj2g0WW4X7R0ImVK2XpqYJ952ETPZVjrOr
4BkPCWlb4etUYOAZDwlp6LJeB44ixsOS2BsS9z6Qi+j/U7Twxw==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQU0cUhu/uvYQMVioatCKDqGNFRHwgCFU4q4i0Mn2ArU+kQIXayiMi
WBtRYaYiioqMItXWB0aqUyQUrIIU6VKpYmQoIgTKABXkIQFEhPAQISVh75nJ
ZJLsPef//+9k5wRH+oVgjuNCxl+Gd7EGbFtO3fASaL7NkU7f/Esg1e7oCXAT
P6ugR6VfYblYoGY1Srm7WR7kfZeueGwr/l4Ex9d40niZQFc4Geo+/Dqp1cRV
Kp5/CJM1CT4vR3jarJCpvJvUEHfFLuVaD8+eLwfz3WrNtuc8/bDJcOAJXHUO
s7ao4Vm/p7COMw9+qObpbMNxm2poUmdfP1jEs/41kJLq2+2Uy9MBO//kv3S1
sDqwb7k2Q5xXB732qfuvnOdpmbHq4bLOpWjTSXF+I2yltfzkeJ76Gb94BpIk
xUf3o0U9TXD3C+vk73fx1MM4sBn22xZVLfEX9T0Hh84vrdo+5elCw3i7Fui4
jQJ/9hT1tkJGnDLDbyVPLcebKWRtEODj1SldJOpvh5nT25f+acPTCRovoPJZ
4r6YqaKfF3A2075wkYSnXb4GgR2wYV8Zah7GzJ8WpGsivH/sxlRjjKMTHk2a
cvKTJsz8dkG8JqdSqMZ0XNx4w25wT9/43h+lmPl/CUO7dTv2FGJqlKfqgTyX
NOWC3zDL4xXsRW4dDUqx3ytwKatzPJuGWT690H8uNnpDkti/F+4E2RRwhzHL
6zXIHaj+TpQ47zUsGwzyCg/FLL8+0BbzSfO2ifP74PcTGRX/foxZnv0Qudl7
+uk1mF4z2FP2g+Pcju3rnTHLVwdmv+x3HLXD9MJ5Q+mgVG4Vfcsas7wH4Nyq
wrvfTME02ShwAD6XBOhnC5jlPwiyJ/p1mkFEje2ODEL1T+nHT3QixmMIzod6
Vqz9D9EDhrgVQxC8rNVyuBIxPkMw823C9uwHiO4xyJMPQ9UDu/SQAsR4DcO1
FHXbLBWiX4ca6g1s8Q9zqExHjN8bWLzAPCoxFVGjXf8RqO/NzvM4hhjPEbha
6DvaH4sYj7ew82jf2kw5YjzewlK/1MSgnYjxGIXX1ivLZ2xBjMco3GyvnVbu
gxiPMYjKVWz9ARDjMQZuB60vf+CEGA89aL2LWl69jxgPPeRODbS/boVYnhyJ
aEDyHeaiHo643lDenoYRy5cjXVFeI490HNPHEereTuI6OJY3IvukxxJcGjim
F5FVT+3Luio4lj8iby6WWShLOKYfEdWuiM1b8znGA5NDTlMuvnuTY34w8RjL
af77Msf4YDJYutEu9gzH/GGSf0YXvvwox3hhciIg7dYLBcf88iTgoNLx8TGO
8eOJtntOtayAY/55Mj2poPErLUeN8jp5wm+ab5U/nsfEfgrERxW6xWI8XyPe
UIFcupcVFnkAsX0VSO5cZ4fKTEQnrhOBfJszP8KtHrH9NSGesw9MyngHM/4m
5LMYbaPMXdxnE5K1UF2SGI7pxHVnQlzvjVzgLon7LSGyEg2JLRf/rxJyb7Vl
2siYuO8SEmlbfPjQEvH+k5B/ps5rFALF+8eU2Nrmnjt1WrzvTMnVGCF5VjHP
eJiSPFycldnLMx6mZE9fSp3HXIHxkJK9uhljVX4C/R+Yye+7
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQlFUUx797v48FySByRUYZRCR5iUS8Bo09V6zUGCwJBTdzwAdIiDzC
RpFSEg1SAiZREeUxwAChKxMFqzV6VdQAh2hFlBR1wQhZnsoCK6/Y5X5nZmdn
d+93zv///529S7bHBu3CHMftmnnp38Uqc9ifUv6hQJU2RzUblfmgu1fWvc1X
/KyAvNL1K+a7CtT0QXGcn2ktFCVovmq0FX+/CsdkGZdTpAL19NDXTdDOcZv2
MRHP3wG3+80f9I/ztCNJqlirbgD/woQfSgZ49nwTQLS0Wd7J03Vq/YG/wcm7
Zr7FA571uwfWKPTzOw08Xaw/bnMfRht1hd9c5Vn/B9ByKq/L4xeejjhuzbyh
fQiXwv2W95SK8/6B5OVP4wtzeXrXUI8hePRw7eYMcf4TWHLDbnJuCk+DDF88
g8ETdf43E0U9aqgNiUg7sJunMsPADki1M2ly2yrq64TP+irmdX3CUyf9eMfn
YK0M2HJujaj3X3j0XV9+kA9P5880S5J2QX5g5nMTF1H/fxBl5e58zYanszS6
wb1TFbvvbdFPN2gvJv7mIuFp70a9wBdwfb/luFqHmb8eyF6jJGf6MG01xKGB
DWbyYxvUmPntBbO28UbhPqYz4mYa9oGq+LzF739i5r8fju2FkPg/MDXIUwyA
3Fd9zqEKszwGwUY40tFeLPYbhK4me8eTpzHLZwgqc2/HfHxc7D8EUTt3V3OH
MMvrJTi5mepqEsR5L6FXVymLicAsv1egqAtMXSoX57+CvZkD9W2BmOU5DN7y
bPOs1ZiW6O0VD8OEvcemj7wwy1cLPRU3HCYdMT2bqy8t1CTujKm2xizvEdgD
kuqotzDNNAgcAVfT8rHFAmb5j0J/y3pZ6yiihnZHR6G6QHPkhAYxHmOw/cuM
ev+niB7Ux500Bu96uZnrVIjxGYPe6ebgS7cRjdfLi9NBVUPC2V1XEOOlg9gc
6bNFCkQjI/T1GlzCat5RFSHG7zV0OYdGp+UgarC7dRzKtboqWTpiPMchmuaN
DCcjxmMCbI/7vV8ZhxiPCejY9DQlfCdiPCahwDblzoJQxHhMwjaN3ZtNAYjx
mAL7mrqgVECMxxQ8OxxxZqUHYjym4VyAyZPBZYjxmIZgy5+Xli1ELE+OWKsD
or4wE/VwpLuyTzEPI5YvRxRfZw7XazmmjyNhq91XHn7BsbwRWTH33iHvdo7p
RaSrNfFWbzPH8kekosjyjeI6julHJHSP8tMtSo7xwMTWR37K/ALH/GDSiSYe
3SrgGB9MSu6eX5L8E8f8YbLtNES+9z3HeGHisl19oTuJY3550mEV5tSYzjF+
PFl3seUv6RWO+efJQMWOth09HDXI0/DEy+yWVDmTx+x+CqTEZzLIYiZfA94I
gdQFroqMPYjYvgrEpP/yMlUlorPXiUB29BTt9n2M2P4akX0j/UalczHjb0Qs
Fm5uk/qJ+2xEDtS7XkuLwXT2ujMi51NDcrh8cb8l5Gq786rkJvH/KiHhqvDs
8Slx3yXESi5J+tZNvP8khC4IfyiEifePMZlj+SLrxyzxvjMmshTP9EXXecbD
mKjW9pRVDvGMhzGJO/lri8xOYDxMiKvUc6wlSKD/Azs18Ug=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQlFUUx++938fCKIoG1CQKEgyCZDohkAZ7rs9Mg5SKlCEe8lBUAgyn
4aH4VsRAAxXQpACRhFktJJFh8AIhD3VNEFYaQBY1kTfIG8HY5X5nZmdnd+93
zv///5295ttD3AIIQihg6qV5lyp8deWm7HUiKzA91rGl4DI4zWkM8VohfVZA
k3p/vtESkc1QZYQ6z7gFbQqz8eqF0u/FoIwsoYeMRLbcTlNlIF/vd9xRTzpf
Afvm6tzvGhdYa6SR4jN1NZxqzJqb2SPw55Vw6uqGbz2eCWyDWnPgERzY235p
jkrg/WrB2/l0691qgZlpjpvWgbPeR9b7iwXeXwULah8G2/0psCFrz4TSwSfw
+pewvFdXpHn/QuVOw9G0FIHd11YjXLTLl7v/JM1vhl2T7kf1DwnMTftFCzhU
jVSVhkt61ICTUg0idgpMrh3YCkovp2+Wekr6nsEFm+bUF18KzEYz3vo5eA3E
tFxcI+l9AYvumFu5OQrMeKpZpNF/0B1btlvPVtL/Egq+Dvij2FRg0zTaINpM
dzj8HclPG6xtz3aylQmsc4tG4CuQ5W88rB4l3F87PIjprLjQRVi9No4OOLMx
fparmnC/neBuvOwrsY6wKXFTDbtgXsuj5MJKwv13w5NrPzSHFhGmlafogcx9
xpaLbhCeRy8E0ltBTRlSv16wmrnteuIFwvPpg+66sYHP46T+fXDz10srUQzh
efVD2G75wb/2SvP6YblDS/meQMLzew1j6PBMCw9p/msouGexpcGF8DwHIOZ8
+fmEVYRlauxlDAD13dG4zp7wfAfhVq6++YQ1YakpmhqEuB8VgXnzCc97CFat
3pwbNIewBK3AIRBn9feZiYTnPwxFqkTH+mHMtO2ODUNSuv3+0x2Y8xgB12BV
6eqnmEVp4o4cAYNPIvRGazDnMwItxMT1+l3MwjTyQkch+UFRYkAh5rxGwSPZ
q8FEgdmOQE2NgYEfMqv5DXN+Y1C/JN3/5DnMtHY9x0ExsuaaPBZznuPgXfai
ZyAacx5v4N34E/Y5oZjzeAP1W22ifP0x5zEBSRb32HtbMecxAXu698iUmzDn
MQnLbs/+4ihgzmMSao/cOLvSDnMeb+F3VzdVrxXmPN5C4PsD86/OwzxPRBc/
P7f9u9mSHkSbFY7ZhgTzfBH9OaKhq2oQcX2Ifr82yu7gK8TzxnSxwYIIhybE
9WLa1VBc3PkP4vljmp7pI2b8jbh+TINCyMZtBYjzINRqZWaCQS7ifggdEtfX
lachzofQKw9fzotORNwfocGpsT4fn0CcF6GfBthmtUUi7legLH++5b1YxPkJ
tCP4RLVRIeL+BWpXrf/Yrx0xrbwOgaZV+BsUTOUxvZ8iXVKa6DJ3Kl8t3kCR
ej+t9A2JwnxfRZpVKDevycFs+joRaZilqd+KRsz3V4fWKbejK/qE89eh6jsl
tUbO0j7r0IxdZ2+fDCZs+rrToR+65CWgy9J+y2jKyAH7aKX0f5VRFKSIG5+U
9l1Ge5I2hR9YKt1/Mpq5IK1G9JHuH106ob8wLv6MdN/p0pnx/kdMSgTOQ5fK
4g3Tc/oEzkOX3nRQKeUfiJyHHjVZvrn/sZvI/gds3Ovz
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQVFUYx88597IgjyQhCyQFnSGEEIyHtDPxHR8MogjhjA45KyQKAmZS
YPHQgEItUWkQMnQG5KGBypJkSoB4kkDcIQqJl4XyVBAWF1zk4YPY9dwzc2dn
7579vv////vOsQvbtzmcIITC5x7dp7Ts/RTexT4iq1h8aDioIhdkzvZRIe9L
35XwaOyW0tJZZMbthTEfGF+DK5VRWpWt9HsNJKWZyFMtRebuplu1cC6gNHmV
kbT/FohWgXXqZwLrTbRU+vaoIKVPY1z0WOD/bwIjZeaH2/oEtr5Ht6EZzsS7
/2DeLvB6LeC9tu3fepXAlui2L26F+2bxdgdrBF6/HdI7rHa7lQvsqYMi4+ZE
B3gWVl0aOif1uwsDe7eP5+UIrFG//oNcr9lVW49L/e9BoJB/0DRVYJv1L7rB
oGlN7c04SU8PVP/Yb5QQKTBvfcNeiN15OMBFIenrA6cVDlkDgQJbrmvv0A+9
U7c7z6yV9A7A2do9SzavEtgbc8USLR9AyAmzcCMnSf9DsPio7ELNYoG9ojEI
d5YFaeIWSH4G4djouIeTTGAjQTqBQ+D/W1ZSzzTh/h4BSvP8/ZSasDZ9HMNQ
G9AhC+gh3O8IpFgl+outhM2JmyuoBnn/oszKBsL9j8KM8np7TDVhennKx1CR
EPr2Oz8TnocGYtfhnV2FUj0NeM0vLD55ivB8xkDbuW7UL12qPwZlRQ/cUDLh
eY1DzL5vE65+LvUbB0e5441PIgjP7wmoxUZx2Tap/xMo/2vvhs5NhOephejT
87/PWE1Ykc5eoRaWhl9u9fEgPN8JMB2ixc8dCDudo1sT0PBLr7rchvC8n0L6
V2luUeaEZegFPgV/P/uEJSLh+U+CuWVDTeskZvpyhyah5V6UeGwYcx5TkFli
smHNfcySdHEnTkFAXGnG1B3M+UyBNQS2Kusx+0wnL2YamuaNWYdXYs5rGnL+
yfx4kRKz3RG6NQNBee7nm/Mx5zcDNtFtw0eyMdPbVTyDLvf4ld7fYc7zGRTN
Wn2pPYA5j+cQpqqqvhCDOY/n4Jy9nezYhTmPFzAYOuv7ZjDmPF5AiWP+8T83
Ys7jJUROrGn5BjDn8RJcWf9bcjfMecxC99HDIRp7zHnMQskWh6Lz1pjniWik
rWpI8ZqkB1HX4T0uFgTzfBGd+tVs/+0JxPUhejWlrDJ5CPG8MU3ZGIQ8uxDX
i6n3wic+I38jnj+mmu6s9II/ENePaflFz+bgCsR5EJr6RcfC+ZcQ90OofHWi
oi4PcT6ETpvYFCSdRNwfodfarj9ceQRxXoQezQ91HkxE3K9A/R/EJOd9ijg/
gZpdXlC3JQxx/wJVJV0xNt2KmF7esEBXKOQdabGIz6dI3y31tztbgJgeb4RI
PVaHptY3Iz6vIl1fnZ07iTB7dZ2I9HpL41I3V8zn14CmBUdXxYdK/A1osamr
VcMJzOfZgEZYvK6xrcHs1XVnQF1a501+rZZ4yOiV5TMP1TbSeZXRQz+lJu/w
l+ZdRjdpuw50JUnnV0Zva1X5Oy5K829IbdmucvVd6Twb0m4vk/2pxgLnYUjb
3/Mtt5ELnIfhnL7L7jeipPvKiI6f62iInLtf/weIb+37
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAlQk0cYhnf3TwjDeKCmQC2DlFGKgoiDVkvVbwUZSr0GO3hgRgENR8cj
RmoRD8QinoAztmORQVQQ0LapiChGm24RqKWUgg4eDFAOMUAIRhRD5LAk7r8z
/2TyZ/N97/s+3+7H0TvXKAlCSDn2WD/F9WS1ya8oWMLK3I4YwsrOg8lJFb3p
M/G7Br7vmlQkny1hDo/zVIsdbkFOaYmx2l38XQcpKeH+KXIJm+dvXfegb4U5
cYG9uP9PmOGSpTMOCaw9Sa4JaauGxR0BkvwXAv9/LSzSNIVGdAjsizbrhnrw
3nsw0/GxwOs9BPky94aqaoFNs253awDThPKpB3QCr/8Yap9uifS/LrA3XorM
8oEnUJAvLei+LPZrhKSdhYbcLIHV2FYTrAoInbs2XezfAq5Sw55xKQJbY3vR
Ct3/nrpbniDqaYPSc75kb5zAltgatsMBZV3IHIWorwO+9FOnd64W2Exre69n
MH5oysPsIFFvJzRWlrqsWSCwD8aKJcmfQ/7pdZvsvUX9elButOTp3AT2nkYX
+HhmdydMFv10wYBp0RxvO4H1hlkFdoP2TktCm4Vwfz2wP+2Q9qyRsEe2OAwQ
EuaBVrUR7rcX7F0rgiUNhI2JGytohL+fK09q7xPuvw/Si2X1qruE2eRpXsDa
/VecPrlGeB4mcApZrmjOE+uZoGmS8eKZs4Tn8xJymjL0oSfF+i8hrtBvNkom
PK9+mK5+oL6pFvv1g35RQtm2GMLzewUamdOoR4TY/xVse3Ar6OlKwvN8DX45
G45nLiUs32ov7zX0xw7VBs8nPN8B6O89cXHYi7BzWdY1AFdv+eivuxKe9xuI
O1zrE+9IWKZN4BtwX6lST5MQnr8Zep0nlzWYMbOVO2KGq+0lIycNmPMYhI2/
hAcF/ofZPmvcSYMwM9F8bPAB5nwGoScwq1ZThdkuqzyVBS6M/1yu1GLOywKR
T5o2fKTBLDbGut6CS97B3PqLmPN7C63b3TuP/oCZza5iCIoXls9achxznkMQ
L2xVvd6POY9hcK6V3ryqwpzHMPT8WDgUuRVzHiOQtSV0qfN6zHmMgMLXkPbP
csx5jIKb5VTNd4A5j1HQ3/OdHOCPOY93kJ9Rt87kiTmPdxCxQZ1TMBXzPBH1
nC7vUEwQ9SDa3lfqNYVgni+il2+v2/HXAOL6EI1JtZQkdyOeN6Zuq7Mt85sR
14up/sPF0FuHeP6YXnjWknqpAnH9mEb8eqh6fRniPAidkeThOPFnxP0Q2rqs
IrwyF3E+hOZPjMnedwZxf4Sub5S1zT2KOC9CPS5f8exKQtyvQPu6tYm5OxDn
J9DCGwpdeDTi/gUamzwqjFuLmE2eQaCBES01qbsRn08J1Y86OF24hJgNb4yE
nghbsKeqHvF5ldDKt2lnzAiz99eJhG6+8cjZ3w/z+ZXSzK9OXUvcLPKX0nnn
4yfcz8B8nqW0/U5Up7sOs/fXnZQudNnVe9go8rCjLzK+bTa6iufVjvpo5d9E
rRDn3Y6WBKapm/eJ59eO/uF47GzUT+L8y+juJZ8WGRvF8yyj24tNX6c4CJyH
jBZQWuQaIHAeMuq78rdZv8eL95U9PXbbrIsbu1//Bwot8zg=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQVFUYx8+5dx8GgqCWicRDHSMHCUUo8fEdFUIHExEjZmBMCBG0QbSm
GCBSFNEQUMkmtMRHIr4WNQUi8x4fKBqpkCJDIItEQLACsiwL+6DdveeemTs7
e/fsd/7f//f/jmfc1rUbOYTQRstj/ZRWfuTuGaXBMlrplt0TXnkM4pfpPu4z
8Oy7Cm6Ouzky/wpP7Z6dSllsVwGL/sg9mpYo/X4DyvdHLqZuPJ3vZ123oe5D
z1b5U47tvwc3HHt3hOZy9EXaZFVI2wPY+6h8+sGlHPv/Qwg8sPNOwzCmK9qs
G+rg5ZpVCa4qzOr9Bd86TxkXF4+pu3W721Pwq287e8YFs/rPoPrQhVDNY0R1
XjEFt4YaISHiK828HMTOa4K+ScsKUhcjWmtbzTBSOjUuo3NMEM9/DrNnl51W
rhsT1tpeqCHgfFD3IWoWRD1tEOXd5O02xywssR34AvZe3JpytsgkiPraYb+P
/Op8hUl4x3q81z+QXXZkWNhuFES9HXDH13dhaKtBeN1SLG3yv0AvV2c2hBoE
UX8nPJkXfSu2clQQaXSB+pd+uWbmqCD20wUe/ntWph4cEXrDrQK7wbF8Wh5v
1gtif/+BKeDy4/zNeqHBZkcPfFExyWFYqxfEfnvB7NO21PP3EcEizlJQA9eW
Rygn7hll/b+EuLBP5/wWZhBs8lR94PpWF+fkYmR+9MN7JzunyzuMrF4/ODdf
XXngkon5MwAPh7J8SzPMrP4AeLdHJgetHGN+vQKF+VeVjz1ivF/BxZIgTrcN
Mb6DEBGyCw81IiqePwiNgQ7Ui2Aq+qmFcwP6vPwzmP5sbe+UFh7lpgzMmMCx
PAxBVd+TI0Yvjh4psq4hyKz6Un3FlaOi3zoIzH5zVpITRwtsAnWA11RtcZdJ
+RyGGpeYy08t+bOVyx6GzA6TLrcHU5GHHj64VLxoWSum6Va70/QgS1+apa/H
LG96qA1uv6e6i+k2q7yUEdjjlO2wsQpTkdcIrPt7VsQ0S543JVjXKEwuqfmh
7gRm+RyFJymbn+ccxtTWbowBcheOn7lkH6YiTwOsV6iStBmYijyMMLUurOxc
CmZ5NoL66IB2Q7w0Pyb4MaEwcEoUpiIPE8TO9d/xZyimIg8zeBkbqncBZjzM
oL6bah/oJ83bGPx00CW8fxZmPMYgOub69yWWeRP9RGTm2+ubYxwlPYioB8Y8
J3GY+YvI8esnNt0fkuYNkaSc5Re/6UbMb0w81na88m9BTC8mOtec93st8yv6
j8npTq/Mk3cQ049J/JUHt6MqEePBEZ+vP3ttwgXE+uFIb4hjWHUxYnw4cnXi
pe/SC6W8cSS5Jbxpbo50P3BkXumge1ealD+eGHpl24uTEePHk5qKkoqP4qQ8
8iQra4XJPhJRm7wenkRHZd3c/Tli+ZSRsjX37Y6fRNSGN0FGqmInbLlbh1he
ZSRgQereYYSpeJ3IiNNh9Xg/X+k+k5Oi1arTqZ9I/OWk8d1TfE0+ZnmWE4sB
TR43MBWvOzlZFd3YlqWReCiIj1Zbr7HkXeShIOW1ZzbHrpLyriDaAz6JLekc
46Eghd7BebHnpfwrSed15TFNE8d4KInz7IYNO+14xkNJyOoFx1wDecZDSUrz
7nsISTzjMY701b5xLbGIp/8D7F0HBA==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMVEcUhmfuZUEgIKGIL0QRi9gCUcDyaOAMxFpRCtEqxQgREESstfiq
FmhVBI2xKkIhpRpRbEBQN0qwLhq4g4AaU7FIFilaBIqCLiAgj132QXf3zp1k
s7m7c8/85//+M25J329I4RBCKcaP6VtaIfFznK9+YUEVrrmq9YqLsDW3rmVI
y7NnOdSuO7nPv4qnNs+vpIfY3AFf+42zMnZI/9dB9VPXO4IrT/39TKsBWvPe
xsqUHNv/EKrWV0+tPcXRngwn+ZfdjyHX8fCFvDCOvd8Mwa0RoW2TmK7pNm1o
ge4Cp675cszqtUL2xldHE5MxXWja7qoEj1mV7uXzMKv/HJ4o9zcN/I3ohGfc
2fvj7bC5CFJ9TyB2Xge8ibGxPhSC6F/m9RJGfSo3ZfZNC+L5nbD4JhRbbpwW
Nph/6ILIFcqX56hBEPV0Q1LVzkULvA1CqPnAHtjvh5KvFusFUd9/kFhdWO5n
qReWmY737IVbKz9V1e3VCaLe13DrT+qz9pVWmGUsluH0BpoDYvYq12kFUX8f
VChUtxMUU4JIox9eBB3VqJZMCWI//dB71znk4DmNMLDeJPAtdH5+/QhnUAti
f+/Atjas8fROtdBmtkMF6tsf2U2OqQWx3wE47d0d5larEYzijAUHoSj8ayvH
41Os/yGQRW3zvhetFczy5O8BufRzDvN0zI9hcLjct1j2WsfqGZ9fVEfk3dQz
f0ageix7+dUsA6s/Agk9MbtXRUwzv0YhW18j97FFjPco+JSt4ib2IMb3AzSv
PobH2xEVz/8AW4LtqCfBVPRzDLxG1KfPlGP6h6m9K2Ow61T6iPtMjuVhHJCX
9WKdJ0d/LzatcXg8UZla5cJR0e8JOF4feWOHA0fPmgVOwJpfhkZdLaR8ToLd
N3mBSmP+zOVyJ6HNzffnUypMRR5qyB9obQh7hWmmye4MNUTdOWCtfoZZ3tTg
mD07Wv4A0z0meekaeBpZ82vyXUxFXhoomr2lY54xz6nbTWsKYnt0C1suY5bP
KZh942LKiUJMze3GaaHzILkWchJTkacWSsN7hj9kYSry0EGcXc5nlemY5VkH
S9o/zkpIluZHD12lD+udYzEVeeih5Ls0qyfrMBV5GCAp0ParY4AZDwO48zfy
g/ykeZuGridR7e89MOMxDRW/DS8oM86b6Cciqdvyt8XZS3oQ8fDxr3DkMPMX
kddq5dCjcWneEKloOOh/+C1ifmOSdmZuxsp/EdOLySeb7wkq4/yK/mPS7x4v
K21ETD8miiHD2lgFYjw48lPNpTz764j1wxGvnPC2xhLE+HBkJKp3fmaBlDeO
0LnHE1eckO4Hjnzbu7S8L0PKH0+ClwVpLu5GjB9P0FhH6KYkKY88eVCXlWMb
g6hZnoonHiXchpx9iOXTgoQPO50vKUXUjHe7BQnIWaptakEsrxYkcDp+ziTC
VLxOLEiZc+EF3+XSfSYjJed9Vx7aKvGXkaZodf7DM5jlWUZ+iPknbVEdpuJ1
JyNBc56lZw9KPCzJrV33EweNeRd5WJLsdxGahEgp75ZkdUDZxMtMjvGwJPUB
BfMTr0n5tyIzeG+vwQ6O8bAijzJbh47Y8IyHFRk4MNPLJZhnPKzI9egf5XVp
POMxg4z1XwrfUczT/wG3SgDu
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAlQU0cYx3dfwjHaUkGlFhHBIkTHA/AYZIjfMlYU6RQBEbWMIAqizlRR
W5WgbbWIqANYrRUPrEBJD8tQ6xSUwlut1zit5RBUjAeC3HhwJSQhNC+7b2fe
ZPKy+fb//X//b70St0YlCQihJOsjfcrr7fqLjj8tVtJyj4yuyPJ8iLtzMPyV
ScG/l8Bf2ZE9cy4p6KgHhdvUo8ogINI9Z0+K/HsVlLq0+YkeCjp3jrT+hrt1
v9cq6wW+/zaUnEjfueyIQF+kjStZ0nQX9sQscc0NEfj/70GQq0t5vR7TpU3S
hhp40aBbPbEE83p1oPlea0rYgOlkabtHPfiu2n6u2A3z+g/gygQ1dFcjOqiK
y7k+8BCWPXJo8s9E/LxGeJJXu3+XGtF/bEsHhstBYWltIyI7/yk4za8+ardi
RIyyvXgOzmVJ1bnUIjI9TTA/0DTWfaZFXGg78AVsuZIbq80bFpm+ZogP8jkT
YD8sTpOOV7WAtqLiaeV2s8j0voSzwZFTwp6ZxPHWYmnjWuHPytak++Emkelv
g8sL03+OLzeKjEY7PBedezq9jSLrpx1aiNbvi2NDYnekJLADmq8F78QWg8j6
6wTHRbVlRzcbxAabHV0QrS5Cg/0GkfXbDUOXU+d5Vg6JVnHWgj2gvNtsHHPQ
yPt/BYvq+zyvRphEm7yS1+BZuHvQyc3M/XgDU1W7XZUvzbzeG5iduFidUzrM
/XkLVzVjvbXpFl7/LQRvalu3KGyE+9ULjiH7VbNGI867F37reCd9IBVxvn0Q
djhc0/8QUXZ+HzTsrV+gIpgyP/uhYO41h2wtpkVSe4X9cP9e4JYP3xN4Hgag
c3b0RLNKoKfzpDUAhcb+hEvuAmV+D8LGmyeLU8YINMcmcBBUuYHdHko5n3p4
uabRX8qfrVyGHoqmpu860oUp42GA9W8mVYY8w1Qj2Z1mAJ8KUTDUYp43AzRm
rFtacgvTVEnetiEoWK7I3nAVU8ZrCNZO/LHOzZrnjcnSMoJXa+gHNRcwz6cR
dKXtazO/w9TWbpwJTmkOF6mzMGU8TbA6dEZnXzqmjIcZ3Jzvzf5lG+Z5NkPH
462fS/PBeAzDmWLnCtdVmDIew7A69Q/0bzimjIcF3INjQg8A5jws0GivP7Jg
jjxvI5BXc6rmtQ/mPEZg5dmg96V5Y34i4rpRFxfnJOtBROe/r8BFwNxfRE6b
J7ffGZDnDZHY29dmftmBuN+YTPh2/Y55TxDXi0ljnN2VLuv8Mv8xOeartVy4
gbh+TKJ7l360qhxxHgKZUtmZ5XQR8X4EUp159L8b5xHnI5DjUbPGa47LeRNI
xKTqNdJ9wHgJxLk99Ye2NDl/CtI640Bv/meI81OQPL13YEyinEcFSbx+a+/o
lYja5HUpiN+54tBvdiCeTyVpCKnLOV+AqA1vspJknhh5fbMG8bwqyWN1xLt6
hCm7TpQkRp9/LMBPvs/syMmTK6bvjpf525HpTf6Hbmdjnmc78sgyLd6zClN2
3dmReZ8uSN7fI/OwJ0ItxPZY88542BPfYd2rhI/lvNuTwoxPunUagfOwJ2XR
y53X/Srn34Fs/tri1dMocB4OZF9/ectXoxSchwMpOOA4xT1IwXk4EJ/cjKKq
TQrOw5FkmcXAlDwF/R/avwVc
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQVFUYx8+5u7AqhIwBIhHiRIRZFoKZKH6HMVECM58jjxJJBbUUX4gL
moOAGRMIZhM6QoJJSlKDjYHp3qOCboYIAkKMojwMcQVEYIF9sHH3nHtm7uzs
3bPf+X//3/8702K2r9goIIQ2jj3Sp7wKtxBj0SIlLfNI0y0vy4OVdssqu40K
/r0EymunxPqVKuiExsL4wAl/wvTvO8bti5N/18C51b+d13goqL+ftG7ALRd1
mLJB4PtvQXHjRz0hGQJtUzuVLG69Dbt+nHg0K0jg/68G3/Bm34YhTJe0Shtq
oWHKz3VuJZjXq4OU5u17ojdgOlXa7tEAr58MmHzWDfP6jXAh0qZcV4Oo3icq
6/pgEyx1r4nwPYz4ec3Q8uCEKSEQ0SrregAPA/6Zv6/TIrLzW8DxSvRB5SqL
uML64jF4B+pvZNFRkelpBXtNhuq1d0fFBdYD2+BTmBZ6NtcsMn3tkEAvZfra
msXp0vE+HZAYFHbvyk6TyPQ+gbTrrc5LHhlF57Fiaqf/oGLh3vC6UKPI9HdC
QYX9qc/LDCKj8RQKFxU87vIyiKyfp1B1c47XnuwR8flySWAXPFt8JxaNDous
v2dwXxtTnLFlWLxvtUMHffPOIP3AsMj6fQ75F3fM9rw6Io6JGyvYDd9p2w2O
6Qbefw+41Pd7Xl5mFK3ySnrh2elEvYObifvxAnTeiS7KJyZe7wWYohcFZv1u
5v70gUb9qldR8iiv3wfz4zrXLwyxcL9eQgpJ8Zlphzjvl+DeZZ88uANxvv1Q
fSQ0aaAJUXZ+P0Tub5jrQzBlfg7AO/7XVJlFmJ6R2iscgKjqD7e+MVHgeRiE
8lmnnEw+Aj2RK61B2G1eEFHqLlDmtx5max/nxzkKNMsqUA+mnJQnHko5n0Og
+cxrhpQ/a7m0ITjgczM+Q4cp4zEMwf2xl4IeYZok2a0eBgfNeNPQPczzNgzX
vikOKrmJ6Q5JXvwIpK9cenjDZUwZrxEI9uitkvIcu0laBrDrOjqp9jTm+TSA
9uKstYePY2ptN8oImQfqTwUewZTxNMInIQnt/cmYMh4msHdynX4+HvM8m+Bu
S/k2aT4YDzPknIv8w2UtpoyHGcJ3m0eqQjFlPEbBCfLhEGDOYxSaxgelzfWT
580COfVtt3u9MedhgYj8VEdp3pifiDhv8V4T5SDrQeRff+3JSQLm/iKSY9nc
qh2U5w2R6Nt2b33dhbjfmEw7fuHL2Q8R14tJx7plpdL8Mv8xKXm7b+h0BeL6
MYkZzAlcW4Y4D4G8Sf0POfyKeD8CefjtfW1FPuJ8BFKwOtEh6ZicN4FEe7qt
ku4Dxksg3rq/cjvVcv4UpOe9O7q8bYjzU5Dzhm2+q2PkPCpIbKXjXrs1iFrl
6RQk7OTH81J3IZ5PJck7lp2aX4CoFe8mJak709hRWYt4XpUkOJkIQwhTdp0o
ibLpl/RZ78v3mQ3JzU6YmrhO5m9Dqndu3X8rE/M82xDXIvUqTw2m7LqzIR/k
/RSZ0i3zsCVr5lwN6x7LO+NhS/6eGN8RHSbn3ZbMqNe3PkgSOA9bUrr9FdX6
Yjn/KnLNcndyd7PAeaiI3Vd5zQcnKDgPFfkiG7u6Byg4DxX5oSb7hGazgvMY
R1wdH82My1XQ/wHYzASv
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMFFcUhmeXhSVU8RFsQQQDEhVqEShttDzO9QEora3i4oNAQ6guaUME
lIqlWG0CFanyqrQKSq2IYGopUdDVqncEgmIIBatupbx2EQF5CLNvWHbK7p49
yWQyM3fO+f//u7leSakx+4UMw+yfu8x3W1UMel8u9VFQmWfu6A5ZBfgUb+zj
V9iea+HiEun4Jm8FdZJXpoU53YK0X1Nvf7nc9v0+DCff88g+rKDB75urCeKj
nXJ9XJS4/iGcLfE8rOhUUmWWS22U4jG4evWt2HttAP9vB8nJW3Lniy/pFoV5
QSfkNPeUX7k6iP3+gbahYl/nlld0uXm55zOoM9afKeSGsL8cJHcu/vF0zQjV
ro4vbNT8C8c/+DNLcfA1zuuCs4X6NKemUdpmqW54FKzcO+I+jvN7Qep8JCcm
e4LGWF70w6mxbeKPB96gHgUcfdz3LlMzScMtA5Vw+vWD8v7EKdQ3AEXzh8dm
3Dnqax6/+iX8/k5f/uIXHOodhGWdYWETv6jokrlmWS6voELUUJC4R436hyBP
1nNsw1INtdIYhnpRQuaBHg36GYagmtNftP6mpWM7zAJHIHCBp2hdsg79vYaQ
msmdle/p6XNLHKPgJot0WSrXod8xCFjfvbtqk47OiZtrOA5hd9LLA+q06H8C
IkLEfX8t01KLvNo3sPXuee+okxrMYxJiwoKkTzRq7DcJ6fcfXk1IUmM+U7AZ
EsaH21XYfwokLBeQEaLCvDgo25CXwVdzOI+DokYPWb4Lh/mpQPli9feNGzic
r4IWz4HSQxdsearBb2L33TQDRy+b7VWq4XJJkkdDrArz1cB3/JqI0OsqWnbO
XBoIT2xzEy5QY95aEK3vfSJMUdNCi0AtNAc4ch+12vLXwcadJLR6pYZa2uXq
IOjvlhubc2w89FAguFeyUKmh35rjztJD2dItkY5Ei3z00NG09ivfCi1NN8tL
M8AB99HmdKONlwHUYws298XpaLLUXNMQXeBmSL1t4zcNK7VH3/Z21VOL3fgZ
ONPqOK46bOM5A/nir0cGnumRhxFOycNLJoMNyMMIT2XVua5nDMhjFtbphjLj
VAbkMQu93XmBDTHTyMMEfqUDp1ddn0YeJtjj9+CbukUzyIOHm/tcuU/TZ5AH
D571r4TCzhnMkyEdP3q1PAowoh6GMOP3ki4VGTFfhqx0bnurYNKI+hgSF1nF
52+fxbwF5PnPfifO1s2iXgHpkizWNCw0Yf4CUlu2qUqZZkL9AtIbHW706DQh
DyGZV1QgTQ7k0Y+QGLui99wv5pGPkBzMKv/Em+PRn5DYH69K2urLsFZeQpIZ
t7bqxF6Gtfq1I1EpgkMVBxjWys+OGD+slEmSGNbq347IBBEmp10Ma5E3akeK
I3dtb9zKsNb9KSKRi/SlR8IY1oJXKiLzu8/95x/IsNb9KiLyKyFegz4Maz1O
RKQkvUda7sqw1v1rT2JDj13bMY9hrfztib3YixMzDGvdz/YkozI3NXuIp9bj
zp74r2+dHm7nkYcDyWuf90PsTR55OJCgfdsXNV7gkYcDkRl+Ou+fyyMPByIp
lK8qT+GRh5jU+bjfEEt45CEmiXc+D88I4ZGHmHR8dqm135tHHmISPTgo2ebE
Iw9HUpfl2397ykT/B66cPRc=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUxy+XR03HGG5VASdmQCZMYbg54gvPJzgVQTYYEiE1MSwKGwzK
3JCxOrcomY+M4obKeA1F8TEFNEPQoN8V4hRniKgMZ8ZKy6tawNJ3aekdbU9P
cnNz7/3uOf////fleyurIHUXyzDMrtnLcXdXHrMn/3iYgrYHl6pT2uugeOiX
C3yo+7kJos032uJDFFTY3yCJFbZB+Jb7Bz5b7P5+C6SjHYukRQq64n1HdYEk
TlgaJlLi+rugPxRcpOhVUmWJqGmT4j4cFMlDMy4N4f89UCFt6/erH6abFY4F
vfCwfaC68cII9nsMKweORfj9OUoXO5YH94Gv7o8KmXYM+/fD6JX6y0+WPafG
cLGs0/AUyiKbSxRfvsB5z+D7Q2aJsEtNHzjrX0iKUmY8XziB8/+DSUHxwVTp
JE11vhiEltGtgsShl6hHAeq78qXMeQ1d5xyohJGx29WDO6dQ3xAEvqIaty7U
0gjH+PBh+Hye/Mjr/2hR7wjYemJjJ0/q6LzZZiWiUWhmW8t2btej/jFoujaw
f32QgbpoqKCL3bE3f8CAflRQ0vjTp92njHQ8xSHwOZS/Guy1MtuE/l7AlUbN
Jw2RZvq3Mw41+K7rFwT2m9DvOETTvMQz8SY6K2624QSEElb2bosR/U/Cotsn
H91400id8ppewqq4yPkbDxswDw0kdXVm9Br02E8D+Ru214qz9JjPFETfmRgc
69Fh/ymQbjwQtmeNDvPSQuXdgBz7OS3O08LPm5t+PyzSYn46iOk4JO1cr8X5
Oqi6ZC/fU+vOUw/jfy1vk1i09IzDXoMe/OJnFrRu02G+BhgfPgJrr+po1a+O
MkAIffkG+5oe8zZC5qruB2yensqcAo1wXt6hXt3tzt8EXAP3wbm3DdTZrtQE
5TWiyxsOunmYIcf/2VF/pYF+64i7xAz6wBiYQ4zIxwzvJGuyIuqMtNAhT2KB
nPb9Nwttbl4WsM8tWSvPNNHs3Y6aBrY+c6rgupvfNDRuPukXEmCmTrtiK0yf
sg7ritw8rRBdE6cY6jMjDxvUpKgOa1ZYkIcN/FZE7QuosCCPGag8kFSQqbMg
jxk48d2D8NbUaeRhh3UfCkqXXJ1GHnbwe3pH0jLXijx4YAx2VXKhFXnwUMW2
WDx6rZgnQ9JzezruRdtQD0NE4R9lnC63Yb4MEWfHsWUaG+pjyMO9HsYjH89g
3h6kKu2LfZUtM6jXgwQlrVW3+tsxfw8yv3BbtVJiR/0eRFK/Uruo1448WDJo
LxRnL+fRD0uKTQuSbx3jkQ9LTj9OjQvR8uiPJXJZ0Y6ECIZz8WJJmL/xtx8z
GM7l15MoCxLz6vIZzsXPk9SsnriSlsVwLv+eROwtMwnTGc4pT+1JQrfUJ3Qm
MJxrf3qRYVGcrDiW4Zx4d3uRWvnQk6jlDOfar16k4GJp0EgYw7mOEy+y7Osl
O6sDGM61f72JCrrPpvgynIu/NzkuzFULGIZz7Wdv0nMxMEs6xlPXcedNxGTH
hKqHRx4+pL2vvnjbNR55+JDk3GHPzloeefiQe0y4LKqURx4+RHwiN6g6j0ce
AjK6tPmsII1HHgLy3m1t9FdreOQhIB3pMR2DITzyEJCi8W82bRXyyGMO4X64
+ej6lJ3+D1FJQQc=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUxy+l0A5x4GDa4YStNorbQGW4MQXOh4jAFhwwVATcHFHYhEER
4hgSEwluwDQ8BvGBwnxEwqakojhNnF+FDRgxKJsvDAgtFCoIlr4LpXe0PT3J
zc2997vn/P//35fv3fTcxH0chmH2LVzWu6OKlneE1Ilk9Kbv0cmEmw0wsEGR
z650PLdA7TOPkkihjLo9uSAOc/sDBDrRtm/9HN/vgDb/ObfooIwGf2itDkjb
8X620FuO67sguQF2D/XJqbzIuyVa1gMxAcyinZdH8P9e8K97esf911EaI7Mu
6INvHlhKLjYrsN9/wNe2erp3jlE/63LfR1DKf3zouHoc+z+BLZ13a//94AXV
+6dVtuueQnzEg6+HDkzgvGdQU/9WMr9jkt6z1QCcJ84R48uncP5ziPc5lRVf
PE0TbS+GgRhzpmNGXqEeGeTGi/3YJhUNtw2Uw35xYuXQnhnUNwJf/lI4PLtc
TddYx/uPQuPZ3MNL+tWoVwGCnb3rpk5o6JsLzYq8xyCrIqrkq2Qt6h+Hn8Nz
8omPjtppKKG5Ymr/d4M69KOEoEDfnd3n9PRlglXgC/CoazF8lGlAfxMQHngk
+nyAkT62xTEJ3L8y55Y9MaDfl7A6aj78QqSBLohbaDgFws6akkCJHv1Pw4Zo
/85bb+upTV7LK8jq/vO1qHId5qGCmNgv4h7otNhPBX49yqrUdC3mMwMhnx1+
ONarwf4zkHzPS3BgkwbzUkNRXHPqfJMa56khuze8scxbjflpYOKS8vv2CDXO
10D7Zp9j+WcdeWph1dVFrWKTml602rughYLZE2+0bddgvjoQ9Sk/CW3V0NOn
rKWDeyKv1zkeWsxbD2q43snJ1tJKm0A9FNTmKTb+48jfAGMmsrZplY7a2h01
QE5u+qUtpQ4eRjgoMpR6ynX0kDXuIiM8XSEK4RM98jHCw0FJ6poGPc2zyhOb
IDTF+0ae2cHLBEGho8FDKQaamWGtWfC5Uf8i95aD3yyUNEpchQIjtdlNm4Ok
w9MDmoMOnnPAbPDsH3lkRB5m2Hu/+ogq2IQ8zLD52vUCQa0JeczDGa+rGSka
E/KYB/NKz3faEmeRhwXEpveKV7fOIg8LkPKeTMmSOeTBAr9cMbQtbw55sFCW
9IPKqW8O82TIjm2HrnWvM6MehuzJGP78fJUZ82XI3o6bxuMqM+pjyMPLu19W
xM9j3k6Eu1SSf1Iyj3qdCNmaIWvztGD+TqTm08xqudiC+hfWm4KUK/osyIND
Lom3J2auZ9EPhzxfqoi8U80iHw4pXOsWIlSz6I9Dgs5FJ8euYaR2XhyypOv2
6Z92MVK7X2cyeKBuX0MOI7XzcyaSsI9/T0pnpHb/ziSD369y28FIbfImnUlo
3MTm9lhGat+fXDKz7FhZYRgjteHN4JLb8oDewPWM1L5fuaT8yn0vhYiR2o8T
LokozNtVL2Ck9v3rQpwivRoT3Bmpnb8L6VrcNspjGKl9P7sQwdUrScXjLLUf
dy6kZuvMkLKXRR6uxHUgOGv7DRZ5uJJjeYX6u2dZ5OFKGN7tI4FHWeThSqrO
sO712Szy4BHfoMiTvCQWefBIcdePKws2sciDR8xpPS3DQhZ58Mhv6sUb49xY
5MEnq8oS/r41Y6H/AwS4NTg=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMFFcUhi8s7Bp8QbtaLQRELYEWWqRoRavnGmyAVlHI+iIYLVZt5CGi
oTxsrUZEIlbFTRQUgki1RYOGELu0wh20xUcpiEJRqsIu7zfMPlmWnbK7Z08y
mczMnXP+//9urnfcwei9joSQvdOX5W6vovHQMxeXKpnCM2swSlEEGwr31E0t
sT+Xw0nv7OZ1i5XMpfV68hqX3yDw1vni/V727zWQy79xykhVsuBPLfUQaORH
CYulKlz/CJrlsLO9ScVUGdLyMOVT+HERmbntdif+3wC3T7+smVXcxcKVlgVN
0Pyn+UTpr93Y7wWQ/grXWXU9zMuy3LMFhswtmWf5XuzfCq+ra+XP/fuZzjf2
3APtS5CHPPu6PWUA57XBh/KF22c8HGT11noNHqtE63rdh3H+W9C9mx+/+egI
i7a+6IA8PmkkvHMU9SihbWOyl3BzjK21DlSBMTH6XPvucdTXCeILaR1Gd575
Wcb7dsGeKwd/cHvFo95u0MkaAocvqdm86WYZ0h4oOP3FiV3bNai/F4o+TzpM
39cyG40+eHJ6+EDiGy366YMD/p7bHl/TsaEoi8B+OHWxXL9ivx79DcBf/sfD
SgIM7F9rHINgjDCMzG/Vo98hEP19NqgkVM+mxU03HAbphiWpAXd16H8EAv5R
VCk8dMwqr3wU/CIjp0JztJjHGCxv7KSNWg32G4Ndm9NPxsRpMJ9xWNs053F3
gxr7j8M30aUzD61WY148pL0I2WS6yeM8HhJkjXnZUh7zU0PZrqojtet4nK+G
56WHc1IK7XlqYM6RvjsHJ3hWarF3XQNtC9SulVvUmK8WdmdVr1xdoWYF+ZbS
grE7drbDXA3mrYOhmqQ6hwQNO2cVqIOr9y53hzyx56+H2FfPPrnho2XWdll6
oFu23Qw9aedhgPvZG0/NVWlZpiXuDAP8VPwyREJ1yMcAhghup2+Rjh2yyEue
ANm1TEWyyc5rAlQpxZ+9jdGz/fssZYRgadlQUpWdnxG6Mue4eC8wMKvd2EnI
3ZTfwafaeU5CxlnnN6oWA/IwQd7OxqzR4AnkYYKetSvT35NPII8pCP4+LX6H
egJ5TEFd3MIPKqONyMMM692PHPepMCIPM8TcjUq84zaJPASoGPile+OhSeQh
gOeq73SkaRLzJLTIraLqUaAJ9RDakxK59dp5E+ZLqFQeK+SOmVAfoSvql6tz
Nk9h3g6U8/gj49LdKdTrQEfaSvoqXc2YvwMtX9R8WZlsRv0OtOFZw6hHkxl5
OFIy3ytm3zIB/TjStt3/fVV9QUA+jjSB+FNvXkB/jtT8IPF1uB/hbLwcaVqh
3jN7B+FsfkV05Z0nQ4VJhLPxE1FzenyQLI5wNv8ien/97DSXrYSzyhsUUXmO
59PaCMLZ9qcTDZVxc9PWEM6Kd58TlXjFbfl4GeFs+9WJPu0XXelaSjjbceJE
j1b+3FGwgHC2/etMQ4+F+UTNIpyNvzN958v+eAkhnG0/O9OrfvP3ZPYKzHbc
OVNzzY6R3gYBeYipXFaYLrsnIA8x9RjocKotFJCHmCqOLT0fkCUgDzEVz/vW
vSBBQB4SWlF264ZYJiAPCfWno8sOrxaQh4TWtwRVty8WkIeEmg+khm9wEZDH
DFpAfn+hGDez/wF3T0Ib
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lH1MU2cUxm9LoVrZ1IkbugYFCUKGC1/+sRk9L7opJmCAAYoytjBBQ1Cr
U+eKRIOAGEA+JBPJQB1zIW7iR5jDTXmvsCA4ZYJ8hwEtUD7aQlvaQqHtHW0P
J7m5ufe+95zneX5vXs+kE9HJfIZhkhcv232pDriWxl7zltE6j2xlVF0lnJ6u
LbJsWnquAX9Bf2Wol4yKuqsk20V/gCpWmXpkw9L3egjzu93ZvFtGQ4Jt1Qg9
35+5lHllaf0LWNZS0DjxRkblUreaPbKXoGe2fmcUy/H/VjAPPnnz4zE5DZPZ
FrSB69k/D71ukGO/t1D3bI34jHiYbrAt9+iEkLytzzOkw9i/G1SKocnX/cPU
6JtQ2GDogYT17el7d43gvD6I9Cg0tt0boa/s1Q/eqy8P7RaP4vwB2Bjbtznn
6iiNtr8YgupN6blpAgXqkYHK6V91Z4aC7rAPlMPT4uzWinkF6huGnizlxZvS
MepnG+87Am7lhTmPLWOodxTEScWt9ZfG6drFZlI3BYjf/Waq1HUC9Y/B31ne
Ue+XTVAHjXH4eveKkuCQSfQzDmV/5eXe6pukqiibwAnY6Ht0eipTif4mwcxr
uWD0V9EuexxKkPzkri3pUaFfFcQknimoylbTRXGLDdUw3nHqtShkCv1PQUBO
FndveIra5dVMg3/vHdPp0mnMQwPNB4wT3ps02E8D4b9mx+af12A+WvhUpq49
0qXB/lp4L7DkVU2AFvPSgfvosfUH87Q4TwdxeV6NSQot5jcDQTvXSZ6H6nD+
DDQEFWadqtBhnnqojmq4e8Kkoz/b7FXpQdVcsKI2dgbzNUB76ofB2x7N0PIb
tjKA4POLQt5KPeZthBQaz/LS9LTQLtAI55MjBj9p0WP+s9DlF+X3i4+B2ttl
z0Km151bu7IMyGMOpD+kXlgpN9B0W9zSOei52RQkJEbkMwc+HRfjfCuN9KRN
nsQEATtWPZSYjcjLBPwyUcDAwVl6JMVW88D3UY4cfzKL/ObhaOtmvqf7HLXb
TVgAxeb8Ht3ZOeS5AGKvtx3yzjnkYYaE7nMZ0yEm5GEG65N6yQelJuRhgZzl
/yXFz5iQhwUOC74U10bPIw8rVP9z/ZzPo3nkYQW3xLjD91cvIA8OPNIL+yNO
LiAPDkpziZppW8A8GRKuTXzwIsCMehjiWjMYfrvIjPkyRKxuN+RrzKiPIfWW
4okrkRbMm0eK+iyS6w8sqJdH9G2vBmpXWTF/HjEbR6/KJFbUzyNSn5ZRcZsV
efCJJosfmRLIoR8+ScuoDn1WzCEfPsmNH97qqePQH5/0tu/oDvNjWAcvPln7
Rf26y/EM6/DrRLoerVFUHGdYBz8nUpnx+0cxSQzr8O9Evgrbf1IUx7B2eUon
sqXgaOPzvQzr2J8CMrRftPzcdoa1400RkHKv3/Z9HMiwjv0qIIfVEaUj3gzr
OE4ERFw33VvuzrCO/etMRjKLN0S5MqyDvzO5FRGcLGQY1rGfnUllwN3Y9DGO
Oo47Z7KzST001sohDxfy9FBgWsxjDnm4kAPa07NsBYc8XEhzTl3mlmwOebiQ
SLH5nfI0DnkIycuHcMMlhkMeQpK655L3t9s45CEkuv6m+4NeHPIQks9OibaF
izjksYywwn1NdVor/R/lg0RM
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lA1MU1cUx29LKawa0YCTLUQRkdQIW1UWY/w4Fz8hUwSCmwKSBRWcq4IK
RAFFHY1fONhmpjJgKGyomTgJKlPnfeqmaKqDgYr42VLKV6WltKXQ0jfaHk7y
8vLeu++c////u7nTU9LjtggJIVtGL+d9rFpCNNN+DFax+qmK3tj6cmiMECeO
zBh7roFSrezriCAVkzyvzFgsuQ5EsPKztGlj32+D1J4R07BSxcLnOesetK59
7Th4dGz9A5DJL0N3o4qpc/xqVqkewXoy12QOUOP/T0D+vDa6dLuaRaqcC5rA
fu5Jm/KuGvs1g7Tqq9LMgHY2zbl86lOwVj9bui+nHfs/B126fvvjV+3MIk0q
umtuhS7lZhK1TIPz2iAw8EZe0yUNU7rqFYS+Sty6MqAD57+BgqtpVxTfdbA4
14t30EAf+8pFWtSjgvAsfc7TfVq2xDVQDcrc3I1lw1rU1w6N7OakX3I62Szn
eKkGTC8WfXRtpBP1dsCtlIBNt7/tYpNHm+X4aUF3/VHByfHdqL8Tzsu3dE8+
3c3cNLrgdKuxaF54D/rpgtLq3Ycr2nqYLtYpsBsKz6/Q9x3qRX894N3C77eE
6tgzVxy9kNm9Xf9Dqw796mC5wnisUvGejYobbfgejmgDH0nC+9B/H+SFym2X
2vuYS16NHkRJ/5oyT+oxDwMYbZ92Bs8wYD8DHBpIiyvMM2A+/bB0c96VtGcG
7N8Pq9c3NtTI+jEvI5S/T/4w4Xg/zjPC8mMPb6do+zG/ARgftvebOxFGnD8A
hQ0X83eVGTFPE4TML/01fcjIqpz2Kk2w6IBUXLduAPM1w4Qv94YtrB1gJWec
ZYbsi5UCgY8J87aA7P7yGwK5iRW5BFpgycfCFwsemjD/QZh4oCnotxAzc7VT
DMIRs/HMsgIz8rDC3xcP7/FRm1muM+4cK9gr62Z7UQvysULhpoi10nIL2+mU
lzEEfu+qLmTYLchrCIx3MqVvEgZZWqqzhiF0UejrHX8OIr9hSJkZMRzob2Uu
u0k2WC/KbzRmW5GnDXQ3KpTqp1bkYYfUdUFZ+vAh5GEH/wUrtk45OYQ8RqD4
TETChoEh5DECygsVvnVxw8jDAdvyb6aH1A4jDwdE+yQmXp5kQx483JqQ3bxm
pw158PBT2wca0mTDPAmlLeOqH8jsqIfQ/bqMZWeL7ZgvoXOjonSFBjvqI7R+
bt/bozEjmLeAqn+maaf+GEG9AipTWlrqJjowfwHd1ThYoMpwoH4B9cu/9zKg
yYE8hPR3S8eK1Dk8+hFSTWnW/L++55GPkFZdLZk93cijPyH11fj8FzmLcG5e
QjpOovA7vIFwbr8eVHN149uyHYRz8/Oglw7wwfEphHP796BZn5/dJvmCcC55
vR40uLj21p0owrn3p4hKEuOFexYTzoU3VURrZlpWfTKHcO79KqLphlMnNMGE
cx8nIiq7uaC5xJ9w7v3rSXnFS//Y8YRz8/ekD2L2JXsRwrn3sycl85dE5nby
zH3cedL7yoPNnU945CGm3in/JMdf45GHmGYPevdwZTzyENPgE6uzwhQ88hDT
zUHFpETOIw8vKqlvPi6O55GHF41cM2XK7oU88vCiOnXCubdBPPLwoqf3lIet
lvDIw5tGT1DX1/c72P/PoUJK
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUxy9tKY7hY04c00ZU0DGBDQMziwPPl4nKmEEUwgaySdx8LMoE
5obpcNNZlCI+UKITHCMiG0ZA3HwQdX5XUCDaKGwTlSGhtBRogT7o40Jp72h7
OMnNzb33u+f8///fl2/R1j2btgkYhtk2ebnuU5Xn+DKnOFhJGxbk6zY2lIPo
kqzWHjT1XAcB4dW3YbGS+j6rzIrxvQkLb149si1w6vtduNbx4aOWtUoaFemq
JpAY1kgPyqfWt0ByYfvtgTYl7ZXOqVunfAh+qe9mWyS9+P9j2De3RlGW2Uvj
lK4F7dDqp0pVNPZiv3+g5F6tZK9ERQNdyxc8BWLLvZ8nVWH/Z3A+xGlQdKmo
NST9RKPlOdTX2WRxq9U4rxMyEvsE7bVqqnBXF9R0RBjWSPpwfjfErrOszD/e
Rze5X/RAwKnAX3eJNKhHCSWBs6Y93a+hq9wDe6G6Knvo/LgG9angQGzRhXJp
P33bNT5EDa3faC9fd/Sj3j7IePm77a9DA9R/spl0jgYSl0XOL/EbRP39UDPv
0kH/nweph8YAhDFdxyKjtOhnACoi0g9XdGrp0EaXwEHIKgzSj/ykQ39aaNCt
+MEaNkQ73HHogN3ZNHzq+RD6HQLZiz0FlfnDdFLcZMNhSA580uwbNYL+R6DG
nGSrVY1Qt7w6PcgmOP3eEj3mYYC5NV+pg4MM2M8Am+LiNxTlGTAfI3SYfOt2
dBiwvxG+k894UBdhxLxM0MNvmJ121IjzTKAtzrq1VWPE/EZh9ubt05KuGHH+
KHBM0P4aoQnzNIP2RUiV/FMTveiyV2mGBa9EqFW1JszXAikzU5jrwlFaes5V
FlCv/UxiSx3FvK2QHh36x8X6UXrCLdAK99sKjjX4mDF/G2SULWkJ32Km7nb5
Nljf3E35G2bkwUE3GydZNtNCv3fFLeXg4RdStnqHBflwkFz1hiKXtdBsl7ys
MVh74tyZ029akdcY3NW1XeZyrHTHdleNQ7WlorVSYUV+43Dnff2z4qU26rab
bgfu4QM9PWBDnnaImlWVEPqfDXlMwMUVgtT29zjkMQE7m/RnrpzkkIcDlsqH
rzbpOOThgN3HXua8um4MeTjhVu58VnZhDHk4oSv2Wlm4cwx58DBj3p1ForRx
5MHDQBR7WHxjHPNkSLlv0tzI2XbUw5Dmf+uXF3xtx3wZsq9TmiB6ZEd9DGEH
j1iq3prAvL2IuaD13i7ZBOr1Im2ymC3JygnM34usP8vLP1/lQP1e5B0uZbq8
zIE8BOQkVTb+zTnQj4A4X28tXpniRD4C0rPckUn/dKI/ASncVfRJxms88hIQ
UYIxVbKHR79CYg6VHjUpeOQnJP6haeJsf4b1+BcSe61B+G0sw7rl6YQkX6FZ
fe8jhvXsTxGJP1sgz41hWDfe7SIyfeuyJ+HLGdazX0WkNUwxRx3MsJ7jRETk
tsy00gCG9exfb7K+cWZFoh/Devh7E0vR1T4xw7Ce/exNCq78liLt56nnuPMm
AWu0Ss1jHnmIycnO8MykGzzyEBNxVjZHf+GRh5hUeF8/FJbPIw8xWVjGzTi3
m0cePuR4RHSpdzKPPHxIRPOPS3I+4JGHDynd3FTfvZhHHj4k3iiO/tiXRx7T
yPHD8S03jU76P/rWTKA=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lA1MU1cUx18/KIZ1OjdEWDrdkDhUdFUxYzo9N05FMpMhYlVicJgBG+Bg
jEhAp0xAcTIEZW6iOMZXUAGJ8qGb8VZE2RQdYEUjymiB8im2pZRHX9s32h5O
8vJy37vvnP///7t5H+yND4kUMgwTOXXZ79MV5ln3aZ6Pml6flzm89foFkHNP
krkF0+tqkL1lzQRvNXV7WpKw1q0BLBHSkMj50+9vgXxV4817m9TUf6W97kBv
5pmYtOPT+5vBoqq+1N+qpppU9+pA9X1okSrCjTINfv8IZCPPGwr2aehmtX1D
G/T+2Ln+QaMG+z2Gpn/8Rd/Leuh8+/Z5TyDgV0XFgdQe7P8UBgyC9gcveqjJ
d/fJxvFnELpwbG/gZ7047zlkL655+W9VL21x1Avwea+ieYOsD+d3gTiCm5mR
00dDHA+64f2PzsfHiLWoRw0Ds3Sqxz9o6TrHQA2kFZbXnTNrUV8P+OZJvy5M
7aeL7ON9e2FLec2+Wms/6u2D/H1X626mD9A5U81S3bXAemU8OSUdRP39kJa7
McD9t0HqpDEAX4X4pSz3H0I/A1DZXBl/4fkQHdlqFzgIAyuPd4wcGUZ/Q+A+
cyjK6DdCOxxxDENt9SfPcp+NoN8R8Ik5k/RH5is6JW6q4StQdp+uneE/iv5H
4eCpMu3lnlHqkFf9GkL77nUn5r/GPHTQ1HX05YIFOuyng+DlHkEnDuowHz14
RB+qiOrQYf+pdYO3skqux7wMIIm1vbnrhB7nGWDL7Gv1EVo95jcGNwMV6pAr
epw/Btn9DYpKkQHzNEKwV/jh4zsNtNRur8QIV70EtKfKgPmOQ1H6rc5a0Rgt
OGuvcch9uJM17RrDvE0QVlSXU1ozRk86BJpAxRXGXHc1Yv4T0HT6dunSPUbq
aJc5AV011kK+3og8WND9pzUvmjVOD9jjTmWhY27+7xXR48iHBVvsxcvJynH6
nV1ewiQcEhbtP+1lQl6TENq4OZtNNNHoKHuZwSI4drGkxYT8zNAdTW7kLZyg
Dru7Objvc7iNpk0gTw7y6+7Il3ROIA8LZEWkr2lbxSIPC7B3W1Ou5LLIwwpF
LUt+uTPMIg8rVObtV7wROIk8bJDYLi3NKJ5EHjaIK+IOL7VNIg8eclbtkIjD
zMiDB5WmMlZSb8Y8GeImP8mteJtDPQxZ9s3quVnfcpgvQ85rv/AXP+BQH0NU
x8o7yz60YN4CotIsq4jNsKBeAYlTDW4MVVswfwEJ99ElhK+zon4B2fzuT8as
c1bkISQ1ndsvtbNW9CMkK84fSFmtsCEfITlaNrqdXrOhPyERKv6EL2fzyEtI
PAPD1sviefQrIgkdsiRDC4/8RIS90mxOmMMonf5F5K9bKWzSBkbpkDcsIotb
5WtvBzFK5/kUk76C9iPJaxmlA2+UmBRGJv29dDmjdJ5XMYmVe8zs9WGUzt+J
mPhyDdsKPBml8/y6EP3dXWeDpYzSyd+FlOVyXRKGUTrPswsprl8dlNrPU+fv
zoUEbDmk0j7ikYeE3FPf3rOtnkceEuKX7DJMC3nkISGPpEH7/TJ55CEhm4qz
BWfjeOThSio+bs12CeWRhysJePiOZ+IaHnm4kpa9O0q6vHnk4Uq82YJln7vx
yGMGOfNz140GvY3+DzRtT6c=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUxy9toYyxyEATZxqfTHCrm47HiIjn0ynsoVtBcErQoePlQGSM
DFZRUWGiOAUfDPARN9CZTPABUbOo30WyMYEgyoYVkNEWWqAItPQFpb2j7eEk
Nzf33u+e8///f1++Rbv2RiXyGIZJnL7s95nyCnAVlvjK6b35BZrIe5egeJPf
OsuSmecaKNRFSmCxnHo8r8wI87gLdZ7JosQFM98fgsT99Id/hctpYIC9GkAQ
Z+s/eGxmfSME5rQtVbfJqUI6uyZC3gRiz81d4yIF/t8KEmV7UMUeBf1Ybl/w
FGQ1o/VNjxTYrx28bh46kilS0gX25fP/hbJa07J9UiX2fw4t+7ximruV1Ogf
d+qRQQbuLwrU4R/14bxOCBF3ff2kuo+2OKobBtS5X6wX9eP8HkipLyw7crKf
Rjle9MKFjSOTuwUq1CMHySGvXe37VXSNY6ACBIUX1p+fVKE+JVxu7jZfkKrp
Mvt4/z4Y7t/O1FnVqLcfLqeHfXr/yACdM91MOlsFbQ2a1NOeg6hfDZdzfmzz
KRukThoDkNfnk70ycAj9DEBW7dn0S51DdDjSLnAQquqSOoYPa9DfEBT/tzBJ
Lx6mHY44NHDfcLKjWDaMfofBXOyT+UvBKzotbrrhK9iqW3vLPXAE/Y9AVshP
it+VI9Qhr2YUZMljXZlnRzGPMag7xHYuWTKG/cag9AfzhqLcMcxHCyFDnleS
OsawvxbEPfH3q1doMS8dJHw3+tq2Ii3O04GvV+ztnSot5jcOn68I/yPqhhbn
j0N608YV1/k6zFMPVTFnth3bqqNVdnuVehD7PStXVuswXwOEG5bereOP04py
exngQGT0P8Zt45i3EXbwSGrVzXF6yiHQCJd8ayPuCfWYvwnijm8/vPwrPXW0
KzCBrFyUy93RIw8z3Lbmv1g2y0D32eOWmiG+qfrAtWQD8jFD8MrQomzWQL+1
y8uYgO+zrm4585YReU1A989smjnTSJOT7DUJnm/sOV7ZYkR+k+BfWlJRstRE
HXbjLHB1f0gtzTMhTwvwYhXe73aZkMcUsEWC+U+DzMhjChSNt+JuFJuRhxVK
Z32T06AxIw8rpJ2bter1iAnkYYM8se1o/q8TyMMGsZZ1CcttE8iDg3yJbogf
O4k8OIgvLpe43ZnEPBkyL6a59wNvC+phiL+1YepougXzZYhM5ztP0GxBfQyp
ePvP+it+U5i3C4lafe5kav4U6nUhxsWl4mj5FObvQlbf6v1yxxor6nchZPWD
rsLzVuTBI+tMj0uema3oh0f8fd/fuWqLDfnwiGJubxittaE/HskgA37xb3LI
i0dU0PCOaC+HfvnkUR6N07VwyI9PHgcGjWbMYVinfz458IT3Kms9wzrkafgk
uF0aXP8Jwzr3p4CoL4pys8MY1oE3SUCqUh7WL1/JsM79KiB7A+KFfb4M6zxO
BGStzWVTxVyGde5fV2L9u/K0xJNhnfxdCXtmg8yNYVjnfnYlzIPWUKmao87j
zpUkRHk3qlo55OFGOtUxUZvvcMjDjWTsL39JL3LIw43YvF+miAs45OFGTlxb
qC9L45CHkAyFJRx0jeaQh5Dktf/mkRnKIQ8hcd+tOdezmEMeQpJhe2/RZx4c
8nAnvLOZ1+9qbfR/Tf5Ewg==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUxy99gbURp2JgYzqRMQSWiUM3nXo+FRUdWwCNA+MEdKAzCkgY
Yh3iCx8YpUHnRKdOHs6MgNO6ytDx3WCWbbUyn9ChI7aF8lT7oi30cUfbw0lu
bu693z3n////vnwzNuWmZPEYhskavTz3sVKOO5xWHq6hjdNKB5IbL8KTm7Wn
h2eOPTfAV/P/rloUpqHi9uq8ReJbILn7KGfz9LHvzWDQbr7xxwoNjfvQU3eh
15GdWXJsbP2fsPCMqUr/QEO10ikNKzVKkGQlpZpDtfh/K6SG3ZdX7tDSBI1n
wUNoDBYsUbZosd9j+Ph+Kz8/VEene5ZPewox/Mo6qVSH/dtBHTddrXyuo9bI
DeUtQ2pQNwVvX7GsC+d1wKENov7W+i6q8tZzkGmT25eFduP8TnhnzdSwgye7
aYr3xQt4foEc/lqgRz0aiI+Off2oWE8XewdqIe96xeNzI3rUp4OYpPpjP0h7
6CzP+MguUJWMPyV39aDebnD2/tV5+2AvDRptJp2ih+3z1vIqJH2ovwfCI5Rb
J5/toz4avRAucRXExvWjn15IWFi842JHPx1M9gjsg6Iz8W2DBwbQXz/U2L7I
ssQM0jZvHAOwtaDriUw9iH4Hoahblnu59CUdFTfa8CVERhvqA+Jeof9XkMB8
01mne0W98hpeQ0HAm+35p19jHgaInzPSPnOmAfsZYGNrx9Lj3xowHyNcLTp/
ObvNgP2NcCXwUmP9bCPmZQJr6Qth2nEjzjPB1GC/hky9EfMzg/OF1ZF8zYjz
zcA7Is+r45swTwu0pP929miqidZ47FVbYFI5266tN2G+Q7DxO71ZzjfTc5We
GoI21ctAa5oZ87ZCVMvt2upfzLTcK9AKj9aF7L/lb8H8bZA3Q9EUk26h3nal
NshIzJW7FRbkYYeyFf8Gzgocons8cUvtUNQnvvnTliHkY4e10VdpITtEd3rk
5Q1DRFBUWUWIFXkNw82dmZds+Va6JdtTI8Duib1TpbIivxE40FxyTxZho167
GxwgTl6na95nQ54OiDozd2nUMxvycMKVOxWJD+bakYcTPl+1r6xBZkceLpAE
7q1tGbAjDxdsmpyTLV45jDzcoHLVyQ9WDSMPN1Qo48tj3MPIg4OJPyYG8deP
IA8OrE1JUqFiBPNkyM8y3bg5kxyohyE31i9590iOA/NlSH7G+KX8ew7Ux5CL
ucF9Ne85MW8/0jkh7ddth5yo1490iVtT1micmL8fyX5bVvzlYhfq9yOz9/Yw
R8+7kAePbFuer3hod6EfHlFXppbOX+dGPjzy4NaJzGa5G/3xSKEx9NP0Nzjk
Nbr+8f7P3srl0C+fdF0XlxhVHPLjkwk5YfvyghjW559P+g2NxQXxDOuVN8An
hYHXfmdXMaxvfwrIgo4k/q5FDOvFmy0gvFpTwvuxDOvbrwLSlHv6pC6cYX3H
iYAULJj3pDKYYX37V0iiheqQJAnD+vgLif2f3ekihmF9+1lIDs39aPXuHo76
jjshcSulT7tbOeQhInszmjNSFBzyEJFgq99g8wUOeYjIgePLd0WXcshDREJn
HOOd3c4hD39SplCdEKzlkIc/ESVODNn5CYc8/EmqZk3Nf2Ec8vAnlsLvP1gt
5pBHAGmQPGtSGN30f8RQQBo=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQVGUUxy+7wBIRFqiEEAyPQQosHdIkxPMNY/GsdHGKFMEHyOZAPDRL
YnRTGXYaE9RBEwNKlAgFEWuhyfZbJctR8IGEkLrDLo9dWHnssk9Y9sbuHs7M
nTv33u+e8///f998QTvz+dkchmGy5y/bfaEsIb0h5aFy2h5Qqt7UXgP+PGOG
OWThuRke+AXkxQbLqfvjuoJY9za4nbcielfgwncJVDyp5hzwk9O3o2zVAdt3
abYeWLqw/h/4YfmNiKKX5VRRvLg5Xn4Hvurs0Mm8Fv6/B2nc74qXpctpgty2
4CGUCCXRBVcW+j2CjatHt/p4KGigbXnAv9DXdj8+pVCB/R+DgB/8S6pMQQ3h
6eU39X3QImNOlfAHcd5/EB4j7g3qGqSd9noKbj9FtjR+MITzZeCcN6r+9tEQ
5dtfDEDBr/UNcRnDqEcOoo6y7m3jw3S9faACRL2Sgr3CEdQ3CIKDUf2hPkr6
um18+BBkqQf6/K8qUe8w9PgJn3h+qKJL5psVLx6Bzq42X/G4CvUrYa2isLun
fJQ6aKjgabZ1W1DYGPpRQQ937elK8Rh9vskmcBSyZJWXUhPV6G8M/DOWVMTK
1LTXHocahDmth9Z88Rz9PofIhiCXEM9xOi9uvuE4COoTZlQN4+h/AnLpqtL8
9yaoXV7zJIR+Eu5VOziBeUxBy87TyTuOTGK/KRioXyza6DWF+WjA41Zf1MVd
U9hfA62Z5TEXf5vCvLQwskH/e7ybBudpwXK1KvnoVg3mNw3tXSM9m65ocP40
HM9LSLrE1WKeOoirnSgSpWnpBZu9Oh0cqz3RqmjSYr56qHnho/vXuNO06qyt
9FCSOqrWfzqNeRugKOz9w3Ut07TcLtAAl795M6ONp8P8jTDky/8+MlNH7e1K
jTC25vgJq1iHPEygyv5yInyRnn5ti7vYBN3Voad+ztEjHxOYNNG1+6V6WmiT
V2AGgWjlnpO+BuRlhqSE/kPGIgPN2W2rGdCW+VSf7zQgvxmQjj+4XBFmpHa7
6bNwvXHRLYnQiDxnYU/M5tA3nhiRhwXald5vPVhtQh4WGEnekddcYUIec1DD
vy66qTYhjzmQ+PCS3OPNyMMKW9Kqzxw5b0YeVsgKO7Y30mpGHiw0/qE0c7bM
IA8W6gWxmS7iGcyTIZ7iwMlVXrOohyFhk3fcyz6fxXwZIskdWM69O4v6GNL3
0jv3Lyy3YN5OxCCg5/YctaBeJ8LZUhydKrdg/k4kt1GYtW39HOp3Iik/LlOV
nZtDHhxyeMdI9UPTHPrhkGXBHnnRH1uRD4fsjDiUKLlmRX8c4vE0KSrzFRZ5
cYisc2y1Xz6LfrkkJb0pR9PJIj8umdKW7ytYwkgd/rnkhlNc0b4NjNQuT80l
S73NYmkiI3XsT2fS86zKsj+Wkdrx7nYmlQ3r4lasYqSO/epMtu+VlQ2GMlLH
ceJMfNcLu86+ykgd+9eF9LkFe2/0YKQO/i7k+KOONFeGkTr2swvpXnd33QEl
Sx3HnQtZ2e15e/geizxcSXMOP5UvZpGHK0mYq5RJqlnk4Uqun+z/LKKURR6u
JC78Nf2ZXBZ58Mhff24XOm9mkQePvJt64cXCGBZ58EiPSnn6WTCLPHhk6cGI
4CR3Fnm4kb+985vEGiv9H+UaPjc=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUxy9tKYwpAuGh4gOBMVScYzofcXC+KQZhspTCNtTyiA8wG46C
wBDUIIjiMsE52XSbhOFjBgPqlKLG8TU4fILKYIUoouUtFGxLW0ppe0fbw0lu
bu693z3n////vnyLtqcJd3EYhtk1dVnu09UfGjBa4i+nNxcUDUffLIecLZsW
T/hNP9dAvjljdYivnDq1nxOHONXBndnF3B0Lp7/XgyiFac7xltOVKyx1F/wf
xgfs85xefx/Oh63VpbvIaXeue024/BFkzqvr7HKb/v8JCOZn7ZgrktNNcsuC
FvjE95af+Mp0v1bocJ0V7jWjmy60LF/wH3SsWblyc3o39m+H2ButP8d0dVNd
oKi0QdsBimOOBfuFPTjvOdzYMOf+ouYe2mStTliToPijKqoX53dBhQvv1fet
vVRoffEaiNzr7PqEPtQjB55nxIP4kT4aah3YDTfjH6Tsze9HfT3Q5re/xd9r
gC62jA/shbDmhH/nXRtAvX2gkAXKnD8fpB5TzXLd+yG1Md9DMjKI+gfgxvzo
p22lb6iNxiA03fbS+wQMoZ9BiNUs+qhMMkQV0RaBbyDwRGRETMQw+huC1IfH
l4d0DVOZNY5hOPV3v8+qLAX6VYDg4DuXfJ1H6JS4qYYjcMrrRfngpRH0Pwpx
R3ctTds4Sq3yat7CfsXYrfKeUcxDCeKZSk1S4Vvsp4SC3wvjBW5KzEcFgiGe
04UdSuyvgtzGvW4XapWYlxp2c4//GO6ownlqEI689ju8TYX5jcFOiaw6+ooK
549BsuCl32WuGvPUwA8v/KKK49T0vMXeOQ0EVW8/3l2txny14JhXV3WdO0Z/
PWMpLZxu772v3TKGeesgv/hZwrmrY7TUKlAHlVUb1tU5aDD/cdjpMpoVlKih
1nZF4/BsYXWaWaJBHno4WejRHDhLS/MscefqIU4QmvFnihb56OHDuscHs6Va
mm6RJ56AKsOqyJNzdMhrAjrnRyeNZ+hoSrKlDOD+k+lAZZMO+RmAmedbciJg
nFrtiiYhm/vwYn3+OPKcBOOrDP6SF+PIwwiPXMtcn32sRx5GkEatF9Sc0CMP
E+SWGb5pGNYjDxOIvCuWOYVPIA8zJP1VkldYOYE8zCA81PpVkHkCebBwUVbQ
xdlqQB4sGD2WhNlLDJgnQ4zPt7UFu02iHob4FsYqj3w7ifkyZDCndib38STq
Y8jJy1/Unn/fiHnbkYSG9wq+PmxEvXZEdinAJ0ZuxPztyObV6Z/Fh5pQvx1x
boh6evQ3E/LgEMGBrUUtehP64RDnKhq79ksz8uGQznJxcP11M/rjkNx7Od6J
rizy4pC2xpgF3mks+uWSB3yBQNXEIj8uufOdabfYg5Ha/HNJptvj5MwwRmqV
N8wlKzw3XJVGMFLb/uQR9etebXYII7XiTeYRyeUj65YFM1LbfuWRlOzAQz3+
jNR2nPBI0KeP7p2ZzUht+9eeGN5NnSGYwUht/O3JP7KZQj7DSG372Z50rk9c
vm+Apbbjzp4IOypv9z1hkQefqPf0bxRKWOTBJwe5S1rqz7LIg0+6Tu8RLS1i
kQefxH5wbeCXVBZ5OBDDXU0GL5ZFHg4kdcsas3gdizwciHI079hLXxZ5OBDR
Yeoe6cQiD0fCm8utkKjM9H/bpTV+
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMk2cUhktpgTE1jhR0ooCKWhMZqCVjTjlfUBDxMmCLOi1MXLzABMum
RBlOx8URhIEwIqgD1AYv8xpQWLLwqeAUVKA6lTjsWgq90At/S1soBRwth5M0
zd9+/znv+z4n3/zdB+P3sFks1p6Jj+N7qnJFTfWSFBlt9MvTxjVWQe7K0IDW
s1PPN8GjcFvDgQ4Z9XxzSbTGswH4745/9sBDjv83Qbdp95kjvnIqWOmoZggM
bmOO+Mjx/GPoTbpzP32mnPZk8m6ul7dBS9y1FqnX1Pvt8NW8hE1zhHIaLXcc
kMD1q3XTRbem+r2EmpeCFbOm9VB/x3G/VxBSXRGwKb0H+7+BA/bc3C+lPdTK
FxY/tHTBuo9npmfFK3DeW+AHZzXMf66gz5zVDWL7H2XXNvfifClMK/V7UfCy
l8Y7f5BBljr/dERiH+qRgyDcsylB30fDnQN7gFUnSfzhhBL1KaCisKU1cJaK
LnWM5/dCWFL307l3VKi3D3YFSjpnbFFT74lmmTwl9L6P/uieXo36VXC7KujZ
P8UaOklDDWF5waUBi/vRjxqE8R+2/3avn+riHAI1cEU7rozfoEV//aAe5nas
lmrpa2ccWshXznkYeliHfnUgXm6MWTBDTyfETTTUw+3vUteqr+jRvwFaPq2U
pEUaqFPezQEQpNGkKoUB82Ag4PKGql05A9iPAWGBaUWsF4P5GGHOB8tl4m8Z
7G8E9aLtGvFdBvMygfWvwOT1HkacZ4LowCWjOTuNmN8gnFxbZ/f+2YjzB+Fi
SzRc0DOYpxlqI6XZy3YwVOywd8kMc4tUhQeLBjBfC4iKvXgn9xro2UpHWaDw
9Jpz50GPeVthe9n+BXWzdbTYKdAKWeVlV1uN/Zj/EMyuaAqRtWmos13eEHRW
ahqsl9TIYxgE53kw/ZiK/uiIO3MYan6HvxduVSKfYeCvueC7SttH0x3yRDbg
Cx7vaDmlRF42kM2rfswKUtF9ex01Atczkny07SrkNwIhqp0+x9PV1GlXaAeR
JudOI0+DPO0g+ISjK2vUII9RuH3xkWJaQj/yGAXZK3OHP1uLPMagNyOX1XpZ
izzGYF32jXecLTrkMQ6xzamqDrMOeYxDjTf37uLzeuTxHmT2dDN33dQ+vIfY
Ln1yis6AebLIk43JA7HlA6iHRTIPcVbt9GcwXxb5fqtkbOMhBvWxSHio3xdH
WxnM24X89OejZrmfEfW6EKZzlT3nkBHzdyGEG1OV2GZE/S6EX/dvoijAhDzY
pE3QMNSQYUI/bOLhuX6Z4LkJ+bAJ3zvxiWLhIPpjE1H/WPWjzEHkxSZi4lfc
JRlEv67EXHT4qO9SM/JzJdlPI2KKTpjRvyuZmTrbvKzLTJ3ytK4kpuCKyBZs
wf3kEOHq0vvGXyzUiXcvh+wPDtHyZBbcVw6Zm7J/PCnMSievEw5hRR2b0VVi
xf3lErcz/4VmaKzIn0ui3Njln0cM4T5zSXtJUPySc0N08rrjkhfLt1WGmYeQ
hxvpvGU9l7Z5GHm4kfZsacmT2mHk4UZ4b3n1kSwb8nAj1+tvRPV9bUMe7qTe
vfbX2job8nAnIgN9nT99BHm4kwL5N2mn9o0gD3cSpUm5euPBCPLwINLWRTKD
r53+D7/XSS8=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lA9Qk3UYx8cYf0RC2830ohgoh3BSnIJFWT2/AAkpTLguUAjBEoMEIQco
/gFDwkAOD7UQKUFQyDtIk2Sa8SP/gagQggGBsI2x/xsbG2MDxdh4eO7e273v
fu/zfL/fz3Ovx449UTuZDAZj59xl+V2o+mKX3O4UAeW7FSgj+b+AKsOlor1i
4b4ROPzEtbu7BNSpryb9fadmuMkeudrqKMT/W2CftEWe5SqkAf6Wug28Pezg
7FeEeL4NeP4idvpSIRXlcBo/EnZAbb94cIi98H4nhC1pTFwRJ6RhQsuBbvj6
+Ih72m8L/Xqg/EOn4GXOIsq1HHd7AuW3tW+GZ4iwfx94xwefiBwWUaN3XOmt
yX5oUnjk5ESN4rz/oD207y/uo1H60FpDwGqI+Kk+Qozzh0G2z6nnWI+YRlkf
CCCuta2UxI+hHiGQrvrrseox+oF1oAjaRSPRGXkS1DcKnkWfta5cLqU+lvHe
Yrg5ZdP66hUp6h0DR+/qW86bZXTZXLMcjgRMA/2MJrUM9UvBUVN2/XGpnM7T
kIE2g7uR66VAPzIgS7ceOnlNQVWRFoFy4CmulUVuUqI/BTinvJW9YVhJ/7XG
oYSv9vYkBWSq0K8KYpqCVO4uajonbq6hGnx/TxZK6tXoXwOsB1G7UzdqqFVe
4zgM7dhkrhzVYB5a+CSted32/HHspwWx74UDn7K1mI8OWsKTV9d+qcX+Ojg4
xvWr/UOLeU0Av6OgIdRRh/MmQPL2GsiP1WF+ejh+P3icc0SH8/VQHj6wrkqt
xTwNcOlBWtaabVpaa7FXYwDnM4681JJxzHcSqs76z+QnaWjFGUtNQszP8d9V
gBrzNsKpcz8surJCRUutAufuq5tOtOkUmP8UbKkZWT7cIafWdgVTcPmC0zlD
jQx5mOBo3XqvxYek9IAl7hwTlP+a0ODxuQT5mKDV1ffpO8oxmmGRl26GGF3X
a3eKJcjLDAJ/zyLGG1K6K8lS03AsIXFA0SlFftOQvurJwOEMGbXajZuBfWZe
Jp8jR54zEPbjN5dP8uXI4xmI5dX1zl8okMczcC8MOc1lKpHHc+C4h95rr1Mi
j+cQcG2khrVZhTxmQbxsSWOXQYU8ZqGXyznoValGHi8gL0b9p13Iwj68gEqf
3rUpKg3mySCcgOvNW06Pox4GMRUmuMVytZgvg3QOJ4g+5mlRH4N0FAn899/X
Yt425Pz6G/VCNx3qtSGznQmCfJ4O87chK0er8uM7dKjfhtz7Z0dIuvsE8mCS
U/rUp81ZE+iHSQI7fdkBjyaQD5OsDPm2cXSVHv0xySUlfH83R4+8mGTb4ZLM
/m49+rUlVXtfTnD1MSA/WxLY5rS2JM+A/m1Ju2bxoG+/gVrlKW2JwrYt2uw3
ifvJInEeg3W6wklqxZvEIizj+cccwSTuK4vYF7EkiYFGOv85mTsfGGTsO2HE
/bUjd/oevp4lNyJ/O9LLXn5oQ9AU7rMd8ZInv7v67BSd/9zZEe/oG0cCDVPI
w54YPPOOpkWYkIc9qX1Ysr/9ogl52BN+rrxyI8OMPOzJe1DnN7bVjDwciJFx
J/viVTPycCACkU3rsZemkYcDcd9+N7p41zTycCC+ufqyhr+nkYcjubmo+77G
dYb+D3EPSqQ=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMk2cUhkspFIlsikXrUFBwjDKHZJIM5uV84mUFJwhxRsURdBG5eIHB
MGNVIVyGisEImk3RoTgsUyuOqcw5PpXAkAwFhMEc62ih0Dt/oZQWqh2th5M0
zd9+/znv+z4n39K9h+P2sVks1r7pj/17pgqqEyI7UvtpvU+hJrb+MszpU8xr
uTDzLIGwt1NvpD3vp+49Velr3O+DUvJR8CM3Gf7fAGGZS3/J9pbR0JX2agRz
1zGPI/NleP4PKN6669/Dc2RUnsOTfCJrheWBvY19njPvP4Niwfko/m4ZFcrs
BzpgdfBL90O3Z/q9AJZPSLDXbDn1tR/36YaWDZ95R2XIsX8PCB8Zj8ZK5dQU
uLv0yXgvdJ0TpOTEDeC8l9Ae87HEt22A/umoPuCnepwQbxnE+VI4s+jd5uIX
gzTO8UM/8HRhBSRBgXpkwPFLvR2vU9C1joFyEKeoojNyh1DfAFSuuFTvt2CY
CuzjAweB8/fxX9+5M4x6FVAvj/x9drSSek03y+ENweqOK9Y6nRL1D0OJ4Mt7
naUq+oaGEnKbw/7zCVCjHyUYbRELy+6pqTbWLlAFoRVpIbGRGvSnBmG3ZP4q
qYb+5YhDA9uect1Cv9KiXy0ITwaVLnlLR6fFTTfUgdDfWjgk1qF/PdwsK/I8
uFFPHfIkI3DAzLtSMaDHPBjYsXBuX0L+CPZjINmPFxvjyWA+BghJP/eq6gsG
+xvg/GaO67W7DOY1CkknFhducjPgvFFYm5mxID/egPmNgSimSz4vz4Dzx6C2
PSXgBx2DeRpBHGtLCdrF0Gt2e1VGyPpREJ92egTzHYeS69vkeUl6euF7e40D
Iz6e8h3oMG8TJN74iZHwtbTUIdAED291H2kyqDH/Cdhxm2X7p1VFHe0KJ0B7
5/2i0Sol8jCDsG67x6yjw/Qbe9w5ZjhzN6/cd/sQ8jFD4NS9y+EaBc2wy0u3
AKu2V9p4agh5WaAlquZT1gfDdH+SvSbBGrWnQv1sGPlNQnpi9KVjGUrqsLt7
CoTuSeH1PBXynIJkW2dWWb0KeVhB9OGxg7M/VyMPK7SHl+/yZWuQxytgWrkl
Ldc1yOMV9KrnpnKitcjjNfQl12Y9N2qRx2soCPJfH1ChQx424NxPznfZMLMP
NrDmPLCkaPWYJ4tULpqVu/XcCOphEfHFh+x4XwbzZZGr+5nmzVkM6mORs/1X
+V8/ZTBvJyK9Izkt8zGgXidyqK2oKT/LgPk7kYrHE8kJrQbU70Ta9SpB+pJR
5MEmtT8va7yfPYp+2CT0rKd5Zdso8mETfmZR+YD/GPpjE6k270BTzhjyYhP9
b9b43o4x9OtMGnbe2uQtMCI/Z5LV2LngdK4R/TuT/nTb4+W9RuqQp3EmlUcV
ay0rxnE/OaTZdVmp4dtx6sCbxCHih14PeP3juK8ccr6msm1PmIm+uU44RBvE
lfacMeH+uhAp/4FLtsqE/F2I2nf5vlURE7jPLqRoXbXfexcn6JvrzoVcFi1O
DTNOIA9XEnFh1sFDW8zIw5U8mb9mb0u1GXm4ktCAhsKNLAvycCWmp5V8xU4L
8uCSuElZYnWdBXlwiahnfU2xxyTy4JKbfUHrTu2fRB5cssNLJLr1eBJ5uJGQ
KFGd3nuK/g91J0R8
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMk2cUhku5tDFoCIJDDTenTCbLLrgNYXi+MVEgioVszCmwuSEwBgIJ
IKvOsaqRCIKo25giIQLihXQ6hAJmfoJEJzenoGWOsLZAW+iFv1dKuThaDydp
mr/9/nPe931OPv+vs+MPsFks1oHFj+17qXgdwpVPMiS01eeEKq61GrwggfPw
wtKzENS/FlZnPJbQZeLanPBlImCUNX6UK8X/70LdwrGjBWuldHOwre6Da5hK
XLBKiucfQm/W04ZsNymV8T2EO6TdcCSp58aw+9L7/UACjwZ7JUpplNR24AkM
Ng8as35f6jcA6f99ttrTVUZ9bcd9nsFHN9o4Mbky7C8GHufKd3EjMmremFje
aRoC1w3v7uHHj+K8F0DCLlX79o3SXnsNQyWnj3911xjOH4G5S9BWPDBG4+0/
SKDOeK2QJI+jHikMRW+q36cZp1vtA2UguauPzC2So75RqKkcv7nuNQUNtI3f
OAZeWfN/rLmlQL3jsO0dvcg1Vkk9F5vxPeTg5ZphadIoUb8Cbl+PbXpaPkFf
0VDCzgre9z4Bk+hHCenJQc1nWyapOs4mcAKKp337edEq9DcJN53eaAkdUdHn
9jhU0KUPuxacr0a/aigKd3/Pb4WGLopbbKiB3kNlb8qvatC/FoI+aW/NjNRS
uzzhFLD4kqiqUS3mwYBHU8aJ5GNT2I+BBLdjAbvdGcxHB9zyjoHabxjsr4P2
G8rh2mYG89JDd0Rz4nauDufpgXVdNCXYp8P8DJD6LOW5+086nG+AUwnW1dUa
BvM0wnlxeVLgXobW2ezVGmHzrZiIb09PYb4mWN+U/+jHVC298JutTJDSXMP7
BTSYtxnyRD3iRi81LbcLNENlmzn5vm4S85+Gxjv+8n+6J6i93YlpKPxzZxZT
q0QeFsikh4wuPyjoYVvcfAs0dlw+7J0gRz4W8IvuZIeoxmmuTV7ODLCI8uPO
EjnymoHewHvChSAFTUu1lRWKBYJ5Zb8C+VmBZzgyfyRXSe12E2dh2FRX2eIx
gTxnIT10w0BF6wTymAOeUN69LGkSecxBodRT5M1WIY954ArqFQ8aVMhjHkLK
+rvYsWrksQB7Hpf19xnVyGMBBv0DqtZXaZDHS3DlnPvXcdvSPryE1rEVcelq
LebJIoOfn3oe+/MU6mGRdOv5t/b6Mpgvi5Dh/bqYPAb1sUjUHWFE4SMG83Yg
PEgQSXx0qNeByBN6tII8HebvQEJKXlQkdetQvwP5dEtmfLafHnmwSWn7DlVL
gR79sInbGbFvcJ8e+bDJ8YvaO7LXDeiPTQpzys518Q3Ii01aHwgF4icG9OtI
fDxcstYEGpGfIxHEDYSXFhnRvyPxMlxVbBoyUrs8lSPJdNuSYnnbhPvpRHid
624zJ03UjjfViRxsvjeyUmLCfXUi6xiL7qsQM311nTiRv3qWs8VnzLi/zoTr
nROYP2FG/s5EVnK2ODRiGvfZmZStuhsZcHGavrrunMnfIkXph8Zp5OFCut4/
WZ61y4I8XMhRbvbxh1csyMOFGL+sb9jGmkEeLqQ3dGvo2BczyINDLp/+QFDf
NIM8OCQ2j9d9crkVeXBITRqz/1SaFXlwyNzB2arGDivy4JL23S0DmrWz9H/T
/VD2
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUx/vmETV1qwuZW4XIJj4WccAgi3K+KYvKK6I43AaGbbxEHdQU
J4gGmI5sEkEdgtI5RSeLD4bolOjgQ8bDMWFFhjhj21setkDBFvrm4dp6epKb
m+/e757z//9/X67fl1lbUzksFivVcTnv7vJ/NqeQZzK0QXx0LK7hHIgOry5s
P+te14Kwtcgn8x+GevdfzF7nfQcOiFlVTZ5qfN8E0imVXLpYTYODnPUneB4M
WpHzhhr3d0AJcO17hWo6kCeq3ajuBJk292qml/v7bgh+fESzi62mm9TODT2Q
eDOO7rcy2K8XiK1guGKCoUuc28V9UHBjBdM76NbTD9bBcK81TxhqDkgsbTE9
gZRbM8d//5vBeU8hMOuQNL2JoQ9d9QziBXEno+vc/pSwQ7a8IvMCQ7e6HjBQ
Nn3Ks+MEg3rUsNZyd0N6IUPDXQMHIEITdHhLtlvfIJw/8ai9eCdDlzvHBwzB
PPa3gtei3XqHYa1mGdsYxtBFjmZ5oucQEZv/yfvvuPVrQHfIUtQjZOgrGlog
/in3r1pU6EcLvo2ntxQ/VFFdnFPgCJTVywbXnVehv1F4UL1id/8+FX3simMM
mu8lnP08QoV+dbBFlajtEamoQ5yj4Ths+iD25EdDSvQ/AWEx3bIb9Urqklf7
Ahp87/YFFCgxDz0UfN3Vdz1aif30oNWGczb6KDEfA2S0bTtuH1BgfwMID43m
d19TYF6TELhj5sKDHAXOm4Sy3xZdmlinwPymIHCnzGv/BgXOd6zvdFRqspWY
pxGYth5riMPvJae9i451wHr9lQx3viaQJob7ijlqevaMs0wQv7nLL0umxrzN
IM/4uaYydICWugSa4ZZnXWF57wDmb4E/YO1PydmD1NXuqAVEZ37lmeYPIQ8r
NO9MUMVcG6IHnXHnWeFWgESSFjWMfKzw47KY1tCxYSpxysu2Qfysntty7Dny
skEBfCyZW6Wh6WnOsoNwT1GztluD/OyQstrcnC/RUpfdxGmI559OvC0aQZ7T
EFFdUnGiYQR5zIDV1FLqnTSKPGYg+FRq/tucMeQxC9qV6dfba8aQxyyIWljH
OLE65DEHlX6B5V1GHfKYA59VIV/5y8aRx0soS1lwkRsxgTxewp4Qk0+GbgLz
ZBE5PD0XW/4C9bBI3XzDws+W6DFfFnmaYuiLlOpRH4tMCiXLDvylx7zZRHYv
UsaIDaiXTeZtN/QWSQ2YP5sId635JqnTgPrZZEHCVGiW7yTy4JDq3Dn57f2T
6IdDJrY18oO6JpEPh/h3cqoHlk6hPw6pl8hzW/OmkBeHxPPEu/p7ptAvl7Tb
Lmx7c7kR+XFJckyVf0mBEf1zSbdU1r3yiZG65I1xifz7hCjrahOeTx7ZV7O7
Sl9soi68aTzinR/U/jpjwvPKIyxh+X/JYWb66nfCIwuaHo08LjPj+eWT2qSk
hTkjZuTvWFfWZH+43oLnmU94Wfb33q2y0Fe/Oz4JU0TmhBotyENAWq4ID+yN
sSIPAbm8Vby347IVeQjIv/y8sgiWDXkISHBb6NKhT23Iw4MIiuN3/3LThjw8
SHvGyZvF8+3Iw4PwhrdH/ZBuRx4e5C3+ke+u3bcjD0+iK/2icXzxNP0fN0VF
Fg==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQVGUUx5cFFgKcqJAQFVejBoxJBAXGZjmftOYj5GFUkGAMjWwwoYsu
DgEqkooPGpDRNCW1QNwxYIjATBk+IYQyQRByGZPde3kIuAsu7HtBbHc9e2bu
3Pnu/e45////981dnrZ7204uh8PZabmsd3up9DHSnkyG3vA7ooy/cRGix3mz
d87b13XguvhkecZ9hrrJKsUCt9+h5mbiwhZXFt+3gM/BqAuSxSxdE2qtP8Gf
vaSVeLO4vxMOJ+e3Z3mydCjPq24jexfqC17kZL5i/74bKo4uashwYOkm1rqh
F+rdDMf3GRns1wfnMiLqz04xdJl1u9+/UHhad61v2K5HBvz9fv3BAwzVBySX
tukGoCp4JqnpHwbnPYLcseMgamHoPVs9hvYDOSnR9XZ/cjjME6Vl/sTQbbYH
DNwLU/Z1nGJQDwv+D4JeFR1iaKRt4BAs4bdujhPb9Q2Dlyy/vHgHQwOt4wNG
QKrZ9OC1aLveUfBf5N6liWDoQkuzPK8n0C/cvyLkbbv+MfBp8I7t9WToSxrj
EMcqkn4xKNDPOFwuj5s4ek9BVfFWgRMQHHemQHBZgf6eQmJlmpNsj4I+tMWh
BL70fuh2oQL9qqDsvYVFvV4KahFnaTgJuTEbg9aPyNH/FPQcdQ3/tUFObfLq
nkFP21pxQKEc81DDucYT4tpoOfZTg3Fe8OOHPnLMZxoGuk8HmocGsf808Euz
fLprBjGvGbh9oFXwV84gzpsBRrmETAkGMT8NBHOmD+Z8MIjzNTCgFniOieWY
pxYSv0jPXmvxW2W1V6kFibtv7bWv7PnqIPf9nweXcll6/gdr6eBYyS3FrgoW
89ZDT653+rnwIVpqE2hZx9WRM31DmL8BtEG3k1PFw9TW7ogBxs/Wt2sXjCAP
I6Qy7KWtNSM03xp3nhGWXCwISf9oFPkYYY43cCRcOUqzrfLEJnBqNt1pPfkE
eZmg7NO7ofNBY1SUbi0zcD4r+na8ewz5mUH69e7DBdnj1GY3eRYKvIv5170m
kOcsEHft9lM3JpDHHCREXkpwS3mKPOZAu6Fp/VKuEnk8ByIL2NtxVYk8nkO/
PiSeG6NCHvMQndO7vUurQh7zIAwTrvSvmEQeL+Bx2/FMR+EU8ngBHsX/MSLV
FObJIYkBK0UxZ56hHg6pW75Vn7RMjflyyIHJwptbJGrUxyEl6aEeuX+rMW8H
Ig2HQ4zfNOp1IOUfv/lHkWQa83cg3288lpxydxr1O5BmSd7S3fwZ5MElVRFN
16/vm0E/XBLpU6kM6ZpBPlxiNnofG3pLg/64xHfv66nteRrkxSUror6LlfVq
0K8jkSoE63wDtcjPkXy++Uv3kkIt+nckc/rSpncHtNQmT2nZ77gvxLhKh+fT
iVSXNBapi3XUhjfdiTREVde+wejwvDqRwlWrW1Mj9PTl78SJPKk/2/uwTI/n
15k8urjFJJnQI39norrSnLguyoDn2Zns6gzzfueCgb783TmTRm5dSrjWgDx4
ZBP/fGrWViPy4JGGiq5POquNyINH/GpivhFyTMiDRzpiV3uMJJmQhwsRFu5J
uPKbCXm4kF0p/RXFC8zIw4Xkpt1ac0JkRh4uZMcFD3FNqxl5uBJej8fVycWz
9H+eLENX
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUxy+lAtY9QAvBVRluGOsWI6JE4oTzxamQIIqMKQ/DKrFQmI5i
wDE2scOhxo3ZRZz4AEFhE+Q5R0bG4tcNHx0CthRKYVJuK+IcryIIBQTWltMv
ubk5vV/P+f//v+/eVfEpEWIOwzBiy2W925fS7dpRVTJL671yBvbWF4KK22Ru
T7fXVaAUhE2Ml7KU13lDGsj7DXTerU2NM/bnd0DCKxWnCQx000bragTTztdo
mocB9z+AvC/Gvj/iaqDGTH5VsKEJiFsOSV5swP+3Qtrmqq+SHAw0xGDdoIbI
+KuRx8ws9tOAd/dI5sVhlr5t3e7VAS4ZinTNE7ueTlB4zBX66lg6ITxw7q+X
OjhU+cyn7iGL87qBK/qRl3iHpc229RiUE5eEu2rs+vWwVVqyLrmYpRG2H1j4
I3Xbtfs/sKjHAExlYXfC1ywNsg00gmf0bvdwqV3fE2BWro47HcfStdbxwj7I
6H+j0G2XXe9TkIQO548FsNTd0iyT3w9XP8ga3rDarv8ZpPX7C9SuLF2g8S9E
Fca+KJ/sRT+WOomXfaq5lw7utQp8DvlDue6BRb3o7z9wKb1coD3aS7W2OAaA
zQtuidnei34HwZTVIlDze6lFnKXhEDAScp/06dH/MPgqtqlrftFTm7yqEQgQ
1/KEMj3mYQLXqeAllbv02M8EEo/AgJ2eesxnFDx1HXenjD3YfxRkxabbLRU9
mNcLUJac6nqQ3oPzXkC+0OfxUGAP5jcGRaU7JtI+7MH5Y0DW/Xq6X6rHPMfB
NDP9fJPFb4nV3o1xiBwZTSqX2PN9CSqB05WVHAO9fMm6XoJCVVbw2VUD5j0B
srO5PvmbjfScTeAE8K9UzOdpjJj/JOje2r5CJH1Cbe1yJiEkv/6b8df7kIcZ
dPGHRWEVffRLa9yZZsjgnxkThz5FPmZgipLDtqx/SlOt8qRTMFh8oT3cpQ95
TYF3iSI20WCkiQnWNQ2+Pw0Yj/9ufx+mYetNj+S88yy12T0wAzcjTxo/7tIj
zxmQR3WZsr99jDxeARu7fr46sBt5vAJhq8efyTwd8pgFZUOVuPFuJ/KYBe+x
UvONrE7kMQdR8au3vBnQiTzmQPWeROs8qkUe82D+VJQgL9Mij3nISNknvXVQ
i3kyxDciWxK7XIt6GGKSFtVeV3Vgvgw5UykrOHm6A/UxJFwpP8IEdWDeDqRm
8OBHgvF21OtAVHVrU7Vl7Zi/Awm5HtS98ZN21O9AZPvk5/357ciDQyTVgrwe
pQb9cIhcE3Nv3XEN8uGQooRaR+EGDfrjENelHV6tfW3Ii0NEYr/uVflt6NeR
mIJ3D/mEtiE/R+Lr7sPtmlWjf0fieUJGoUZNbfIGHIk8PLouJl6N55NLREHv
pL7PV1Mb3gQuYR54pd2+p8LzyiU1EbX+48dUdOFzwiWq0p/fHVmjwvO7iBQd
XrwjtPYR8rfUy+QCv6WP8DwvIoo4sfTC0Va68LmzPL+9TPd5WwvycCKygirt
PxtakIcTYfbvYRvlzcjDUi/PjfYbeYg8nAg5MXpxbdhD5OFMmCVJxlvlTcjD
mbCT1akNzk3Iw5nI9jdIYw79jTws9bDX7FmFEnm4ENF3KWv2rFDS/wFGHEEn

     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMk2cUhn9utjKnyMpkXrBmKOzi1gYMNRPPF0cyQoEFw6IOp0ypNtVl
BdExdAyjTpjJQLwMZZpNEFGE1bm5BtSPCAytXFpa2s7R8v+lThTlIgU65bK2
nJ6kab729Jz3fZ+v/7JtX66X+TIMI3O93O/e4q8cXKNVsFQddqQ/RX0e+CHN
TsNe77kWhL8njDkusjTQVK6MDfwTMngaTeNL7/e3IW6aUWct4mh0lLsagX80
df6e1znsb4FUaTi3K4ijtlxB7UecBlodZ0vkszn8fTscsF1s3+nD0XjO3aCD
jTSrMtvJ4jw9hAZcaD01wNKl7vawLhDckrboer16TCAZ2jr0npmlY5Gbi+6M
mqGVLtl3/T6L+x7Amv3n02S3WdrqqW4ID876OkHl1W+FxKqEPPkvLF3v+YAF
Fe+PwabjLOrhINyv+23ZQZau9Sy0QeJIqixZ6dXXC+nnRmqObGHpW+71kXa4
Oqfi2bxEr96HIByJ7xuWsDTENSxX8C84N52LFS336n8E5sJQRUcQS2do9IHz
g8qiS+M96KcP1AZz2KHWHvo0xS3wMcg11murf+5Bf09AUrd7tT6rhxo9cfRD
vv6MfENcD/p9Cvnj52+0CXqoS5xr4DOITypOj7Vb0f8AqDOCdtX8ZqUeebWD
YI6ZKA/Pt2IeQ5Dz3byKy4lWnDcEIuagdl2oFfMZBlX3qc1jNgvOHwbnyXel
mqsWzOs5hCrXKpv2WnDfc8hp2ZD1JNaC+Y1A316rKfNDC+4fgeKO2Tt7lVbM
0wEFltdaxC6/FW575Q4ojt5uqpJ78x2FAvlW3mJfjp49465ROPzJAP+LnzjM
ewyisxt+OB1jo0UegWMgF+jkJ/Q2zH8cWOlnh7coe6ln3JFxmKi41//8VTvy
cEKqIucv6VU73e+OO9cJ8dElGzOkD5GPE/qqj0VL3n9IM93ylP/B4tob9cl8
O/JynVXcOhlnozt3uOsF3Lw2R7O/zvt/eAGG6zEpJSdY6rG7+SWodjerUv62
Is+XEKlcRPOOdSOPCQjKzmyrjn2APCZA7kjbpgg0I49JqHpTxGtsMiGPSRgS
bz9bnmdCHlMQNDese67EhDymQGQqy+ENG5HHNJTWtPOLLxuRxzSojFPB1Z8b
MU+GFGRmvJL2hhH1METyoD71grYL82UIO2ggh452oT6GlO5ZMp9Z24V5+5DS
khXjCx0G1OtD0u3LQ4yXDZi/D1E/ysyL2mpA/T7EHPciZpXAgDx8icpQL7Hc
1aMfXxJ0S6RY+Y0e+fiSocqbVRFiPfrzJeqYkKY2eyfycvUzl75dVtqJfv2I
8PFYSbi0E/n5EUkSc8U8qUP/fkRpLZKBSkc98vr9iEhRlvbpNh3eT3/CVJxe
8I5ARz14d/gTbWDzwuvNWryv/qSBX9g9sk9LZx4n/iQ/XaUZiNDi/Q0gwgUH
TiRc60D+AYQs3a4QB3fgfXadHT/Sk1ntdOZxF0AafC5GfNXZhjxmEaHx3Ip/
xG3IYxYh5WWixuJW5OE6/7rqinjwPvJw9R8f7YtMuo88eERoaImqvqJBHjyS
XilvrONpkAePsBFtdzZl3EMePEIWFX78fcNd5MEnJFmcm7z4Lv0fRAhAzA==

     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAlQU1cUhkPY4lJNKVIUxwZHJTpYoToQW+DcilOQTXTautQlVUDUThuY
ipVaSxXGoHVERQvUIhQcECgFtQOo5UakFSFIEpakNMt7IaIVRRaBACpN4smZ
efPm5d6c8///d9/z3vXVxnguh8OJt1zWu72cwsBVsY+htQsy+jbU5kMVv8+g
OmB/roQBny91Q5cZOl1dJAmeXgNy32fVtyft6/VgPrH7aLIXS1ettNYd8Hwq
+zfZg8X9d0GSeLF8P5+lxlT3yjC2GRqlgu2J01j8/33IPvt+7h4Hloaz1g1K
uOXhmfS1mcF+7RB3YMtP5/sZ+o51+4JOqCjwOKvssetRw+ZMuPmuhqGjwm2n
G0Y0UBX01ofXWhic1w2bh8uWxNczVG4rLRScuLA2osquXw/hbtJ1iYUM3Wj7
gYGmNTNvNp5hUA8Lnvro0bgfGBpiG2gEX1+jX4zErq8HPu65eChjB0OXWscL
TSCd2ls3O8qu9wH4Lva9Pihi6BxLs1T3Xjgcmz/Nb7Fd/0Pg1QcGtPEZ+prG
I1CYvYUlYwb08wh45WdrjsoN9MkGq8D/gJOojlhdYEB/j6HpZrFKlWygXbY4
+kAke5O7aa0B/T4BYdim2FZ3A7WIszR8CgMJmRNBJj3674fS/Ajn367qqU1e
5TPQdB8MWZSmxzwGQCiXh1yJ0mO/AdB4pO1f46nHfAZB09s1NmLUYf9BEJT8
3nuvQod5DYHivOPMxgM6nDcEYqedsx4H6zC/YcjxXBmTFKrD+cOg4aXpjRI9
5vkcclJKwd/it9hqr+g5FL/9QXZpoj3fETCF3Wn04rI0L9daI1CVo/37i4ss
5j0KWemB0RcCjfS0TeAozNze5nOu3Yj5j4FWxIbukPRQW7uMMYgqVpYPvWFC
HmbgPOEej6ww0W+tcaeagV/2y9y4yAfIxwyHayq8AlY8oElWeZJxMNepf43i
mZDXOPBvcZftZo10T4K1JmBV/fLqQzfs78ME8GWbRVnnGGqzu20SJOmu30f/
o0eek1Ar3X4q9aQWebwA6Y/Xfi4J7kYeL0DgVei4b7oGebyEb05WlzY0qpHH
S5BJBEFFR9TI4xXU1nkcmSVSI49XUJDeNs91sAt5TEHt06Dy01e6kMcUiENK
/ij7vAvz5BDxmY8qt87tQj0c4heqHitUdGK+HCJ9b6np6PFO1MchIkHZ9ang
TszbgcgC+/LmPe9AvQ5E6LawrvNKB+bvQDgrLi9cubMD9TuQJv847Sr3DuTB
JeHjn+m0Te3oh0vEpS6zl3/Xjny4JKv3brSPfzv645KcbZ/sbTWpkBeXxOZ5
LfbOUaFfR6KQXhItilQhP0fil65dr3mpRP+OhB98aQZUKalNXp9l/ZjOYesu
JZ5PJ8Lnzahf5q6kNrwJTkQWs//21b8UeF6dyMCf4mPDKQr6+nPiRATz65L6
fRR4fp2JoKGfXVfdhvydiUwYUOfn1obn2Zkwmc2zspPv09efO2dSsD7gYIqq
FXm4kALeqZRu/1bk4ULSBh+mNWTJkYcLEYfpJ/yetSAPFyIrHl8tjG5BHq5E
kLsko6ysGXm4EvGn3nNuuDYjD8v6hN59S9w95GF5Dh8uzJQ1IQ8eEbsNy6Pn
N9H/AW2yOeE=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAlQU1cUhkPCVsQSNVU7VoUyFZjRIsq0dBDPLVpEwY7Sis6UKrJrHEkp
UKsUUmSJtlRaLMVKJS0UgWForNMRqngji4ZNyMLmQPJeWAqCssmigDYJJ3fm
zZuXe3LO///ffc8pLDYoksvhcCINl/FuXuNJuqutJxlauSF95GDlNWAcB3Wq
BPNzBYxTYe/knwy16ywU+djdAv9VIzfuzZv378Kp1fcD49ax1HO7cdWC/Sdb
iuNWs1j/AA6kCxKFfJbqzwoq9rCNsHZ9sUvMayz+/yEs+LaGR1uw1J81Fihh
8+lq7/g5BvupYXSAH/bzU4ZuNJZvaAfNeTZE2WfW0wmX396Y8W4XQ2dcQy7V
THfBkSpb+5tNDM57BBLhrYmIuwxtNq0eGOXedtgnM+vXgmtSvSDmd4YGmX5g
wDI5PKPuRwb1sGBbRe9FfMvQnaaBerCPjF3YLzLr6wO+m99H6UcZ6mYc79oP
pybd0x0CzXoHYMdhB/GEF0PfMDQ7KxgEyZ6Cdvd3zPr/A8FkMLeVz9AlGkNQ
+c9v8uJZHfoZArk48EBqs46OHjQKHAaJVVufl1SH/h4DudMjVMXpaIcpjhGQ
ll+4Grxbh35HQZbr8LhZoKMGcYaGT8BWnHp5R78W/T8FeWdaQfnfWmqSVzEG
oqSpLmexFvMYB9mKi90lgVrsNw6iLSnWvmu1mM8EKMbW5Ezre7H/BEirtqU2
lPdiXpMgq1Zcr03oxXmT4PphVNmwTy/mNwUx1Zl1ol29OH8KhnbPHNKLtJjn
M8he5VO51eC3yGiv8BlI5lceLIkx5zsNd1xcUtdxWfrrFeOaBqanMe1UPot5
z8Da3Iplue/r6SWTwBkoL24Z/Emtx/xnQbYpkndU1EdN7dJn4dOibuHk8n7k
MQfi01l7Asr76Tlj3GfnwNKp9FF4wADymYOu2haup/sA/cIoT/QcFPVzF/bZ
9iOv56B54LziOKun0VHG9QLkDR/nffWv+X14Afzmrzf+kMNQk92QeXDM37t/
b7cWec6Dq7Tgs8TvepDHAvCLpk8U+jxCHgsgGThyKcquC3ksglQzvp3WdSKP
RQi1G7pfkNyJPF4C51y07TKvTuTxEs74lhXxJjqQxytwTfvD8/vSDuTxCkhm
3s7rxzswTw4Rnax77/CbHaiHQxQSfcq1tnbMl0PE9TXClMx21MchMp3Ke8Gn
HfO2IP5WRU5rnmlQrwWRNwtBVarB/C2IV6W4xP2YBvUb6mNVxz0EGuTBJUTx
eVi3Qo1+uCR0JD/H7Rs18uES/+QppbOHGv1xidxtzZOGfhXy4pIzSfEl6/NU
6JdH+MeybzsGqJAfj7RtjlJpFpXon0ckuTVZ3jIlNckb4RFxzNXzwWFKPJ+W
JPtQBLgIlNSEN8qSbGVCff+qb8Pzatg/McUbT2yjS58TS0Kqhyceu7Th+bUi
0vws1vdGK/I3PO8SVLqtbMXzbEUcs4bts+Ie0qXPnWG/75f4WFUL8rAm0pZt
X6o9WpCHNeGkq5NuZzcjD2si9lsx4zbWhDwM9WUJnk77m5CHDZF+8CS5sKwR
edgQssnz9Zs2jcjDsJ8By4MiGpCHDQl1KrySKlcgD1sir5qq9XtLQf8H4clD
nQ==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUxy8FWiRz4mRSDWqFsYFZtM7NQRicb2QytlWUR1hMcOCjFefi
an1kPlczCUvcFMcMZUZWZbpBtEGHGTrD1wmovKQtfVH6uAVUEOQlL4XWtfX0
JDc3373fPef///++3OVbv80UcxiGEXsu791fg6WrJO1fs7R2aeFARm05yFVj
dsUm/1oF8TP72Cc5LA01VUiTQv+BfftmT+3c6n9fB/z9V7JLD7P0/TXeqge2
e8Wergv+/fegIPHPhiI9S7sPhas+dTaDlbl9UDLHid8/gOyhuzfEAU6a5vRu
0MJsc8nPsml/vw5g5tf/XTLE0mXe7UsNENv0jaq9x9/fBNYZueldM0snY3NP
35kwA9OavPlai3+eBYRFNGVbHUtbfWUFxdKS/LRqv347iGp2iSUevZm+Byxk
LzAa75xhUY8TZl93zd92nKXJvoHdMOveLxJJ/fp6ILsy/OwPX7E0zjs+thdO
8Bv1c0V+vQ9h3L2zfTiepW96mh0KfwRWcd1bK2P8+h+D8mxCRlsYS1/R6ANl
Vt/miikH+ukD/tPFT4+1OuhghldgP4w4BfIPlA709wSkOhWvXeagRl8cAxA7
0LU26xMH+h0E/jzniaZwB/WI8zR8Cvli3cqEXjv6H4LpI5kJldft1CdPNQy1
G5JlArkd8xgBZXmG7JLIjv1GIIRfX57Mt2M+ozAyblox1m3D/qMgvLp70d0r
NsxrDGKL5Mnq/TacNwZKRxl5lGTD/J4Bv7bBtS7YhvOfgbre7e5osWKe48A8
O/zg/Bkr/cNrr2Ic5Bvm7Porx4r5ToBCrL0yvdhKfyvz1gSoc8+llti7MO9J
YP5l7h250EVP+wROArGUld3c1oX5T8FI2vKQ9Jgu6mtXOAUh0acSkx9ZkMc0
pF2KSTp12UIPe+M+NA2aiBNTH0ssyGcahCnnP9wcY6F7vPKkz4G5WHO1p6cT
eT2HvsL1Q+YLnXSHxFsvQJi1YC/J60R+LyBs2a1zSyI7qc9u7gwo2kyqvWYz
8pyB/MkblnW/mpHHLBTfjlxbusGMPGZB8Vq5UBJqRh4uUCfKDHUNJuThAsVn
lwp+P2ZCHm7oi8mvCo03IQ83bBy2pQaOGpHHS4htDDOdrDQij5cgHSLOy1uM
mCdDqn+83JmzyIh6GKIcdUWVawyYL0OKQyLmfV9kQH2e9ck8x0ySAfMOINKq
gsaF43rUG0DUMzt6tJV6zD+AEKZGtCpPj/o9+3M/4q4O1yMPDikedHE773eg
Hw4JM8ji4452IB8Okda5D0Sv7kB/HKJJ//KXpl4d8uIQNqJ//RKFDv0GEiWT
sEXwhQ75BZL87Snf6V1a9B9I2AntmsRqLfXJGwgkmuO2uJytWjyfQSTstvnh
2+Fa6sMrCSKCKF6/qlGD5zWICAUtVcMHNPTV7ySIbDw4pnjyjgbPbzBRpzLC
lGvtyN+zTn/MjXujHc9zMBFER+b+JHtAX/3ugkn+e3ENu3VtyINL2MCoet3q
NuTBJWrdsrZbxa3Ig0uUtpupccMtyINLBP8dLBSsb0EePCLgiDQXq5qRB4/I
DYN513nNyINH2E0ZeRnbm5AHj6g/nzt4XH0feYQQ5dEbC1Mj79P/AVJfSCE=

     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMk2cUhku5ytDUwUwxXIqGrbtgILoAbnA+FpnVgSIbipNph4AwF9cx
FAWtZWpkww3dnIAoclEC4ogwM5VsfA3zgqDS0tKW3vgLeOEyoXKxE8G19fQk
TXP6fz3nfd/nyx+U+k1iOpvFYqVbP7ZvR2maD4Z2fcXQawFHRjZcq4C/3Jfc
KN3s6BtByrtxc3gjQz3VNaIoz6vAay3MyUp1PG8F4eKylSX5DF2x3Fb/gJd/
xSZdleP8beDpbjccVTK0P8+ncbWpA/QnY1ZlzDPh/+9DXcUWSbqTiQpMtgNy
OL4kMjnb4pinAFFBnvjXJwwNtB0P6IHSS+H7ugYc89Xg8puw+j0NQ6f5KcVt
UxqoE6zgN3U69mkh4mXn/O2tDL1rLz2cOXX1XcFlh34jfBZQH5ph1Zto/4GB
w+tCqttOMKjHBFeGdhlSCxgabV/YD14Rztw4kUPfAAjH/hYe2srQt23r+YOQ
81pR5fw4h94H4BUWXz4WwdA3rMPyfB7C+RQ6HhLs0P8IPDqS/e9xGPqKxmPQ
cNKmq5/1oZ/HkNmmPCK+20dHN9gEDgFX4uv7fmUf+hsGpvth5f3sPqqyxzEC
GvWnssRVfeh3FERbywLu+PRRqzjrwH9BIu5sjxg0ov8nwPx5TFHXbKR2eY1j
YDFf9+JJjJjHOIwPLJh/Ic6I88aBLGuLjOYaMR8zHJ/j3jL3G3C+GaSt5is3
Lxkwr6fAaYzV0t0G3Gft/ar0D6IMmN8EyJwXnI51NeD+CZB6/Viu6NRjnpNw
mbdm59kTenreZq9mElgfcT3qNuox3ymQTQattSzW09NltpqCvVtCBn8x6jDv
abg2qUjbX6WjxXaB01C4qDH8+nYd5v8MuKv31MYH66h93JFn4HFuqTbqoRZ5
WCBh04zup1otzbfFnWcBS3PZqZgMLfKxQPLup6qUYC391iZP9B+E+q6JHxjo
RV7Wfoj3s6aql+7IsNVzEAmCvcm2XuT3HIQCzw/9/Xqp3W7KDFg60td/p9Eg
zxng7CjIjz2pQR4vIPSDYPWp9Rrk8QIkywfk6Z4a5DELoTUTe1pvqJHHLHB+
SPU8J1YjjzngyJPjPCPUyGMOMs8sHGKbVcjjJSS4HdxXVK9CHi+hMGnoUO2X
KsyTRcbrCvdv9FWhHhap/Nz31llZD+bLIpK1O5vFR3tQn/V5+Oj3M1E9mLcT
YRJCshZNKlGvE+G+k3ZUXq/E/J1IxMePxpdtU6J+J8JZW3sx1EeJPNhExKlo
0LQr0A+b7KUCA/+AAvmwSebcPL+lYQr0xyalOSXhdwa7kRebcP/4YsKvtBv9
OhNOlcmN90k38nMmyWcCApSzcvTvTHhJpt6Vl+XULm/Eer48UJaUKsf76UIY
XvyxN33k1I43w4VIMn4vbrwpw/vqQjiq6g1je2T01evEhciWz8DwWzK8v65E
aM4WxzR1IX9XUrm5JYn/ehfeZ1dCWtY1FGXfp69ed65EKm7x3tV9D3m4EUnk
Qu/usHvIw40wQV/7txy/izzcSGVOagl/rBN5uBGh6oAqML4TebgTafvFoOqL
HcjD2h++0NTk3oE8rD1/e1NC2h3k4U5YubnRBdJ25OFBpCQ3K9avnf4PN/s5
6w==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lHtQVGUYxpdlucikIq0N1IaQMUJKrQXKMMH7MQMDBiK3kWQodQvQRgqo
gMFy1oTEPxJESMLKRU0uBpE0tmXjtyHk5nLZhd3lAHs5XEQUkkUQkGu7y7vv
zJkz53zfed/neX7fHG/RJwlpXA6Hk2a+LHdbJXV0LXR+xFKpZ9F4vPRHOFaU
WFd5wPbcCJzm568/2s9Sl94rWSEuvwPrvjnlqMi2fhvKm4u8LhxnacBblroD
AWGbQgeqbfvvQu2hsbLTapYOFfAbIwfvAd/v7ob0dYP4fSfs2Gd6J81ukEYN
WjaogF9geCVn3tavB3RTO/ecf8zSLZbtnhrglXLDu4Zt/Xuh8HWSuYNh6axv
aknLUwai2vymmxS2ef0QkMcwotssbbeWDkY26GYjm2z6DcAvHl1MM+tNsL5g
YeRMYWbLORb1DALTytaKTrI01DpwCATZpcPRWTZ9w8AEZOw49T5L/SzjfUfA
fSXu2PoYm977YBIJMyaDWLrZ3KyAPwpJibK//H1s+h+A10rew3ZXlq7RGIOx
DuPZy3NG9DMGksqznifajXQi3iLwIQhfdrsRIDGiv0cgVHsGd+YYqdYaxzhU
tiqOJoQb0e8ESBripXK+kZrFmRv+B1kXWkVBIwb0/xg4pn8ya28YqFVe4yRI
ywNrtogNmIcJJH7tNVdjDNjPBMKIv9Uh7gbMZwpYp5TDU0N67D8F7qrP4tp+
1mNeT0Cudsmln+tx3hMIerc2/36IHvObBhKbvCvCQY/zp0GatDmoR6HDPGeA
iX3B+YdzOnrVYu/KDEgDtv1Us1+H+T4F56KcB3Mv6mjVd5Z6CpIUerLMMIB5
z4LwjRruF9UDtMQqcBbiElo00g8GMP85EEcowvf6DFBru6I58BL8kR8y2o88
5kG8TlXwzbV+etwSd8E8eO39JTAsvR/5zENcbWRuqk8/zbbIy3oGshL9xNBw
H/J6BlHRM/5MdR/NSLfUAijf3t0MB/uQ3wKw2Sk6gaCPWu2mLoJJPj2ZwzDI
cxFYbYwgopxBHkuQ/6d//rf7GOSxBFnLVe+JXBjksQzF429yb7X2Io9lyNr6
WsXFE73IYwVcy+q0jkG9yGMF5CkTOasmLfJYBdn3I9ziOi3yWIUjl/qfu3JY
i3lyiPNXjg6JHlrUwyEyyauxVUoN5sshYj0v+PhpDerjkOI5vst8iAbztiNK
weik24wa9doR39GG9Z11aszfjshULbnbD6pRvx3J/5ov9OerkQeXiI2XhBp5
D/rhEinXeNjnyx7kwyXzFYGSLTt70J95PezArbaRbuTFJWPlN3M9KrvRrz0J
yus+I4juRn72ZCy8VqJcVqF/eyJv4KXublJRq7xxe8KK9fEJIhWeTx7x+vja
+q18FbXiTecR4exl1+ttSjyvPEJOBXaP5yrp2u+ERw5ptstGtynx/DoQsWLT
ieBfu5C/A5F8Wpnk7daF59mBkNuZdYU5nXTtd+dA2I2CTRndHcjDkciWbm5U
7OxAHo6E/Jbs0VzajjwcCZtbUeY9qUAe5nXdM6X7XgXycCKSI9kvXay/hzyc
CCdZWl/vdA95mNeld+r2fPgv8nAisrhtuwpkcuThTNiJvEOhAjn9HzSsQiQ=

     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUx0spLQIaIjUDUgE32RBJwMDGY+L5XJyPwaZgZmBzUh7SOFws
xjkFITVqbPYIENABc5MCOmET0aESVD7GRBnPAm0plLYXqMBEFJBHea+tpye5
ufnu/e45////9+VuSDgWfZjNYrEOmy7z3VqCEc+Gtq8ZWu1xYTSq+jfYV+Py
5HKsdV0BIbzLT0cOMNShu0Qc7nAfnCXrT4oSrO9rwSBp/fBSOkODAs31D1S/
jIjpkVn3P4XSXY1/XFAwdCCNX7GrvwnETlph0qp+/L4NBPPDVxJt+unufvOG
DuB3V50QG639usBpvaEw5yVDPc3bPZQQqfzpUuugtX835PGKa33VDJ3xOZhV
P60GV3XcjlvN1nm9sDGX2RRfy9AWS/WB0Ldq185Kq34dHK37MTLJpDfa8oCB
rZ6zj+pyGNTTDyPuHnPCswzdZhk4AAaHnwM/EVv1DULM3ffPnD3E0E3m8T4G
qNs49MAx0qr3GVQ5/HBvLISh60zN0vhDUJeqd/TztuofBoPsi5BmZ4a+oTEC
8hRfv6uzevQzAgznqwdpLXr6Isos8D8ImU/4bEuRHv09B9fn48qm43qqssQx
ClK2h93eHXr0+wKk776zv4GvpyZxpoZjEJPBXwoy6ND/S8jOy+Ndu6OjFnkV
r6BRJCECiQ7zGAdyL5fIInXYbxzU/nbfhLnqMJ8JKHJynxsb0GL/CRA/rhz+
+08t5jUJMVfrnR5+q8V5k+A6q1kzEK7F/F7DeDu3ZbudFue/BnsNaW1v7sM8
p0DuWHulIKePlprtlUyBRBQRWnqgD/OdBnGGS/qUex8tLDDXNEhPaPlZOg3m
PQPVHR9dOiXT0CyLwBmQTmpEdxM1mP8sOMcnqvZ4a6il3YVZEIbJV4UN9SIP
Izg/Ejl+f72XppvjTjMCK+BJQ3hyL/IxgvRLvV2sdy9NNcsTz4F9zUy6frAH
ec1B5a9ZDxWyHipKNtc8+KR8vn1rXA/ymwf74MUjboIearF7cAHUz9wyjqnV
yHMB8tcYb2zPUyOPRdinOMTJ3atGHosQs5FZjndQI48lyN9fVVLzuBt5LEFl
/PAHv2R2I49lqAsvPsUN6UYey8Diea1bGVchjxXI7ou+drFMhTxWQMg9d6s4
XoV5soiPbOT3aDcV6mERZhWZKJArMV8WEXrFatMuKlEfi0hLZDdnw5WYtw2R
1Jfnrp1SoF4bstul/HZrmQLzN63fmnHfHKdA/TZk/ESmwo+vQB5s4swhSkVj
F/phk1NjVVzvjC7kwyZCFfnYc0sX+mOTGFGBsMHQibzYxOi/WeCW34l+bUm+
a7q/IKIT+dmSG2fO75QvdaB/WyJezWcHV3ZQi7xRW+Jc6GmMSujA88kh2Z3u
VW/zO6gFbzKHBITtuV/eIMfzyiHy4NWnR0/K6ZvfCYcw2UGioffkeH7tiOS7
8y2ht9uRvx1hMlNKvNa243k2raOLjOeOt9E3vzvT/vibwuTOVuTBJazA63FN
W1qRB5dI2KVH7mS3IA/Te6dtg16vmpEHl5CJpQ2unzYjDx4pCpAfLSxvQh48
wtimLpbxmpAHjxCpcmF30r/Ig0dYp3Okp+sakYc9KaoM/Stc0Ej/B+wyOng=

     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lA1MU1cUxx+FAqJui2OI4BCGbEUI0cBm3VbONW4CEx0wNQxwlG9c5uhw
M4gfwRnC1DnAgApbWFFAQFTUbKIm3jJxw/JVoJTSQvsKCFVAKvKlCK4tpyd5
ebnv3XfO////3TyP+LSIJA7DMEnGy3S3lIQjym39lqV1btkj4XUlIHx7y+Wz
X1vWV0Hi+6hGv5ulDt0XRQKHW5AorYpOibe8vwcx79/xKDzE0gB/U90He28a
2FNq2f8fOA7rz2TLWdqf6Xg1SCeFDHG8T+ISHX7fCn9UH05JsNLRYJ1pQzuE
+UWBaNbSrxOEp39Pyn/K0jWm7W5d8F1dpLBlwNK/G3xLj51Yp2TpNC8m958p
JRzeuevNa02WeSrgLx2bFN5jabO5eiHrgnLF1lqLfg34rpOuTDTqjTA/YKEg
ascJST6LenQgn8ptEB5jaaB5YD/Mbln7OkRk0TcAy+Y0Qce+Yam3aTxvEPJW
1uQsDbXofQT6T7//eYzP0neMzTIdh6Agle328bLoH4bZroM2TW+xdJGGHmp5
FQ0lM1r0oweictqZ2aylo+EmgY+h9lz08HqxFv09geARXpo0XUsV5jhGQDJe
WLLjMy36HQXxAfVog6OWGsUZG45B8Nnl5wIGNej/KaS2tpaW3dBQs7yr45C3
5JXKNUuDeRjAMBemFodqsJ8Barfa2H/srMF8ngHPKbpgrL8P+z8DmcL/eH1N
H+Y1AaJ/cyrv/tSH8yZA4j9QrRP0YX7PQewSlrqZ24fzn4PBs3lvW1Mv5jkJ
Mv6pTUX5vbTMZO/iJLhHRSku7u7FfKfAfnmi86RLLy0uMtUUZOxPu/GbRo15
T4NymZN/Rqma5poFToPQz8D9K0GN+c+Ac2zdjyFeampulz0DWbeSKjcNqZDH
LLinCapPVKjoIVPcmbMgkaoTBckq5DMLYacDyiO9VPQHkzzRC2hcf8pVO9CD
vF5AHZMQIy/toSnJpnoJlcIU3SexPcjvJYQJQx1Wre6hZrsxc5AxcOndNKUS
ec5B1tH7IZsLlMjjFcgiUsrPfKlEHq+A2eYljnNQIo95cL/74ed3GrqRxzw4
l5Ypi492I48F4D8udrHldyOPBTDc/OrWgkGBPF4DcasPyqlSII/XoN/nE3Eh
ToF5MoRXL/0iYpUC9TDkfHp0QZGsC/NliDj+SlZmThfqYwg/zC98RtCFeVsR
UUraxhWTctRrRcjmil0tVXLM34ro93jTdbFy1G9FJHH6DF9HOfLgEIbHHpQ3
dqIfDlEqTl5ee6QT+XDIL06hT9w2dKI/Dkn9tYf7YLADeXGIQfpnvfP5DvRr
TYJve3a5butAftbEcFM42jbfjv6tCX+fZ+VHte3ULG/EmpAbcSXh8e14Pm2I
eGNu1HuO7dSMN9mGGI6M76l+IMPzakNEY4NrRg7I6OLvxIas3yZ4Y+gDGZ5f
LiEeMy6brrchfy5xPxk4sWZFG55nLmEedwQdT2+li787LmGvBNYmdbQgD1si
3Ft47eGGFuRhS5gIw+3rec3Iw5aQ8iF/9/Em5GHcb83Zv3J7E/KwI2TG715R
tRR52BHmb+8dVXZS5GFH3COHtwcnPkQexvWlOVWGpBF52BNh+hxXsLqR/g8f
uj0A
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lHtMk1cYxnsBChgZmzWpyLhkYzJdZlUweGHvacLNTRg6omgEURCdUawo
MtGZEocb/0DxjhpSBiPqkOGCl8SEU51uyLXlUj4obb9ys9y0yB0Kri1v3+TL
l9Nz+r7P8/xOPv+DJ3Ye4nE4nEPWx/Z2VM2nyj2NR1n61CdnaMfTIhAXnJZf
3+NYV4ClOuiyaRdL3dtLpKHuT2D8842Swwcd+9VwmpYJrp1jadAGW/0Douj1
AR3FjvP/AXPMLSunlaXdWcKKSGMtmIJME8luRvx/I1Tt/Xh9MtdIo4y2A2oQ
XvrgJp129GuBmvmd4oK3LPW1HfdpA+b2Z2saehz92yFp84G41QxLJwP35b+Y
YKBX9W1nRZ1jXifEXpyhSdUsrbdXF7z0mteFVzr068HvqqAn2ap3p/0HFmqu
/RGnLGBRjxGGVVx5UjZLv7EP7Abm/MPabVKHvh7oJb8ty05k6Ze28YG9kOKe
/sOS7Q69fWBO2xEzEsLS5dZmWcJ+MCcaS9YEOPS/AbNboarWk6WLNEwg7/NP
KJoyoB8TiCtVw2frDXR4h03gAAQGx8nECgP6GwTzUJJrbbqBauxxDIG4a2lI
TJgB/Q6D/NWVSy+FBmoVZ204ApV/uawL6tWj/7cgF7htLf1bT+3yKt5BVHlm
xkqZHvMwwxGJxxnFdj32M4MogV+ySaTHfEaB9b2zdqRbh/1HwXXgsc/zch3m
9R44I9vDnmXocN57INLBCGOoDvMbA05qoZPEWYfzx0B2bLdLU10X5jkOstR4
zc2CLlpqs1cyDpzoH0+V7OrCfCdAeqfq0ZhXF71VaKsJEJ3ixubptZj3JIgj
B1SZxVqabxc4CSFHnUqrkrWY/xR4Jixdti1AS+3tcqbAvGEuYlN/J/KYhni/
ZdtyyzrpOVvcWdNw99AoPzS1E/lMA1HmhsUHdNKTNnnSGYi/6/tM39OBvGYg
JGWjpaW4gx5OtdUsKOPOZm/Z34H8ZoHJvXNf5N1B7Xb3zUGsMbg6jWGQ5xwo
3+YNkqsM8rCAp/pExOXvGeRhAZVQtybRnUEe82DiZ6gev2xHHvPw0+ZjyTcu
tCOPBTDdGyrlhbQjjwU4kv61ZM6sQR4fILbqC/XFexrk8QHiH3triw5oME8O
kRdGtcSs0KAeDol6mup9XdWG+XKIYiLCNfPXNtTHIX4f7WbGQtswby65GxRY
7THeinq5hLG8076+14r5c0nSgFP4qv2tqN96vmjXQqCwFXnwCDNlXFDVtKAf
HhF5+Yv9f25BPjxifpCZtnJdC/rjEc+9t3Of9zYjL+t++XTY8pvN6JdPovKF
8aLvmpEfn5CEwbT6eTX65xPpvxGrN1SqqV3eEJ+Yb/j6xRxU4/10Ioock9ZH
qKZ2vKlORObRpy97pcL7al3fylS8OaOii58TJ2IePp7XvUqF99eZKGavea1/
2IT8nQlb4j0q+qQJ77MzUY6Mhp9Pb6SLnztnkiRRPEhsbkAeLkT21ZbyF+sa
kIcL4fRpH92X1yMPF6IoW7F2xbs65GHdX3LhuGd0HfIQEPbWxJPL92uRh4DI
ftka+bugFnkIiLI/MkKS8hp5WNcX/mw+qaxBHq5E5m2xBHvX0P8BIdg/xQ==

     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUx68FpLJFCZZYN4bFgSIuE1RcWYTzLXuAOgUfOMwglIeMidtA
N1AQIUXiVBxzgchkMhhiqCQElkWri3yIwiovb6G0tw+givIewniqILsth5M0
zen39Zz/+f/OvW7R3+07LGAY5jD/sXwvximpo3vrETNVumYP7VUWwXuVWRMK
v8W8EmID3nwjS2imDrrSRH+HWyBUrP9YWdmN5zWgityWeOTzbrp1iyXug2zw
k6sug114/x+oku1vbD3bRZ+kiioDHzfCTFPUdKZHF/6/FVTeie5b7nfSoMeW
C2oIunR67zNZJ9Zrh5DnOacvvzbRNZbrrh1QvLOwYsdvJqyvA/F1BffKz0Sn
PMNz6yY5SJy/ZVepM2I/A4gPNWyW/WCkzdYwgapaE+m00oj9u8C8rCfnQZWB
7rP+YAZh9Njt5D0G1PMYVMr5Xs9hPQ2wNnwCEsflIuM5PerrAUm8y0cX1+vp
Bkt7z6dAary+hXoO9T6DWpFf4Vg0R535YqmiXgg7GqgqZTjU3wfSutDJ0CId
XaDRD5mrY9cKt+twnn5gEo8F39Fr6fBei8ABKG/IPHU0RYvzDQLrkqtwddZS
rdWOISg4flXL/tmB8w6DtLHCJiukg/Li+IL/QpjkjrfviAbnHwEuWRXRd0FD
rfIqn4PnpTJNjH8H+jEK8XrvlPRwLdYbBTairF+VrkN/xqBYfirBr4TD+mOg
PKdOqmtY9Os/EL/T+vsXIwbsx+cbb7YMrzKhf+PA9Add8bfrxP7jUDwuL2xq
MqGfE+D4LpOQf8lEr1nGK52AExkX7YsPLu7DJHjnh+4YfctEr/xqiUk4kbOm
53yXEf2egpmBMzHflxhprlXgFIgdXLdVxxjR/2nwPll27VMPI7WWy56GkP1O
nG+vAXnMgFmj0GdfN9A0i92pM+AYJMzzizMgnxkoP+amOeBhoEkWeYkvQKmW
7jT26JHXC+D+Up9nS/T0qzhLvAThmcsrpJF65MfnwQFSZxc9tY4b/gokc1/u
SuA45PkKyLoPU/zzOOQxC/FDxW0/BXPIYxbE29e2RDhwyGMOqhKmkm4+0CGP
OWBPbrC7fFqHPF4DF/r0M4FUhzxew49rontejmqRxzxwE3nHsxRa5DEP8a71
6UVRWvSTIbLbXsl7VmtRD0OUbnKaz3agvwxhPyisSD67uH8MYf7uSRvn92nB
7yUkyDActXxCg3qXkPiNwxkPFRr0fwkJ2yQdWBepQf38/ZzaPzxFGuQhIMRF
Xsqq2nEeAWFtpzWS9HbkIyDSEfnKt33acT4BkWQY37/3tA15CUhV4DeDooI2
nNeGcJvuzq3a1Yb8bEhmXoOoeU6N89uQUfeD7OYqNbXKG+Lz6qiG3dFq3E9b
4j0ULncVqakVb5wtCdl3Ift6PYv7aktkwcGBfcksXXid2BKmPNn3yXoW99eO
1JYJv/apfoT87YiZfwbFTo9wn+1I5hn3/LRjrXThdcfnuT5zEW0tyGMpYWK8
Zu/5tCAPPt/qufTGz83IYykx+9dliJ83IQ/+3E1es2J3E/KwJ5KoA8t+udGI
POxJ5rbJghL7RuTBnysPFZDYh8iDzyucPZJqVchDSGTdd4N9XVT0f/ESNmY=

     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lH9Q03UYx7fBgOM6oED5kQqaBHHqgZKNC3w+eWeSoQ6u0yzMBYGKVsMf
MPDHdlcIyglaYaszBSF03UVgpuQffgZEAQPZYHz33S/YcBC/QUAhFGwbD8/d
bvfZPt/neb/fr+e+q1O+TErjcTicNPvH8b1UtiTRWFuGhdauyhtOrL0Grvcr
jDdjls5VkLBj/aTMw0I9deXiOM97IKw7/PKdqh78/wHIsyVb0hN6aPQmRzVA
Ey//SMBQN97/BySSEnlLfjftzfWr2m5tgVJbeePp0G58/iHMbr89uaHBTOOt
jgsa8FAog60iM/brBIF7e8K3CyYa7Li+qgsKUs05266asL8OfB4MV87EmOjT
8OTi+icsCP3nOhU6I84zQECmBzf5pJG2OssEwublG7x8jTi/G+RrQj9WVhto
kvMHC4hzNhUc22VAPVYQaN75Y+2Inm5xDuwFdZiwlzmvR32PQCn9xPt8mJ6+
4RgfbgM5czT27UYW9fZB5PpTh0dTWLrM3izXrx9mvz5/5TqHRf3/QoDx+4bE
azq6SGMACqIqJ1xidehnANT5d1be1TN0JNEhcBBId/2OQ9kM+hsCebQmO2gZ
QxlnHMMgL+ypaL3dhX5HQG4d1ZwVdlG7OHvDUSCC5wuRY1r0Pwa3ij3XPSrU
Uqe8qnG4de7O1tS4LsxjAlhfSf/pZAb7TYBSvnpf0xkd5vMYhLIIs6CMxf6P
odSzylb391Jek3Cor8t375gB500Cme/bOuJvwvymoHrjN5vj+GacPwWCWC+B
SmXCPKdBJmxzL7lsohUOe+XTIMq8WnF9z9I+PIGQ0Mr+8SAT/fEHRz0BTmGN
7EK3EfN+CqK1H3JPlBlpsVPgU4h8d6O2OtWI+c+AJWtu67ZQI3W2y5sBcfvN
rDf7DchjFthzUklepYGecsSdOwtK68pNMekG5DML6oqs4x+EGmimQ574P/B5
r23Q8EiPvOznwJ8j1GV6ejDdUXMgkyh+e+uAHvnNQbikiPVboadOu8nPoODZ
4HAGyyLPZ3DoCj8g7jsWeTwHSYbieNFuFnk8B0vKwS/2e7LIYx7kHdm+d//S
IY95CK/tr7xyVoc8FiCeax7gCnTIYwFYVUne3ASDPF5A5GaX5V8pGOTxAmR5
n4dc+5TBPDkkXv9S4K5ABvVwiOzCTykl6i7Ml0PEueO7svKX9o9DLOni4Cn7
Pi3mzSUB0hq+17QW9XJJ/L6B15oVWsyfSywnj1x8/YAW9XPJpZyI7eF+WuTB
IwFkTby6qRP98Ag71poTcqYT+fCIaENRbVBUJ/rjkVsVr2qVtg7kxSMFvdZi
P3kH+nUhpeq0cv/3O5CfC2FVN+6r5jXo34WI8tKyNlZrqFPesAsJaSk/ujNF
g/vpSiJ3a8JX+WmoE2+6K/EpiVpX2ajGfXUlQn7YWH+Wmi6+TlwJSZWarGFq
3F8+ESWduhdZ0478+cTyZ32R/yvtuM98ogzca8s99pAuvu74pNRcn7C/ow15
uJFSeWBCXVQb8nAjFumJPYpLrcjDjXCYDLX/uAp5uBFl9Dlv750q5OFOlGG/
f3T5lxbkYT/bfh0qdW9BHu7EUnBkCD5rRh7uhDDSbLGyCXl4EFGZ9Eb0iib6
P47sP7M=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAlQU1cUhh/IVoTqOCAWLIvWGaulosIQRvFcqS2UdmQVlVINqMEpUuLS
iij6BBEENNSxCzJKKAwdFmlwY1G8gaAglEZQQgghgFAR4g4qQZG+JMc78+bN
n3tzzn/+785zi0kI3WHKMMwO7tG/3y/+OuKT9LsMqp3TtCHV58H18+KiUdsG
1BUwWyhx2JkiBeuuQqGvdRW4OjqfMh+uw/0bwB87/bdAWgueK/VLBmzglroU
URWebwKSY7c/Muwy3E+yq/AfaAFmra4DZlbi//8FsmTuzMPxZRAwoD/QDuxS
v1vzy4qw3l1gq77/0uZ8Hrjojzt3ArP5CD9gexbW7wJGGuKUFbOKvlocJWp4
qQTG94hf+dGT1NhPBeyHh9Q/+p+j/xiWGtj1os/2MMXU2F8DJLbPduPPF2io
4Yd+YFP75manXKRGPwMgPeZn4hFxla4xNLwPYgEcGPGqpUZ/g8Dedv42w+0G
/VTffvEQ8FfFrYi3qadGv/+BpNFmvsJWRu25Ykl2D4CMzREN2d2kRv/DIB6x
lye7NVEjjYcgzfyo6/jK2zjPQ2BXKPYNBbbSRyF6gyNAEtz5B2PbcL5RYEIS
gjxOyKnCEIcWmtsSzca77uC8j0DIX1Yje9xOOXNcwcfAzrKU68zv4vxPYNNU
mDbD9R412Kt4CsojMkmMbyfm8Qz4wXTDoSgF1nsGbNe5203JXZjPcwg+qlzP
K1Bi/eewSZS5sf5WN+b1AmZLetMjnqiw3wuo7rCv1jqoMb8xmJfc07HavBf7
j4HkWO69llY15jkOmw6fLTrzi5oW6ccrHAfh9rK1+RFqzPcl5Fx+lfrUUU3P
5urXS7DK/MI5U9ODeb8CZuvS/L0FPVRkMMjplK/2SLb1YP6vgfkpaGDdoh5q
KJf2GjK+8bX3eqBCHhOQyNvgkFasogf1cSdNgFXyyg6eQIV8JiBA2TonfJGK
7tbbE+ogmEafUA12Iy8dPExKbJEXdNNYgX5NQvOua0HeW7uR3ySwBZpEu/nd
1DBu1BtgdPuzf1AqkecbyLFor159Rok83kLGSKXdqSAl8ngLifw0296n73lM
wbwdPU7Wf3Yijyno37l8iXf4XeTxDnjx6bztFu3I4x0wg7UnF+xuQx7TcGdU
UHqosxl5TEPw2JwmhU8j5skQ8XhyU/Rqin4Ywny9Qq4YrMV8uX1xXGp+ZA36
YwiZKPLe2V6FeZsQcZhG6xFwFf2aEKbEQay7cRnzNyFSJiS8wesS+jchZEum
VVZ5JfIwJexV2fWwhRKch9MfTw7wPC8gH1PC3NwV2OJWivNxOqnv4nez/kJe
nF4Y6vT4bSHOO4OwmsbUw6Ni5DeDMPMSlC6SPJyf0wnhJX5Zv1KDPS2nIzSi
TyJ+w/tpRpi4vVciS/KoAa+A05aKnHW5YryvnG48vRwOFFLj54TT62e7TO8r
xvtrTljr9D/6s0uQvzlhHNdO+9SX433m9Dah3P0DCTV+7rjzsY3X/aWVyMOC
SKN9sm2OX0IeFoSNvC45G3kFeXA638zHdk0V8uC0WkcPetQgD0vCunvyJ5df
Qx6cXlBXmutXhzwsCclbViCIociD2zcr3nylWYo8rIirmUV/53A9/R9Z6Ri9

     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lA1Mk1cUhj8QCsKMbGBQN6H1Z8NFMxmSDSaeCw7tzBYpMlDDBkOQidNV
x4xWSIoLRJkgbk7ERtICgYGAMBDQKfdDVGCAwrD2FwRxFAHlT2pRkH1tjydp
mre9Pec973P7CWJ+DI2zZRgmjnuZ39/UOs3cwmPZjVDnkTosqssFpqDeOLzg
JupyqJB5J+49zoKTKl8c4FQLTMqD7Y6GG/h9PfROf560l70G633M1QjR++Zn
pJ6uxfNNwHed3PzN9mp4JHEr39L3DzCxAkWQcyX+/i4QvwjFL/svgbDPfKAT
pLMFYcsvFWC/LmDinm1zz5WBp/m4hxIYY89X38b+iv1VwLCPy/+N+owavSJP
35xSA5N5suRcSga1ztOClJS8H7vlIm2zlB6IQKf/gSmk1vk9wCQfaBEdLqOh
lg96gWn8QnLy+F/U6qcPotd8mbA2vIZutAx8BHLnR4YB32vU6q8fGJWITRXU
09Xm8V6PIeTJltF9bzVQq9//QOxQpLu/oJEu4ppJ3AZA/DBW1O92m1r9GyAr
bMnZJEETtdIYBLFnc26qTwvuMwi9aauhf2srHRGZDT4BF57nWkl8O+43BNI8
k8dHJ+/RB5Y4hkHokrZ/UtWB+45AhzFlRePTTsqZ4xo+BccrMv9p+y7c/xl0
JHyw4wT/PrXYKx8FYbEhLypAiXmMgXz8UPDRyAfYbwwGEw01t5JVmM84mHLq
/XwVauw/DkThSurvaDCvCWB9XQ5sf6bFeROwY5NJNuiux/wmQTiX/r2ffTfO
n4Re59t7m1r1mOdzOOEf5HfmjJ4WmNfLfw7i7HtKWbge852C86XZ7iNL9fRC
jrk4XfBdZVqPDvM2AmvT5C1W6Ohpi0EjLF4ebVe2W4f5v4AjWYZDgat01NIu
9QVkJYQVeg9okYcJTowMF6UUaukxc9wSTkdtjfHdo0U+JhCm784LWaWlB832
xNPgNSRZrOrXIK9pkLa77mxTaGj8HnO9BKlM0+0TpUF+L8ExXsp7+z0Ntawb
+Qo63HKXxKvVyPMVZAUkBfudVSOPGeDb9cvTt6mRxwyEHGnSqUff8JiF6ORl
Q/Z5SuQxy/1ffzJ9HNaFPF7Dp6ktvGheJ/J4Dew78OHSg+3IYw5c3h3enKhs
Rh5zIF2Rvfuu3y3MkyG94WmMaANFPwzhX/J3vNN/DfNliNw28XrmrqvojyHR
4WXiiM5azNuG8KsGVvKFNejXhkgd+ZrB+mrM34awsTszKn2r0D+n634LlJRW
Ig9bwixqmwpaUYH7cFrpFOa+vgz5cDoj+fqfghLcj9Nrxlb6LyxCXpx+GJPR
OpOP+84j0ovKqcghOfKbR5jfs67rL8twf04//TljLv0ParE3zGmvTK1H+Dm8
n3aEqXK2+bpYRi1499gRadl0TWCOHO8rp5smIzYczafWxwmnu84FzyQW4v21
J9LLy2j3qWLkz+mG+6s+aSjF+2xPmOCKmDXzK6j1ccdp48S2zWwl8uARaWSI
p3NaFfLg9OGaTTm7riAPHmHPdLc6b6xFHjzCCMtDJeuuIg8Hwl5omDB5/408
HAh5Igg4H3QDeXD6eYJPXAxFHpw2ludVN7PIw5Gwp156KQ0N9H9AVSMJ
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUxy8OWpER6/AxHzhwEpmbSwmQSUTOrXHCHBkVGZkdjw4mZc4N
XJhhoKzI2xf1iYojvNKIOIJSoWPBrwii0zEglNKWxypIqatAkTeK7rb3+CVN
8+/9es7//H/f/dxjEkL3L6Ioaj/zsX6/WdIfiTG1oAmU67PMe5RFYHmpCxpx
vou6CqSKmvYDx1SwpLsscfuSOjCU5q92Gm7A53fATTATdFBVDz7e1tUEhhxF
RG5+He6/D+KUjpXivQoYSFleFfj4IYgjP0v41Okm/v8foJ8VfJL3QyUEPbZu
6ADpd9zBTZXlWK8TpFFpog1FhfCedfv6LqCU/tuSvj2B9buBkl7fsSZyG5n2
jMi/O6UF6psL76SnnyJsPz1I39cl7gv8jfxtW71A7dp0SkLJCdu/H6ihhczg
w7+TUNsPBlB5Kfqyj90irJ/HYHj1Zefm8FoSYGs4AOLuzPAnvvWE9TcIBk6W
T4b7HfKBtb3nE+Bf23jjwNuNhPU7BAaRoLDTuYmsYIqlLDcCv6fWZWD5PcL6
HwZh67p9qe73CUvDBMWqw3GZ3n/hPCZINB5xHNj9iDzbYzX4FIRy3nyypBXn
+w/aX6ePbslrIxpbHGYwfXVO87y7Hed9Bqqz6lN3RzoIY44pOAKe0Xz5rEMn
zj8Ks//ON+e4qYnNXtUY8IqmedHbuzAPC1Af1iuSIzRYzwKe1bGbmo92Yz7j
QF06WOlTosX643Btg+VWQ4sO83oO/IVVA6Gjeuz3HHJXeC4zrerF/CYgd7fa
3s+hD/tPwNYwIef+o17McxJ48Us1sjO9pNw6XtkkCPP6fyoM78V8p6DY36Qw
r+klVy5b1xQIyya+yO7vwbynQeh/pS2hpIfk2wxOAy8qqfRGbA/mPwPFp/2X
CTx6iK1c1gw8MD7d6WXUI49Z0BY17kqX60mqNe6UWfCcj7bzjdMjn1lwa1AK
hB56cshqL3EOVOKlSs2gDnnNQTV/ePZRiY5I4qxrHoJk5qPe0TrkNw9CWbuc
t05HbONGvACey0f1cVot8nwB4qpA49bzWuTxEqgMs+B4iBZ5vASLzPG6euwN
jwVYfCFaaVfahTwWwHTpdsvHYZ3I4xVYrjp1fc3pQB6vwCBoall2qBV5vAb+
5wmD33c9QB6voT10LdXi14x5UrRYedqP9ifoh6JproZa6VCL+VI0xY9IOl9Y
gf4YHep1daLmJOZtR1Nrc4J9My7i+87olTEbtkQVAJs/o8Ux7iGu54H1z+ge
tUh2UwYsj0U0tTFt/2Xv48DOw+jrismHFceA5cPo+BEJN+dnvF8YLUtcMzm5
F1hejM61tx8vjMd536Ip+si5yqg05Mdo+3c1kqu5OD+jB892O289Q2z2zIx2
CfBYHX4Rz6c9TXHLg0MqCokNbxyjRa59AZeL8bza09LGsDS/X8oIe50wOtL1
4FySHM+vA02FKYb0JyuQP6Mj44N9Gm/geXagVW6Wqc2O1YS97hid5z64U3UT
eXCY/ZJbjtk1yIND02erNQWi28iD0b/WRi0JqEMeHFpVHTOUzP8DeXBpyi4k
a8brTzw/XJq+nd12cUcDvg/Mc5H8XmwMwfPEpcXGOnPNAxW+H4tpscvYIfVw
I/kfca4XMg==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMk1cUxz/RCjLMWIbTuRUhDnFqsiqy4QaeO5cMH1koSCUhzDGQR2DE
gi+kTjpmFZ0LJSC18rBdCRsRmSjTWoe3iiCOx3AIlFJZgQEqaKu1PBRkX/sd
b9I0/3635/zP/3e/6xu3OyLBhWGYBPbj+H69pHOz6w4p6kHrLRsN15aBYMbX
zbbwJupqEG5aIxHn6MG9WyMOcb8CsX8uEr0zUofPrwMpOLH/gF4H6wMcqx7I
I9GRgrwruP82SAUeG1O318JAlld1aP9fwAxalcI3avD/bcCIecqzaedgc79j
w10gKWsjN54rx3odwJDgb8PKimGZY7t3JzAJwafbdv2E9buBMdcuvxX+GR1f
GZN3024A5sub7it++Jly/YwgLSrVrw4tpS3OZQL9UlWZkKmgXP8+kK6wZgfu
P08jnD+YwWdgJEySc5FyfvrBPLT102U7LtONzoYDENsYetEQqKOcv0GQ+vvL
Dvhepx862q/8D0iqpW2Xxw3K+R0CsU2ubV1YTxexxbK8hkG8XLHa5NVAOf8j
IH/3TOo+39uUo/EArNrSPYcD7uA8D0AQF/2WaWszHQt3GHwIYlXNdEZSK873
CMTZtlH/43/TLmccoxA7pPvH0t2O846BMDP9GH18l7Lm2IKPQbxyS6md14Hz
PwGtV9HVIz73qNNetQWsCl72zpBOzMMKwqQ5H2TGdGE9KzDWfxX133djPk/B
U7mUv15twPpPYcmvLX51jT2Y1zNgmpbtiHhixH7P4MKjqKMji02Ynw2Ep/jq
IN597G+D30p6f2lsNmGez0F7ypQhzzfRcsd4mudgljx+s3iHCfO1g6E5KGJ0
qYmeUToWq9WyMVlfL+Y9DvL9aWm71b00z2lwHHKVuaQqvhfznwD5yfzfiV8v
dZaTTYBnfPagYNiIPCbBLFQMSSuMVOKIO2sSyKl9qvWJRuQzCSrLwv4wPyNN
d9gTT8Hmbk1U12AP8poCbYHudLO6hyYlOtYLEMhm+AHf9CC/FyC96hPq+X4P
dY4b8xIMnrroRIMBeb6EZO+3jwUVGpDHNLjNeT5wPMyAPKbBp3JbZrvlNY8Z
EFepj86oO5HHDDA1E4WrIjuQxyvQ1n6liZp/F3m8Anl6aPyC9FbkMQvWg7bs
+M4m5DEL8pyzJXUbbmGeDCGLFBkfBVP0wxBzQt8GHu8y5ss+t3w3nFFcif4Y
wmzZuyvt0knMew5hShOSM38swved1apt4+t2KoDLn9UiuTWSXwicf1bbr/kV
1ciB4+FCGHGJrTzgBHDzsLrNLumqzAGOD6sNX6R4H9uH9wurhTOTYfbtwPFi
tflr//riZJx3LmGS15wv3HkY+bHaLEqMKcnF+Vk9/Z6vW1A+ddobZfWd2T39
oiI8n/PY/YXKxZXF1Ik3cR6Rdgy7LFeq8Lyy+ohGwz+oodx1wmoP3/z7eyvw
/PKItF3hTk9WIn8eYe6Fpy+5UYXnmUdIY6Ybf8EFyl137P6GFvvH+hrkMZ8Q
/ecNL2WXkMd8otfdeng8+g/kwepZj4zpkCvIg9XgMpUiuIo8XAkpCFY+XHsN
z48rkUoaBnM31eH74Er0U58YRXEUz5MrUQWuGq9q0uP74UZU604cah25Qf8H
UFkhyg==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQU0cUhq8RiMai0YlTxQeXtlJBamMplTbqub4K1bYiakF8jEMRUcQG
ihZS0CuFSkUHbRUaUx06ETsZlQawhIJkAwgECBAehQ5qBynISzQKQRCR3uSe
7kwm82c3Z//zf7vrFvpV4H4BRVH7uY/t+/+R9fOaC4mZ5VC4OGVga+EVEMd+
FDLsXIY6ByyHbrZFJxlA1KaWrxbpgKbrXeb3lOC8HmjlqvUKQxG8720b5UAJ
p2zPSNfh+ipgtf3OR7bdgk6FJMfvQQ3sE8yP2DYjF/9fD2z8x+9mR10H/we2
BY1AyS50rr9+Fes1Ayuoiwy5ogJX2/LFfwH1RJXSFZaG9duAojbqZmyRkZGl
u9PLrH8Ddc4UIz55lvD7tQNVUity87tMTPZxD6h7A59vpq4Rfv9/gP3whEx6
7CYJtP/QAbR7YH5cUh7h/TwA5ux29cIvCsga+4ad0BHZT7f6FBHe379g8A0Z
i3XTEw/b9ku7gHYxpX35Winh/XZDgO+yOJNzOZnLFVNIHoJ0Zt9gu6SC8P57
gE2+LI11qyI8jV6wbPlUluhdjf30Altw8277plryaKvNYB9IV6qrow/UYX/9
oDUnFLv/0EBa7XEMwDwPo+xJmxn7fQTiWXee6gcbCWeOKzgIAXX3p1kdm7H/
xxCcdNA9mW4hdns5T4A2tZ5WerRgHhZg3uzWba5qxnoWkMcPdU2ENWM+TyGu
YcocraAZ6z8F7RIxhGY1YV7PQJyw+LBkTRPu9wxSG72UlXcbMb8hYN+WVcbF
N+L+QyA+/smQ5+uNmOcwRLQE0fdvmclVW3vqYfD3DP8sPdCM+VpBLugbTupo
IJeUtmEFcY7jlp4FDZj3CGh3vqHZHFRP0u0GR8DiBFO1P9Zh/s+BvrVrj6Te
ROzlUp4DszdOFzfdhDxGYZ/o4uz7G2rJt7a4FaNgKMyNXMvWIJ9RoMLqK7KL
q0m0zZ58DLJmDbiKnhuR1xjQxULFkfeM5EC4bbwAacRbLU1RVciP05K1y1dq
Kom93d3jwJTuSVV1VSDPcRBHKTonXSuQx0vQzstcFbbrDvJ4CdI7+RnGjHLk
MQFyudni1VSGPCaAWji46bxzGfJ4BVrj9GyrfynyeAX0UffJnckG5DEJzLrv
8xJOEOQxCR1KEr5xpATzpBjD0KjLzKjb6Idi2PKHMcMOBZgvp7WJwVtVGvRH
MRTovHryzmDeUxhq0Ybk4u8y8L5zmvap8d2bCXz+nN6gJyGLLgDvn9NCtUWV
ew54HgKGMhed1HqfBr4fTj/8YGqnJgl4Ppw2XDrsc+oovi+cDkhru27dBjwv
TlsKNl1URWC/U7n5e5WJe48jP053/DQS8Esq9s/pOdmHBL7nid3eAKfzftff
3ZGB59OBoVa/0z1boyJ2vOEODBsj8qCVWXheOZ3sUOMSryb8c8Lpi7/p2mOv
4fl1ZNjY5Stun9Egf05/0505t/QGnmdHhvm1ULVgupbwzx2nd4yn+hhykYcT
Y7gdHPwiJR95ODFsqz4hNeQP5MHNP+52GF+tQx5ODKMpSDso/RN5CBlqonpZ
74piPD9ChvXzPHZqXQneB24+6OvD20MJnichwyzxhhtGA96PaYyh6HiFqaeU
/AeSwRBz
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQVFUYxy8oyENgRwkMFLWgpGmQBNJQ+E4+krKZBFQyiHZIxBkiFjQa
MPUOiqIIqBAPGWUbGBIwBkQF5XEu4AbyxkUXyGhXTVTe8lh25dHdvV9nZmfn
v+fsd/7f/3fOWRsS6RdqyDBMKP/Rff8/OrO8049lNkClQ8Kgb+VVELXuvT5l
UY+6BLhT690Px3NgpsiTeJlVgPSzM0r7gRqcr4U1T0asjnF3wd1NNxqAc77+
bnZqBa5vBLHD/b8l/jfhSZx1yU5VMzCz5ON95mX4/3Zgnc/IiiKKwUelW9AF
bOG05PPifKwnB1YVFBN6NQdW65Y7PASmTROtPZCE9RXAKM12+X+5mU6vC0qt
n+oBZn9Pn5ZNpsJ+fcBkaffY7LxCW/XjMXCLNi3sYAqosH8/cHmW6g9i/qB+
+h+UwKZW28TE36CCHxUwQcFL7fbdpt76DZ8A8UhOlXvcpYK/pyANS46IXltL
nXXbr3sGrOKaT8jSOir4/ReU52QbWywa6Ft8sTjr50DMN5f2Wsuo4H8AlLPS
qei1jVSg8QLIuNbwF7f72M8LYG0NCnq/aKFDvjqDL8FVkZ4hCWvD/l5Bp6tx
ktPZDvpIH8cgcJKH+SOKTux3CC4U2QTVDndR3hxfcBjEP0cfmTSSY/8jkKje
knZyTTfV2ysZBdGzFft/de7GPMag0vP90zsb5VhvDEwuepRrDsgxn3FgBrYp
iw3lWH8c1nj5WQRLH2Ber0GUJvYUeT/A/V5D08sfw+r/6sL8JiCLHEs/EtuF
+0+AOCOp7j3bLsxzEjYNZY/03Oyk+br28iZBtPWafZJfJ+Y7Ba4bIi7GKTvo
5WzdmIKxx2cH++07MO9pUCYW7NgW0E5T9QanodOtIff3S22YvxqUqn805u2t
VF8uQQ2ilFl/iWkr8pgBkefbJd3bW+hRXdxxM8A89zD5hG1GPjPApvmFXKm6
T6N09iQaYEhktYG6CXlpQPoqyebghiYadlA3tFCadU3SHNGI/LQg3iZrdin8
k+rbDXoD7KjKMe2ZDHm+AfHl+ePq1TLkMQtiH/vewMB7yGMWuImNblxGA/KY
g925e5IdH9QjjzkY2xU1kGhRjzzmgVMnfzrsU4c8eJ1flON7ikMeC6CUpgyG
n6DIYwG4mcZc9+kazJMhrK/BnrkfqtEPQzin0eKni29jvvz84ZTm9TmF6I8h
zBbtpPjGeczbgDC/vSOdP5mB953XxcRbEpwJQv687iNel1alg+Cf11+Xx8jL
LoDAw5Awk55XVrufA6EfXt+L+tC3KB4EPrzOClMsT/wJ3xde7w7ocdL4g8BL
N2/l1JN9CPtdxM8bOuZ+exz58Xpl4FVVTiL2z+vwm1XNGy9Svb1BXqd8Z/po
bwaez8WEOSpzXVqYQ/V4Dy4m7AqXr1ZlS/G88vMJoWO2sXlUeE54befSrzhS
gOfXiLBWsoA75wuRvxFhlsXWLqu7jueZ1ydmXOxMS6nw3BkR8tJ5pTtXhjyM
CVcdOTiTUI48jAkzXml15ptbyMOYsP21mRqvCuRhTIhluMMh1zvIYwkh3wfU
Pv+oCs/PEsIsTzU5vbUG7wOvb5XM+4VQPE9LCGe7JbG4icP7YUKU2w9btg7U
0f8AIaMbKA==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAlMVFcUhi87WosUJbRV8ZlYy1IWrZU2Fs6jaMWlUMBWNAOijRRcEBfQ
YiOviO2UiIDsTCWDIAiyzLAOoDMPqUgJAlXLIqQZFgGFyiIgm9A7M8ebTCb/
3Dvn/Of/bu66wyc9j2gTQo7Qj+r77Yq1WTh6MbkWZOaXhzxk6cDs9nonV3IP
dSFIHn++PaS3Bpa2ZQY7Lq2AFkGW53sba3BfDuyu0xkDqTxs/lS1aqHl1l7d
mjU8nn8AXFPH3ofnFNATtrJwR3cDrQ9GEf1y/H8TiCsznvRHysG1W3Xgb1Am
LnUYdJdjvcfAJDxKct4mh7Wq4+b/AGe5ISbdV47124CpDjIqE8lhykIQc2+y
Hfy2vB6sH5Bjv6dAco/G/dF+FxrVqwv44RYt0ZM72P9fYAKsh6a7qsFT/YMS
2D6bJefHq9BPN3Crdh4MN60CJ3XDHuB0S9Jtv65Ef73ANlwvPxEpA0tVe4s+
4L4P8p5prkC/z4DYwbsnLCrAlBYLW9kPvJn7vt3R5eh/AJiOINBdKAMNjUEQ
b/VIm/2pDOcZBKbuy6+EpAyGPVQGnwP7bXOIVlwpzvcCmM79lyqsSqFVHccQ
8Ks/7p5tLMF5h4F3cnm4+lwJUHO04H/gF1YVFWxRgvO/BGVcuNseZTGo7RWO
ALvCeGhJejHmMQrcigM7DA4VYz2qf3W5nW1RjPmMgfJw4Au3CSnWHwPmQ9uz
x2qlmNc48KEjbscTpdhvHPyu2enUBUoxv1fA1KeHjYEU+78CwnzResxMinlO
gDjQ2Kl8RAJZqvEyJ4CJ7cr/rl6C+U4CM04qH4klkJaqWpPAjR0UVJ6XYN5T
QOKN7qS4SyBGbXAKmK2KUe2PJJj/ayCn38/4YKwI1OUuU22/M0QUX4Q8poHz
+rlBbl8EF1Rxh00D77FRUP2gEPnQfWlcZ+O+Qjilshc8A8TyuWiTsgB5zQDX
smW7nV8B/OivWrPAXlm4YtiWj/xmgSSfmtTflg/qcQVzQHznroVk30aec8DW
OLRnvMlDHvPALboHdLrmIY95IAWVI2d+y0Ueb4Cd2qOjkN1CHlQrbuqZdOUg
jwVgm3iTP0ezkQfVEbVjNlM3kcci8Bc6luUNZSEPqr1MTia0ZGKehOWMNtTv
yrqBfgjLJ2uFfuKfgfkSlqyai08zFaM/qmOXrx394TrmrcWS2ehIr5A09Ev1
OiuTUN9kzJ/q1qBlKWsS0D/VZ9OcO6SxyEObJb77ra03R+E8VL8sLhHkRSAf
qvvudlgJQ3A+qv36y3+Z8UJeVMsCXfNSAxSaeXVYElzsKPS5qNDwo1o71bZV
JFRo5qc63FHvvkOcQm1viGr+zERD41WF5n7qskTglGR8KUKhxutPtWy90vtZ
gEJzX6n2lqTEOgeA5jmhev2hSPMDEXh/9VgiTOppz7yK/KnuPSL+KzQR7zPV
v3PN2SIRaJ47lf5m0VkpRh76LBl8miQZz0Qe+iy3KcB2rV4O8qD7UZP3o83e
3he63xbhM29ZgDwMWLJcGPaZuQR5GLCczK3ueI4UeVDtZ2qSZf/2/TBgWcMu
n87KUuRhyPIlN3JNXMrhf3Nd7Ls=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lHtMk1cYxo8IOKHzjwkyl4AwISk6GSIbyS6+x4CMZAoB4uoclyoRmcoE
jSlTlMpACAIqjhFAWAeVAtIb14qsLWUDZLihOGEbkwKCIow7KFd32r6c5MuX
p9/p+z7v8zs5TkdOBR01I4QcZY/hvbomdqwcv5jTBCqH5JFAVSHwb9utlCt0
qGUQk7zgLRhoBKuu4phPrepAsYNzcOPORvyuBm16ZNlwrhY8dxlWE1CLcusm
ey3ubwFh2aHQBwIN9J+zkX3W1wb6ezrO5SE1/v93oMc9ml8kqcGvz7DhAZCs
yM2jAWqs1wk09POovT5q2GLY7vAn6KNS/IvC1Fi/C8jycL0qXw1z3JCrutlu
ENW08NqfqbHf3yA8LBj7sftnaDeuHtAO3thf+KgB+z8BUUCHy1LPXQgy/qAH
MtDvcX6qHv30AblL4xJt62G3sWE/EK6LZKfvHfQ3APRAqywmSQWuhvbcp0B4
2XTpjzr0Owj8exWDp7h1YMuKnbMZAuoV7OifUYv+n4G2M2zecqUGTDSeA92a
snf52xqc5znwWzb1ppEaGA00GBwGrY3c3Px6Nc73AkS6YvP6bdXw2BjHCPDr
9hxYbq/CeUdBm/SD5xZBFTBzrOB/QPfJB09zq3D+MdC/l1Dgr68Eoz3ZOPAz
v3PjFFZiHhPguFiWsP5wJdabAH5qV3cptxLzmQT9oOTNwBkl1p8EvlV8RnST
EvOaAkczRdg32UrsNwUi61/Wt36txPymwfFkZNw0KLH/NJDFa79F2ykxzxlw
jAjerhpXgNgwXvEM6F0jsnitCsx3FrRfOOU8EikgL9ewZkH4MnrX3TgF5j0H
tOKr9LwABVw1GpwDYXxevbmLAvN/CaQxiWs/KQdjueSXQJ3IZOENOfJ4BVqn
DR/r3OVw3hD3Oaalrjp1iwz5MD0n8OrgySDWYC9mHkggHftAL0Ve86AVX8j0
4EvhWKRhLYDwpvy+dVcF8lsAemytm5VPBRjHDVkEbYm+Ka7kNvJcBOHbvWtu
LZcjjyUg4c5XnviVI48loOHvcgQpZchjGUiqdLNOVYo8mD4Ytsm2R4I8VoC8
5ebQMlGCPFaAVu5+5T53C3m8BmGsaoN0RIw8XoP2oeRkTkcx5kkoyWhs3C8u
Qj+EUt74ifcjf8J82ffwpMsFtiL0x/SZweXZiALMew0lV6ShX57NQ79MF20c
Oh+Wg/kz3XHznwL779E/0+mXOL3Ka8jDjJJmwZ0PPdNwHqbJzEdR5YnIh+kG
m549qWdxPqYnzmT/Ox+MvJjmNp2Iz43SmOZdS4nfEV5s6EWNiR/TusfqtvxU
jWl+pvOb/TVe1zVGeyNMZ9U2+LRnakzn05ySfZfC0hITNUa8kUzz3dfQgSiN
6bwyHScWlHlHgek6YTrIoUF8KBHPrwUlScHvhIszkT/TJ3waOIJsPM9Mm4WP
DOfng+m6Y/r+JxkRehHysKTC7W3OD6eKkQfTCbwGaiFBHpaU/Po0WG63el6Y
tjo9Yr9NijzWUWF1wh5fBwXyWEdJiG/GBYkSeTC9wvmr2n31/mD7SzudR+9U
I483KA3Oi9nqXQv/A+7873E=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUx688Wh4BWSaMsAzK4rI6k8mA+cgi55ORCXEZCNvArbKyDWST
QIEAAhFvMupwqEiIMGBoBWQorxZk5VkvYCN0TmEoEALbbd0QLI+CPMQK3W05
O0nT/Hu/nvM//9+X6/11UnisFUVRsdzH/P1/DfZ0HzpT0gdtnlL90bYrIA70
WKyX96JuBLJvODDzcQ84jFZJDjoowUd85rjrez34XAU+ATEKfSkD/n7m6gMS
av2q+g0Gz98FRsrGPsq4DbqsHY2HtRqgUkIcf5pS4f/vA2W8o5zPVUGw1nxg
CGSRfcaFUBX2Gwbq974DIUEq8DIf93wE7NUpp5poFfYfBdly9ImuchWsCkUF
vStjwGbp1Q+eqHDeODA9p49UjXXDPUtNALsYUXrtYRfO/wsEqali00QnhFt+
YIGtKxblLHWgHy2QU/sKpa4dEGAZqANxdXGT/0ft6O8xkJilmtTcNthlHi/8
B8RPO4WmB0r0+y8wdh6qFKESXLlmWTumQOAaORN24Tf0/wTYgk9a7DdbYYvG
NNBDXQZTZivuMw2kwpB9gWqF2aNmgzMgVlws4hXewv2eguzinLTrnVswYolD
D8RPNGC614L7zgLTOFPundECnDmu4RzQvGqSJmzB/eeBNOXMhrHNYLHXuACC
1dVk5yvNmIcBmIfrSseYZuxnAEHOSV6dsBnzWQTZsSmfiGUF9l8E2jBQk9Sn
wLyWgM6VJEouK3DeEpCsKBfNdwrM7xnQ9u+mr4AC5z8DMjbNJL2mwDyXQRBZ
7N6xIIdq83pVyyDrnsk41i/HfFeAtB9KG5HJoazUXCsgNmY7dJ+SY96rwKpr
Rb+EyqHAYnAVxG1puby35Jj/GtCvLDYJFpvA0k66BhRPmVBZ1IQ8ngOZvFqn
9mmCbHPcWZzmvynsvduIfDgN0UXDkY2QbLYnWQfmhxJygG1AXutAp98ZfV/c
ACfizPUCGLnYeftoPfLj9OHLcU5B9WBZV2QESqtezq6pQ55GIGlnd9du3EQe
L4HWPG/QBt9EHi+BccwXZv14A3lsAOXt7KNuq0UeG0Dr3d52n/gVeWwCFVa+
S2OoQR6cnmjf9Fu9jjxMQJ0scZHrq5GHCejPDn5fNliFeVKEsj/eGVZdiX44
7T0Z4xt3DfOlCH3DKVPmKkN/3PMvOieM31Rg3tsI5fjH3q/SytAvp1OK/Hzl
DZj/NkJfT2a/3d6G/jmtOR8RVcUgDysiZti9mwFq3MeKUB3+HtXjA8iH0815
GyHp93E/7vyniYa1vCHkZUUGQ911mpFh3NeaiD/uHa7YOYL8rIkkOEEtSRnD
/a0JE+Sm/JAZB4s9vTUhhKl1c57E+2lDBFw8M1/+DRa8cTZEpveOuMRn8b7a
kHjdSvie/SxsvU5sSBT/9XN/xrN4f23J/sD8/sxSFvlzOrN4aqeGxftsSwS9
3R3DL1jYet3Zkmn/Qs+zu7XIg0cMXpfmPhBpkQePBCc42q6c1yIPHnFxcwhS
dGuRB4/Ynd6TL5nXIg8+8Ump6vL10iEPPvl5yti5FqpDHnwSbydMvE3rkAef
yPtF7ecUOuRhR/IqraSf63TwH8yoBrM=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lHtMU3cUxy8FWoTEuWGj4IQ6RQrqBEFCgO38SBiQ/TGELUgmzqJSZXOO
6RRkAnfia4uLMB4ODKYIKiCP3vIoItSLxFGYCoznCOhtEXG8LO8OAdeWs5M0
zWl/95zv9/v55W46+F1YNI+iqGjDx/j9f8ka6/2TrzVCjcOF0dCaG5D6futx
Rv4Q+zKg8isLEwcbwLonP/YjayVIdoiq7dwb8H8V7LGbsNBls+DpYaxGkMW3
HWneyOL5JqBPtm94FvcAtAlry4I0LUCNeXX99lKFzz8FUUT29fnzKgjWGA+0
A+3FW9aHqHBeB4g8W/aHBajA0XjcoQu45o3h5V+pcH4PiPZJux5dV8GcOPLq
w9lekHROlP89rMJ9fcAGHYwo7a2Hx6bqBzpNrb7bWYf7nwFttVmxauA+hJl+
4IC66NR2eaoW9WhAUk+2pgpr4WPTQi1QecXREHgP9Q2C7FBmYtL5GnAxrhe/
ADId7WjdpkS9Q0C3enUmipUgNAxLWPsS2HuBDpG/VqP+YZCdkfKFy1WwQuMV
cP3BUTYJVejH0Md4rsqmqmAs1CjwH+B0f/i9l1aJ/kZAFB/6qdq1ErpNcYwC
pXIotHlSgX7HgAz4ZOyIqwCDOMPAcRDZKUJ/Eleg/wmgvOKE+zkFmOSVvQau
QqCwv6HAPHQgqgxdvT5KgfN0IHP2PaEUKzCfSaB4UcyBGQbnTwLNOvmebWQw
rymg1g8LEzMZ3DcFst3OLd0xDOY3DdTRLH8eYXD/NLB1brln1zGY5wzQ1laW
Ta/lUGC0lz8D3K7Ok1K1HPOdBVmaPnlQJoecbGPNApu2d3NLvBzzngPWnZ9S
FCKHqyaBc0B3VCttneSY/zywtYKdvpPlYBp3YR6o097m9enlyEMPJO+bCM6t
HH40xp2gBzpdNNLfVIZ8DP0cHTOxtwy+N8qL/RfI8V6XL7hS5GXobbd27JGU
whGpsRaAbR+3d+0pQX4LQJ5IUsQBJWCyG/kG2Fsjomu37yLPN0ALnKWNS8XI
YxFIIMwtBhcjj0Vg9YWJmZeKkMcSEG+/NK6mEHksAbucke7Rfwd5LAPZIJcN
6W4jj2Wg1IrkkLlbyOMtUIw658/RAuTxFtgMs6WqtnzMkyJsuDD8WMFN1GPo
u3Tmn0nzMF+K0IdHNtUJZaiPIpR4wsfjcC7mbUaoK8dkWadyUK+hZ841fC4v
xfzNCAmMuXPqnRrUb0ZkOVZKST6LPHiETo3M4cMj9MMj1C/yxJK+ZuTDI+Sc
RVTY6afoj0d0fts/WLzcjrwM5326bVu7O9CvOXHbTVve3NKN/MwJ5e46/8OJ
XvRvTiTbO18FsX1gkjdqTkQuSX32qwfwflqQ2C3ix+P7noMJr9SCqA/MJqUK
OLyvFiTCPSVppzcHK68TC0KYQ5V/HeXw/lqStvup02eyOeRvSWK3ffmuUwuH
99mSFNr4D3UscLDyurMka77uCr64TYM8+IS+lLXOL1KDPPhE90nXh7NXNMiD
T3qzf/+WqdcgDz6RdKdUxk5okIeAkCbV0C5HLfIQEEnY8xfzIVrkISD63M6s
B7QWeQiIOr1D8zOjRR5WZE1RQGm4Vgv/AZXr/l4=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQVGUUxy/PbRhAmGAE4rGWjCg50JiFM8T5csxMa3iGJSstCijVCIZg
osGlEC0xEFLkvQouBQvs8pAVcrkCBkIiBsLGCNxd4pGgsAjIa7W76+mbuXPn
v9+35/zP//fNXXcgOiDCkKKoCO7Rvf9fGcHf2dHZLSB3Pj3pLy8Eq1NZYTXS
ZtSVkBEUX5o0cgvM+otj3jOrB1Z7pvG1t27hvgL8BGrz2RwG3t6iWy1A+lyj
O50YPN8GzJ6A9erjTaBOsKn8UNUB/K8aei6NKfD/XcA333R+JUUBu1S6A/dB
uDWUXfVVYL0eEL3Y7hG8QwEuuuPOD4DwkmxrQhVYvx9EBarkO3kKWHATpDfP
K4H9tMl5cFyB/QaAbxBdJ1XehD/16yGwyedsqnp/x/5DQDRtU+aDjRCg/4EF
9vuBpXOzDehHBex+L8iybQAffUM10B2OR7bvvIH+RkC40BSXnCKHjbr2bv8A
tZjGs+iuR7+jIPyyREK71YMtVyzBZgyYgd3joeevo/9xYI8FM2uf18FLGhNA
mhPNLRPqcJ4J4EdZivOoOpjy1xn8F6g6cafNhVqc7xEw4XmdHZtqoU8fxySw
wdscLe/W4LxTQL/+84rH8RrgzHEFH4NwSiz5wa0G538Corvx4V+w1aC3VzkN
QveT846F1ZjHDIjyrux0CKvGejPA33iv6IZbNeajAVFKUW/YnAzra4Apjw1K
bJFhXrNArpa6Jl2UYT9Olzd2K6NkmN9ToC1CwZjIsP9TYAvOZiaulWGec8A3
3DPbPi2FEt14xXNAOvd9frhdivnOA71gFzoqkkJujm5x+mLEcue3Usx7Adhd
gYHlvlJI1xvktH1msq2rFPN/BsTg2HUfTRXoy51+BrRgOpHJqkIei0Af1LaP
eFbBSV3cCZx+bOfHtlUin0VgfA7d1uythKM6ezFLwGR6nNrLViCvJSCjXzsG
CSvgUKRuLQMZLgzZ3C9BfstAiWcb3XdIQD+uYAWYoXv+ueJy5LkCZH9X+h/a
MuSxCtS1V+2pj8qQxyrQxda5l8/8hjy0QDryS0fkvyIPTl/4pOSdh6XI4zkw
fk6SiRkx8uD02ObUgIVryOMFEGlpftdkCfLgtEP2sry7GPOkCOmU+kaXXEU/
FGFyh5b8Iq9gvhShC2JtmmxF6I8iFK/Vflt4AeZtQCjrtBP5cbnol9Oao75x
0grMn9PjwiOpa+To34DQUSkOUcUM8jAk/ANKrSXcxnkMCS14U1U7cAf5GBLG
n27dF9+F83H7ro8CqR/vIy9uf90vH/T09eC8RsTKyedd8fo+5GdEPO0m3E58
o8T5OW2b6fAxMwB6e5NGhLX2NnexHMT7aUz4FmNaTcgw6PFGGpOzf7eXZfBY
vK/GZDHVqszDi4WXnxNjIgyTDP91mMX7a0I8vS85J+SwyN+EKEecvF07WLzP
JsQqpHVN7zILLz933Pli+9hUdxXyMCUxC/nvewtUyMOU2G0o+mw+TYU8TInn
GxuyZTdVyMOUTGxVDsY8USEPHmH5A5ZbXNTIg0eolmaLRV818uARP6/kpiZa
jTx45PLB3WY/ydTI4xXiWZf6IFithv8AilYD+w==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw9lAtMU2cUxz8KtJMsiBukmxuCQYWpEXS6SRDON4NOBxsP3SSMmAKDMR0T
WYANM3ZlPDZE0TFxgJAqiIACLeVReXQX2OIklog8Q0Ruy+RhHS+hvGG35WQn
ubk5/b6e8z//38ndHHLGP0xACAnjH8P7/9AdGGeutYByU7LOT5kPl1/POl4t
a8a8HOxFPkXnB5vAoqcgyt2iFliXRdZ2dxOeq2DCst96OpuFve8aogWs7H6M
VduyeP8+cFt6dw7F/QHaeOvyDzWtQMUfPM4ZUuH/20Ca05CwmqSCIxrDhXag
s3XNxFeF9TqA/aaeBHqqwM5wfVMXUHjaWXNShfV7gGZ+tkudqwK9U1BG80wv
EPFgOjeswn59wIXEvFbV2wgPjfEEmEwvSWVnA/Z/Cqz1aUer/nrwN/7AAeN1
ySFjqg71aIBsdA7IsqkDD2NDLbCHLsUeOnwP9Q0CszoamZSkhHcM7Z3+AWma
Ynz9o1rU+wy4kg3JPznVgg1fLN56CNiaT2TBF2tQ/zAwzofjN65UwxqMESDR
VbVW8dU4zwhwbiMH80k1vPAzCBwFe7+UQPGVKpzvOXDOz7zV26ug22iHDpju
Y5et1Aqc9wVIfDUhe+IUwIvjC/4Lktu5ohQnBc4/BlK/WEUwVwlGeeXjwF0d
22+XX4l+TIB97GTC28GVWI/P3wpV1ztVoj+TIF3snw2dlmP9SWCvNEUyLXL0
awqIY8S+81fl2G8K6Ju+PX1fydG/l8Dc2uoupHLsz+ffc6mMWI5+TgP38uJA
67gMCg3jFUwDe1LjcepvGfo7A1yA64FhqQxysg0xA0zut+3q72Totx4koVKH
Mh8ZZBgF6oEERnqJt8rQ/1kgfpz7wckKMJZLngVKixZaMiuQxxxQuwzXYZcK
OGewO34OyEcbagbvlyMfPk/8ePPMiXI4a5AXNQ/kz5S2QK4Mec0Do1SEnZCU
wZfhhljg99vnukvPXeS3AGxa0vQuz7tgHDdokfenOjGv6A7yXARWGXPvwXIp
8lgCYjHiZnq0FHksAXMkviY3tQR5LAMrWW4cUhYjDz7fJqx2fXIbeawA+S2t
VjdRhDxWgBWXpH+qv4U8VoEtT8lv1xUiDz7P3jlX/6gA/SSU8fY+Gl14E/UQ
SiUPx4+F30B/+fPRJWGzjRT1EUoGsuc8vshDv00oybrjfzMmB/XyuXNwf5as
DP03oWxqwL5r65Wo34RK3UjC2QIWeQgot+d4sBj+wnkEVLKj2LOx7wHyEVDi
sOQYGtuG8wnoxKvFyWa/tCMvAZWt84/r6e7AeU2pxHwponRLN/IzpaxJUeAP
0b04vymdWPbx9mX7wChPx5/Pzbs7WPbjfppRoi9w1n8+AEa84WbUd4B8/auI
w301o73dnad37+dg7XNiRiMW5290RnC4v+Y04r1TmnPZHPLn88iY1W2tHO6z
OXWqud7RtcDB2ufOnJLtUe//vEODPIT0DeszQo8gDfIQ0gDJc9vZdA3yEFJm
3WiQolGDPIRUGmVZGD2mQR4iOhKW2LXXTos8RFTa19c576NFHiL6+5IwtYnR
Ig8RdWlwe3xBrkUer1BZliYvQKuF/wDyYgfL
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lHtMU2cYxg/lUq8LOHfJjLZKyKpErVMyh9Pn02nETTLELeMPzI6o0Lkw
K8QLl8y6IevwQtVElKnhom44BRQziWFwaLkLWKBQBMW2ouBQPKBAQS5r68ub
nJx853znfZ/n+X058yP2hO6ScBy3y3E575MlHBotP5xmQOG8Iz1bCi+C9U4P
VfXqaZ0LdXXOiWUpekwzZ6tXT7sN472UdVVxk++LwYc8Desy6LFiubMM0Mh2
RJZFGWh/JfhCS18MM8AWPzt3o7UG6olXfGDF5Pf1YNz+iD7oEWR1bmiA5otZ
VyJvllK/JihT6p9EzS+FzLl9XjPE2PXRz1IF6m+G+HLKlMWcgEFFeKp+oBWa
ltirYfZimtcG/s/No7/tLUGtqx6AK8k9HCgRaH4H8od26td/JyDU9cACIWnt
8lv/CKTHClFRsHu/rBRrXANtUGvPDJzWTep7DM1eY/6SqXosdI5XdCKjMuHR
Ia2e9D4Be+Lj1zLTgPcczeJnP4XSZ+6h02cn8+mC/PeKEH9FGd7S6Ia47fxR
eVEZ+emGsLD9jfs35Xi+xSnwGdRnBu/EvCwnf/8hI+1G1ewTFWhxxdED/lRy
9R9LK8nvczDl4u7Spko4xDkavkC+UmsOiq8i/73gFe/02xdUwyUv9yWE+jux
GXXVlIcIZWP+3VnxNdRPRMY1q0ShuEv59MFb2BhQZL5L/fsg74qbk6etpbz6
4R2envU4sI7m9YPp2nXoraP8XsHy19SAv7Pqaf4rcE23ZT5h9yjP18jvj+5f
IjXiktNe9mtoDTv7SyKMlO8AWtcZjxcUG5F+zlkDODi2NEEyp4HyHoR9z773
rxxoQKpL4CBUecqQs6YGyn8IqrDsi03LGuFqd2QIYvTPYmhqI/GwQ6H6INPn
RSMSnHHH22Hf3RU9/asm4mPHh2sXR3+e04S9TnnqYWhbUj0zpSbiNQw2P/tp
QKQJUZHOGoEYFCCxl5mI3wi8ZwQnd/o2w2U3/A14lJvtvzQTzzewFMUe/8TW
TDxGoQus/TF1bQvxGIXI9/EzM1uIxxi8FykOX+XMxGMMnDHLfRdvJh7jUErT
sUowE49xiF9ey/GXtxKPCchvJDSs0LQSjwkIc5K+/9bSSnlyjFX5vnuM3Sc9
HNP5NQjmjPuUL8c0p+NCPnVrI30cE2o9inK2t1HebswYNzxzib6N9Lox4Tp4
w4J2yt+NWdTjbapf20m/Y115smBuZzvxkDBl2xl/6/oH5MexXjVDd/PyA+Ij
YXxi0sqTXg/Jn4TJV/+QnBj1kHhJmHdkcGds1UPy6874j4LL9y/sIH7ujMnj
LyWldJB/dyaatnpc6OmAS16PO1Pu2PRTyeZHdD49mJi7Iabn+iO48EZ6MG6r
Ke2U1ELn1YMF+UWkLVtpwdvfiQc7eHldnUllofPrybrz9sxIPGch/p7MKPts
0cc1FjrPjvcTsvHmEQve/u48mXbbre1afyvx8GKKxH3KNeFW4uHFDgbe2jh0
zEo8vFjY8QPJBf9aiYcXK6yJqIvptRIPKdPduTC+QmYjHlImbCgeG/7aRjyk
THWyIK9UYyMeUsa0N0eO3rARjylMOO9bEWaz4X+NixAA
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cYhg8FWueCOWEyTbZB1W2W4KTMKQtD33/zRsTMgk5xYRmYcXEz
WgiKK2apbC5MiVSdsxo1XJyKm66yTdEoHNoiCIJFLq3cbCtTFMGCAqWAjtaP
Lzk5+c/5z/e97/v8ObM2bYtNEnEclzRxue+TJUy/djz7iAGlgXt6YkpPQtos
j03t09P6AvhvS/eH7dVjqrlIuXjqZfCSQ59Vfz/5vgyKrU/iHhr0+GiBuwxQ
BiiTjSkG2l8FJht9mMEMsKumX1hpq4Gi2e/zyBuT39dDvWXHimfQI8rm3tAA
5UuXOrWkgvo1QjNy/vLmWRUIcm8PbIbO9sGinjyB+pvBJ/DV8zkBQ7L4PP2g
BcLB0KXxzjKa1wqmKNu9L60ctzzVDmWhNiJSJND8TiTcP5S2YoOAWM8DK5SV
rZZ/Lwmkxwaht1u8M6gCSzwD7VD/fCrnsGZS331YZ4xEyF/TI9g9XtYFJhEn
7s7Rk97/oPtm5UmznwEBE81U0x9AeiPK8at2Mp+HUPy24Oo8mRGvaHTDEXW4
d9Y1I/nphmlO8XrfdZV4EuMW+AgswDYt42kl+XsMbng84M39N9DiiaMHXHsm
fyK0ivw+gWnAO9jQWIUJcRMNe8GlZfuvUlWT/z6o16bMdc2+CY+8C08hLf+j
qKDuJuXhgKZj29Abqhrq5wB3tlAWLKulfPqREBi5/rq5lvr3Q6c3hetyblFe
A9Bo1Ve7Iupo3gC4vqxTrK+O8nsGoS132Z+F9TT/GRTHl4X4x92mPJ+j+0j0
jlCJCafc9oqeozryuwxhk4nyHUT+an7aP2UmHDvqrkHIc6+MiN5qoLyHoL20
4dDpzAbkeQQOISdEVattaqD8h1HanjizKewOPO32DMMZXJ66Nu8O8XCCH3gw
w7/3DrLccaucsBhj7r8e3Uh8nIh6sNgWWdyINLc85QjOXovZWSBpIl4jkBql
cYuSm5CS7C4X5H/tTHcam4ifC8r6rwe75jTDYzd+FCxPt3wku5l4jsKRyFwf
2puJxxhYUbY579MW4jGG/MKjtX4FLcRjHA6vmsfnODPxGAc7v3xLUoKZeLyA
gl9+5hPBTDxeQLoumZ8ntRCPl5DHRocvVFuIx0vwxduMX1gtlCfHrLFhmbns
LunhmDJH/K4l/y7lyzGW1l4S7tVK+jiWrzn2zrnEVsrbi7GNVVvn61tJrxfT
XFwlGGa3Uf5ezJQeHbH5xzbS78UcGe/5B3a1EQ8Rc5Rs/8W2rJ38iJigjegt
+b2d+IiY/KD48AFxB/kTMTZzqX1XSgfxEjFTfzYyqjvIrzdTBtqDMoM7iZ83
U69Mf/HT3k7y783kp0u+OtHTCY+8Hm/GRftXla++R+fTh2nGs2p6zt+DB2+y
D5PePmM4KLHSefVhFtVTfdjHVrz6nfiwKev3OZtSrXR+fZlavj1811Er8fdl
+ZaxdXNrrHSefZliTZGsxWXFq9+dL+O1zn05ITbiIWb8o6wvl8TbiMfE+u0f
0oZzbcRDzEwzxLq/r9uIh5hpQi4PpffZiIeEqQOuzF0YZCceElZ9qeB91xo7
8ZAw3bwES4XaTjwkTLoxeE7uRTvxmML44qS+OLsd/wMxigYS
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cYhg8FWudtnULElHFzi8Cc1LEpXuD9jYYx3RQdKolGEQWG7nJc
xkAcW+MkgjFQL5uAlxUvm3PR1MuUGYLHtogoKJcCFUo9oCijiAUFEQasLR9f
cnLy9/z9vvd9n/8c//hvVidIOI5LsF+O+1gJHsXHdh/Ro8gn07qq6ATkN/b+
zXfpaH0Bmvx3e+bv02F8wyk+fPw18Brp71U7x56XQPSNL36u1+HDUEfpIXZZ
yiuS9LS/DGy2wvI906M13ePCxy13oOWDF0bcGvv/PXA9acG90CGqxbGhGvKz
beu3XbpJ/Wqh4nOzt/vfhK9ju08d1ObpI525AvVvgCbSO0vJCegL3JCr6zVB
XFlg3tRfQvMawdaGyXJ33ECFs8xQiXtehEsEmm+BMtPgF7VOwGrnDyLkG1N+
vHZVID0tYPW+p3b63kSEc2ArxIzLiiPqMX2PIBwLKJ3zhg5BjvGBj6GWH2jd
naUjvW0Q8jOmPZikh6e9WbrHE9h8Ujb/mjeWz1PIwwtnzA40YJRGO7TFOStn
FBvITzvifku9KI0pRecqh8B/wckr4lOel5K/DmjLl22ZlnML9c44rGCHk9ed
CCkjv52oUjQlG2rLYBdnb/gMojzjs+Xpt8l/F0SzsGEwoBxOeReeQzvheO3J
ynLKwwZVeIi/Z/od6meD2LdlRXDgXcqnG9q7ytSShrvUvxtK68yYi1kVlFcP
mHdSTduCSprXA80h76LFXZWU3wvwa+Qx50/eo/kvwM5Vz50ae5/yfImi9UED
IbIqnHbYO/USabU7+oT4Ksq3F3Ep0TlXSqpQkO+oXniFLUlzVVRT3n3Im75A
/kdqNXKdAvvQXqqPzDdWU/6voN7ld9A4pwbOdpmvwI+MiJ/n1hCPfkQdvpoz
5VkNdjniTu9H1bzi2InLa4lPP/IKV6wJ/7MWOxzy+NeQX59qLZQZiddrfJFx
onxuohFJiY4aQNr7xa39BiPxG0Dc2W+3ts2og9PuhkFou49efr27jngOQqOY
lBTaWkc8/rO/b/OXqBfXEw/7+tXiuZML64nHEKK7tsf8xTUQjyHIC9uNCXEN
xGMYyvdskxcJDcRjGCLvlzrLz0Q8RiBIFcc/UpmIxwjUkeuD1oomypNj0d0R
TfvZA9LDMeXwwr0mzQPKl2OqTfAMc2kkfRyTb1X+dG5zI+XtwqKX/XJ/tq6R
9LowVrbGzxDQRPnb19l5+ck/N5F+F6ZS/sP7PG4iHhJmK4h52rLUTH4kTC1L
Xnb5jJn4SJjyalb3AWkz+ZMwzuXtiIykZuJlf76/qOC7283k15VpPkhNTw2y
ED/7+odtsZn7LOTflWkz37p23GqBU57VlfFo8hU+fUjn043ZYi8FdJ5/CCfe
RDfm5T0+0mIU6by6MfX0hyVlgy0Y/Zy4MdO0K/MuBjyi8+vObJ7Z2oJPHhN/
d8Y8Ngbt4dvoPLuzsCmhJ7868gSjnzt3pnlznGJdyVPiIWWmSc2HWFs78ZAy
fsKlicETO4iHlPlFLeJijnYQDykTgmedsVR0EA8Zyzptzkoc7iAeMsZU0jJr
iJV4yJjaa2jn15utxEPGtDMN17sOWonHOKaWvFP4pcGK/wG53QDS
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw9lAtMU2cYhk9baAHRIVHD4qaIEKui4OpleHv/dWbi0AgOByS4FTLByzbK
lmUKi+lEt45kUjUKm0xBhUynjHkBMhkc2iqCwA7XIiAWtIpUroqAAo6Wj33J
ycl/zn++733f58+ZFx23baeY47id45ft/n9dTPw6KdWAgjmHrSEFp2HOvnRd
3a2ndQ74gOX9Acl6uJjOqde55ENlmpYt7J98XwTz+l2FPQY9litsZYDGYi2r
iDXQ/lJwP0ZuT2QGtCfMyNnYVg6uKs6ovDX5fRXUQt/NYegR2GbbUA2V+xHn
uCsl1K8WLPLDTep5JZhr2z6nHur3eaEvhaf+Jgj8ob0rOB4v5JEp+oFG8N/s
jd89VETzmqD5YIMhLb4YFfZqgU63yKIU8zS/FW63zT5bwnhssz8wwxz6z8nC
PJ70tIENL606MLcE6+0D2xEc7h6RrpvU9wCccvOMVc56LLSNlz+EJnVQqdXq
Sa8Fntd/1rZONWDmeLOEGY/AtaW1n0qbzOcx3MKV1xRyIyZgdEBY6tEjLzSS
nw7wwx9/6hp6E09DbAKfICPmqzmJPTfJXyd6Y5f4vn3kFhrscViRES1ect6v
lPw+RS93Iai8thTj4sYbdiF3TLImJOE2+e9G7tBP20Xzy2CXl9MD4cxK0++V
ZZRHL1Rnff1mJ5RTv15ovtsR4y+/Q/n0IfiYIc1oukP9+8DnDxzI11ZQXv0w
+86SPl1dSfP64RkV9nxjdyXl9wy5+w6nXT1bRfOfoTdTkfRm+L+U53O4NS/2
VsgEnLfZO/ccHX94eRujBcp3AOrFR4rziwT8+outBhBo6boknV1Neb8AH6YI
vPhtNVLsAl8gMLX7+/S6asp/EIEsSjAtq4G93eFBFGxf6xWWUkM8huAUXF8z
s6sGiba4E4ag+ijrzBtBtcRnCNpF1tPsQi3ibfLUw5AXb1mVJasjXsNQOUd5
rI6pQ2yMrV6iwP+ZYsRYR/xewn/ApaBjfj3sdiNfwbwgyXn0YD3xfAUue1nx
yvZ64jECziv5t+PvNRCPEQiBfx6bntlAPEaR6/7oSg5nIh6jEPJUK3arTMRj
DEJPWDx4E/EYg79iT7OfZyPxeA0hLUASoGkkHq/BOyqPRpgbKU+OaXLbNujY
XdLDMd3UlP7mjLuUL8e4xFUH14iaSB/H1Nf0XZejmihvEXOLzsc7+ibSK2Ke
J0aPlno1U/4ixkcUun6R1Ez6RSz4r62WeQ+biYeYafShOywbWsiPmPHzy0vy
slqIj5j5f6bcc0J6j/yJmafPggJN7D3iJWZuW6fM2nf7HvmVMLNoymDCwlbi
J2E653cbtMmt5F/CMm5MX5lpbYVdnlXCcoNkGYbN9+l8OjD1Scn5nsv3Yccb
48Cc3J58Yq4z03l1YLppRaayV22Y+J04sGDX48FXvR7Q+XVkKpddZembHhL/
8bXTOuUPagudZ0fGS91vxKU+wsTvzpE1Sh4rIooeEw8pCxcVXlJaOoiHlMlf
63x8XTuJh5RpNq/lQk91Eg8pa1zqm9Va0Uk8ZMzjQos2ZqyTeMiY5yFpqdXP
SjxkrOOt0f1fRlmJh4zpFhv/7j5mJR5OTC31zvzcaMV/wnEA2A==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cYhg/lUmAaq8OZDeWmRpBN69CJ1/fXkQ0v2YbbRKMm6CaOxUth
jirOWOfIgDAhOrygEpywoDJkFwfTDY+9CIri4WYLIhygKFKRCgIVCqwtH39y
cvL3//t97/s+X47/tj3rtks4jttue+zvsSViyeofTmpQ7JNoiijOgmiw5Ly0
ju0LIB4/PmXFbC089RcUyzyLIOflhrqZWjovgbyvKbaqX4P5IfalgVD7RVR+
nobul8LPEr/mINOgJcGr4MPmO2C5yb+H3VLT/ysgW9Z9cRBqhDfbL1RCrIg3
Kv64SfWqobgT5B3nfxO+9us+tVAVXjzdk8ZTfT14eWrwQo5HX+DmNHWvAaq3
Z3nuspRQv3rwnVfDz8bewF3HakB6nFdWmISn/o1Q/Tmh9qNIHuscP4hgGeuX
lvzNk55mCP99+bXK9yaWOxq2gEX6PTuXPqavFeYne7NCPdQIsrcPNILpD2uT
k9Sktw2yBRoncbwGk23FErweQzyh/fTcqbF8noCPvjJtQaAWozTaoZgyMWL2
v1ry0w5Vz4xr4z/T4VmEXeBT+LVtjvuuS0f+OiAr3b/f5+gtPHDEYUL65Z5v
cueWkt9nENSHUsurS2ETZyvYCW7Z8LfrEsrI/3OI/q0pkum34ZBX0IXs9FnS
S/duUx5mcAWmjVMT7lA9M8xKn9R5geWUzwsUPi/6R6cvp/ovoDq29kxx0l3K
qxt8jHVa5+J71K8bfjf6paue36P8eiDku+f99UsF9e+BeSd/9K0N9ynPl5Ad
8sgLkQrIsdu78BLymUG/arcJlG8vhPkVKC4RkHnavnqh2qsMlnpXUt59aM+a
rLukrESaQ2Af8l4PHTpbU0n59yNU57vaMK8KjnKJ/eAmHcyMTKsiHhaE1+Ws
eqOzCgfscSdYYMifMFm2ppr4WMDdH5y04mI1Yu3yFK/glzPhUq60hni9QtTl
xuTF0TXYEW1fAxBOvJdj1dYQvwFkF02b9XR6LRx2Nw8iKn63cuj7WuI5CMXq
4eCFLbXEwwo+hXn8vOIB8bBCSI4cmnj+AfEYgsr049QrnJ54DEHIcM6KidIT
j2GwfkkdeD3xGIZs6YyVcj8D8RgBW+wRs0hlIB4jtnl4p2+jaKA8OSYs6cpL
Z3Wkh2OyOO3nDdl1lK/tfGOmcYlTPenjWLZyw8cFW+spbyemWpmY/a66nvQ6
MfNp9+7SgIeUv+18i8fOXUcekn4nVril9f0A40PiIWFRmSHX28IayI+EsSMW
n6LcBuIjYeJ+7a0Mt0fkz3bOOXkd3vGIeEmYop7F7it7RH6dmcItO+JAUCPx
c2biHLk8OaWR/DuzT35SpJ03NcIhz+TMCkMEi2ZtE82nC+OMi6xdvzXBgTfa
hcldypQtNSLNqws7JTlnLh9sxujnxIVZRmJjrga00vy6sg3DH7RkrTISf1eW
ZPXelKRoo3l2ZZYBc3XsyccY/dy5snCLbu2mkifEw42F92bqwtraiYcbs/Ts
WT5nXAfxcGPCUu8315/pIB62vc9rJeLdDuIhZapT189/NdxBPKRs3962ps65
JuJh249rOKbYaiIeUiZ4X6g2HzMRD3e2r09ybbfWhP8Ba/kRRQ==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lA1Q03UYx/8bsKFiEZEXR8qE7EbexUrM4qznx+WBZXrzJdCia2JAdhkj
vJRhxyRNJAv0DBELhyhHQWvWFaQGYxsT5cUhg80Be0EGuLExXh0v0/6bD7+7
3e75/37/5/l+v5/f/VenZu5IY1IUlUb/vP+Li6+d4xw/p4T6Vcft2+vLwbX1
7I2ZhcVaCgJp3tp3XlbBUl2l8K2ldSD23z/Uu0aF+w3AYw0f1j5UQuw671KC
8MXET6TVSjx/E3iekvg8ooQBUag00XIbNKSqPEGtwPc7oFgx9YMHFLDZ4j3Q
CVTO3sav/mzCfl2giV/myF7dBBHe46u6wVX7U+p0kRz760C2otT+BiWHGW5K
kWJaD2bn6UqhuwHnGcA8HdNxMasR2nyrD8QyKjmBKcf5RuB/QI7xk+Www/fA
DDzeuKXxHznqsYDkygVWfkQTvO0bOACybTF5F4sX9d0HwRfl3LglCoj2jucO
grg/KOH7AgXqtYJ4/6zIslwJz9HNRKFDwBlzqcpLF/MZBtnylSde56rgCY0R
KD619K+1N1ToZwQ0WZOhT+9qhtHtXoEPQGhKVH8z1oz+bCArU6sjflRDjy8O
O5BU67WqmJvodxSEjqT2tq6bQIujGzpAY3LLdopa0L8Tgms3yv2iboFPnnQM
JL3Pb6hpv4V5uMAcVHNspeg29nOBQG26+hq3FfMZB0lZrUGta8X+4yC4Vln3
b0Eb5jVB+x1Y74xrx3kTwN9XGv6esx3zmwRJ1Km6vy914PxJEOZsLQvffQfz
nALxpuG1sWwNXPbaq5wC9/UYbnOqBvOdBknKU/L6Bg2UnfeuadgdwfiNHd6J
ec9APcMdX3OoE4p8AmcgsPbo4V+0nZj/QxB/alTqX70LvnbH6Xrkv5DdRXeR
hxvIkYPyFY67kOuNW+SGwAhRYfCWLuTjBtnJoBPxv3ZBlleecBaCKzpfqGJr
kdcsmNNS5uPStZCR7l1zIAkVhXpUWuQ3B5xiXsmDqG7w2U2ZB8qwx+rJ70ae
8yDzay3dMNCNPBbAzH548Gx8D/JYAGJ6nBFS0YM8PEDpo7/7g9IhDw+QgirW
5wId8ngEghApIXId8ngE8j3Gah5HjzweA8+p73hTrEcej0HySthHH5r1mCdF
NLqFoNPkHuqhiHxotr5Pcg/zpYh4sydhI8OA+uj9LU6ZdK8B82YQQexOxjqF
AfUyiPzqsztaInsxf7rOTGo98G0v6qfPhx+6FDnYizyYhJ8fEja0qQ/9MInY
8dKRuit9yIdJZOUJUSWsfvRH79sMmUcz+pEX/f7Br9sOt/SjXz8iDFtfmxtt
RH50vY9beLLQiP7p+sCdkQq7EXzy7H5Ewz2/XfW+Ce+nP+ET4S7X7ybw4U33
J8HuquJBrRnvK13P5C7pmLfAk8+JP2mZ5OfXRd7H+xtAWibWzEveHUT+AcQ1
NpddKLTifQ4ggc47o9nnhuDJ5y6A8EYvp33cMIw8WISy5RgTrCPIg0Xcw9uS
eUE25MEiEhIelnTBhjxYRBy5rMHcZkMebCL8+XrFZ49syINNODlWkyPGjjzY
pPqZvjPCvXbkwSYUp7LLdcaOPAJJwSzz2pcqO/wPWewVmA==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMk2cUhktLgeFQFHS4CI7NIZuCoHNrMuf5RsZsCCKYYRh3EaVsCkUk
BBDBuIIzmnbuApoNmIjiECSwIbiJlYsgMAZyK/feL5RLubZAgbXleJKmOe33
n/O+7/Pld46KP36aSqFQThs+xu/XJWQ90XJy6qHaiaMOqM6DzIC93Tr9674M
hLdiwfvDBrDuK2R/Zv0Y/N/Mnxt+vwH/rwVb7lhGr7YePjpgrHogSdvCy4vr
8XwT8Oeenq8MbwBxqn3ZEVEL8P6yz3TMa8Tn2yHyutdO3+1NwBQZD3RChyzN
vbWuGed1QebkLrfgGy2w03jcqQc0RdzKrLNtOL8PhEUBDzYHtsOCayi3bl4A
LJeTP/zq1IH7BsDB5rd3UzZ2QpuphiCXVuljpe3E/SPAn2nxcu19BcdNPwiB
xWxNzfujC/WIDPPv+ekSu+GwaaEYynPfYkXs70F9EnDISYZv5D3wgXG9qxSC
Zg6f1/B6Ua8MbLP6SxT7+2CrYViqvRxYD8iPPv/2oX4FaNJH+q1OCmCdhhKY
W7Txq5MC9KMENr2neiq5H8YDjAJVUN0Yrr6q70d/YyC4k/FFRPoA9JriUIMg
v9R5dmkA/Y5D87dPEyqSBsEgzjBwwqD/5e7liUH0Pwkea2tXHKOHwCSvbAre
SXnkFC4Ywjw0EFnqUK71GcZ5GtD4Oefs+GcY85kGf6+KXbo9Izh/Gvh56opH
t0cwrxmoLr3EPWU1ivsMvYrK35c0ivnNAj8x5N5e0SjuN/RURuMnLkLMcw4e
fi/I4oQI4a7RXuEcdEfZvcjmCTHfebi7aP/Yu1EIt28Zax4YpWVVjYtCzHsB
mIc4MTbuIuCaBC4A0bxqcY4SYf5aKNcnB1r+IgLTOI4WbDfNmtW9FCEPHVw9
8TwicEUEaca4U3XATOcWNHiIkY8OKLqbhVuixZBglMdeBErcV2uf54iR1yJo
OnZbB7aIIeaMsZaAWfud6OiKGPktAe+nWLa7hwRMdkOXobhr/IIuSoI8l8Gq
6m1O6c8S5KEHRhDD7lizBHnogdRdThhZkiCPFSA2ST2hblLksQK81Zrg1ggp
8lgFhm8lfc9NKfJYhY6mhsaLDVLksQbCTUHJzxekyMPQbyiWLbrKME8KafYN
bnMJkaEeCgm6Ni5g3pBhvhTiELdcEvlMhvoohBIeMxA3LcO8zUjQpyGTie/J
Ua8ZseIyWOxAOeZvRnT7zj6LzpajfjPiSnM/FVAjRx5UQnFz//tjtRz9UImu
ytN1q6MC+VAJ/0KB+YSfAv1RSe4TelFtpgJ5UQnjKCfoWoUC/dKIstI71l+q
QH40wt/euWPzNiX6pxGP/HN/th1RgkmemkYiKXHnrqQo8X6aE6Z/2uWDJUow
4T1jTgrYAhfJkBLvqzlxGMvnXd+ogvXXiTkR/K6f9CQqvL90otSExXclqJC/
oc+6fyihUIX3mU54aWEZG3pUsP66oxO2si3sjsUY8rAgkSc89QcZY8jDgmQe
67v4InYMeVgQ5RvZHLsDauRhQZiWoav6r8eRhyXpoHsmyzMnkIclITQLzX/3
J5GHJbGlDrJq2qeQhyV5uNbH7kzVIA8rwr7k5fblxmn4HzC0GW0=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMk1cUx0sptMOIVUFwkdec2E1l4GNjz3PnZmDEOauQMN4gCCwqBSS8
B0yruI1QNRtINtaMDdgYyMBMFAbIQxCQCKxQEKHvFsqjyKPlUVlbjjf58uX0
3p7z//9/N59LRNypKCqFQokyPMb3yyWKua/lFrRCnSNXza4rBmb5RYZ+7WVd
BfyoLemfvdkGVkMlnA+t7sKTvL/el+xpw/1GcO8IFIxoW+HwIeNqBU3ZeOud
8lY83wGca40JtSFtIEmzqfISdwHZaZvtUNyO/+8FjtknTsd3doC32HigD0Sn
M9y6Wzqx3wC4n9xzICCvC5yMxx0FELaSX3vlXA/2HwKmhv3HVr9eWGIF5bcs
CsHZO/z6T45PcN4IpOz/+bVU6z7oMa1RcHeq9WFo+3D+GGRv6j7KGuyHU6Yf
ROAc3p1W/OcA6hGDqKH0hC7xP/jINFAC5ZV2MaEHBahPaqiT4SuFAN4wjmfJ
oJwOCRreIOqVA//WcIXy4BDYGpql2SiA30Bu+jweQv1KCLs+NswIF8IGDRWo
dmvjXswI0Y8KhHaCutnkYZhiGwVOQO5QiDp3bRj9TUJzTdanoZkjMGiKQw2F
1ZUu8ysj6HcKsjP/ja9JegoGcYaG01BY/mjv6vRT9D8DzZsplx0iR8Ekr2oW
Yq7ddgwRjmIeGvBssK/W+jzDfhqoC3Up2NXwDPOZg0J2zeu6fWPYfw6Yleqa
20VjmNdz4DV8nX+GMY7znkOKltr8VtI45jcPrG8CS/eLx3H+PPBe8Wx/x1WE
eS5ALk94hRsogt+M9koWwDd2+8OrPBHmuwiidZu7x9pFUHTLuBbBt7bqn/Zl
Eea9BLlHudGb3cSQbxK4BNVL/V0uEWLMXwsiaoof/UcxmNpxtcC0nTdreSRG
HjogQQ9C/fRiSDfGnaYD1qV8fpu7BPkYav2Nkm2REog3yuMsQ3Oi7/rHBRLk
tQzZg3ut/LokEH3WuFbAvfWy+HO9BPmtgH1RLMfNXQomu0GroBFOXdRFSJHn
KgjrX+VW/iBFHmtACfbc/kWnFHmsgX9HTvzYihR56IG1LUkQdECGPPTgTLsf
0B0qQx4vgMmutdh3Q4Y8DPXjtvaMNhnyWAfvHf7JD5ZkyGMdcpnl8mWWHPOk
EA07oMc1UI56KKQzf0ronSfHfCnEPmG1IqxJjvoopDAieuTCnBzzNiPNEDiT
uFuBes1Iyk3PGI6fAvM37B8+1xR5VYH6DTXd7Qz7ngJ5UIm3h1v922oF+qES
fr0Hy9ZBiXyoRJTCp02fUKI/w36Txe+N2UrkRSX+bK7/tzVK9GtOOHXHYk/K
lMjPnLAc+3Zt3aFC/+aEV3L+To+XCkzy1OaET7tw/lKqCu8njTT7puccqVCB
Ce9ZGrFPErpKR1V4X2kkZuYX3vfWE7DxOaERfunajAeZwPtrQXQLwXED8RPI
34Iwviv7IL5kAu+zBUnJCs7aJJiAjc+doZ7qCf7VchJ5WBJOgMfaEc9J5GFJ
wk4PZTyMnUQelkSojyq2PaRGHpakevU9u/Uvp5AHnXgvb+GpsqeRB50wdTJG
f9kM8qCTzsV7OfW9s8iDTgpTvTL70zTIg0GO6/5+18t6Dv4Hf3EWmQ==
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUxy/lUabCmkwFzEQIurCpsxONuODORzRSwTgBRabGaUV02caK
Dqb46lyAYla5Y0OROMdWk1VZmHMTMPPBaB1MBUEo1IKl76eUlgKFUmBtOZ7k
5ua797vn/P//35cby/0i4xCDoqhD3st3f1VNUyfaSy5JoDG62JreeBXIElbM
jOfVug7Y/MkLae9IYU6viLdhTgN0yHRbdMuk+P4+0L3c/n6XBNYk+EoCvJHm
5nqxBPe3gEq6vufvfVLQFM2vS1E/AnsxrV129SF+3w68vffP7YhqAY7at6ET
eLdd33U1t2K/LmA9qKG5wkewxLc9WgZ04dyI8s+eYP9euFnQNm/RznYYi99b
3jwqh6awJZKa6A6cpwDW6O4dp8M74Ym/+mHcwjs1z9WJ85UgVgi+XNHzDDL8
D1RAvVf22y83ulCPGrYLc/ieY93wgX+gBuizsssHV8tQnxZY/LX5eQYZvO0b
H68DvsIjGqF7UK8eVHmXXlhX98ICb7Oi+QYQ0NPSbW29qN8I2blX5oYdkMMs
DRMI3H/9zBiSox8TVNkqLM6vnsPLdJ9AM0TWvblY6HmO/ixgP7+h8OBpBfT4
47ACJfg00+VWoN+XoMo8Kaov6AOvOG/DQa/e0o9mBvvQvw1o473bsTn94JdX
NwTHD3y+nSvvxzzswK/sUU+mvsB+djAlDrTG3H2B+Tggcjkvy7Ncif0dQJVe
1/1ZrcS8hoF1Memfw6EDOG8Y6M4mR0LBAObnBHpPlJytHsD5Tgh1LVSuf0uF
eY7AldMNP5XuUcE1nz3RCNizhpVltArzHYWOQefTlIcqqL7sq1H4oUb4tGVC
hXmPgX1VDv/1d9VQ7hc4BhzdH9o4rhrzdwHHkZX32kU1+NsVu8DOeLZI+p8a
eYxDTWrN8V1Tajjpi7toHOLz8+78y9Ygn3EQW/Pvzs/RQL5PHm8CErkJkZsu
aZDXBDRJQ+J2PdLA4VxfuWH/rYPuD6c0yM8NoWWcMjZbC367eyeho+Wx0M3V
Is9J4NyY+PH3Si3y8IA4LWJFeqsWeXjX9fvPq9xa5DEFvIAdtn0rdchjCsTD
VcfaPtYhj2mIIRXRKyt0yGMaWHdFyjNSHfKYATpoHS0Z0yGPGdg+UzI9Ga/H
PCkSn7xeH79Hj3ooIjjz2JEq1GO+FMnmKqTcB3rUR5HjGZudPIce8w4g2ave
ZxbGGVBvAGF9E/H10Z0GzD+AsJemyXNLDag/gMS45p3KvGNAHgzCjg3rTrQa
0A+DULWs5IjFRuTDIPwjZxcPbTOiPwZprdPda+IbkReDCJJz8r+9ZUS/gaRR
vPRchs6I/AJJU9jNtW8sNKH/QML5fmtbe4oJ/PKsgaRmZGtJ8QkTns8gYtq4
u3pdrQn8eHODSHZOA+j7TXheg8gR5ZnrF8LNMPs7CSI3K/uYa4gZz28widEn
CWT5ZuQfTDqKSnYeE5nxPAcTipdUFSYzw+zvLpiM99UWXguxII8Q0pHKWpCY
aEEeISRyY31l6ycW5BFCGh2bGiISrMjDu7ZFsQN2v0QeTBJps4kt/EHkwSQC
qyS2+1cb8mASlbmq+l77EPJgkv3O+rKuIjvyCCXjR2M3c8Id8D/lRSBW
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cYhsu1XsB18QKagXVMwzZdGtGJBvf+SyYUxxygoAOnHSBqnA7G
BMFbdVPADO3ckEo2h0CiTqNsRtF4oUgdHQiicqkIpXdaQKGWS7m6tn5+ycnJ
Of9/vu993+fPmZfwXfQWVw6Hs8V+Oe5vik1k1h8tqMIN/yPdUTfOQDTv/DKX
8TfPl6HeYSj+4gM5prSUpKycUo6itjkbjPPltH4XvM3JOtVQFZYEOaoK4lUn
K2+cr6L91eDFrWi+tUkObdaMy2GaGshMEt38M/fp+3qkPL57eN3sagg1jg2P
IHvX9suTewrq9wQ8/llJQl4N5jq2+zehrHaqz4lvH1D/FohkdV5zYuoxGLjx
xL0BJQSCuVVF/g00rxWm6fHr9k97hAfOaoOUm7rPa+gRzVdBas35YWHzY0Q7
X6ghCM+9VPzXE9KjAStNEo+lNeIT50AtFPlNpxMXN5E+HZT5S1N3GZvwvmN8
oB6+vWMl/ZJm0mtAw6GC9u7FLZhpb5Y1wwhB6YR8TV0L6e+EKPP3qd7fKPGa
hglir2tnXXuV5McEHufXLmvGU/REOQSawSre8csbe0r+uqAsXJmeuL8Vzc44
umEq2LF2aKSV/PZAtGVvyfXdz2AXZ2/4HGJJ9levnj8j/y9QNHjn2rykNjjl
Xe5FX8rOyARlG+XRh7LSZs3o6nbq1wd1aIeCf7ud8rEgZ3lK7NiHKupvgey3
C/qrhSrK6yWkpSGVWyd10LyX6OuQWYJ2d1B+VvC3z1YKNB0034pL47NUyxeo
Kc9+RPxU/md2vBqlDnsl/Yj8+qUqV6KmfAfQb7U+DLuvRuFpRw0g4lzew+ph
NeU9CNvHSeK3PtLghFPgIPhdf+sCEjSU/xAm2WJ3TT6lgbPdkSH4Tn48R/6f
hnjYII0s2rN+XIO9jrizbPDN2HXzX4GW+NiQY0m9PSNJi1SHvJRh+G4L8v2s
QEu8hhFc4xmwvkaLrcmOGoGwPHHky3Et8RsBOy7MFQh0cNrdOIoNdbV5Iwk6
4jkKYdnwH1fydcRjDHuifRZGKXTEYwziW6Jj6hEd8RiH0HPdi02L9MRjHDk2
aVrdZj3xmEDgqpP+i07qiccEhJUlqgNyPfF4hb7JyyRVg3ri8Qpl7tkTo4EG
ypPD+KHLDYHxBtLDYZE/1lpW5xkoXw6TJrfKEyoMpI/DhLGh1hSLgfJ2Yfwl
K7jpAUbS68IU2T6Hvo8xUv4uTB34uTI520j6XVjRqNe+tTeNxMOVKeZ7NwZ3
G8mPK5Nc4X3q49dJfOzrOw/69a7pJH+uTHpVf0cm7iRerowXmpT68z+d5NeN
8S+9dzha30n83FjD22VLp88ykX83dr4goq4+zASnvG43ts0WcfRIponOpzvj
hccVLrtoghNvsjsTbS+Hoc1E59WdSbUHLhyfZsbr34l9vfAZdwkz0/n1YCJz
SE5Tqpn4ezD+waMxaSVmOs8erCgtROrdZMbr350H81VfTC/17CIenky2hjcz
OLiLeHgyftj1fMX2LuJhfzYGNMwO6iYensykswnd4nqIB5eJNXWVPeLnxIPL
yjqKVzSfe0E8uEzSnnG1or6XeHBZ/84Fpxqz+ojHJNbYI4kOn2bB/7U7HFQ=

     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAlQU1cUhh8hLEOtosSl0qK0WHGmtW5VcfsvHQpqUeNW6UBb6qjEGiuo
MwLWDStgoYLMKFFAKJaSKZWiVmRQLIgbuOHC0opOCIJAQkjyLgiy2CzHM5PJ
JPe+c/7//8487/XbVm2UCIKw0fKxfr+pnKN+eQnplSjxOqRbWXIKkV4+rqET
btDvQmi2X3qvpOwW3OpPRy50uwhBUrE9KOo2nV/Bfp5//9jce5g101qVUHmP
VbsdrqH7N6GYXbFMNvQA2lhZYVBTNeQ+W1Ycj31Ez9+DseRQQPngYyxusl54
gMSfNwxdj6+jfo8Q/fRMdZOsAROs171q0dA4v29t/r/Uvx7jvjBd27rwCXp8
w1KudjegpuD+P3vqGmnef1AUbNE0Rz3DHVs1QnU+Me+gi4bmP4O+zL+noE6D
VbY/NMhJHROvSWoiPU0omZabscNPi0W2gVrIPg1bl2/Ukr5m+Ho+zc4qasYU
63jf5+D5xf4/RD8nvS1oUP2YOiuoBaMtzWJlrUjcVzpvsrmF9L/A3I1CWr6y
FXYabQj+pCtpW2sr+WmD/FXS21HfvoB+pVVgO8Kz/c5l178gfx1Q/CE7aFze
hjpbHDpkumaVfnW9jfzqIVVOS3s4rx0WcZaGnUgM/27s6r/ayb8BQl+Oy+P3
O2CTV9iFkH6Hs8uPdVAeRqhueNZfdtZRPyN8JwVkjNulo3xMaCjdExHWqqP+
JkTOSH8St0ZPeZkRrht+Ob5CT/PMUMet167/uJPyEyGP2j91lKqT5otQVHnF
pDgYKE+OXrEyvnazAb9Z7Z3mUE9d1/+sxkD5dkPjP3r577O7cPKEtbqxuOhO
2aSMLsq7B+V3l3y+bqgLKTaBPfBVGoPGTzNS/i+hSpbuCg03wtbu0EtkXhXy
dClG4tEL992Lht+8YsRua9yxvRg28kxRu95IfHqhWOsXuGK8CVFWeZF9SJ2+
FGKgiXj1ITgvvKxmuwkRm6z1CspThl+0WSbi9wryfXsnfXDLBJvdsH4Iw4Mz
kk0m4tmP4Hu78saNNxOPAVy74Hy83N9MPAbQIO8I2aMwE49BKEeE7Ag6YiYe
g9hZWyEde95MPIaQM+JuVXOdmXgMIdy7yDuvz0w8XkNftGnMKk+ReLyGOmim
omm+SHkKbOBKS+aSUJH0CIzXhXgciBEpX4ExJHnuPS6SPoG5P8z2mHNOpLwd
mDxOdzj3jkh6HdhHE6UbLraIlL8D0/x5wG3roEj6HZhSVqu65MGJh4RdTl/k
nmnZC7sfCWO3U5NdF3DiI2HRplExA8s4+ZMw6cOEyp3fcOIlYYKH71uRWzn5
dWRh7y6tMsRy4ufIFMr4KDGek39H1lu1OSHuKIdNns6RDYyarc49yWk/pazE
81ZCWC6HDe8mKRtWHaEpVXPaVymTBwhfVp/hsL9OpKw8onPZibOc9teJqdK8
y+b8zYm/E2v7vtZQfIHTPjuxicUzAqcUc9hfd05s4HnM4K+WczsPZ5Z6xLFl
luV5Ow9ntsZrgU+Ppb+dhzPbeTZ0qK+QEw/L+cgZmWsKOPFwYT99Zn7yTj4n
Hi5sQ0Lc5K8tfuw8XJi7dvfK6VmceLiwgMDSaHX6Gx6uLGD1h+ZHlnz+B+DH
GG0=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtQVGUUxy/LwpLOFJNYiAwQYsJEDU48VTofUyMwAzgCpcJKZIPhqDwS
C5EMX0S2BkWx8oqVRzBBhCEICAxvURwDeYqIsLx3l2V378f71T6OZ2Zn5977
3XP+///vzH3nRKR/GIdhmDD1T/P/qkiqW8EPwmaosrguPVz1B5RJrKV8yza8
LoWEGiGnpq4dtvTnRblvuQfGW0VHvaM78Hk9GEe0Vwhdn4Djh5pqBtsAmrH1
x048/wCMXWzI9o0uEMeZlHqOPoIkoamHMK4b338CnWs+To3rPeA1qjnQBbci
LeRtiX3YrxusgvdXi00GwFJz3KIXimqvTX5W+Az790M4Ky6LcH8OC7b85Kb5
AYhdDf7rUt8QzhuEAb2kh+PRw/BYW0Ng8iJoxzXeCM4fBtfywFMlfSPgr70x
Ai1FbyWO/DSKekZB4Jybec5NDB9pB4rB1Jl/pFAhRn1jcMbiRU522RjYacbb
joNXRaVHROw46p2A6cH4FEfPCdiubhZnMgmipqyEPaoJ1D8F8d9M9BeemQQd
jWmw9fmvK3JyEv1MQ6hbaED051MgO6wROAOxd1cXc/qn0J8EaEd9u8JvGvq0
cUghZtiOCWqdRr8y8NrI6H+6bwbU4tQNZ6F2awE/4J8Z9C+HspBqnx5rCWjl
lc6B7bJk3u93CeahgKIzXTvrDKXYTwGxhU0vTb+VYj5KSDjfWMyflGJ/JSwl
Z1leDZRhXipoOP10M7FRhvNUICoe2f3l+7OYHwvhXRXRb96axfksDIzzapP1
5JgnhXDv4w97T8khX2MvjwJjm+3+slOO+c6DsSM35U/nOchI19Q8KLpCN3dn
zmHeC0Acvk88sjEHyVqBCyC7cyzczEGB+S+Cg8c+YXCoArTtri+CeT7TKk1W
II8laHnX8IMH9Qq4qIk7bgl6mH2dMzIF8lmCA4NJYYfMlBCtkRe1DC1Rx0LY
g0rktQxRv9oPdX6thK9OamoF6PK5EnG2EvmtgOhJ9ce72pWgtctfhfx0t2qB
Uok81dcZ25pNzVTIYw3IVZ/yBg8V8liDltTe89+Fq5DHOljJx5I9f1Yhj3Vw
3TVj9Xa5CnlsANf3xsRYnwp5bIAsdv1AwbIKeWyCaNF9r/9OFnlswtDqzSuj
+1nMkyE9r9dVegezqIchnXkF9pcvsJgvQ2xsDjpeSmNRH0PiHRrfc/mXxbz1
SIvg9O3cxyzq1SMj8sG4exMs5q9HjHwLrc6us6hfjwzd9ii9v40iDw4RBUps
stR7ofPDIWskRmR0gCIfDjn62h7Bmi9FfxxitdjaGxNCkReHmBy6YR51lqJf
fWLk1PFMHkeRnz6JYawvs4kU/euThFDztCu/UNDKk+oTY6f1itwMivvJJSXH
cn/j51LQ4j3JJVYtgbKaIor7yiX2RcwXj/6moPuccEnKFOdo+h2K+2tAzJ/7
tbncpcjfgAjesFisrKC4zwYk3yzT166Sgu5zZ0B8bHjcXPVzHQ9D8smJ+xJH
9fs6HoZE0Wxjt6Dur+NhSKo6LnJWSinyMCSC1JScwGKKPHik4dO04R2FFHnw
iCDmnN1xtR8dDx4x3mzw35tNkQePmE4FXSgSvuJhROKr7FTd6nz+B1XlIo8=

     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lA1Q03UYxzfYBpGVFeZ8xcJTPA+vjBRRfH6cZ5BKolF68tJSnPNOb6Ps
UnxBDQUKAgxBBHUgJV42UifsUjwCAw4Q2E0HFdk2HGxssv/2/zEHAraXx+du
t9t+v//zfL/fz3P/t3dKt+7243A4u90fz/eLOr547HBOaTOo5p+ybFFdBF1U
aFdqSAv+VgDn4oGh2w1tENR7WRYdVA8ycebajekdeH4XdK+by8siuyDifU81
Q2OBOn9abg/ebwXhquzlb02pwZARrIjVt0OhoGX5uQwNPt8FwsjgRU2TDyBO
77mgBuHGvn9bT2uxnwZIR9uVgeA+CPFcn/8QEvLua7Zd+Qv794Iw90GFNPof
cIYlFzSN9oFkjak4U9uP8/4G14bqG8b0R9DprX7Y/lJ4flaADuc/AtHonv5r
Wh1s9f6hg4Ss0YuG7/WoRw/3Fp5Qfr3KAGu9Aw3AhK2WXWUMqG8AyGt3VJd+
G4AlnvFhjyGi4uwO2cHHqNcIbXlJV1fEGmGGu1lG8CBY6zNbFjuMqH8I4m62
z6vZNwg+GiYgh2tnygYH0Y8JNp2MKEv/fAisWzwCzSDsboiW9w6hv2HgMZJX
7R+bQOuNwwJxdXXrd/xpQr9W4J3hz9NEmcEtzt3wCcjrTJWf1JrR/wiYmtVF
D94ZBq88hQ1UTk3U5rPDmAcDC6ZnixoEFuzHQOOSmIWzvrFgPnYgS/lM8qAF
+9tBYq7c9W2iFfNyADN0dl32H1ac5wCJJnXvrvAnmB8LgcssyjfOPcH5LLgm
makC7gjmSUFU7nxZu3cEqj32LlOQzx/I/K9nBPMdhchQVv3zChucL/PUKLhs
lCwqt2HeTlhQpGzdNmWDAq9AJxx0NuXMfpfB/J/CXCqtTxIx4G136inIszhG
SwGDPFwgV9+Pb73LwGFP3BkuyLG12MxWBvm4oCalL2vzbDuke+TJxqBQITnK
fmhHXmPQf8w13vOlHfaIPTUOEYlj7YYLduQ3DsVzR78IbbOD127yMzgeurg3
z25Hns8gUlyrE852II8J4CSc6WmMcSCPCbA+bDxzVOJAHpOwpkN6LfYHB/KY
hDzp9OiZNx3IYwpycmO5j7UO5DEFxd0btv805kAez2Fu9IxNW+ewyOM5RNaa
KvSrWcyTQ5iU4p6PkljUwyFpUsf6E4dYzJdDtgdy44+VsKiPQ1z5hnUrb7CY
N5f0lVhUVZ0s6uUScud6Ub2Rxfy5RGXpXLF/kkX9XJIWrmi+/SZFHn6ETi9Z
VeHeC58fP5Jza5sycA1FPn5EF7L60kQ8RX9+ZOEcnulAKkVefiTwO2u4bD9F
v/4kL37T8EgGRX7+hPNjQyF7mqJ/f1Lt7Ko+WUTBK8/iPv/sXnPVeYr7ySO8
0iOVyVUUvHjFPHKtIcb1ew3FfeWRtiDuvvZfKfheJzxiEgt3ll2nuL98EhZ6
pHulkiJ/PhHeFD+vu0Vxn/mEc8z/0yV1FHyvOz6Z2FkcVOU+9/EQEOUHXzER
7ud9PARELnllmdPd38dDQDqN5YJxBUUeAjJthq0q8ReKPAKIbk+UftYVijwC
SKEobWmK24+PRwDJmyNIfO8CRR4BJC372aGa0hc8AoloXrhD487nf9QeJNI=

     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAswnFcUxxfrEdOWpNqqGLaYeGTabkpFG+m5GVqmTdMQZho2aFqipc1u
iaaSFgmZSAgmRFDEI0VNPFptVj2GRuM5QrFoTeJt2cU+LtYz/Xb35M7s7Nzv
3u+c////O/O9dvqsb6gui8UKZX7q/2eLNAh9k7MfgNAqSeIjLADOUmHE59YP
cV8F6R4HE1qaOsB4uIR/2Pg+cP9xF30i6MbzZohvt3UucOsFF2f1egA1RkOj
LyT34f12uGMdF2e+0w+TsWZVXhNdwHreMSE3dgDf74U7RR4xbduD4D2hvtAP
6QIbbtcVEdYbAIeHEVszZiNgrb5uNQTctnWngLJRrD8Mbs7Vq4LD/8GqAy/t
r5UR8L6ZKk8QjWG/f4GT6bhHLHgMPZo1BqVlZ5qTDMex/2OIrOWYVInGwVfz
YBzO/7RSMHl9AvVMQIpTQt25dybhPU3DSUh0OsSvkE2ivim4uKdRWFgzBY7q
9g7TYFaRFcA/P416Z6CxN7DC1WsGXmKKxZrNAjs654SjYgb1z4H3p09+qYic
BS0NMdTY9pYKZmfRjxhUi1/tiwqeA6mPWuA8JGaadxcNz6G/BejJV+YpjolB
pIlDAuFbFwYC/xajXynEB5tUDr47D4w4puAisPwI1796Hv0vgZ80jiOyWQCN
vKplaFka7zyetYB5yKDvz43lZgMJ1pOBqbltncV3EsxHDuPVvPigWQnWl4Op
fQxN9JNiXgpQPVkcvNoqxX4KSI85svnF64uYnxJGQoO9zG4vYn8liBu3MzJ0
ljBPCkJxceHwl0tQqrZXQmHExtVsom8J810BjisNK3ddhtwc9WL2pZUi+7xl
zHsVQlodgk7uLEOaRuAqhM8G++3lyjD/NbhoEH2ZFyIDTbmkNZh259dK02TI
QwWU3rPoaJbBBXXcsSpQXbNsWpDKkI8KXB6V+x63kINALY+/DiGV9R/RD+TI
ax3GrPo6+7+Vw5kw9dqAePOg3Kl8OfLbgMj1xQN2HXLQ2OVtAv9qQ1mqXI48
N6HRa672VQsF8tiCkTdjiluPKJDHFvR0nQz9MVyBPLZhLLk9zvuGAnlsAz12
YLf5bwrksQMhye6iaZECeewAN8/6jZ/XFcjjKaTsF9mc2KtEHk+hrbU4evKQ
EvNkkRY3/4oPA5Woh0UsfTqsL32vxHxZJL1+wz7ulhL1sYjRUROO269KzFuH
NG4G3CrpUaJeHcLJjeILZ5SYvw6h++Qvf7OtRP3M/obn3cYXKfLQJfzdVZb5
zFxo/egSy/dZObvcKfLRJZ4Rl5K2P6boT5fpv/boXBBFXrrELjX7FcHXFP3q
EVVW/dByLEV+esRhbuUHeoWifz1y1GP05uUMChp5Ej0iTLlbV5JLcT7ZxCXr
YOapYgoavGFsMuYxLG0opzivbGLXfPZ09z0K2s8Jm0RO8AJyaynOrz5hP5fR
6VZHkb8+EU57bt7/neI865N4brGv0x8UtJ87fWIZPL+rhDnX8jAgpUZR8reZ
97U8DAjvdiV3jamv5WFAuPu7jTerKPIwINHXi8r9KynyMCSmTZ+JLcoo8jAk
fToK5yDGj5YHc86TnHornyIPQ8JucUyqyH7Gw4h09GTtDDL5/A9DKCPk
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMk2cUhstdiTqMaApsgoYsxUiCFxa84Pttk60zmwFEp5MhLkOrwa3F
4bSaaSA4cVNjwhQUWKVGqJOb00nEyVRQVKKgrDBsDLRQC+XS/v2UIhTXy/Ek
TdN+33/O+77PyT/vm++TM7xFIlGG8+P6flvyxL1RR0/fQd3cPHNSXSnY9dK1
GeF36XcVuo/O2nb772YEdqjl8YHXkPgs7EaS4iGd30QQVoeo4h5h6RJX3cGh
FZdb3slvpfv3UBiuV4RMtkGvDK76tOcBDh3UZp1VPqXnH0HaG7i9ydEOaY/r
QhtMX+rCHx7WUr+nOPLx2IAxuBPhrutz/4VK/ZF4c/l/1L8Dsi6VPiv+GV5J
Uk/cftkJuyFEl6PV0bwuTOlPGDcpnqPFXTrw1mWLDwd00/znWFq+JKdK241k
9x/d6J0pjL9/oYf09IBNvXzxSrYeq9wD9ZBp7HniBAPpMyBFU7khJLgXUa7x
kl7oRuf0HdL3kt4+RM4vqp7c04fZzmbKYCPE1/YXRQl9pP8Fmnc2WjSZRnho
mBDJqgYURiP5MSE9Gpm7t7zAYJJLYD/e1XQFlXW8IH8DONBQ0iOsNUHrjsOM
I0+mhKQ2mcjvIIqFfZb25f1winM2HILuTW72+up+8j+M4uTCDO38AbjlVY0g
fej+jKTfBigPC9LTa5Y2+JupnwVxxefsoT+aKR8rInaoGtOMZupvhSx3f1xe
yiDlJaB1S604/9YgzRMgUTWsyogeovxsEDUVHA0uHKL5Nqg6je0nvYYpTw5p
/Ep9x45hnHfZU3NsDDuwoad1mPJ9iRiJoaLigxGcKXLVSwQ1QSw5O0J5v4Il
Mu33TZMjOOEW+Arihfd/CIuxUP6jiKnXqFPTLXC3yxuFdK68bfCEhXjYwVXZ
y5tvWrDfFbfSjm6lRjcwaCE+dnyeYlckhlqhcMmTj0Fkbt7JP7ESrzHIpxWb
2rKs2L7NVa9h2m2oM5RYid9r1EijEiObrXDbTR1HwSxN0zGrlXiO43xw7uOQ
UIF4TKDRUd9w60OBeEzAND0h5yeZQDwc8JWtK5YeF4iHA53FG6PFfwrEYxKR
98asvVqBeEyiW8j87MKYQDzeoEBRGb8uzEY83mAi23Fcv8JGeYqYJH/hnTWb
baRHxHTvzV6Ws89G+YqYrPQqO3jKRvpErPFiTFzcZRvl7cVWBjyrVLfYSK8X
q5Gt+bmuz0b5ezH73TnR3zlspN95HlZ7/cYsTjy8WcujTYtKnHvh8ePNptUb
Lk1dyYmPN+vMOVXo+IKTP292QBGrz07jxMubRdwfkyh2cfLrw1j1cuOIkhM/
H/ar8uQxfpiTfx8m7/qlLPckh1ue2YdFVGfeVp/htJ++rODpzHNfl3G48W7z
ZatXNdrrKzjtqy+bmCff9bCSw/M68WUtW7O+PVPLaX/9mHT9zSdxVzjx92Op
+cd86q5y2mc/trEg8KsFf3F4Xnd+7FLpniC189zDw5+l6BaMxjqf9/DwZ//E
F8SOOvt7ePizxgTzjPEqTjz8mXS66NL6PzjxCGAtj/3MoeWceAQw1bA+Ns3p
x8MjgJn2xmxZXMKJRwCL2PogT3P6LY8prHlR0WS7M5//ATTdJkA=
     "]]}, 
   {RGBColor[0, 0, 0], LineBox[CompressedData["
1:eJw1lAtMU2cUx1vKw+nc2GRBceOxkFiWmTGZQJh4vsUh6DbHyw1mB2jKw8xh
K+KQmckQGIbMquOhjOoUw8uJyFSIY4qiQJQxBCyooKUPoA/gtv2AKlB32x5P
0jT33nPP+f//vy/XZ8fu6GQHDoeTzP6s/y/LWx3EKSprg2bPfF1U8yngvHb6
w1Svdryuh9Z0ZvPtfzph8UClKHRxE7QGzp2JEd/D59eBKIUvzgR3w0cB1moD
1yzJDdfDPdjfAUk+YUIPy31QZLvVh4/cBTJ5SFiR3Yfvd0OOV+/X7Qv9EDF